/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.data.snapshot;

import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.cp.taskmng.util.StringUtil;
import com.kingdee.eas.csinterface.billmapping.BillMappingHelper;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.DBUtils;
import com.kingdee.eas.csinterface.data.model.StructuredDataModel;
import com.kingdee.eas.csinterface.util.EipSQLUtil;
import com.kingdee.eas.csinterface.util.IOUtils;
import com.kingdee.eas.csinterface.util.MD5;
import com.kingdee.util.db.SQLUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ChangefulBillData {
    static final Logger logger = Logger.getLogger(ChangefulBillData.class);
    public static final String FIELD_HEADPK = "headpk";
    public static final String FIELD_HEADPK_IN_VIEW = "viewheadpk";
    public static final String FIELD_AS_HASHCODE = "pktablehashcode";
    public static final String FIELD_HASHCODE = "hashCode";
    public static final String FIELD_CREATETIME = "createTime";
    private Object headpkOfPkTable;
    private Object headpkOfView;
    private String oldHashCode;
    private String newHashCode;
    private String beforeHashCode;
    private String[] sortedChangefulFields;
    private String[] oldSortedChangefulFields;
    private ByteArrayOutputStream changefulFieldBytes;
    private ByteArrayOutputStream oldChangefulFieldBytes;
    private boolean initSnapshot;
    private boolean isOracle;
    private Map<String, Boolean> filedmap = new HashMap<String, Boolean>();
    private StringBuffer changefulFieldValues;

    public ChangefulBillData(String[] sortedChangefulFields, boolean isOracle, boolean initSnapshot) {
        if (sortedChangefulFields == null || sortedChangefulFields.length == 0) {
            throw new NullPointerException("empty changefulFields");
        }
        this.sortedChangefulFields = sortedChangefulFields;
        this.changefulFieldBytes = new ByteArrayOutputStream();
        this.initSnapshot = initSnapshot;
        this.isOracle = isOracle;
        this.changefulFieldValues = new StringBuffer();
    }

    public ChangefulBillData(String[] sortedChangefulFields, boolean isOracle, boolean initSnapshot, String oldChangefulFields) {
        if (sortedChangefulFields == null || sortedChangefulFields.length == 0) {
            throw new NullPointerException("empty changefulFields");
        }
        this.sortedChangefulFields = sortedChangefulFields;
        this.oldChangefulFieldBytes = new ByteArrayOutputStream();
        this.changefulFieldBytes = new ByteArrayOutputStream();
        this.initSnapshot = initSnapshot;
        this.isOracle = isOracle;
        if (initSnapshot && !StringUtil.isEmpty((String)oldChangefulFields)) {
            this.oldSortedChangefulFields = oldChangefulFields.split(",");
            Arrays.sort((Object[])this.oldSortedChangefulFields);
        }
        this.changefulFieldValues = new StringBuffer();
    }

    public static final String[] getSortedChangefulFields(StructuredDataModel dataModel) {
        int i;
        StructuredDataModel.TableModel[] tableModels = dataModel.getPriorityTables();
        StructuredDataModel.TableModel header = tableModels[0];
        StructuredDataModel.TableModel entry = tableModels[1];
        ArrayList<String> changefulFields = new ArrayList<String>();
        for (i = 0; i < header.columns.length; ++i) {
            if (!header.columns[i].isChangeful) continue;
            changefulFields.add(header.columns[i].name.toLowerCase());
        }
        for (i = 0; i < entry.columns.length; ++i) {
            if (!entry.columns[i].isChangeful) continue;
            changefulFields.add(entry.columns[i].name.toLowerCase());
        }
        Object[] sortedChangefulFields = changefulFields.toArray(new String[0]);
        Arrays.sort((Object[])sortedChangefulFields);
        return sortedChangefulFields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addHashCodeColumnIfNeed(Connection connection, String pkTable) throws SQLException {
        boolean existHashCodeColumn = EipSQLUtil.existsColumn(connection, pkTable, FIELD_HASHCODE);
        if (!existHashCodeColumn) {
            ResultSet rs = null;
            Statement stm = null;
            try {
                stm = connection.createStatement();
                if (connection.getMetaData().getDatabaseProductName().equalsIgnoreCase("MySql")) {
                    stm.executeUpdate("ALTER TABLE " + pkTable + " ADD COLUMN " + FIELD_HASHCODE + " varchar(64)");
                } else {
                    if (connection.getMetaData().getDatabaseProductName().equalsIgnoreCase("PostgreSQL")) {
                        pkTable = pkTable.replace("\"", "");
                        String tableId = pkTable.substring(6);
                        pkTable = BillMappingHelper.calc2PkTableName(tableId);
                        pkTable = pkTable.toLowerCase();
                    }
                    stm.executeUpdate("ALTER TABLE " + pkTable + " ADD " + FIELD_HASHCODE + " varchar(64)");
                }
            }
            finally {
                SQLUtils.cleanup(rs, (Statement)stm);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCreateTimeColumnIfNeed(Connection connection, String pkTable) throws SQLException {
        boolean existCreateTimeColumn = EipSQLUtil.existsColumn(connection, pkTable, FIELD_CREATETIME);
        if (!existCreateTimeColumn) {
            ResultSet rs = null;
            Statement stm = null;
            try {
                StringBuilder sb = new StringBuilder();
                ColumnInfo createTime = new ColumnInfo();
                createTime.setTypeName(SQLType.DATETIME);
                if (connection.getMetaData().getDatabaseProductName().equalsIgnoreCase("MySql")) {
                    sb.append("ALTER TABLE " + pkTable + " ADD COLUMN " + FIELD_CREATETIME);
                } else {
                    sb.append("ALTER TABLE " + pkTable + " ADD " + FIELD_CREATETIME);
                }
                sb.append(" ");
                sb.append(DBUtils.getDataType(createTime));
                stm = connection.createStatement();
                stm.executeUpdate(sb.toString());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stm);
                throw throwable;
            }
            SQLUtils.cleanup(rs, (Statement)stm);
        }
    }

    public void appendFieldBytes(ResultSet rs) throws SQLException {
        if (this.headpkOfPkTable == null) {
            this.headpkOfPkTable = rs.getObject(FIELD_HEADPK);
        }
        if (this.headpkOfView == null) {
            this.headpkOfView = rs.getObject(FIELD_HEADPK_IN_VIEW);
            if (this.headpkOfView == null) {
                return;
            }
        }
        this.oldHashCode = rs.getString(FIELD_AS_HASHCODE);
        this.resultSet2OutputStream(rs);
    }

    /*
     * Unable to fully structure code
     */
    private void resultSet2OutputStream(ResultSet rs) throws SQLException {
        this.changefulFieldValues.append("\t");
        isOracle = this.isOracle;
        if (isOracle) {
            for (i = 0; i < this.sortedChangefulFields.length; ++i) {
                obj = rs.getBytes(this.sortedChangefulFields[i]);
                fieldBytes = null == obj ? "0".getBytes() : (obj instanceof String != false ? obj.toString().getBytes() : rs.getBytes(this.sortedChangefulFields[i]));
                try {
                    if (fieldBytes == null) {
                        IOUtils.writeInt(this.changefulFieldBytes, 0);
                    } else {
                        IOUtils.writeInt(this.changefulFieldBytes, fieldBytes.length);
                        this.changefulFieldBytes.write(fieldBytes);
                    }
                }
                catch (IOException e) {
                    ChangefulBillData.logger.error((Object)e);
                }
                this.changefulFieldValues.append(String.valueOf(rs.getObject(this.sortedChangefulFields[i])) + "\t");
            }
            if (null != this.oldSortedChangefulFields) {
                for (i = 0; i < this.oldSortedChangefulFields.length; ++i) {
                    obj = rs.getBytes(this.oldSortedChangefulFields[i]);
                    oldieldBytes = null == obj ? "0".getBytes() : (obj instanceof String != false ? obj.toString().getBytes() : rs.getBytes(this.sortedChangefulFields[i]));
                    try {
                        if (oldieldBytes == null) {
                            IOUtils.writeInt(this.oldChangefulFieldBytes, 0);
                            continue;
                        }
                        IOUtils.writeInt(this.oldChangefulFieldBytes, oldieldBytes.length);
                        this.oldChangefulFieldBytes.write(oldieldBytes);
                        continue;
                    }
                    catch (IOException e) {
                        ChangefulBillData.logger.error((Object)e);
                    }
                }
            }
        } else {
            fieldObject = null;
            try {
                rowOutputStream = new ObjectOutputStream(this.changefulFieldBytes);
                for (i = 0; i < this.sortedChangefulFields.length; ++i) {
                    fieldObject = rs.getObject(this.sortedChangefulFields[i]);
                    if (fieldObject == null) {
                        rowOutputStream.writeInt(0);
                    } else {
                        rowOutputStream.writeObject(fieldObject);
                    }
                    this.changefulFieldValues.append(String.valueOf(fieldObject) + "\t");
                }
                rowOutputStream.flush();
                if (null == this.oldSortedChangefulFields) ** GOTO lbl62
                oldOutputStream = new ObjectOutputStream(this.oldChangefulFieldBytes);
                for (i = 0; i < this.oldSortedChangefulFields.length; ++i) {
                    fieldObject = rs.getObject(this.oldSortedChangefulFields[i]);
                    if (fieldObject == null) {
                        oldOutputStream.writeInt(0);
                        continue;
                    }
                    oldOutputStream.writeObject(fieldObject);
                }
                oldOutputStream.flush();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
lbl62:
        // 3 sources

        this.changefulFieldValues.append("\r\n");
    }

    public void appendFieldBytesByMiddleBill(ResultSet rs) throws SQLException {
        this.resultSet2OutputStream(rs);
    }

    public void appendFieldBytes(ResultSet rs1, ResultSet rs2) throws SQLException {
        if (this.headpkOfPkTable == null) {
            this.headpkOfPkTable = rs2.getObject(FIELD_HEADPK);
        }
        if (!this.initSnapshot) {
            if (this.headpkOfView == null) {
                this.headpkOfView = rs2.getObject(FIELD_HEADPK_IN_VIEW);
                if (this.headpkOfView == null) {
                    return;
                }
            }
            this.oldHashCode = rs1.getString(FIELD_AS_HASHCODE);
        }
        this.changefulFieldValues.append("\t");
        boolean isOracle = this.isOracle;
        if (isOracle) {
            for (int i = 0; i < this.sortedChangefulFields.length; ++i) {
                Boolean isHead = this.filedmap.get(this.sortedChangefulFields[i]);
                if (isHead == null) {
                    isHead = this.isExtence(rs1, this.sortedChangefulFields[i]);
                    this.filedmap.put(this.sortedChangefulFields[i], isHead);
                }
                byte[] fieldBytes = isHead != false ? rs1.getBytes(this.sortedChangefulFields[i]) : rs2.getBytes(this.sortedChangefulFields[i]);
                try {
                    if (fieldBytes == null) {
                        IOUtils.writeInt(this.changefulFieldBytes, 0);
                    } else {
                        IOUtils.writeInt(this.changefulFieldBytes, fieldBytes.length);
                        this.changefulFieldBytes.write(fieldBytes);
                    }
                }
                catch (IOException e) {
                    logger.error((Object)e);
                }
                this.changefulFieldValues.append(String.valueOf(fieldBytes) + "\t");
            }
        } else {
            Object fieldObject = null;
            try {
                ObjectOutputStream rowOutputStream = new ObjectOutputStream(this.changefulFieldBytes);
                for (int i = 0; i < this.sortedChangefulFields.length; ++i) {
                    Boolean isHead = this.filedmap.get(this.sortedChangefulFields[i]);
                    if (isHead == null) {
                        isHead = this.isExtence(rs1, this.sortedChangefulFields[i]);
                        this.filedmap.put(this.sortedChangefulFields[i], isHead);
                    }
                    if ((fieldObject = isHead != false ? rs1.getObject(this.sortedChangefulFields[i]) : rs2.getObject(this.sortedChangefulFields[i])) == null) {
                        rowOutputStream.writeInt(0);
                    } else {
                        rowOutputStream.writeObject(fieldObject);
                    }
                    this.changefulFieldValues.append(String.valueOf(fieldObject) + "\t");
                }
                rowOutputStream.flush();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.changefulFieldValues.append("\r\n");
    }

    private boolean isExtence(ResultSet rs, String columnName) {
        try {
            if (rs.findColumn(columnName) > 0) {
                return true;
            }
        }
        catch (SQLException e) {
            return false;
        }
        return false;
    }

    public void snapshot() {
        byte[] beforeBytes;
        byte[] bytes = this.changefulFieldBytes.toByteArray();
        if (bytes != null && bytes.length > 0) {
            try {
                this.newHashCode = MD5.code(bytes);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if (null != this.oldChangefulFieldBytes && (beforeBytes = this.oldChangefulFieldBytes.toByteArray()) != null && beforeBytes.length > 0) {
            try {
                this.beforeHashCode = MD5.code(beforeBytes);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }

    public boolean isNewHash() {
        return this.headpkOfView != null && this.oldHashCode == null;
    }

    public boolean isUpdate() {
        return !this.isNewHash() && this.newHashCode != null && !this.newHashCode.equals(this.oldHashCode);
    }

    public boolean isSnapShotUpdate() {
        return !this.isSnapShotNewHash() && this.beforeHashCode != null && this.oldHashCode.equals(this.beforeHashCode);
    }

    public boolean isSnapShotNewHash() {
        return this.headpkOfView != null && this.oldHashCode == null;
    }

    public boolean isDelete() {
        return this.headpkOfView == null;
    }

    public Object getHeadpkOfPkTable() {
        return this.headpkOfPkTable;
    }

    public Object getHeadpkOfView() {
        return this.headpkOfView;
    }

    public String getOldHashCode() {
        return this.oldHashCode;
    }

    public String getNewHashCode() {
        return this.newHashCode;
    }

    public String getNewFieldValues() {
        return this.changefulFieldValues.toString();
    }
}

