/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.data.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AssistAccountUtil {
    private static final Logger logger = Logger.getLogger(AssistAccountUtil.class);
    private static final ThreadLocal<Map<Integer, DataBaseInfo>> dataInfoMap = new ThreadLocal();
    private static final ThreadLocal<Map<String, AsstActTypeInfo>> asstActInfoMap = new ThreadLocal();

    public static AssistantHGInfo getAssistantHGInfo(Context ctx, Map datas, String groupId, CtrlUnitInfo cu, String srcAccount, String account, Object numberGroup) throws BOSException, EASBizException {
        if (datas == null) {
            return null;
        }
        String cuID = null;
        String cuNumber = null;
        String cuName = null;
        if (cu == null) {
            CtrlUnitInfo unit = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            cuID = unit.getId().toString();
            cuNumber = unit.getNumber();
            cuName = unit.getName();
        } else {
            cuID = cu.getId().toString();
            cuNumber = cu.getNumber();
            cuName = cu.getName();
        }
        AssistantHGInfo assGrp = new AssistantHGInfo();
        AsstActTypeCollection types = new AsstActTypeCollection();
        Set keyset = datas.keySet();
        Iterator it = keyset.iterator();
        Map<Integer, DataBaseInfo> dataMap = null;
        while (it.hasNext()) {
            String key = (String)it.next();
            AsstActTypeInfo typeInfo = AssistAccountUtil.findAsstActtypeNumberByName(ctx, key);
            String value = (String)datas.get(key);
            if (value == null) {
                String number = "";
                if (null != typeInfo) {
                    number = typeInfo.getNumber();
                }
                throw new BOSException("\u751f\u6210\u6a2a\u8868\u7f3a\u5931\u6838\u7b97\u9879\u76ee\uff0c\u7f16\u7801\uff1a" + number + "\uff0c\u540d\u79f0\uff1a" + key + "\u3002\u6e90(\u79d1\u76ee/\u4e3b\u8868\u9879\u76ee)\uff1a" + srcAccount + "\uff0c\u76ee\u6807(\u79d1\u76ee/\u4e3b\u8868\u9879\u76ee)\uff1a" + account + "\uff0c\u6e90\u8f85\u52a9\u8d26\u7ec4\u5408\uff1a" + numberGroup + "\uff0c\u76ee\u6807\u8f85\u52a9\u8d26\uff1a" + keyset.toString() + "\n");
            }
            if (typeInfo == null) {
                throw new BOSException("\u751f\u6210\u6a2a\u8868\u8fc7\u7a0b\u4e2d\uff0c\u901a\u8fc7\u6838\u7b97\u9879\u76ee\u540d\u79f0\uff1a[" + key + "]\uff0c\u672a\u67e5\u8be2\u5230\u6838\u7b97\u9879\u76ee\u6570\u636e\u3002\u53ef\u80fd\u539f\u56e0\u5e93\u4e2d\u6570\u636e\u5b58\u5728\u5982'\u7a7a\u683c'\u7b49\u7279\u6b8a\u5b57\u7b26\u3002");
            }
            int hashCode = (value + typeInfo.getAsstHGAttribute() + cuID).hashCode();
            dataMap = dataInfoMap.get();
            if (dataMap == null) {
                dataMap = new HashMap<Integer, DataBaseInfo>();
                dataInfoMap.set(dataMap);
            }
            DataBaseInfo dataInfo = null;
            try {
                if (dataMap.containsKey(hashCode)) {
                    dataInfo = dataMap.get(hashCode);
                } else {
                    Class<?> GlUtils = Class.forName("com.kingdee.eas.fi.gl.GlUtils");
                    Method method = GlUtils.getMethod("findAsstActObject", Context.class, String.class, String.class, String.class);
                    dataInfo = (DataBaseInfo)method.invoke(GlUtils, ctx, typeInfo.getAsstHGAttribute(), value, cuID);
                    dataMap.put(hashCode, dataInfo);
                }
            }
            catch (ClassNotFoundException e) {
                logger.error((Object)e);
                throw new BOSException("\u3010\u96c6\u6210\u5e73\u53f0\u3011\u53cd\u5c04\u67e5\u8be2\u57fa\u7840\u8d44\u6599\u51fa\u9519,AssistAccountUtil.getAssistantHGInfo", (Throwable)e);
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new BOSException("\u3010\u96c6\u6210\u5e73\u53f0\u3011\u53cd\u5c04\u67e5\u8be2\u57fa\u7840\u8d44\u6599\u51fa\u9519,AssistAccountUtil.getAssistantHGInfo", (Throwable)e);
            }
            if (dataInfo == null) {
                UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
                Date now = new Date();
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss");
                String username = user == null ? "" : user.getName();
                String usernumber = user == null ? "" : user.getNumber();
                logger.error((Object)("\u3010\u96c6\u6210\u5e73\u53f0\u3011\u751f\u6210\u8f85\u52a9\u8d26\u6a2a\u8868\u51fa\u9519\uff0c\u5f53\u524d\u7528\u6237:" + usernumber + "(" + username + ")\uff0ccu.id=" + cuID));
                throw new BOSException("\u751f\u6210\u6a2a\u8868\u67e5\u8be2\u57fa\u7840\u8d44\u6599\u51fa\u9519\uff0c\u6838\u7b97\u9879\u76ee\u7c7b\u578b:" + typeInfo.getAsstHGAttribute() + "(" + typeInfo.getName() + ")\uff0c\u57fa\u7840\u8d44\u6599\u7f16\u7801:(" + value + ")\uff0c\u63a7\u5236\u5355\u5143:" + cuNumber + "(" + cuName + ")\uff0c\u5f53\u524d\u7528\u6237:" + usernumber + "(" + username + ")\uff0ccu.id=" + cuID + "\uff0c\u7cfb\u7edf\u5f53\u524d\u65f6\u95f4:" + dateFormat.format(now) + "\n");
            }
            assGrp.put(typeInfo.getAsstHGAttribute(), (Object)dataInfo);
            types.add(typeInfo);
        }
        AsstAccountInfo assAcctInfo = new AsstAccountInfo();
        assAcctInfo.setId(BOSUuid.read((String)groupId));
        assGrp.setAsstAccount(assAcctInfo);
        return AssistantHGFactory.getLocalInstance((Context)ctx).getAssistantHG(assGrp, groupId, types);
    }

    public static AsstActTypeInfo findAsstActtypeNumberByName(Context ctx, String name) throws BOSException {
        if (name == null || name.trim().equals("")) {
            return null;
        }
        AsstActTypeInfo asstActTypeInfo = null;
        Map<String, AsstActTypeInfo> asstActMap = asstActInfoMap.get();
        if (asstActMap == null) {
            asstActMap = new HashMap<String, AsstActTypeInfo>();
            asstActInfoMap.set(asstActMap);
        }
        if (asstActMap.containsKey(name)) {
            asstActTypeInfo = asstActMap.get(name);
        } else {
            IAsstActType asstActType = AsstActTypeFactory.getLocalInstance((Context)ctx);
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = view.getSelector();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("asstHGAttribute"));
            sic.add(new SelectorItemInfo("mappingFieldName"));
            sic.add(new SelectorItemInfo("isMultilevel"));
            sic.add(new SelectorItemInfo("groupTableName"));
            sic.add(new SelectorItemInfo("useLongNumber"));
            sic.add(new SelectorItemInfo("glAsstActTypeGrp.id"));
            sic.add(new SelectorItemInfo("glAsstActTypeGrp.shareTactic"));
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            FilterItemCollection fic = filter.getFilterItems();
            fic.add(new FilterItemInfo("name", (Object)name.trim()));
            AsstActTypeCollection asstActTypeCollection = asstActType.getAsstActTypeCollection(view);
            if (asstActTypeCollection != null && asstActTypeCollection.size() != 0) {
                asstActTypeInfo = asstActTypeCollection.get(0);
            }
            asstActMap.put(name, asstActTypeInfo);
        }
        return asstActTypeInfo;
    }

    public static void clearCache() {
        Map<Object, Object> map = dataInfoMap.get();
        dataInfoMap.set(null);
        if (map != null) {
            map.clear();
        }
        if ((map = asstActInfoMap.get()) != null) {
            map.clear();
        }
        asstActInfoMap.set(null);
    }
}

