/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.eipserviceplugin.execute;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.service.IServiceContext;
import com.kingdee.bos.service.job.core.Configuration;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.csinterface.agent.service.base.util.StringUtils;
import com.kingdee.eas.csinterface.agent.servlet.openapi.util.QueryUtil;
import com.kingdee.eas.csinterface.async.app.task.AsyncOrderTaskUtil;
import com.kingdee.eas.csinterface.async.app.task.IAsyncTaskExecutor;
import com.kingdee.eas.csinterface.async.app.task.model.ResultInfo;
import com.kingdee.eas.csinterface.eipserviceplugin.execute.IERPExecute;
import com.kingdee.eas.csinterface.eipserviceplugin.execute.IERPHttpClient;
import com.kingdee.eas.csinterface.eipserviceplugin.model.base.IERPModel;
import com.kingdee.eas.csinterface.util.gson.ContextConvertUtil;
import com.kingdee.eas.csinterface.webservice.WSServiceInfo;
import com.kingdee.eas.csinterface.webservice.app.handler.user.ierp.model.FieldDefineModel;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public class AysncIERPExecuterImpl
extends IERPExecute
implements IAsyncTaskExecutor {
    private static Logger logger = Logger.getLogger(AysncIERPExecuterImpl.class);
    private static final String DATA = "data";
    private static final String MODEL = "model";
    private static final String ACTION = "action";
    private static String SERVER_TAG = null;

    public static ResultInfo orderTask4API(Context ctx, String adaptorNumber, String action, String bosTypeStr, List<String> idList, Boolean sync) throws BOSException {
        ResultInfo result = new ResultInfo();
        try {
            IERPModel model = IERPModel.getAdaptorModel(ctx, adaptorNumber);
            if (model == null) {
                throw new BOSException("\u627e\u5230\u6307\u5b9a\u7684\u62e6\u622a\u670d\u52a1\u65b9\u6848\uff0c\u7f16\u7801\u4e3a\uff1a" + adaptorNumber);
            }
            BOSObjectType bosType = BOSObjectType.create((String)bosTypeStr);
            model.setBosType(bosTypeStr);
            if (sync != null) {
                model.setSync(sync);
            } else {
                sync = model.isSync();
            }
            String solution = model.getSolution();
            String loginService = model.getLoginservice();
            WSServiceInfo serviceInfo = AysncIERPExecuterImpl.getWSServiceInfo(ctx, loginService, model.getNumber());
            FieldDefineModel fieldModel = IERPHttpClient.getPKFieldCache(ctx, serviceInfo, solution);
            String data = StringUtils.converList2String(idList, ",", "");
            if ("delete".equalsIgnoreCase(action)) {
                data = QueryUtil.getSimpleDataOP(ctx, data, fieldModel.getFields(), bosType, model.getUserImpl(), action);
            }
            JSONObject dataObj = new JSONObject();
            dataObj.put(DATA, (Object)data);
            dataObj.put(MODEL, (Object)model);
            dataObj.put(ACTION, (Object)action);
            String description = "\u65b9\u6848\uff1a" + model.getNumber() + "(" + model.getName() + ")\uff0c\u6267\u884c\u64cd\u4f5c(" + action + ")";
            if (sync.booleanValue()) {
                AysncIERPExecuterImpl executor = new AysncIERPExecuterImpl();
                result = executor.execute(ctx, null, dataObj.toJSONString(), null);
            } else {
                AsyncOrderTaskUtil.orderTask(ctx, "EIPAdaptorService", dataObj.toJSONString(), null, description);
            }
            result.setSuccess(true);
        }
        catch (Throwable e) {
            logger.error((Object)"\u4e1a\u52a1\u4e8c\u5f00\u89e6\u53d1\u6570\u636e\u540c\u6b65\u5f02\u5e38", e);
            result.setSuccess(false);
            result.setMessage(e.getMessage());
            result.setException(new Exception(e));
        }
        return result;
    }

    public static void orderTask(Context ctx, IERPModel model, IServiceContext serviceContext, String action, String data) throws BOSException {
        JSONObject dataObj = new JSONObject();
        dataObj.put(DATA, (Object)data);
        dataObj.put(MODEL, (Object)model);
        dataObj.put(ACTION, (Object)action);
        dataObj.put("serviceContext", (Object)ContextConvertUtil.serialize(serviceContext));
        String instanceName = Configuration.instanceId();
        if (!StringUtils.isEmpty(AysncIERPExecuterImpl.getServerTag())) {
            instanceName = "(" + SERVER_TAG + ")" + instanceName;
        }
        String description = "\u65b9\u6848\uff1a" + model.getNumber() + "(" + model.getName() + ")\uff0c\u6267\u884c\u64cd\u4f5c(" + action + ")";
        AsyncOrderTaskUtil.orderTask(ctx, "EIPAdaptorService", dataObj.toJSONString(), null, instanceName + "_" + description);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getServerTag() {
        if (SERVER_TAG == null) {
            Object ipTag = null;
            String logPath = System.getProperty("EAS_HOME") + File.separator + "server" + File.separator + "properties" + File.separator + "eip_ip.properties";
            try {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(logPath)), StandardCharsets.UTF_8));){
                    Properties properties = new Properties();
                    properties.load(reader);
                    ipTag = properties.get("ip");
                }
                SERVER_TAG = ipTag == null ? "" : ipTag.toString();
            }
            catch (IOException iOException) {
                SERVER_TAG = ipTag == null ? "" : ipTag.toString();
            }
            catch (Throwable throwable) {
                SERVER_TAG = ipTag == null ? "" : ipTag.toString();
                throw throwable;
            }
        }
        return SERVER_TAG;
    }

    @Override
    public ResultInfo execute(Context ctx, Job job, String taskData, ResultInfo result) throws BOSException {
        String action;
        result = new ResultInfo();
        JSONObject dataObj = JSONObject.parseObject((String)taskData);
        String data = dataObj.getString(DATA);
        IServiceContext serviceContext = ContextConvertUtil.deserialize(ctx, dataObj.getJSONObject("serviceContext"));
        IERPModel model = IERPModel.deSerialize(ctx, dataObj.getString(MODEL));
        String actualAction = model.getActualAction(action = dataObj.getString(ACTION));
        if ("delete".equals(actualAction)) {
            AysncIERPExecuterImpl.executeDelete(ctx, model, action, serviceContext, data);
        } else if ("addnew".equals(actualAction) || "update".equals(actualAction)) {
            AysncIERPExecuterImpl.execute(ctx, model, action, serviceContext, data);
        } else if ("audit".equals(actualAction) || "unaudit".equals(actualAction) || "enable".equals(actualAction) || "disable".equals(actualAction) || "submit".equals(actualAction)) {
            AysncIERPExecuterImpl.executeOP(ctx, model, action, serviceContext, data);
        } else {
            AysncIERPExecuterImpl.execute(ctx, model, action, serviceContext, data);
        }
        return result;
    }
}

