/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.eipserviceplugin.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.rabbitmq.support.EASConsumerManager;
import com.kingdee.bos.service.IServiceContext;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.csinterface.eipserviceplugin.EipServicePluginAdaptorFactory;
import com.kingdee.eas.csinterface.eipserviceplugin.model.EIPPluginAdaptorModel;
import com.kingdee.eas.csinterface.eipserviceplugin.util.EIPPluginServiceAdaptorUtil;
import com.kingdee.eas.csinterface.eipserviceplugin.util.cache.ClusterClearAdaotirCacheUtil;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class EIPPluginServiceAdaptor {
    EIPPluginServiceAdaptorUtil eipPluginAdaptorUtil = EIPPluginServiceAdaptorUtil.getInstance();
    private static final Logger logger = Logger.getLogger(EIPPluginServiceAdaptor.class);
    private static EIPPluginServiceAdaptor instance = null;

    private EIPPluginServiceAdaptor() {
    }

    public static EIPPluginServiceAdaptor getInstance() {
        if (instance == null) {
            EIPPluginServiceAdaptor.initial();
        }
        return instance;
    }

    private static synchronized void initial() {
        if (instance == null) {
            instance = new EIPPluginServiceAdaptor();
        }
    }

    public void executeApp(IServiceContext serviceContext) throws BOSException {
        Boolean isMethodBefore;
        String methodName;
        Context ctx = serviceContext.getContext();
        String dataCenterName = ctx.getAIS();
        EASConsumerManager.init((Context)ctx);
        if (!ClusterClearAdaotirCacheUtil.isConfig(ctx)) {
            return;
        }
        BOSObjectType boType = serviceContext.getBoType();
        BOSObjectType metaType = serviceContext.getMetaType();
        Boolean flag = metaType.equals((Object)MetaDataTypeList.ENTITY) || metaType.equals((Object)MetaDataTypeList.FACADE);
        if (!flag.booleanValue()) {
            return;
        }
        BusinessObjectInfo bo = this.eipPluginAdaptorUtil.getMetaData(ctx, metaType, boType);
        if (bo == null || bo.getFullName() == null) {
            return;
        }
        IMetaDataPK operationPK = serviceContext.getOperationPK();
        MethodInfo method = this.eipPluginAdaptorUtil.getMethod(bo, operationPK);
        if (method == null) {
            return;
        }
        String className = bo.getBusinessImplName();
        if (!ClusterClearAdaotirCacheUtil.isExist(ctx, className, methodName = method.toString().trim(), dataCenterName, isMethodBefore = Boolean.valueOf(this.eipPluginAdaptorUtil.isMethodBefore(serviceContext.getExecutionMode())))) {
            return;
        }
        try {
            this.eipPluginAdaptorUtil.doAdaptor(serviceContext, dataCenterName, className, methodName, isMethodBefore);
        }
        catch (BOSException e) {
            logger.error((Object)"daAdaptor faile!", (Throwable)e);
            throw e;
        }
    }

    public void executeClient(IItemAction target, ActionEvent e) throws BOSException {
        Context ctx = null;
        ctx = EipServicePluginAdaptorFactory.getRemoteInstance().getContext();
        if (ctx == null) {
            return;
        }
        String actionName = null;
        String uiName = null;
        if (target instanceof ItemAction && target != null) {
            ItemAction action = (ItemAction)target;
            actionName = action.getClass().getName();
            if (actionName.indexOf("$") >= 0) {
                actionName = actionName.substring(actionName.indexOf("$") + 1);
            }
            IUIObject uiObject = action.getUIObject();
            uiName = uiObject.getClass().getName();
        }
        if (actionName == null || uiName == null) {
            return;
        }
        String adaptorName = actionName + "@" + uiName;
        Map<String, Map<String, List<EIPPluginAdaptorModel>>> frontCache = this.eipPluginAdaptorUtil.getForntCache();
        if (!EIPPluginServiceAdaptorUtil.isExist(adaptorName, uiName, ctx.getAIS(), false)) {
            return;
        }
        Boolean isMethodBefore = this.eipPluginAdaptorUtil.isMethodBefore(target, actionName, e);
    }
}

