/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.monitor.app;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.util.StringUtil;
import com.kingdee.eas.csinterface.DynamicBillTemplateCollection;
import com.kingdee.eas.csinterface.DynamicBillTemplateInfo;
import com.kingdee.eas.csinterface.IDynamicBillTemplate;
import com.kingdee.eas.csinterface.TransactionWrapperFacadeFactory;
import com.kingdee.eas.csinterface.agent.service.base.util.SQLUtil;
import com.kingdee.eas.csinterface.app.TransactionBlock;
import com.kingdee.eas.csinterface.billmapping.BillMappingFactory;
import com.kingdee.eas.csinterface.billmapping.BillMappingInfo;
import com.kingdee.eas.csinterface.common.DIPException;
import com.kingdee.eas.csinterface.data.model.DataRow;
import com.kingdee.eas.csinterface.data.model.StructuredDataModel;
import com.kingdee.eas.csinterface.data.model.StructuredTableData;
import com.kingdee.eas.csinterface.data.process.impl.BaseDataConvertBatchProcessor;
import com.kingdee.eas.csinterface.monitor.FeedBackFlag;
import com.kingdee.eas.csinterface.monitor.FeedBackLogCollection;
import com.kingdee.eas.csinterface.monitor.FeedBackLogFactory;
import com.kingdee.eas.csinterface.monitor.FeedBackLogInfo;
import com.kingdee.eas.csinterface.monitor.FeedBackLogState;
import com.kingdee.eas.csinterface.monitor.FeedBackStatus;
import com.kingdee.eas.csinterface.monitor.IFeedBackLog;
import com.kingdee.eas.csinterface.monitor.app.MonitorManager;
import com.kingdee.eas.csinterface.monitor.app.SrcToMidBillMonitorLogInfo;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionFactory;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionInfo;
import com.kingdee.eas.csinterface.util.MidBillFactory;
import com.kingdee.eas.csinterface.util.ThrowableHelper;
import com.kingdee.eas.csinterface.utils.KSQLUtil;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class FeedBackManager {
    private static final Logger logger = Logger.getLogger(BaseDataConvertBatchProcessor.class);
    private static final String FEEDBACK_ENABLE = "feedBackEnable";
    private static final String FEEDBACK_CONDITION = "feedBackCondition";
    private static final String FEEDBACK_CONNECTION = "feedBackConnID";
    private static final String FEEDBACK_BILLMAPPING = "feedBackBillMappingID";
    private static final String FEEDBACK_BILLMAPPINGNUMBER = "feedBackBillMappingNumber";
    private static final String BILLMAPPING = "feedBackBillMapping";
    private static final String SRCDBCONN = "srcDBConn";
    private static final int RETRY_TIMES = 3;
    private static final int INTERVAL = 100;
    private static final int MAX_MSG_LENGTH = 2000;
    private static ThreadLocal<Map<String, String>> headpkConditionMap = new ThreadLocal();
    private static ThreadLocal<Boolean> deletefromVoucher = new ThreadLocal();

    public static Map<String, String> getHeadpkConditionMap() {
        Map<String, String> map = headpkConditionMap.get();
        if (map == null) {
            map = new HashMap<String, String>();
            headpkConditionMap.set(map);
        }
        return map;
    }

    public static void destory() {
        Map<String, String> map = headpkConditionMap.get();
        if (map != null) {
            map.clear();
            headpkConditionMap.set(null);
        }
    }

    public static boolean getDeletefromVoucher() {
        return deletefromVoucher.get() == null ? false : deletefromVoucher.get();
    }

    public static void setDeletefromVoucher(Boolean flag) {
        deletefromVoucher.set(flag);
    }

    public static void initFeedBackLog(Context ctx, StructuredTableData data, StructuredDataModel model) throws DIPException {
        try {
            boolean isEnable = (Boolean)model.getProperty(FEEDBACK_ENABLE);
            if (!isEnable) {
                return;
            }
            String fbCondition = (String)model.getProperty(FEEDBACK_CONDITION);
            if (StringUtil.isEmpty((String)fbCondition)) {
                throw new BOSException("\u4e1a\u52a1\u5355\u636e\u6620\u5c04\u7684\u53cd\u9988\u914d\u7f6e\u7684\u6761\u4ef6\u914d\u7f6e\u9519\u8bef");
            }
            Map<String, String> headpkConditionMap = FeedBackManager.getHeadpkConditionMap();
            Map<String, String> srcMidFieldMap = FeedBackManager.getSrcMidFieldMapByCondition(fbCondition);
            List headRows = data.getFirstTableRows();
            for (DataRow headRow : headRows) {
                Map fileds = headRow.getValues();
                Iterator<String> it = srcMidFieldMap.keySet().iterator();
                HashMap map = new HashMap();
                while (it.hasNext()) {
                    String srcField = it.next();
                    Object srcFieldValue = fileds.get(srcMidFieldMap.get(srcField));
                    map.put(srcField, srcFieldValue);
                }
                String jsonCondition = new JSONObject(map).toJSONString();
                String headpk = fileds.get(headRow.pkColumn).toString();
                headpkConditionMap.put(headpk, jsonCondition);
            }
        }
        catch (Exception e) {
            throw new DIPException("\u521d\u59cb\u5316\u53cd\u9988\u4fe1\u606f\u5f02\u5e38:" + e.getMessage(), e);
        }
    }

    public static void addFeedBackLog(Context ctx, StructuredTableData data, StructuredDataModel model) throws DIPException {
        try {
            boolean isEnable = (Boolean)model.getProperty(FEEDBACK_ENABLE);
            if (!isEnable) {
                return;
            }
            String conn = (String)model.getProperty(FEEDBACK_CONNECTION);
            String billMapping = (String)model.getProperty(FEEDBACK_BILLMAPPING);
            String billMappingNumber = (String)model.getProperty(FEEDBACK_BILLMAPPINGNUMBER);
            SrcToMidBillMonitorLogInfo info = MonitorManager.getCurrentSrcToMidBill();
            Map<String, Set<Object>> errorBillIdsMap = info.getErrorBillIdsMap();
            HashMap<Object, HashSet<String>> map = new HashMap<Object, HashSet<String>>();
            for (String errorInfo : errorBillIdsMap.keySet()) {
                Set<Object> set = errorBillIdsMap.get(errorInfo);
                for (Object o : set) {
                    Set<String> errorSet = (Set)map.get(o);
                    if (errorSet == null) {
                        errorSet = new HashSet<String>();
                        map.put(o, (HashSet<String>)errorSet);
                    }
                    errorSet.add(errorInfo);
                }
            }
            Map<String, String> headpkConditionMap = FeedBackManager.getHeadpkConditionMap();
            Set<String> headpkAll = headpkConditionMap.keySet();
            HashSet<String> headpkSuc = new HashSet<String>();
            List headRows = data.getFirstTableRows();
            for (DataRow headRow : headRows) {
                String headpk = headRow.getValues().get(headRow.pkColumn).toString();
                headpkSuc.add(headpk);
            }
            IFeedBackLog instance = FeedBackLogFactory.getLocalInstance(ctx);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("connection.id", (Object)conn, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("billmapping.id", (Object)billMapping, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("headpk", new HashSet<String>(headpkAll), CompareType.INCLUDE));
            instance.delete(filter);
            HashMap headpkFidMap = new HashMap();
            if (headpkSuc.size() > 0) {
                headpkFidMap.putAll(FeedBackManager.findMidBillIdAndHeadpkOnly(ctx, headpkSuc, billMappingNumber));
            }
            BillMappingInfo billMappingInfo = (BillMappingInfo)model.getProperty(BILLMAPPING);
            ConnectionInfo connInfo = (ConnectionInfo)model.getProperty(SRCDBCONN);
            CoreBaseCollection colls = new CoreBaseCollection();
            for (String headpk : headpkAll) {
                FeedBackLogInfo logInfo = new FeedBackLogInfo();
                logInfo.setConnection(connInfo);
                logInfo.setBillmapping(billMappingInfo);
                logInfo.setHeadpk(headpk);
                logInfo.setStatus(FeedBackLogState.MID);
                logInfo.setFlag(FeedBackFlag.WAITING);
                if (headpkSuc.contains(headpk)) {
                    logInfo.setFeedBackStatus(FeedBackStatus.EXPORT_MID_SUCCESSED);
                    logInfo.setMidID((String)headpkFidMap.get(headpk));
                } else {
                    logInfo.setFeedBackStatus(FeedBackStatus.EXPORT_MID_FAILED);
                    logInfo.setFeedBackMsg(FeedBackManager.generateMsg((Set)map.get(headpk)));
                }
                logInfo.setFeedbackCondition(headpkConditionMap.get(headpk));
                colls.add((CoreBaseInfo)logInfo);
            }
            instance.addnewBatchData(colls);
        }
        catch (Exception e) {
            throw new DIPException("\u66f4\u65b0\u53cd\u9988\u65e5\u5fd7\u5f02\u5e38:" + e.getMessage(), e);
        }
        finally {
            FeedBackManager.destory();
        }
    }

    public static Map<String, String> getSrcMidFieldMapByCondition(String str) {
        String[] srcMidMap;
        HashMap<String, String> result = new HashMap<String, String>();
        for (String s : srcMidMap = str.split(";")) {
            String[] temp = s.split(",");
            result.put(temp[0], temp[1]);
        }
        return result;
    }

    public static String generateMsg(Set<String> errors) {
        StringBuilder sb = new StringBuilder();
        for (String str : errors) {
            sb.append(str).append("\n");
        }
        if (sb.length() > 2000) {
            return sb.substring(0, 2000);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doFeedBack(FeedBackLogCollection colls, BillMappingInfo billMappingInfo, FeedBackLogInfo feedBackLogInfo, boolean override) throws Exception {
        String condition = billMappingInfo.getFeedback().getCondition();
        String srcTable = billMappingInfo.getFeedback().getSrcTable();
        String srcStatusField = billMappingInfo.getFeedback().getStatusField();
        String srcMsgField = billMappingInfo.getFeedback().getMsgField();
        int retryTimes = billMappingInfo.getFeedback().getRetryTimes() <= 0 ? 3 : billMappingInfo.getFeedback().getRetryTimes();
        Map<String, String> map = FeedBackManager.getSrcMidFieldMapByCondition(condition);
        HashMap<Integer, String> fieldIndex = new HashMap<Integer, String>();
        int i = 1;
        StringBuilder sb = new StringBuilder();
        for (String str : map.keySet()) {
            fieldIndex.put(i + 2, str);
            if (i > 1) {
                sb.append(" and ");
            }
            sb.append(str).append("=?");
            ++i;
        }
        String sql = "update " + srcTable + " set " + srcStatusField + "=? , " + srcMsgField + "=? where " + sb.toString();
        Connection connection = null;
        PreparedStatement statement = null;
        boolean isSucess = false;
        StringBuilder logs = new StringBuilder();
        for (i = 0; i < retryTimes; ++i) {
            try {
                connection = KSQLUtil.getConnection(billMappingInfo.getSrcDBConn());
                statement = connection.prepareStatement(sql);
                for (int index = 0; index < colls.size(); ++index) {
                    FeedBackLogInfo info = colls.get(index);
                    Map srcValueMap = (Map)JSON.parseObject((String)info.getFeedbackCondition(), (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
                    FeedBackStatus status = override ? feedBackLogInfo.getFeedBackStatus() : info.getFeedBackStatus();
                    String msg = override ? feedBackLogInfo.getFeedBackMsg() : info.getFeedBackMsg();
                    msg = StringUtil.isEmpty((String)msg) ? status.getAlias() : status.getAlias() + ":" + msg;
                    statement.setObject(1, status.getValue());
                    statement.setObject(2, msg);
                    for (int j = 0; j < map.keySet().size(); ++j) {
                        statement.setObject(j + 3, srcValueMap.get(fieldIndex.get(j + 3)));
                    }
                    statement.addBatch();
                }
                statement.executeBatch();
                isSucess = true;
            }
            catch (Exception e) {
                try {
                    logger.error((Object)("\u3010EIP\u3011\u7b2c" + (i + 1) + "\u6b21\u5c1d\u8bd5\u53cd\u9988\u5931\u8d25"), (Throwable)e);
                    logs.append("\u7b2c" + (i + 1) + "\u6b21\uff1a" + ThrowableHelper.toString(e));
                    Thread.sleep(100L);
                }
                catch (Throwable throwable) {
                    SQLUtil.cleanup(statement, connection);
                    throw throwable;
                }
                SQLUtil.cleanup(statement, connection);
                continue;
            }
            SQLUtil.cleanup(statement, connection);
            break;
        }
        if (!isSucess) {
            throw new Exception("\u5c1d\u8bd5\u53cd\u9988" + retryTimes + "\u6b21\u5931\u8d25\n" + logs);
        }
    }

    private static Map findMidBillIdAndHeadpkOnly(Context ctx, Set<String> headpkSuc, String number) throws BOSException {
        HashMap<String, String> result = new HashMap<String, String>();
        IDynamicBillTemplate template = MidBillFactory.getInstance(ctx, number);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo info = new FilterInfo();
        info.getFilterItems().add(new FilterItemInfo("headpk", headpkSuc, CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("headpk"));
        ev.setSelector(sic);
        ev.setFilter(info);
        DynamicBillTemplateCollection coll = template.getDynamicBillTemplateCollection(ev);
        for (int i = 0; i < coll.size(); ++i) {
            DynamicBillTemplateInfo temp = coll.get(i);
            result.put(temp.get("headpk").toString(), temp.getId().toString());
        }
        return result;
    }

    public static void updateFeedBackLogByMidID(Context ctx, Set<String> ids, String msg, FeedBackStatus status) throws BOSException {
        try {
            StringBuilder message = new StringBuilder(msg == null ? "" : msg);
            FeedBackLogState flag = FeedBackLogState.VOUCHER;
            if (FeedBackStatus.EXPORT_MID_FAILED.equals((Object)status) || FeedBackStatus.EXPORT_MID_SUCCESSED.equals((Object)status) || FeedBackStatus.DELETE_MID_FAILED.equals((Object)status) || FeedBackStatus.DELETE_MID_SUCCESSED.equals((Object)status)) {
                flag = FeedBackLogState.MID;
            }
            IFeedBackLog instance = FeedBackLogFactory.getLocalInstance(ctx);
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("midID", ids, CompareType.INCLUDE));
            ev.setFilter(filter);
            CoreBaseCollection coll = instance.getCollection(ev);
            for (int i = 0; i < coll.size(); ++i) {
                FeedBackLogInfo info = (FeedBackLogInfo)coll.get(i);
                info.setFlag(FeedBackFlag.WAITING);
                info.setStatus(flag);
                info.setFeedBackStatus(status);
                if (FeedBackStatus.DELETE_VOUCHER_SUCCESSED_DM.equals((Object)status) || FeedBackStatus.DELETE_VOUCHER_SUCCESSED_NDM.equals((Object)status)) {
                    info.setVoucherNumber(null);
                }
                StringBuilder sb = new StringBuilder();
                if (!StringUtil.isEmpty((String)info.getVoucherNumber())) {
                    sb.append("VoucherNumber:" + info.getVoucherNumber()).append(" ");
                }
                sb.append((CharSequence)message);
                info.setFeedBackMsg(sb.length() > 2000 ? sb.substring(0, 2000) : sb.toString());
            }
            instance.update(coll);
        }
        catch (Exception e) {
            logger.error((Object)("\u3010EIP\u66f4\u65b0\u53cd\u9988\u65e5\u5fd7\u5931\u8d25\uff0c\u3011status='" + status.getAlias() + ",\u4e2d\u95f4\u8868ID" + ids.toString()), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    public static void updateFeedBackLogByIds(Context ctx, Set<String> ids, FeedBackFlag flag, String msg) throws BOSException {
        try {
            StringBuilder sb = new StringBuilder(msg == null ? "" : msg);
            IFeedBackLog instance = FeedBackLogFactory.getLocalInstance(ctx);
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("midID", ids, CompareType.INCLUDE));
            ev.setFilter(filter);
            CoreBaseCollection coll = instance.getCollection(ev);
            for (int i = 0; i < coll.size(); ++i) {
                FeedBackLogInfo info = (FeedBackLogInfo)coll.get(i);
                info.setFlag(flag);
                info.setErrorMsg(sb.length() > 2000 ? sb.substring(0, 2000) : sb.toString());
            }
            instance.update(coll);
        }
        catch (Exception e) {
            logger.error((Object)("\u3010EIP\u66f4\u65b0\u53cd\u9988\u65e5\u5fd7\u5931\u8d25\uff0c\u3011status='" + flag.getAlias() + ",\u4e2d\u95f4\u8868ID" + ids.toString()), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    public static void updateFeedBackLogByColl(Context ctx, FeedBackLogCollection colls, FeedBackFlag flag, String msg) throws BOSException {
        HashSet<String> ids = new HashSet<String>();
        try {
            StringBuilder sb = new StringBuilder(msg == null ? "" : msg);
            CoreBaseCollection coll = new CoreBaseCollection();
            for (int i = 0; i < colls.size(); ++i) {
                FeedBackLogInfo info = colls.get(i);
                info.setFlag(flag);
                info.setErrorMsg(sb.length() > 2000 ? sb.substring(0, 2000) : sb.toString());
                coll.add((CoreBaseInfo)info);
                ids.add(info.getMidID());
            }
            IFeedBackLog instance = FeedBackLogFactory.getLocalInstance(ctx);
            instance.update(coll);
        }
        catch (Exception e) {
            logger.error((Object)("\u3010EIP\u66f4\u65b0\u53cd\u9988\u65e5\u5fd7\u5931\u8d25\uff0c\u3011status='" + flag.getAlias() + ",\u4e2d\u95f4\u8868ID" + ((Object)ids).toString()), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    public static void doMidFeedBack(final Context ctx, List pks, StructuredDataModel model) throws BOSException {
        final String conn = (String)model.getProperty(FEEDBACK_CONNECTION);
        final String billMapping = (String)model.getProperty(FEEDBACK_BILLMAPPING);
        IFeedBackLog intance = FeedBackLogFactory.getLocalInstance(ctx);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("connection.id", (Object)conn, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("billmapping.id", (Object)billMapping, CompareType.EQUALS));
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < pks.size(); ++i) {
            String temp = pks.get(i).toString();
            set.add(temp.substring(1, temp.length() - 1));
        }
        filter.getFilterItems().add(new FilterItemInfo("headpk", set, CompareType.INCLUDE));
        ev.setFilter(filter);
        final FeedBackLogCollection colls = intance.getFeedBackLogCollection(ev);
        if (colls.isEmpty()) {
            return;
        }
        try {
            TransactionWrapperFacadeFactory.getLocalInstance(ctx).doInvokerWithTransaction(new TransactionBlock(){

                @Override
                public Object doTransaction() throws Exception {
                    BillMappingInfo info = BillMappingFactory.getLocalInstance(ctx).getBillMappingInfo("where id='" + billMapping + "'");
                    ConnectionInfo connect = ConnectionFactory.getLocalInstance(ctx).getConnectionInfo("where id='" + conn + "'");
                    info.setSrcDBConn(connect);
                    FeedBackManager.updateFeedBackLogByColl(ctx, colls, FeedBackFlag.SUCCESSED, "");
                    FeedBackManager.doFeedBack(colls, info, null, false);
                    return Void.TYPE;
                }
            });
        }
        catch (Exception e) {
            FeedBackManager.updateFeedBackLogByColl(ctx, colls, FeedBackFlag.FAILED, ThrowableHelper.toString(e));
            throw new BOSException((Throwable)e);
        }
    }

    public static void asynFeedBackByMidIds(final Context ctx, final Set<String> ids) {
        Runnable asyn = new Runnable(){

            @Override
            public void run() {
                FeedBackManager.feedBackByMidIds(ctx, ids);
            }
        };
        new Thread(asyn).start();
    }

    public static void feedBackByMidIds(final Context ctx, final Set<String> ids) {
        try {
            TransactionWrapperFacadeFactory.getLocalInstance(ctx).doInvokerWithTransaction(new TransactionBlock(){

                @Override
                public Object doTransaction() throws Exception {
                    IFeedBackLog intance = FeedBackLogFactory.getLocalInstance(ctx);
                    EntityViewInfo ev = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("midID", (Object)ids, CompareType.INCLUDE));
                    ev.setFilter(filter);
                    FeedBackLogCollection colls = intance.getFeedBackLogCollection(ev);
                    if (colls.isEmpty()) {
                        return null;
                    }
                    BillMappingInfo info = BillMappingFactory.getLocalInstance(ctx).getBillMappingInfo("select srcDBConn.*,feedback.*,feedbackEnable where id='" + colls.get(0).getBillmapping().getId().toString() + "'");
                    if (!info.isFeedbackEnable()) {
                        return null;
                    }
                    FeedBackManager.updateFeedBackLogByIds(ctx, ids, FeedBackFlag.SUCCESSED, "");
                    FeedBackManager.doFeedBack(colls, info, null, false);
                    return Void.TYPE;
                }
            });
        }
        catch (Exception e) {
            try {
                FeedBackManager.updateFeedBackLogByIds(ctx, ids, FeedBackFlag.FAILED, ThrowableHelper.toString(e));
            }
            catch (Exception e1) {
                logger.error((Object)"\u66f4\u65b0\u53cd\u9988\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
            }
        }
    }

    public static void updateFeedBackLogByBotpRelation(Context ctx, BOTRelationCollection relationColl) throws BOSException {
        HashMap<String, String> map = new HashMap<String, String>();
        HashSet<String> voucherIds = new HashSet<String>();
        for (int i = 0; i < relationColl.size(); ++i) {
            BOTRelationInfo info = relationColl.get(i);
            map.put(info.getDestObjectID(), info.getSrcObjectID());
            voucherIds.add(info.getDestObjectID());
        }
        String sql = "update T_EIP_FeedBackLog set FeedBackMsg=?,FVoucherNumber=?  where fmidid=?";
        ArrayList<String[]> params = new ArrayList<String[]>();
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", voucherIds, CompareType.INCLUDE));
        ev.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        ev.setSelector(sic);
        VoucherCollection coll = VoucherFactory.getLocalInstance((Context)ctx).getVoucherCollection(ev);
        for (int i = 0; i < coll.size(); ++i) {
            VoucherInfo info = coll.get(i);
            String fnumber = info.getNumber();
            String fMidId = (String)map.get(info.getId().toString());
            params.add(new String[]{"VoucherNumber:" + fnumber, fnumber, fMidId});
        }
        DbUtil.executeBatch((Context)ctx, (String)sql, params);
    }
}

