/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.openapi.app.feedback.dispatcher;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.async.app.task.handler.IApiUserHandler;
import com.kingdee.eas.csinterface.eipserviceplugin.execute.IERPExecute;
import com.kingdee.eas.csinterface.openapi.FeedBackServiceInfo;
import com.kingdee.eas.csinterface.openapi.FeedBackServiceType;
import com.kingdee.eas.csinterface.openapi.OpenDataRelationCollection;
import com.kingdee.eas.csinterface.openapi.OpenDataRelationInfo;
import com.kingdee.eas.csinterface.openapi.app.feedback.dispatcher.impl.MQDispatcherImpl;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.eas.csinterface.webservice.WSServiceFactory;
import com.kingdee.eas.csinterface.webservice.WSServiceInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;

public class CommonDispatcherService {
    public static void dispose(Context ctx, CoreBillBaseInfo coreBillInfo, String actionType, FeedBackServiceInfo feedbackService, OpenDataRelationInfo relation) throws BOSException {
        String implClass = feedbackService.getServiceImpl();
        Class<?> clazz = null;
        IApiUserHandler reverseImpl = null;
        try {
            clazz = Class.forName(implClass);
            reverseImpl = (IApiUserHandler)clazz.newInstance();
        }
        catch (Exception e) {
            throw new BOSException("\u627e\u4e0d\u5230\u6307\u5b9a\u7684\u5b9e\u73b0\u7c7b\uff1a" + implClass);
        }
        CoreBillBaseCollection coll = new CoreBillBaseCollection();
        coll.add(coreBillInfo);
        OpenDataRelationCollection relations = new OpenDataRelationCollection();
        relations.add(relation);
        JSONObject bizData = reverseImpl.prepareData(ctx, coll, actionType, relations, feedbackService);
        JSONObject sendData = new JSONObject();
        sendData.put("action", (Object)"feedback");
        sendData.put("data", (Object)bizData);
        CommonDispatcherService.sendData(ctx, feedbackService, sendData);
    }

    private static void sendData(Context ctx, FeedBackServiceInfo feedbackService, JSONObject oldData) throws BOSException {
        FeedBackServiceType serviceType;
        WSServiceInfo wsService = feedbackService.getService();
        IObjectPK pk = CommonUtil.convert2PK(wsService.getId().toString());
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("tree.number"));
        try {
            wsService = WSServiceFactory.getLocalInstance(ctx).getWSServiceInfo(pk, selector);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        String treeNumber = wsService.getTree().getNumber();
        Boolean isIERP = treeNumber.toUpperCase().indexOf("IERP") > -1;
        if (isIERP.booleanValue()) {
            oldData.put("solution", (Object)feedbackService.getSolution());
            wsService = IERPExecute.getWSServiceInfo(ctx, wsService.getId().toString(), wsService.getNumber());
            oldData.put("access", (Object)wsService.getIdentification());
        }
        if (FeedBackServiceType.RabbitMQ.equals((Object)(serviceType = feedbackService.getServiceType()))) {
            MQDispatcherImpl.send(ctx, feedbackService.getQueue(), oldData.toJSONString());
        }
    }
}

