/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.planmanager.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.billmapping.BillMappingEntryCollection;
import com.kingdee.eas.csinterface.billmapping.BillMappingEntryInfo;
import com.kingdee.eas.csinterface.billmapping.BillMappingFactory;
import com.kingdee.eas.csinterface.billmapping.BillMappingHelper;
import com.kingdee.eas.csinterface.billmapping.BillMappingInfo;
import com.kingdee.eas.csinterface.billmapping.BillMappingType;
import com.kingdee.eas.csinterface.billmapping.DynamicsMidBillPublisherFacadeFactory;
import com.kingdee.eas.csinterface.billmapping.IBillMapping;
import com.kingdee.eas.csinterface.billmapping.IDynamicsMidBillPublisherFacade;
import com.kingdee.eas.csinterface.planmanager.IPlanManager;
import com.kingdee.eas.csinterface.planmanager.IPlanManagerBaseDataTypMappingEntry;
import com.kingdee.eas.csinterface.planmanager.PlanManagerBaseDataTypMappingEntryCollection;
import com.kingdee.eas.csinterface.planmanager.PlanManagerBaseDataTypMappingEntryFactory;
import com.kingdee.eas.csinterface.planmanager.PlanManagerBaseDataTypMappingEntryInfo;
import com.kingdee.eas.csinterface.planmanager.PlanManagerFactory;
import com.kingdee.eas.csinterface.planmanager.PlanManagerInfo;
import com.kingdee.eas.csinterface.planmanager.app.AbstractPlanmanagerFacadeControllerBean;
import com.kingdee.eas.csinterface.syncdatabase.AssistAccountTypeEntryCollection;
import com.kingdee.eas.csinterface.syncdatabase.AssistAccountTypeEntryInfo;
import com.kingdee.eas.csinterface.syncdatabase.AssistAccountTypeFactory;
import com.kingdee.eas.csinterface.syncdatabase.AssistAccountTypeInfo;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataFactory;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataInfo;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataMapingFactory;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataMapingInfo;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataTypeFactory;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataTypeInfo;
import com.kingdee.eas.csinterface.syncdatabase.IAssistAccountType;
import com.kingdee.eas.csinterface.syncdatabase.IBaseDataType;
import com.kingdee.eas.csinterface.syncdatabase.ISrcDBView;
import com.kingdee.eas.csinterface.syncdatabase.SrcDBViewFactory;
import com.kingdee.eas.csinterface.syncdatabase.SrcDBViewInfo;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.eas.csinterface.util.ImportUtil;
import com.kingdee.eas.csinterface.webservice.IWSBillMapping;
import com.kingdee.eas.csinterface.webservice.IWSFreeMarker;
import com.kingdee.eas.csinterface.webservice.IWSFreeMarkerTree;
import com.kingdee.eas.csinterface.webservice.IWSInterface;
import com.kingdee.eas.csinterface.webservice.IWSInterfaceTree;
import com.kingdee.eas.csinterface.webservice.IWSService;
import com.kingdee.eas.csinterface.webservice.IWSServiceURL;
import com.kingdee.eas.csinterface.webservice.WSBillMappingEntryCollection;
import com.kingdee.eas.csinterface.webservice.WSBillMappingEntryInfo;
import com.kingdee.eas.csinterface.webservice.WSBillMappingFactory;
import com.kingdee.eas.csinterface.webservice.WSBillMappingInfo;
import com.kingdee.eas.csinterface.webservice.WSFreeMarkerFactory;
import com.kingdee.eas.csinterface.webservice.WSFreeMarkerInfo;
import com.kingdee.eas.csinterface.webservice.WSFreeMarkerTreeFactory;
import com.kingdee.eas.csinterface.webservice.WSFreeMarkerTreeInfo;
import com.kingdee.eas.csinterface.webservice.WSInterfaceCollection;
import com.kingdee.eas.csinterface.webservice.WSInterfaceFactory;
import com.kingdee.eas.csinterface.webservice.WSInterfaceInfo;
import com.kingdee.eas.csinterface.webservice.WSInterfaceTreeFactory;
import com.kingdee.eas.csinterface.webservice.WSInterfaceTreeInfo;
import com.kingdee.eas.csinterface.webservice.WSServiceEntryInfo;
import com.kingdee.eas.csinterface.webservice.WSServiceFactory;
import com.kingdee.eas.csinterface.webservice.WSServiceInfo;
import com.kingdee.eas.csinterface.webservice.WSServiceURLFactory;
import com.kingdee.eas.csinterface.webservice.WSServiceURLInfo;
import com.kingdee.eas.csinterface.webservice.model.util.WSInterfaceEditUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.TreeBaseInfo;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class PlanmanagerFacadeControllerBean
extends AbstractPlanmanagerFacadeControllerBean {
    private static final long serialVersionUID = -1948919235836067602L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.csinterface.planmanager.PlanmanagerFacadeControllerBean");
    private Map baseDataTypeFIDMap = new HashMap();
    private Map assistAccountTypeFIDMap = new HashMap();

    @Override
    protected void _saveImportPlan(Context ctx, IObjectValue planManagerInfo) throws BOSException, EASBizException {
        this.baseDataTypeFIDMap.clear();
        PlanManagerInfo info = (PlanManagerInfo)planManagerInfo;
        this.saveSrcDBViewInfo(ctx, info);
        this.saveBaseDataTypeInfos(ctx, info);
        this.saveAssistAccountInfo(ctx, info);
        BillMappingInfo billMappingInfo = this.saveBillMappingInfo(ctx, info);
        BOTMappingInfo botpInfo = info.getBotprule();
        if (botpInfo != null) {
            String name = "com.kingdee.eas.csinterface.custom.app." + billMappingInfo.getNumber();
            botpInfo.setSrcEntityFullName(name);
        }
        this.saveBOTMappingInfo(ctx, info);
        this.savePlanManagerInfo(ctx, info);
    }

    private void saveSrcDBViewInfo(Context ctx, PlanManagerInfo planManagerInfo) throws BOSException, EASBizException {
        SrcDBViewInfo info = planManagerInfo.getCreatesourceviewsql();
        if (null != info) {
            try {
                ISrcDBView instance = SrcDBViewFactory.getLocalInstance(ctx);
                String currentNumber = info.getNumber();
                EntityViewInfo view = ImportUtil.getEntityViewInfo4Equal("number", currentNumber);
                String targetNumber = ImportUtil.getTargetValue((ICoreBase)instance, view, currentNumber);
                String currentName = info.getName();
                EntityViewInfo viewName = ImportUtil.getEntityViewInfo4Equal("name", currentName);
                String targetName = ImportUtil.getTargetValue((ICoreBase)instance, viewName, currentName);
                info.setName(targetName);
                info.setNumber(targetNumber);
                IObjectPK objectUuidPK = instance.addnew((CoreBaseInfo)info);
                info.setId((BOSUuid)objectUuidPK.getKeyValue("id"));
            }
            catch (Exception e) {
                throw new BOSException("\u5f15\u5165\u65b9\u6848\u7684\u3010\u6e90\u7cfb\u7edf\u89c6\u56fe\u3011\u4fe1\u606f\u4fdd\u5b58\u5f02\u5e38\u3002", (Throwable)e);
            }
        }
    }

    private void saveBaseDataTypeInfos(Context ctx, PlanManagerInfo planManagerInfo) throws BOSException, EASBizException {
        PlanManagerBaseDataTypMappingEntryCollection collection = planManagerInfo.getBaseDataTypMappingEntry();
        if (null != collection && collection.size() > 0) {
            try {
                int length = collection.size();
                IBaseDataType instance = BaseDataTypeFactory.getLocalInstance(ctx);
                IPlanManagerBaseDataTypMappingEntry entryInstance = PlanManagerBaseDataTypMappingEntryFactory.getLocalInstance(ctx);
                for (int i = 0; i < length; ++i) {
                    BaseDataTypeInfo info;
                    PlanManagerBaseDataTypMappingEntryInfo item = collection.get(i);
                    if (null == item || null == (info = item.getBaseDataTypeF7())) continue;
                    String currentNumber = info.getNumber();
                    EntityViewInfo view = ImportUtil.getEntityViewInfo4Equal("number", currentNumber);
                    String targetNumber = ImportUtil.getTargetValue((ICoreBase)instance, view, currentNumber);
                    info.setNumber(targetNumber);
                    String currentName = info.getName();
                    EntityViewInfo viewName = ImportUtil.getEntityViewInfo4Equal("name", currentName);
                    String targetName = ImportUtil.getTargetValue((ICoreBase)instance, viewName, currentName);
                    info.setName(targetName);
                    IObjectPK objectUuidPK = instance.addnew(info);
                    BOSUuid newBOSUuid = (BOSUuid)objectUuidPK.getKeyValue("id");
                    info.setId(newBOSUuid);
                    String oldFID = (String)info.get("baseDataTypeFID_TO_BE_REFERENCED");
                    if (null != oldFID) {
                        this.baseDataTypeFIDMap.put(oldFID, newBOSUuid.toString());
                    }
                    logger.info((Object)("baseDateTypeMap(" + i + "):[" + oldFID + "] -> [" + newBOSUuid.toString() + "]"));
                    BaseDataMapingInfo mappingInfo = new BaseDataMapingInfo();
                    mappingInfo.setBaseDataType(info);
                    mappingInfo.setNumber(info.getNumber());
                    mappingInfo.setApplicationScope(info.getApplicationScope());
                    try {
                        BaseDataInfo baseData = info.getDestBaseData();
                        IObjectPK pk = CommonUtil.convert2PK(baseData.getId().toString());
                        baseData = BaseDataFactory.getLocalInstance(ctx).getBaseDataInfo(pk);
                        String queryName = baseData.getQueryName();
                        OrgType orgType = CommonUtil.getOrgTypeByQueryName(queryName);
                    }
                    catch (Exception e) {
                        logger.info((Object)("\u81ea\u52a8\u521b\u5efa\u503c\u6620\u5c04\u65f6\uff0c\u8bbe\u7f6e\u7ec4\u7ec7\u51fa\u9519\uff0c\u7c7b\u578b\u6620\u5c04\u7f16\u7801\uff1a" + info.getNumber()));
                    }
                    IObjectPK iObjectPK = BaseDataMapingFactory.getLocalInstance(ctx).save((CoreBaseInfo)mappingInfo);
                }
            }
            catch (Exception e) {
                throw new BOSException("\u5f15\u5165\u65b9\u6848\u7684\u3010\u57fa\u7840\u6570\u636e\u7c7b\u578b\u6620\u5c04\u3011\u4fe1\u606f\u4fdd\u5b58\u5f02\u5e38\u3002", (Throwable)e);
            }
        }
    }

    private BillMappingInfo saveBillMappingInfo(Context ctx, PlanManagerInfo planManagerInfo) throws BOSException, EASBizException {
        BillMappingInfo info = planManagerInfo.getBizbillmapping();
        if (null != info) {
            try {
                IBillMapping instance = BillMappingFactory.getLocalInstance(ctx);
                String currentNumber = info.getNumber();
                EntityViewInfo view = ImportUtil.getEntityViewInfo4Equal("number", currentNumber);
                String targetNumber = ImportUtil.getTargetValue((ICoreBase)instance, view, currentNumber, false);
                info.setNumber(targetNumber);
                String midBillTable = BillMappingHelper.calc2MidBillTableName(targetNumber);
                info.setMidBillTable(midBillTable);
                String midBillEntryTable = BillMappingHelper.calc2MidBillEntryTableName(targetNumber);
                info.setMidBillEntryTable(midBillEntryTable);
                String billMappingName = info.getBillMappingName();
                EntityViewInfo nameView = ImportUtil.getEntityViewInfo4Equal("billMappingName", billMappingName);
                String targetBillMappingName = ImportUtil.getTargetValue((ICoreBase)instance, nameView, billMappingName, false);
                info.setBillMappingName(targetBillMappingName);
                String midBillEntityMetaAlias = BillMappingHelper.calc2MidBillEntityMetaAlias(targetBillMappingName);
                info.setMidBillEntityMetaAlias(midBillEntityMetaAlias);
                IBaseDataType IBaseDataTypeInstance = BaseDataTypeFactory.getLocalInstance(ctx);
                BillMappingEntryCollection entryCollection = info.getEntrys();
                for (int i = 0; i < entryCollection.size(); ++i) {
                    BillMappingEntryInfo entryInfo = entryCollection.get(i);
                    this.replaceBaseDataType(IBaseDataTypeInstance, entryInfo);
                }
                info.setIntegrateCashFlow(info.isIntegrateCashFlow());
                if (info.getMappingType() == null) {
                    info.setMappingType(BillMappingType.billMapping);
                }
                IAssistAccountType IAssistAccountTypeInstance = AssistAccountTypeFactory.getLocalInstance(ctx);
                this.replaceAssistAccountType(IAssistAccountTypeInstance, info);
                IObjectPK objectUuidPK = instance.addnew(info);
                info.setId((BOSUuid)objectUuidPK.getKeyValue("id"));
                BOTMappingInfo botpInfo = planManagerInfo.getBotprule();
                if (botpInfo != null) {
                    botpInfo.setSrcEntityFullName("com.kingdee.eas.csinterface.custom.app." + targetNumber);
                    botpInfo.setSrcEntityAlias(info.getMidBillEntityMetaAlias());
                }
            }
            catch (Exception e) {
                throw new BOSException("\u5f15\u5165\u65b9\u6848\u7684\u3010\u4e1a\u52a1\u5355\u636e\u6620\u5c04\u89c4\u5219\u3011\u4fe1\u606f\u4fdd\u5b58\u5f02\u5e38\u3002", (Throwable)e);
            }
        }
        return info;
    }

    private void replaceBaseDataType(IBaseDataType instance, BillMappingEntryInfo entryInfo) throws EASBizException, BOSException {
        String oldFID = (String)entryInfo.get("baseDataTypeFID_TO_BE_REPLACED");
        if (null != oldFID) {
            String newFID = (String)this.baseDataTypeFIDMap.get(oldFID);
            if (null == newFID) {
                logger.error((Object)("\u672a\u80fd\u627e\u5230\u57fa\u7840\u8d44\u6599FID[" + oldFID + "]\u5728\u76ee\u6807\u7cfb\u7edf\u4e2d\u5bf9\u5e94\u7684\u65b0\u7684FID\u3002"));
                return;
            }
            BaseDataTypeInfo item = instance.getBaseDataTypeInfo((IObjectPK)new ObjectUuidPK(newFID));
            entryInfo.setBaseDataType(item);
        }
    }

    private void publishBillMapping(Context ctx, BillMappingInfo billMappingInfo) throws BOSException, EASBizException {
        if (null == billMappingInfo) {
            return;
        }
        String id = billMappingInfo.getId().toString();
        IDynamicsMidBillPublisherFacade facade = DynamicsMidBillPublisherFacadeFactory.getLocalInstance(ctx);
        facade.publish(id);
    }

    private void saveBOTMappingInfo(Context ctx, PlanManagerInfo planManagerInfo) throws BOSException, EASBizException {
        BOTMappingInfo info = planManagerInfo.getBotprule();
        if (null != info) {
            try {
                IBOTMapping instance = BOTMappingFactory.getLocalInstance((Context)ctx);
                String currentName = info.getName();
                EntityViewInfo view = ImportUtil.getEntityViewInfo4Equal("name", currentName);
                String targetName = ImportUtil.getTargetValue((ICoreBase)instance, view, currentName);
                info.setName(targetName);
                String currentAliasName = info.getAlias();
                EntityViewInfo aliasView = ImportUtil.getEntityViewInfo4Equal("alias", currentAliasName);
                String targetAliasName = ImportUtil.getTargetValue((ICoreBase)instance, aliasView, currentAliasName);
                info.setAlias(targetAliasName);
                IObjectPK objectUuidPK = instance.addnew((CoreBaseInfo)info);
                instance.enableMapping((IObjectPK)new ObjectUuidPK(info.getId().toString()));
                info.setId((BOSUuid)objectUuidPK.getKeyValue("id"));
            }
            catch (Exception e) {
                throw new BOSException("\u5f15\u5165\u65b9\u6848\u7684\u3010BOTP\u89c4\u5219\u3011\u4fe1\u606f\u4fdd\u5b58\u5f02\u5e38\u3002", (Throwable)e);
            }
        }
    }

    private void savePlanManagerInfo(Context ctx, PlanManagerInfo planManagerInfo) throws BOSException, EASBizException {
        IPlanManager instance = PlanManagerFactory.getLocalInstance(ctx);
        String baseValue = planManagerInfo.getNumber();
        EntityViewInfo view = ImportUtil.getEntityViewInfo4Equal("number", baseValue);
        String targetNumber = ImportUtil.getTargetValue((ICoreBase)instance, view, baseValue);
        planManagerInfo.setNumber(targetNumber);
        IObjectPK objectUuidPK = instance.addnew((CoreBaseInfo)planManagerInfo);
        planManagerInfo.setId((BOSUuid)objectUuidPK.getKeyValue("id"));
    }

    private void saveAssistAccountInfo(Context ctx, PlanManagerInfo planManagerInfo) {
        BillMappingInfo info = planManagerInfo.getBizbillmapping();
        AssistAccountTypeInfo aaTypeInfo = info.getAssistAccountType();
        if (null != aaTypeInfo) {
            try {
                IAssistAccountType instance = AssistAccountTypeFactory.getLocalInstance(ctx);
                String currentNumber = aaTypeInfo.getNumber();
                EntityViewInfo view = ImportUtil.getEntityViewInfo4Equal("number", currentNumber);
                String targetNumber = ImportUtil.getTargetValue((ICoreBase)instance, view, currentNumber, false);
                aaTypeInfo.setNumber(targetNumber);
                IBaseDataType IBaseDataTypeInstance = BaseDataTypeFactory.getLocalInstance(ctx);
                AssistAccountTypeEntryCollection entryCollection = aaTypeInfo.getEntrys();
                for (int i = 0; i < entryCollection.size(); ++i) {
                    AssistAccountTypeEntryInfo entryInfo = entryCollection.get(i);
                    this.replaceBaseDataType(IBaseDataTypeInstance, entryInfo);
                }
                IObjectPK newBOSUuid = instance.addnew(aaTypeInfo);
                String oldFID = (String)aaTypeInfo.get("assistAccountTypeFID_TO_BE_REPLACED");
                if (null != oldFID) {
                    this.assistAccountTypeFIDMap.put(oldFID, newBOSUuid.toString());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void replaceBaseDataType(IBaseDataType instance, AssistAccountTypeEntryInfo entryInfo) throws EASBizException, BOSException {
        String oldFID = (String)entryInfo.get("baseDataTypeFID_TO_BE_REPLACED");
        if (null != oldFID) {
            String newFID = (String)this.baseDataTypeFIDMap.get(oldFID);
            if (null == newFID) {
                logger.error((Object)("\u672a\u80fd\u627e\u5230\u57fa\u7840\u8d44\u6599FID[" + oldFID + "]\u5728\u76ee\u6807\u7cfb\u7edf\u4e2d\u5bf9\u5e94\u7684\u65b0\u7684FID\u3002"));
                return;
            }
            BaseDataTypeInfo item = instance.getBaseDataTypeInfo((IObjectPK)new ObjectUuidPK(newFID));
            entryInfo.setBaseDataType(item);
        }
    }

    private void replaceAssistAccountType(IAssistAccountType instance, BillMappingInfo info) throws EASBizException, BOSException {
        String oldFID = (String)info.get("assistAccountTypeFID_TO_BE_REPLACED");
        if (null != oldFID) {
            String newFID = (String)this.assistAccountTypeFIDMap.get(oldFID);
            if (null == newFID) {
                logger.error((Object)("\u672a\u80fd\u627e\u5230\u57fa\u7840\u8d44\u6599FID[" + oldFID + "]\u5728\u76ee\u6807\u7cfb\u7edf\u4e2d\u5bf9\u5e94\u7684\u65b0\u7684FID\u3002"));
                return;
            }
            AssistAccountTypeInfo item = instance.getAssistAccountTypeInfo((IObjectPK)new ObjectUuidPK(newFID));
            info.setAssistAccountType(item);
        }
    }

    @Override
    protected void _saveImportWSInterface(Context ctx, IObjectCollection wsInterfaceCollection) throws BOSException {
        this.baseDataTypeFIDMap.clear();
        WSInterfaceCollection collInfo = (WSInterfaceCollection)wsInterfaceCollection;
        try {
            for (int i = 0; i < collInfo.size(); ++i) {
                WSInterfaceInfo info = collInfo.get(i);
                if (null == info) {
                    return;
                }
                this.saveWSBaseDataTypeInfos(ctx, info);
                this.saveWSBillMappingInfo(ctx, info);
                this.saveWSMarkerTreeInfo(ctx, info.getQueryFreeMarker());
                info.setQueryFreeMarker(this.saveWSMarkerInfo(ctx, info.getQueryFreeMarker()));
                this.saveWSMarkerTreeInfo(ctx, info.getFreeMarker());
                info.setFreeMarker(this.saveWSMarkerInfo(ctx, info.getFreeMarker()));
                this.saveWSServiceURLInfo(ctx, info.getWebservice());
                WSServiceInfo serviceInfo = this.saveWSServiceInfo(ctx, info.getWebservice());
                info.setWebservice(serviceInfo);
                this.saveWSInterfaceTreeInfo(ctx, info);
                this.saveWSInterfaceInfo(ctx, info);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void saveWSBaseDataTypeInfos(Context ctx, WSInterfaceInfo wsinterfaceInfo) throws BOSException, EASBizException {
        WSBillMappingEntryCollection coll = wsinterfaceInfo.getWsbillMapping().getEntrys();
        if (null != coll && coll.size() > 0) {
            int length = coll.size();
            IBaseDataType instance = BaseDataTypeFactory.getLocalInstance(ctx);
            for (int i = 0; i < length; ++i) {
                BaseDataTypeInfo baseDataTypeInfo;
                if (coll.get(i).getBaseDataType() == null || null == (baseDataTypeInfo = coll.get(i).getBaseDataType())) continue;
                String currentNumber = baseDataTypeInfo.getNumber();
                EntityViewInfo view = ImportUtil.getEntityViewInfo4Equal("number", currentNumber);
                String targetNumber = ImportUtil.getTargetValue((ICoreBase)instance, view, currentNumber);
                baseDataTypeInfo.setNumber(targetNumber);
                String currentName = baseDataTypeInfo.getName();
                EntityViewInfo viewName = ImportUtil.getEntityViewInfo4Equal("name", currentName);
                String targetName = ImportUtil.getTargetValue((ICoreBase)instance, viewName, currentName);
                baseDataTypeInfo.setName(targetName);
                IObjectPK objectUuidPK = instance.addnew(baseDataTypeInfo);
                BOSUuid newBOSUuid = (BOSUuid)objectUuidPK.getKeyValue("id");
                baseDataTypeInfo.setId(newBOSUuid);
                String oldFID = (String)baseDataTypeInfo.get("baseDataTypeFID_TO_BE_REFERENCED");
                if (null != oldFID) {
                    this.baseDataTypeFIDMap.put(oldFID, newBOSUuid.toString());
                }
                logger.info((Object)("baseDateTypeMap(" + i + "):[" + oldFID + "] -> [" + newBOSUuid.toString() + "]"));
                BaseDataMapingInfo mappingInfo = new BaseDataMapingInfo();
                mappingInfo.setBaseDataType(baseDataTypeInfo);
                mappingInfo.setNumber(baseDataTypeInfo.getNumber());
                mappingInfo.setApplicationScope(baseDataTypeInfo.getApplicationScope());
                try {
                    BaseDataInfo baseData = baseDataTypeInfo.getDestBaseData();
                    IObjectPK pk = CommonUtil.convert2PK(baseData.getId().toString());
                    baseData = BaseDataFactory.getLocalInstance(ctx).getBaseDataInfo(pk);
                    String queryName = baseData.getQueryName();
                    OrgType orgType = CommonUtil.getOrgTypeByQueryName(queryName);
                }
                catch (Exception e) {
                    logger.info((Object)("\u81ea\u52a8\u521b\u5efa\u503c\u6620\u5c04\u65f6\uff0c\u8bbe\u7f6e\u7ec4\u7ec7\u51fa\u9519\uff0c\u7c7b\u578b\u6620\u5c04\u7f16\u7801\uff1a" + baseDataTypeInfo.getNumber()));
                }
                IObjectPK iObjectPK = BaseDataMapingFactory.getLocalInstance(ctx).save((CoreBaseInfo)mappingInfo);
            }
        }
    }

    private void saveWSMarkerTreeInfo(Context ctx, WSFreeMarkerInfo info) throws BOSException, EASBizException {
        if (null != info && null != info.getTree()) {
            try {
                Boolean isExist;
                IWSFreeMarkerTree instance = WSFreeMarkerTreeFactory.getLocalInstance(ctx);
                WSFreeMarkerTreeInfo treeInfo = info.getTree();
                WSFreeMarkerTreeInfo parentInfo = null;
                if (treeInfo.getParent() != null) {
                    parentInfo = (WSFreeMarkerTreeInfo)this.saveTreeParentInfo(ctx, treeInfo.getParent());
                    treeInfo.setParent(parentInfo);
                }
                String currentNumber = treeInfo.getNumber();
                EntityViewInfo view = ImportUtil.getEntityViewInfo4Equal("number", currentNumber);
                if (parentInfo != null) {
                    FilterInfo filterInfo = new FilterInfo();
                    filterInfo.getFilterItems().add(new FilterItemInfo("parent", (Object)parentInfo.getId().toString(), CompareType.EQUALS));
                    view.getFilter().mergeFilter(filterInfo, "AND");
                }
                if ((isExist = Boolean.valueOf(instance.exists(view.getFilter()))).booleanValue()) {
                    treeInfo = (WSFreeMarkerTreeInfo)instance.getTreeBaseCollection(view).get(0);
                } else {
                    IObjectPK objectUuidPK = instance.addnew(treeInfo);
                    treeInfo = instance.getWSFreeMarkerTreeInfo(objectUuidPK);
                }
                info.setTree(treeInfo);
            }
            catch (Exception e) {
                throw new BOSException("\u5f15\u5165\u63a5\u53e3\u7684\u3010\u6570\u636e\u8f6c\u6362\u6a21\u677f\u3011\u4fe1\u606f\u4fdd\u5b58\u5f02\u5e38\u3002", (Throwable)e);
            }
        }
    }

    private void saveWSBillMappingInfo(Context ctx, WSInterfaceInfo wsinterfaceInfo) throws BOSException, EASBizException {
        WSBillMappingInfo info = wsinterfaceInfo.getWsbillMapping();
        if (null != info) {
            try {
                IWSBillMapping instance = WSBillMappingFactory.getLocalInstance(ctx);
                String currentNumber = info.getNumber();
                EntityViewInfo view = ImportUtil.getEntityViewInfo4Equal("number", currentNumber);
                Boolean isExist = instance.exists(view.getFilter());
                if (isExist.booleanValue()) {
                    info = (WSBillMappingInfo)instance.getCollection(view).get(0);
                } else {
                    IBaseDataType IBaseDataTypeInstance = BaseDataTypeFactory.getLocalInstance(ctx);
                    WSBillMappingEntryCollection entryCollection = info.getEntrys();
                    for (int i = 0; i < entryCollection.size(); ++i) {
                        WSBillMappingEntryInfo entryInfo = entryCollection.get(i);
                        this.replaceBaseDataType(IBaseDataTypeInstance, entryInfo);
                    }
                    IObjectPK objectUuidPK = instance.addnew(info);
                    info = instance.getWSBillMappingInfo(objectUuidPK);
                }
                wsinterfaceInfo.setWsbillMapping(info);
            }
            catch (Exception e) {
                throw new BOSException("\u5f15\u5165\u63a5\u53e3\u7684\u3010\u6570\u636e\u6a21\u578b\u3011\u4fe1\u606f\u4fdd\u5b58\u5f02\u5e38\u3002", (Throwable)e);
            }
        }
    }

    private void replaceBaseDataType(IBaseDataType instance, WSBillMappingEntryInfo entryInfo) throws EASBizException, BOSException {
        String oldFID = (String)entryInfo.get("baseDataTypeFID_TO_BE_REPLACED");
        if (null != oldFID) {
            String newFID = (String)this.baseDataTypeFIDMap.get(oldFID);
            if (null == newFID) {
                logger.error((Object)("\u672a\u80fd\u627e\u5230\u57fa\u7840\u8d44\u6599FID[" + oldFID + "]\u5728\u76ee\u6807\u7cfb\u7edf\u4e2d\u5bf9\u5e94\u7684\u65b0\u7684FID\u3002"));
                return;
            }
            BaseDataTypeInfo item = instance.getBaseDataTypeInfo((IObjectPK)new ObjectUuidPK(newFID));
            entryInfo.setBaseDataType(item);
        }
    }

    private WSFreeMarkerInfo saveWSMarkerInfo(Context ctx, WSFreeMarkerInfo wsfreeMarkerInfo) throws BOSException, EASBizException {
        if (null == wsfreeMarkerInfo) {
            return null;
        }
        try {
            IWSFreeMarker instance = WSFreeMarkerFactory.getLocalInstance(ctx);
            String currentNumber = wsfreeMarkerInfo.getNumber();
            EntityViewInfo view = ImportUtil.getEntityViewInfo4Equal("number", currentNumber);
            Boolean isExist = instance.exists(view.getFilter());
            if (isExist.booleanValue()) {
                wsfreeMarkerInfo = instance.getWSFreeMarkerCollection(view).get(0);
            } else {
                IObjectPK objectUuidPK = instance.addnew(wsfreeMarkerInfo);
                wsfreeMarkerInfo = instance.getWSFreeMarkerInfo(objectUuidPK);
            }
        }
        catch (Exception e) {
            throw new BOSException("\u5f15\u5165\u63a5\u53e3\u7684\u3010\u6570\u636e\u8f6c\u6362\u6a21\u677f\u3011\u4fe1\u606f\u4fdd\u5b58\u5f02\u5e38\u3002", (Throwable)e);
        }
        return wsfreeMarkerInfo;
    }

    private void saveWSServiceURLInfo(Context ctx, WSServiceInfo info) throws BOSException, EASBizException {
        if (null != info && null != info.getTree()) {
            try {
                IWSServiceURL instance = WSServiceURLFactory.getLocalInstance(ctx);
                WSServiceURLInfo treeInfo = info.getTree();
                WSServiceURLInfo parentInfo = treeInfo.getParent();
                if (null != parentInfo) {
                    parentInfo = (WSServiceURLInfo)this.saveTreeParentInfo(ctx, parentInfo);
                    treeInfo.setParent(parentInfo);
                } else {
                    String currentNumber = treeInfo.getNumber();
                    EntityViewInfo view = ImportUtil.getEntityViewInfo4Equal("number", currentNumber);
                    Boolean isExist = instance.exists(view.getFilter());
                    if (isExist.booleanValue()) {
                        treeInfo = (WSServiceURLInfo)instance.getTreeBaseCollection(view).get(0);
                    } else {
                        IObjectPK objectUuidPK = instance.addnew(treeInfo);
                        treeInfo = instance.getWSServiceURLInfo(objectUuidPK);
                    }
                }
                info.setTree(treeInfo);
            }
            catch (Exception e) {
                throw new BOSException("\u5f15\u5165\u63a5\u53e3\u7684\u3010\u8fdc\u7a0b\u670d\u52a1\u3011\u4fe1\u606f\u4fdd\u5b58\u5f02\u5e38\u3002", (Throwable)e);
            }
        }
    }

    private WSServiceInfo saveWSServiceInfo(Context ctx, WSServiceInfo wsserviceInfo) throws BOSException, EASBizException {
        if (null == wsserviceInfo) {
            return null;
        }
        try {
            IWSService instance = WSServiceFactory.getLocalInstance(ctx);
            String currentNumber = wsserviceInfo.getNumber();
            EntityViewInfo view = ImportUtil.getEntityViewInfo4Equal("number", currentNumber);
            Boolean isExist = instance.exists(view.getFilter());
            if (isExist.booleanValue()) {
                wsserviceInfo = instance.getWSServiceCollection(view).get(0);
                wsserviceInfo = WSServiceFactory.getLocalInstance(ctx).getWSServiceInfo("select *,entrys.*,entrys.freeMarker.*,entrys.loginService.* where id = '" + wsserviceInfo.getId().toString() + "'");
            } else {
                for (int i = 0; i < wsserviceInfo.getEntrys().size(); ++i) {
                    WSServiceEntryInfo wsserviceEntryInfo = wsserviceInfo.getEntrys().get(i);
                    if (wsserviceEntryInfo.getFreeMarker() != null) {
                        this.saveWSServiceEntryFreeMarker(ctx, wsserviceEntryInfo);
                    }
                    if (wsserviceEntryInfo.getLoginService() == null) continue;
                    this.saveWSServiceEntryLoginService(ctx, wsserviceEntryInfo);
                }
                IObjectPK objectUuidPK = instance.addnew(wsserviceInfo);
                wsserviceInfo = instance.getWSServiceInfo(objectUuidPK);
            }
        }
        catch (Exception e) {
            throw new BOSException("\u5f15\u5165\u63a5\u53e3\u7684\u3010\u8fdc\u7a0b\u670d\u52a1\u3011\u4fe1\u606f\u4fdd\u5b58\u5f02\u5e38\u3002", (Throwable)e);
        }
        return wsserviceInfo;
    }

    private void saveWSServiceEntryFreeMarker(Context ctx, WSServiceEntryInfo wsserviceEntryInfo) throws EASBizException, BOSException {
        WSFreeMarkerInfo info = wsserviceEntryInfo.getFreeMarker();
        this.saveWSMarkerTreeInfo(ctx, info);
        wsserviceEntryInfo.setFreeMarker(this.saveWSMarkerInfo(ctx, info));
    }

    private void saveWSServiceEntryLoginService(Context ctx, WSServiceEntryInfo wsserviceEntryInfo) throws EASBizException, BOSException {
        String currentNumber;
        EntityViewInfo view;
        WSServiceInfo info = wsserviceEntryInfo.getLoginService();
        IWSService instance = WSServiceFactory.getLocalInstance(ctx);
        Boolean isExist = instance.exists((view = ImportUtil.getEntityViewInfo4Equal("number", currentNumber = info.getNumber())).getFilter());
        if (isExist.booleanValue()) {
            info = instance.getWSServiceCollection(view).get(0);
        } else {
            this.saveWSServiceURLInfo(ctx, info);
            info = this.saveWSServiceInfo(ctx, info);
        }
        wsserviceEntryInfo.setLoginService(info);
    }

    private void saveWSInterfaceTreeInfo(Context ctx, WSInterfaceInfo info) throws BOSException, EASBizException {
        if (null != info && null != info.getTree()) {
            try {
                Boolean isExist;
                IWSInterfaceTree instance = WSInterfaceTreeFactory.getLocalInstance(ctx);
                WSInterfaceTreeInfo treeInfo = info.getTree();
                WSInterfaceTreeInfo parentInfo = null;
                if (treeInfo.getParent() != null) {
                    parentInfo = (WSInterfaceTreeInfo)this.saveTreeParentInfo(ctx, treeInfo.getParent());
                    treeInfo.setParent(parentInfo);
                }
                String currentNumber = treeInfo.getNumber();
                EntityViewInfo view = ImportUtil.getEntityViewInfo4Equal("number", currentNumber);
                FilterInfo filterInfo = new FilterInfo();
                if (parentInfo != null) {
                    filterInfo.getFilterItems().add(new FilterItemInfo("parent", (Object)parentInfo.getId().toString(), CompareType.EQUALS));
                    view.getFilter().mergeFilter(filterInfo, "AND");
                }
                if ((isExist = Boolean.valueOf(instance.exists(view.getFilter()))).booleanValue()) {
                    treeInfo = (WSInterfaceTreeInfo)instance.getTreeBaseCollection(view).get(0);
                } else {
                    IObjectPK objectUuidPK = instance.addnew((CoreBaseInfo)treeInfo);
                    treeInfo = instance.getWSInterfaceTreeInfo(objectUuidPK);
                }
                info.setTree(treeInfo);
            }
            catch (Exception e) {
                throw new BOSException("\u5f15\u5165\u63a5\u53e3\u4fe1\u606f\u4fdd\u5b58\u5f02\u5e38\u3002", (Throwable)e);
            }
        }
    }

    private TreeBaseInfo saveTreeParentInfo(Context ctx, TreeBaseInfo treeInfo) throws BOSException, EASBizException {
        Object instance = null;
        if (treeInfo == null || treeInfo.getLevel() != 1) {
            return treeInfo;
        }
        try {
            if (treeInfo instanceof WSInterfaceTreeInfo) {
                instance = WSInterfaceTreeFactory.getLocalInstance(ctx);
            } else if (treeInfo instanceof WSFreeMarkerTreeInfo) {
                instance = WSFreeMarkerTreeFactory.getLocalInstance(ctx);
            } else if (treeInfo instanceof WSServiceURLInfo) {
                instance = WSServiceURLFactory.getLocalInstance(ctx);
            }
            String currentNumber = treeInfo.getNumber();
            EntityViewInfo view = ImportUtil.getEntityViewInfo4Equal("number", currentNumber);
            if (instance == null) {
                throw new NullPointerException("instance\u521d\u59cb\u5316\u5931\u8d25");
            }
            Boolean isExist = instance.exists(view.getFilter());
            if (isExist.booleanValue()) {
                treeInfo = instance.getTreeBaseCollection(view).get(0);
            } else {
                IObjectPK objectUuidPK = instance.addnew((CoreBaseInfo)treeInfo);
                if ((treeInfo = instance.getTreeBaseInfo(objectUuidPK)) instanceof WSInterfaceTreeInfo) {
                    WSInterfaceEditUtil.addChildrenNode(ctx, (WSInterfaceTreeInfo)treeInfo);
                }
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return treeInfo;
    }

    private void saveWSInterfaceInfo(Context ctx, WSInterfaceInfo wsinterfaceInfo) throws BOSException, EASBizException {
        try {
            IWSInterface instance = WSInterfaceFactory.getLocalInstance(ctx);
            String currentNumber = wsinterfaceInfo.getNumber();
            EntityViewInfo view = ImportUtil.getEntityViewInfo4Equal("number", currentNumber);
            Boolean isExist = instance.exists(view.getFilter());
            if (isExist.booleanValue()) {
                wsinterfaceInfo = instance.getWSInterfaceCollection().get(0);
            } else {
                WSInterfaceTreeInfo treInfo = wsinterfaceInfo.getTree();
                IObjectPK objectUuidPK = instance.addnew(wsinterfaceInfo);
                wsinterfaceInfo = instance.getWSInterfaceInfo(objectUuidPK);
                wsinterfaceInfo.setTree(treInfo);
            }
        }
        catch (Exception e) {
            throw new BOSException("\u5f15\u5165\u63a5\u53e3\u4fe1\u606f\u4fdd\u5b58\u5f02\u5e38\u3002", (Throwable)e);
        }
    }
}

