/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.reportmapping;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.DBUtils;
import com.kingdee.eas.csinterface.common.DIPException;
import com.kingdee.eas.csinterface.reportmapping.KeyTable;
import com.kingdee.eas.csinterface.reportmapping.ReportMappingEntryCollection;
import com.kingdee.eas.csinterface.reportmapping.ReportMappingEntryInfo;
import com.kingdee.eas.csinterface.reportmapping.ReportMappingHelper;
import com.kingdee.eas.csinterface.reportmapping.ReportMappingInfo;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionFactory;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionInfo;
import com.kingdee.eas.csinterface.syncdatabase.DBType;
import com.kingdee.eas.csinterface.syncdatabase.DataSourceType;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.eas.csinterface.util.DataTypeConverter;
import com.kingdee.eas.csinterface.utils.DataBaseType;
import com.kingdee.eas.csinterface.utils.KSQLUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class KeyTableUtil {
    public static final String NO_PKTABLE = "\u672a\u751f\u6210\u589e\u91cf\u8868";
    private static Logger logger = Logger.getLogger(KeyTableUtil.class);

    public static void createKeyTable(Context ctx, ReportMappingInfo info) throws BOSException, EASBizException, SQLException, DIPException {
        ConnectionInfo srcDBConn = info.getSrcDBConn();
        String id = srcDBConn.getId().toString();
        IObjectPK pk = CommonUtil.convert2PK(id);
        ConnectionInfo conn = ConnectionFactory.getLocalInstance(ctx).getConnectionInfo(pk);
        KeyTable keyTable = KeyTableUtil.getKeyTable(info);
        info.setPkTableName(keyTable.getTableName());
        KeyTableUtil.createKeyTable(conn, conn.getDBType(), keyTable);
    }

    public static boolean existKeyTable(Context ctx, ReportMappingInfo info) throws EASBizException, BOSException, SQLException, DIPException {
        String keyTablenName = KeyTableUtil.getPKTableName(info);
        if (DataSourceType.jdbc.equals((Object)info.getDsType())) {
            if (info.getSrcDBConn() == null) {
                logger.error((Object)("\u7531\u4e8e\u6e90\u7cfb\u7edf\u8fde\u63a5\u4fe1\u606f\u4e3a\u7a7a,\u589e\u91cf\u8868" + keyTablenName + "\u65e0\u6cd5\u5220\u9664"));
                return false;
            }
        } else if (DataSourceType.agent.equals((Object)info.getDsType())) {
            return true;
        }
        ConnectionInfo conn = ConnectionFactory.getLocalInstance(ctx).getConnectionInfo(CommonUtil.convert2PK(info.getSrcDBConn().getId().toString()));
        DataBaseType dbType = DataBaseType.getInstance(conn.getDBType().getName());
        keyTablenName = keyTablenName.replace("\"", "");
        String ksql = "select * from KSQL_USERTABLES where KSQL_TABNAME ='" + keyTablenName + "'";
        IRowSet rowSet = KSQLUtil.executeQuery(dbType, conn.getIP(), conn.getPort(), conn.getInstance(), conn.getUsername(), conn.getPassword(), ksql);
        if (!rowSet.next()) {
            ksql = "select KSQL_TABNAME from KSQL_USERTABLES where KSQL_TABNAME like 'T_EIP_%'";
            rowSet = KSQLUtil.executeQuery(dbType, conn.getIP(), conn.getPort(), conn.getInstance(), conn.getUsername(), conn.getPassword(), ksql);
            while (rowSet.next()) {
                if (!keyTablenName.equalsIgnoreCase(rowSet.getString(1))) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private static String getPKTableName(ReportMappingInfo info) {
        return ReportMappingHelper.calc2PkTableName(info.getId().toString());
    }

    private static KeyTable getKeyTable(ReportMappingInfo info) {
        ReportMappingEntryInfo headpk = null;
        ReportMappingEntryInfo entrypk = null;
        ReportMappingEntryCollection coll = info.getEntrys();
        Iterator itr = coll.iterator();
        while (itr.hasNext()) {
            ReportMappingEntryInfo entry = (ReportMappingEntryInfo)itr.next();
            String srcFieldName = entry.getSrcFieldName();
            if ("headpk".equalsIgnoreCase(srcFieldName)) {
                headpk = entry;
            }
            if (!"entrypk".equalsIgnoreCase(srcFieldName)) continue;
            entrypk = entry;
        }
        if (null == headpk) {
            throw new RuntimeException("\u7f3a\u5c11headpk");
        }
        if (null == entrypk) {
            throw new RuntimeException("\u7f3a\u5c11entrypk");
        }
        String keyTablenName = KeyTableUtil.getPKTableName(info);
        return new KeyTable(keyTablenName, headpk, entrypk);
    }

    private static void createKeyTable(ConnectionInfo conn, DBType dbType, KeyTable table) throws BOSException {
        String ksql = KeyTableUtil.getSQL2CreateKeyTable(table, dbType);
        try {
            DataBaseType dataBaseType = DataBaseType.getInstance(conn.getDBType().getName());
            KSQLUtil.executeUpdate(dataBaseType, conn.getIP(), conn.getPort(), conn.getInstance(), conn.getUsername(), conn.getPassword(), ksql);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private static String getSQL2CreateKeyTable(KeyTable table, DBType dbType) {
        DataTypeConverter typeConverter = DataTypeConverter.getConverter(dbType);
        String tableName = table.getTableName();
        ReportMappingEntryInfo headpk = table.getHeadpk();
        SQLType headType = typeConverter.convert(headpk.getSrcFieldDataType());
        ColumnInfo headColInfo = new ColumnInfo();
        headColInfo.setTypeName(headType);
        headColInfo.setLength(headpk.getSrcFieldDataLength());
        headColInfo.setPrecision(headpk.getSrcFieldDataPrecision());
        headColInfo.setScale(headpk.getSrcFieldDataScale());
        StringBuffer sb = new StringBuffer("create table  " + tableName);
        sb.append("(");
        sb.append("headpk ");
        sb.append(DBUtils.getDataType(headColInfo));
        sb.append(");");
        return sb.toString();
    }

    public static void dropKeyTable(Context ctx, ReportMappingInfo info) throws BOSException, EASBizException {
    }
}

