/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.schedule.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.DefineSysEnum;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.dap.DAPTransformResult;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.IDynamicBillTemplate;
import com.kingdee.eas.csinterface.app.base.EIPLicenseCheckUtil;
import com.kingdee.eas.csinterface.billmapping.BillMappingFactory;
import com.kingdee.eas.csinterface.billmapping.BillMappingInfo;
import com.kingdee.eas.csinterface.billmapping.TranferType;
import com.kingdee.eas.csinterface.billmapping.VoucherStatus;
import com.kingdee.eas.csinterface.bizbill.metadata.info.DIPMetadata;
import com.kingdee.eas.csinterface.common.DIPException;
import com.kingdee.eas.csinterface.monitor.app.MonitorManager;
import com.kingdee.eas.csinterface.schedule.app.service.destBillStrategy.AbstractTransferManager;
import com.kingdee.eas.csinterface.schedule.app.service.destBillStrategy.impl.TransferMultiToMultiManagerImpl;
import com.kingdee.eas.csinterface.schedule.app.service.destBillStrategy.impl.TransferOneToOneMangerImpl;
import com.kingdee.eas.csinterface.schedule.app.service.util.BOTPUtil;
import com.kingdee.eas.csinterface.schedule.app.service.util.DAPUtil;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.eas.csinterface.util.MidBillFactory;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.util.enums.IntEnum;
import java.net.URL;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DesBIllCreator {
    private static Logger logger = Logger.getLogger(DesBIllCreator.class);
    private Context ctx;
    private String scheduId;
    private String midBillName;
    private BOTMappingInfo botMapping;
    private String cashflowRelation;
    private int batchSize;
    private boolean intergratedCashFlow;
    private boolean intergrateEASCashFlow;
    private String easCashFlowRelation;
    private boolean integrateEasAssAcc;
    private String assistAccountRelation;
    private BillMappingInfo billMappingInfo;
    public static int DEFAULT_MAX_SIZE = Integer.MAX_VALUE;

    public DesBIllCreator(Context ctx, String scheduId, String midBillName, BOTMappingInfo botMapping, String cashflowRelation, boolean intergratedCashFlow, String easCashFlowRelation, boolean intergrateEASCashFlow, String assistAccountRelation, boolean integrateEasAssAcc) {
        this.ctx = ctx;
        this.scheduId = scheduId;
        this.midBillName = midBillName;
        this.botMapping = botMapping;
        this.cashflowRelation = cashflowRelation;
        this.intergratedCashFlow = intergratedCashFlow;
        this.easCashFlowRelation = easCashFlowRelation;
        this.intergrateEASCashFlow = intergrateEASCashFlow;
        this.assistAccountRelation = assistAccountRelation;
        this.integrateEasAssAcc = integrateEasAssAcc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void botp2DesBill() throws Exception {
        if (DefineSysEnum.DAP.equals((Object)this.botMapping.getDefineSys()) || DefineSysEnum.DAPPC.equals((Object)this.botMapping.getDefineSys())) {
            BillMappingInfo billMappingInfo = BillMappingFactory.getLocalInstance(this.ctx).getBillMappingInfo("where number='" + this.midBillName + "'");
            if (billMappingInfo == null) {
                return;
            }
            AbstractTransferManager manager = null;
            if (TranferType.oneToOne.equals((Object)billMappingInfo.getTransferType())) {
                manager = !StringUtils.isEmpty((String)this.scheduId) ? new TransferOneToOneMangerImpl(this.ctx, null, this.botMapping, billMappingInfo, this.scheduId) : new TransferOneToOneMangerImpl(this.ctx, null, this.botMapping, billMappingInfo, null);
            } else if (billMappingInfo.getTransferType() == null || billMappingInfo.getTransferType().equals((Object)TranferType.mutiToMuti) || billMappingInfo.getTransferType().equals((Object)TranferType.multiToOne)) {
                manager = !StringUtils.isEmpty((String)this.scheduId) ? new TransferMultiToMultiManagerImpl(this.ctx, null, this.botMapping, billMappingInfo, this.scheduId) : new TransferMultiToMultiManagerImpl(this.ctx, null, this.botMapping, billMappingInfo, null);
            }
            if (manager == null) {
                throw new NullPointerException();
            }
            ((AbstractTransferManager)manager).invokeTansferBotp();
        } else {
            try {
                MonitorManager.enterMidBillToDest(this.ctx, null, this.midBillName, this.scheduId);
                String monitorId = MonitorManager.getCurrentMidBillToDest().getId().toString();
                this.billMappingInfo = BillMappingFactory.getLocalInstance(this.ctx).getBillMappingInfo("where number='" + this.midBillName + "'");
                if (this.billMappingInfo == null) {
                    throw new Exception("\u67e5\u4e0d\u5230\u4e1a\u52a1\u5355\u636e\u6620\u5c04\u7684\u4fe1\u606f,\u5355\u636e\u7f16\u7801:" + this.midBillName);
                }
                MonitorManager.getCurrentMidBillToDest().setBillMappingInfo(this.billMappingInfo);
                MonitorManager.getCurrentMidBillToDest().setBotMappingInfo(this.botMapping);
                MonitorManager.getCurrentMidBillToDest().setTransformType(this.botMapping.getDefineSys().getName());
                int totalSize = this.getCount();
                int pageSize = totalSize / DEFAULT_MAX_SIZE + (totalSize % DEFAULT_MAX_SIZE == 0 ? 0 : 1);
                MonitorManager.getCurrentMidBillToDest().addBillCount(totalSize);
                CoreBillBaseCollection src = null;
                CoreBillBaseCollection srcTmp = new CoreBillBaseCollection();
                int failCount = 0;
                for (int i = 0; i < pageSize; ++i) {
                    src = this.getSrcBillInfos();
                    if (src == null || src.size() == 0) {
                        return;
                    }
                    for (int idx = 0; idx < src.size(); ++idx) {
                        CoreBillBaseInfo info = src.get(idx);
                        try {
                            srcTmp.add(info);
                            this.transform(srcTmp, this.botMapping);
                            continue;
                        }
                        catch (Exception e) {
                            logger.error((Object)("\u3010EIP\u8f6c\u6362\u5355\u636e\u51fa\u9519\u3011\u4e2d\u95f4\u5355headpk:" + info.get("headpk") + "\u76d1\u63a7id:" + monitorId + "\u539f\u56e0:" + e.getMessage()));
                            ++failCount;
                            continue;
                        }
                        finally {
                            srcTmp.clear();
                        }
                    }
                    src = null;
                }
                MonitorManager.getCurrentMidBillToDest().setResultBillCount(totalSize - failCount);
            }
            catch (Exception e) {
                MonitorManager.error(e);
                throw e;
            }
            finally {
                MonitorManager.exit(this.ctx);
            }
        }
    }

    public DAPTransformResult botp2DesBill(CoreBillBaseCollection src) throws Exception {
        DAPTransformResult result = null;
        if (DefineSysEnum.DAP.equals((Object)this.botMapping.getDefineSys()) || DefineSysEnum.DAPPC.equals((Object)this.botMapping.getDefineSys())) {
            result = this.transform(src, this.botMapping);
        } else {
            try {
                MonitorManager.enterMidBillToDest(this.ctx, "EAS\u5ba2\u6237\u7aef", this.midBillName, null);
                MonitorManager.getCurrentMidBillToDest().addBillCount(src == null ? 0 : src.size());
                MonitorManager.getCurrentMidBillToDest().setBotMappingInfo(this.botMapping);
                MonitorManager.getCurrentMidBillToDest().setTransformType(this.botMapping.getDefineSys().getName());
                this.transform(src, this.botMapping);
            }
            catch (Exception e) {
                MonitorManager.error(this.ctx, e);
                throw e;
            }
            finally {
                MonitorManager.exit(this.ctx);
            }
        }
        return result;
    }

    private CoreBillBaseCollection getSrcBillInfos() throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("fiVouchered", (Object)Boolean.FALSE, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("fiVouchered", null, CompareType.EQUALS));
        EntityViewInfo ev = new EntityViewInfo();
        filter.setMaskString("#0 or #1");
        ev.setFilter(filter);
        ev.setTopCount(DEFAULT_MAX_SIZE);
        IDynamicBillTemplate template = MidBillFactory.getInstance(this.ctx, this.midBillName);
        if (template == null) {
            logger.info((Object)("read MidBill data from '" + this.midBillName + "' 's template is empty!!"));
            return null;
        }
        CoreBillBaseCollection coreBaseColl = template.getCoreBillBaseCollection(ev);
        if (coreBaseColl == null || coreBaseColl.size() == 0) {
            logger.info((Object)("read MidBill data from '" + this.midBillName + "' is empty!!"));
        }
        return coreBaseColl;
    }

    private int getCount() throws BOSException {
        int count = 0;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("fiVouchered", (Object)Boolean.FALSE, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("fiVouchered", null, CompareType.EQUALS));
        EntityViewInfo ev = new EntityViewInfo();
        filter.setMaskString("#0 or #1");
        ev.setFilter(filter);
        IDynamicBillTemplate template = MidBillFactory.getInstance(this.ctx, this.midBillName);
        try {
            IObjectPK[] pks = template.getPKList(filter, null);
            count = pks == null ? 0 : pks.length;
        }
        catch (EASBizException e) {
            logger.error((Object)("get middle bill ('" + this.midBillName + "') count error:" + e.getMessage()));
        }
        return count;
    }

    public DAPTransformResult transform(CoreBillBaseCollection src, BOTMappingInfo botMapping) throws Exception {
        DAPTransformResult result = null;
        try {
            EIPLicenseCheckUtil.checkLicenseEnough(this.ctx);
        }
        catch (Exception e) {
            logger.info((Object)"license not enough.");
            throw new DIPException(e.getMessage());
        }
        try {
            Class<?> clazzClient = Class.forName("com.kingdee.eas.csinterface.license.ClientLicenseCheckUtil");
            URL client = clazzClient.getResource("ClientLicenseCheckUtil.class");
            if (client != null && client.getPath() != null && client.getPath().indexOf("sp\\") > -1) {
                throw new Exception("Please Contact To Kingdee!");
            }
            Class<?> clazzServer = Class.forName("com.kingdee.eas.csinterface.license.ServerLicenseCheckUtil");
            URL server = clazzServer.getResource("ServerLicenseCheckUtil.class");
            if (server != null && server.getPath() != null && server.getPath().indexOf("sp\\") > -1) {
                throw new Exception("Please Contact To Kingdee!");
            }
        }
        catch (ClassNotFoundException clazzClient) {
        }
        catch (Exception e2) {
            throw e2;
        }
        DIPMetadata dm = new DIPMetadata(this.midBillName);
        String midBillTableName = DIPMetadata.getShortName(dm.getHeaderTablePK());
        if (DefineSysEnum.DAP.equals((Object)botMapping.getDefineSys()) || DefineSysEnum.DAPPC.equals((Object)botMapping.getDefineSys())) {
            if (this.intergratedCashFlow && StringUtils.isNotEmpty((String)this.cashflowRelation) && this.intergrateEASCashFlow && StringUtils.isNotEmpty((String)this.easCashFlowRelation)) {
                throw new Exception("\u53ea\u80fd\u542f\u7528\u4e00\u4e2a\u73b0\u91d1\u6d41\u91cf\u96c6\u6210\u9009\u9879\uff0c\u8bf7\u5728\u4e1a\u52a1\u5355\u636e\u6620\u5c04\u6269\u5c55\u5c5e\u6027\u4e2d\u8bbe\u7f6e\uff01");
            }
            result = this.intergratedCashFlow && StringUtils.isNotEmpty((String)this.cashflowRelation) ? DAPUtil.dapWithCashFlow(this.ctx, midBillTableName, src, botMapping, this.cashflowRelation) : (this.intergrateEASCashFlow && StringUtils.isNotEmpty((String)this.easCashFlowRelation) ? DAPUtil.dapWithEASCashFlow(this.ctx, midBillTableName, src, botMapping, this.easCashFlowRelation, this.assistAccountRelation) : DAPUtil.dap(this.ctx, midBillTableName, src, botMapping));
        } else {
            BOTPUtil.botp(this.ctx, midBillTableName, src, botMapping);
        }
        return result;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    private void dealVoucher(CoreBillBaseCollection src, DAPTransformResult result) throws Exception {
        int status;
        if (result == null) {
            return;
        }
        VoucherStatus needStatus = this.billMappingInfo.getVoucherStatus();
        if (needStatus == null) {
            return;
        }
        int voucherStatus = needStatus.getValue();
        IObjectCollection vouchers = result.getVoucherCollection();
        if (vouchers.size() == 0) {
            return;
        }
        Iterator voucherIte = vouchers.iterator();
        IObjectValue voucherInfo = null;
        boolean needDeal = false;
        IObjectPK voucherId = null;
        while (voucherIte.hasNext() && (status = ((IntEnum)(voucherInfo = (IObjectValue)voucherIte.next()).get("bizStatus")).getValue()) <= voucherStatus) {
            needDeal = true;
        }
        if (needDeal) {
            voucherId = CommonUtil.convert2PK(voucherInfo.get("id").toString());
        }
    }
}

