/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.schedule.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.job.JobServiceFactory;
import com.kingdee.bos.service.job.core.Configuration;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobDef;
import com.kingdee.bos.service.job.core.JobManager;
import com.kingdee.bos.service.job.core.Wrapper;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.bos.service.job.wrapper.MethodWrapper;
import com.kingdee.eas.base.param.IParamItem;
import com.kingdee.eas.base.param.ParamItemCollection;
import com.kingdee.eas.base.param.ParamItemFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynHeadFactory;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynHeadInfo;
import com.kingdee.eas.csinterface.basedatasyn.app.newsync.factory.BaseDataHeadFactory;
import com.kingdee.eas.csinterface.basedatasyn.app.newsync.factory.BaseDataPlanFactory;
import com.kingdee.eas.csinterface.basedatasyn.app.util.BaseDataResourceholder;
import com.kingdee.eas.csinterface.basedatasyn.app.util.BaseDataSynUtil;
import com.kingdee.eas.csinterface.billmapping.BillMappingFactory;
import com.kingdee.eas.csinterface.billmapping.BillMappingInfo;
import com.kingdee.eas.csinterface.cache.util.CacheType;
import com.kingdee.eas.csinterface.json.JSONObject;
import com.kingdee.eas.csinterface.monitor.app.MonitorManager;
import com.kingdee.eas.csinterface.schedule.ISchedule;
import com.kingdee.eas.csinterface.schedule.ScheduleFactory;
import com.kingdee.eas.csinterface.schedule.ScheduleInfo;
import com.kingdee.eas.csinterface.schedule.app.service.DBFacade;
import com.kingdee.eas.csinterface.schedule.app.service.ScheduleTaskAction;
import com.kingdee.eas.csinterface.schedule.app.service.util.JobUtil;
import com.kingdee.eas.csinterface.schedule.app.service.util.ScheduleUtil;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionFactory;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionInfo;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ScheduledTask
implements Serializable {
    private static final long serialVersionUID = -937393019177110676L;
    private static final Logger logger = Logger.getLogger(ScheduledTask.class);
    public static Set<String> GL_BALANCE_MODIFY = new HashSet<String>();
    private boolean enable = true;
    private String title;

    public synchronized void setEnable(boolean enable) {
        this.enable = enable;
    }

    public String getName() {
        return this.title;
    }

    public void doTask(Job job, String scheduledId) throws Exception {
        Context ctx = job.getContext();
        ScheduleUtil.repairMonitorlog(ctx);
        MonitorManager.setOperatorSource("\u8c03\u5ea6\u7b56\u7565");
        this.title = job.getTitle();
        new ScheduleTaskAction().processTask(job, scheduledId, null);
    }

    public void balanceModify(Job job, String voucherId) throws Exception {
        Context ctx = job.getContext();
        ScheduleUtil.repairMonitorlog(ctx);
        this.title = "EIP\u8f6c\u63a5\u51ed\u8bc1\u81ea\u52a8\u66f4\u6b63\u4f59\u989d\u8868";
        new ScheduleTaskAction().updateBalance(job.getContext(), voucherId);
    }

    public void processBaseDataDown(Job job, String headId, String mainSQL, String mainPKList, Integer actionType) throws Exception {
        this.title = "EIP\u57fa\u7840\u8d44\u6599\u540c\u6b65\u91cd\u8bd5_" + System.currentTimeMillis();
        Context ctx = job.getContext();
        ScheduleUtil.repairMonitorlog(ctx);
        BaseDataSynHeadInfo baseDataSynInfo = BaseDataSynHeadFactory.getLocalInstance(ctx).getBaseDataSynHeadInfo(CommonUtil.convert2PK(headId));
    }

    public static void processBaseDataTask(Job job, String headId, String mainSQL, String mainPKList, Integer actionType, String userList, String connId) throws Exception {
        Context ctx = job.getContext();
        ScheduleUtil.repairMonitorlog(ctx);
        String title = "EIP\u57fa\u7840\u8d44\u6599\u540c\u6b65\u91cd\u8bd5_" + System.currentTimeMillis();
        BaseDataSynHeadInfo baseDataSynInfo = (BaseDataSynHeadInfo)new BaseDataHeadFactory().create(ctx, BaseDataPlanFactory.Type.ID, headId, CacheType.SYNHEAD);
        baseDataSynInfo.setExtendedProperty("extConnId", connId);
        baseDataSynInfo.setExtendedProperty("delayTime", ScheduleTaskAction.RETRY_DELAYTIMES + "");
        try {
            try {
                if (!StringUtils.isEmpty((String)mainSQL)) {
                    com.alibaba.fastjson.JSONObject jsonStr = com.alibaba.fastjson.JSONObject.parseObject((String)mainSQL);
                    BaseDataResourceholder.putSpecialSQLForMultiPlan(jsonStr);
                }
            }
            catch (Exception e) {
                logger.error((Object)("\u8fc7\u6ee4\u6761\u4ef6\uff1a" + mainSQL));
            }
            JSONObject reverseObj = new JSONObject();
            reverseObj.put("specilaSQL", mainSQL);
            reverseObj.put("planNumber", baseDataSynInfo.getNumber());
            ConnectionInfo connInfo = ConnectionFactory.getLocalInstance(ctx).getConnectionInfo(CommonUtil.convert2PK(connId));
            if (connInfo != null) {
                reverseObj.put("connectionNumber", connInfo.getNumber());
            }
            String actionTypes = "";
            if (400 == actionType) {
                actionTypes = BaseDataSynUtil.actionTypes.get(0);
            } else if (500 == actionType) {
                actionTypes = BaseDataSynUtil.actionTypes.get(1);
            } else if (700 == actionType) {
                actionTypes = BaseDataSynUtil.actionTypes.get(3);
            } else if (800 == actionType) {
                actionTypes = BaseDataSynUtil.actionTypes.get(2);
            }
            reverseObj.put("actionType", actionTypes);
            baseDataSynInfo.setExtendedProperty("interfaceResult", reverseObj.toString());
            if (400 == actionType) {
                ScheduleTaskAction.processBaseDataDown(ctx, job, null, baseDataSynInfo, mainSQL, mainPKList, userList);
            } else if (500 == actionType) {
                ScheduleTaskAction.processBaseDataChange(ctx, job, null, baseDataSynInfo, mainSQL, mainPKList, userList);
            } else if (700 == actionType) {
                ScheduleTaskAction.processBaseDataDownAndChange(ctx, job, null, baseDataSynInfo, mainSQL, mainPKList, userList);
            } else if (800 == actionType) {
                ScheduleTaskAction.processBaseDataDelete(ctx, job, null, baseDataSynInfo, mainSQL, mainPKList, userList);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            BaseDataResourceholder.reset();
        }
    }

    public void desBill(Job job, String scheduedId, String billMappingId, String botMappingId, Integer assignmentNumber, String scheduId) throws Exception {
        Context ctx = job.getContext();
        ScheduleUtil.repairMonitorlog(ctx);
        this.title = "\u751f\u6210\u76ee\u6807\u5355\u636e";
        BillMappingInfo billMapping = BillMappingFactory.getLocalInstance(job.getContext()).getBillMappingInfo("where id='" + billMappingId + "'");
        BOTMappingInfo botMapping = DBFacade.getBotMapping(job.getContext(), botMappingId);
        new ScheduleTaskAction().desBill(job.getContext(), job, scheduId, billMapping, botMapping, assignmentNumber);
    }

    private void reOrderTask(Job job, Context ctx, String scheduledId) throws BOSException, EASBizException {
        ISchedule scheduleInstacne = ScheduleFactory.getLocalInstance(ctx);
        ScheduleInfo scheduleInfo = scheduleInstacne.getScheduleInfo(CommonUtil.convert2PK(scheduledId));
        if (job.getParameters() == null) {
            String description = "XXXXXXXXXXXXXXXXXXXXXXX";
            String jobDefId = null;
            try {
                String sql = "select fjobdefid from t_job_def with(readpast) where ftitle=?";
                int[] types = new int[]{12};
                Object[] values = new Object[]{scheduleInfo.getId().toString()};
                ArrayList rs = SQL.executeQuery((Context)ctx, (String)sql, (int[])types, (Object[])values);
                if (rs.size() != 0) {
                    jobDefId = (String)((Map)rs.get(0)).get("fjobdefid");
                }
                JobDef jobDef = null;
                String scheduleId = scheduleInfo.getId().toString();
                MethodWrapper wrapper = new MethodWrapper(ScheduledTask.class, "doTask", new Object[]{scheduleId});
                String mutex = JobUtil.getScheduleJobMutex(ctx, scheduleInfo);
                jobDef = !StringUtils.isEmpty((String)jobDefId) ? new JobDef(jobDefId, ctx, null, scheduleId, description, null, null, true, (Wrapper)wrapper, false, mutex, 500, -1, Configuration.defaultJobIsolationLevel(), null) : new JobDef(ctx, null, scheduleId, description, null, null, true, (Wrapper)wrapper, false, mutex, 500, -1, Configuration.defaultJobIsolationLevel(), null);
                Object[] param2 = new Object[]{"00", scheduleInfo.getId().toString(), "00"};
                Job job2 = jobDef.createJobInstance(ctx, description, (Object)param2, null, null, -1, this.getEIPServer(ctx));
                JobManager.instance().add(job2);
                JobServiceFactory.getLocalInstance((Context)ctx).createJobDef(jobDef);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    private String getEIPServer(Context ctx) throws BOSException {
        IParamItem iParamItem = ParamItemFactory.getLocalInstance((Context)ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("keyID", (Object)"d4k6+GLn5UKkGn3srVwcXKiB8+c=", CompareType.EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        ParamItemCollection paramItemCo = iParamItem.getParamItemCollection(evi);
        if (paramItemCo.size() > 0) {
            paramItemCo.get(0).getValue();
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        sb.append(super.toString());
        sb.append(",");
        sb.append("title=" + this.title);
        sb.append(",");
        sb.append("enable=" + this.enable);
        sb.append("]");
        return sb.toString();
    }
}

