/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.schedule.app.service.destBillStrategy.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationEntryInfo;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.dap.DAPTransformResult;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.DynamicBillTemplate;
import com.kingdee.eas.csinterface.DynamicBillTemplateEntryCollection;
import com.kingdee.eas.csinterface.IDynamicBillTemplateEntry;
import com.kingdee.eas.csinterface.billmapping.BillMappingInfo;
import com.kingdee.eas.csinterface.billmapping.TranferType;
import com.kingdee.eas.csinterface.bizbill.metadata.info.DIPMetadata;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.UictUtils;
import com.kingdee.eas.csinterface.monitor.app.MonitorManager;
import com.kingdee.eas.csinterface.schedule.MidBillTransferBotpFacadeFactory;
import com.kingdee.eas.csinterface.schedule.app.service.DesBIllCreator;
import com.kingdee.eas.csinterface.schedule.app.service.destBillStrategy.AbstractDestBillTransferObject;
import com.kingdee.eas.csinterface.schedule.app.service.destBillStrategy.impl.TransferDefaultImpl;
import com.kingdee.eas.csinterface.schedule.util.DestBillBatchUtil;
import com.kingdee.eas.csinterface.schedule.util.GroupInfo;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.eas.csinterface.util.MidBillFactory;
import com.kingdee.eas.fi.gl.VoucherAssistRecordCollection;
import com.kingdee.eas.fi.gl.VoucherAssistRecordFactory;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryFactory;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class TransferMutiToMutiImpl
extends AbstractDestBillTransferObject {
    private static Logger logger = Logger.getLogger(TransferMutiToMutiImpl.class);
    public static final int defaultEntrysNumber = 3000;
    public static final int dealWithMapFlag = 20000;
    private Map<String, String> botpGroupMap;

    public TransferMutiToMutiImpl(Context ctx, String scheduId, Set<String> headpkSet, BOTMappingInfo botMapping, BillMappingInfo billMappingInfo, Integer assignNumber) {
        super(ctx, scheduId, headpkSet, botMapping, billMappingInfo, assignNumber);
    }

    @Override
    public void transfer() throws Exception {
        this.botpGroupMap = DestBillBatchUtil.findBotpGroupRule(this.ctx, this.botMapping);
        HashMap map = (HashMap)((HashMap)this.botpGroupMap).clone();
        this.filterHeadField(map);
        if (map.isEmpty()) {
            TransferDefaultImpl stragegy = new TransferDefaultImpl(this.ctx, this.scheduId, this.headpkSet, this.botMapping, this.billMappingInfo, this.assignNumber);
            ((AbstractDestBillTransferObject)stragegy).transfer();
            return;
        }
        this.filterHeadAndEntryGroupField(map);
        if (map.isEmpty()) {
            GroupInfo info = new GroupInfo();
            info.setColumnValueMap(new HashMap<String, Object>());
            try {
                Integer assignNumber = DestBillBatchUtil.getMaxAssNumberByBillMapiing(this.ctx, this.billMappingInfo);
                info.setAssignNnumber(assignNumber);
                this.recordSucNumber(assignNumber);
                MidBillTransferBotpFacadeFactory.getLocalInstance(this.ctx).transfer(this, info);
            }
            catch (Exception e) {
                ArrayList<GroupInfo> tempInfo = new ArrayList<GroupInfo>();
                tempInfo.add(info);
                this.printErrorLog(tempInfo, e);
                if (MonitorManager.getCurrentMidBillToDest() != null) {
                    MonitorManager.getCurrentMidBillToDest().setResultBillCount(0);
                }
                throw e;
            }
        } else {
            this.dealWithMap(map);
        }
    }

    public void dealWithMap(Map<String, String> map) throws Exception {
        HashMap<String, Boolean> typeMap = new HashMap<String, Boolean>();
        HashMap<String, String> tableEntryMap = new HashMap<String, String>();
        String groupBy = DestBillBatchUtil.findTableEntityMap(map, this.billMappingInfo, typeMap, tableEntryMap);
        List<GroupInfo> groupInfoList = this.findGroupInfoList(this.ctx, groupBy, this.billMappingInfo, this.headpkSet);
        IDynamicBillTemplateEntry template = MidBillFactory.getEntryInstance(this.ctx, this.billMappingInfo.getNumber());
        if (template == null) {
            return;
        }
        int count = 0;
        ArrayList<GroupInfo> subGroupInfoList = new ArrayList<GroupInfo>();
        int compareNumber = this.billMappingInfo.getPageSize() == 0 ? 3000 : this.billMappingInfo.getPageSize();
        DesBIllCreator desBIllCreator = new DesBIllCreator(this.ctx, this.scheduId, this.billMappingInfo.getNumber(), this.botMapping, this.billMappingInfo.getCashFlowRelation(), this.billMappingInfo.isIntegrateCashFlow(), this.billMappingInfo.getEasCashFlowRelation(), this.billMappingInfo.isIntergrateEASCashFlow(), this.billMappingInfo.getAssistAccountRelation(), this.billMappingInfo.isIntegrateEasAssAcc());
        for (int i = 0; i < groupInfoList.size(); ++i) {
            GroupInfo info = groupInfoList.get(i);
            if (info.getEntryCount() > 20000) {
                try {
                    Integer assignNumber = DestBillBatchUtil.getMaxAssNumberByBillMapiing(this.ctx, this.billMappingInfo);
                    info.setAssignNnumber(assignNumber);
                    this.recordSucNumber(assignNumber);
                    MidBillTransferBotpFacadeFactory.getLocalInstance(this.ctx).transfer(this, info);
                }
                catch (Exception e) {
                    ArrayList<GroupInfo> tempInfo = new ArrayList<GroupInfo>();
                    tempInfo.add(info);
                    this.printErrorLog(tempInfo, e);
                }
                continue;
            }
            subGroupInfoList.add(info);
            if ((count += info.getEntryCount()) < compareNumber && i < groupInfoList.size() - 1) continue;
            CoreBillBaseCollection sourceBills = null;
            Integer assignNumber = null;
            try {
                sourceBills = this.getSourceBill(template, typeMap, tableEntryMap, subGroupInfoList, this.headpkSet);
                assignNumber = this.fillAssigNumber(sourceBills);
                this.recordSucNumber(assignNumber);
                desBIllCreator.botp2DesBill(sourceBills);
            }
            catch (Exception e) {
                this.printErrorLog(subGroupInfoList, e);
            }
            sourceBills = null;
            count = 0;
            subGroupInfoList.clear();
        }
    }

    private void printErrorLog(List<GroupInfo> tempInfo, Exception e) {
        if (MonitorManager.getCurrentMidBillToDest() != null) {
            StringBuilder errorMsg = new StringBuilder();
            for (GroupInfo info : tempInfo) {
                for (String columnName : info.getColumnValueMap().keySet()) {
                    Object value = info.getColumnValueMap().get(columnName);
                    errorMsg.append(columnName + "=" + value == null ? "" : value.toString() + "\n");
                }
            }
            Exception e1 = new Exception(errorMsg + e.getMessage());
            e1.setStackTrace(e.getStackTrace());
            MonitorManager.getCurrentMidBillToDest().setExtendedProperty("errorMsg", "\u751f\u6210\u51ed\u8bc1\u5931\u8d25\u7684\u7ec4\u4fe1\u606f\uff1a" + errorMsg + e.getMessage());
        }
    }

    public void dealWithGroup(GroupInfo info) throws BOSException, EASBizException {
        HashMap map = (HashMap)((HashMap)this.botpGroupMap).clone();
        this.filterHeadField(map);
        this.filterBotpTag(map);
        HashMap<String, Boolean> typeMap = new HashMap<String, Boolean>();
        HashMap<String, String> tableEntryMap = new HashMap<String, String>();
        String groupBy = DestBillBatchUtil.findTableEntityMap(map, this.billMappingInfo, typeMap, tableEntryMap);
        String groupBySql = this.generateSqlWithCondtion(info, groupBy, typeMap, tableEntryMap);
        List<GroupInfo> groupInfoList = this.findGroupInfoList(this.ctx, this.billMappingInfo, this.headpkSet, groupBySql);
        IDynamicBillTemplateEntry template = MidBillFactory.getEntryInstance(this.ctx, this.billMappingInfo.getNumber());
        DesBIllCreator desBIllCreator = new DesBIllCreator(this.ctx, this.scheduId, this.billMappingInfo.getNumber(), this.botMapping, this.billMappingInfo.getCashFlowRelation(), this.billMappingInfo.isIntegrateCashFlow(), this.billMappingInfo.getEasCashFlowRelation(), this.billMappingInfo.isIntergrateEASCashFlow(), this.billMappingInfo.getAssistAccountRelation(), this.billMappingInfo.isIntegrateEasAssAcc());
        int count = 0;
        int fromIndex = 0;
        int toIndex = 0;
        int compareNumber = this.billMappingInfo.getPageSize() == 0 ? 3000 : this.billMappingInfo.getPageSize();
        VoucherInfo voucher = null;
        BOTRelationCollection botpColl = null;
        HashMap<String, BOTRelationInfo> existHeadSrcBills = new HashMap<String, BOTRelationInfo>();
        for (int i = 0; i < groupInfoList.size(); ++i) {
            GroupInfo tempInfo = groupInfoList.get(i);
            ++toIndex;
            if ((count += tempInfo.getEntryCount()) < compareNumber && i < groupInfoList.size() - 1) continue;
            List<GroupInfo> subGroupInfo = groupInfoList.subList(fromIndex, toIndex);
            fromIndex = toIndex;
            CoreBillBaseCollection sourceBills = null;
            sourceBills = this.getSourceBill(template, typeMap, tableEntryMap, subGroupInfo, this.headpkSet);
            this.fillAssigNumber(sourceBills, info.getAssignNnumber());
            DAPTransformResult result = null;
            if (!sourceBills.isEmpty()) {
                try {
                    result = desBIllCreator.botp2DesBill(sourceBills);
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
            VoucherCollection coll = new VoucherCollection();
            BOTRelationCollection realtionColl = new BOTRelationCollection();
            if (result != null) {
                coll.addCollection((VoucherCollection)result.getVoucherCollection());
                realtionColl.addCollection(result.getRelationCollection());
            }
            if (voucher != null) {
                this.mergeVoucher(voucher, coll, botpColl, realtionColl, existHeadSrcBills);
            }
            if (voucher == null && coll.size() > 0) {
                voucher = coll.get(0);
                botpColl = realtionColl;
                for (int idx = 0; idx < botpColl.size(); ++idx) {
                    existHeadSrcBills.put(botpColl.get(idx).getSrcObjectID(), botpColl.get(idx));
                }
            }
            count = 0;
            sourceBills = null;
            coll = null;
            realtionColl = null;
        }
        boolean isSaveBotpEntryRelation = false;
        if (TranferType.mutiToMuti.equals((Object)this.billMappingInfo.getTransferType())) {
            isSaveBotpEntryRelation = true;
        }
        if (botpColl == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < botpColl.size(); ++i) {
            BOTRelationInfo botpInfo = botpColl.get(i);
            if (botpInfo.getId() != null) {
                if (!isSaveBotpEntryRelation) {
                    botpInfo.getRelationEntries().clear();
                }
                BOTRelationFactory.getLocalInstance((Context)this.ctx).update(CommonUtil.convert2PK(botpInfo.getId().toString()), botpInfo);
                continue;
            }
            if (!isSaveBotpEntryRelation) {
                botpInfo.getRelationEntries().clear();
            }
            BOTRelationFactory.getLocalInstance((Context)this.ctx).addnew(botpInfo);
        }
        botpColl = null;
        existHeadSrcBills = null;
    }

    private VoucherInfo mergeVoucher(VoucherInfo voucher, VoucherCollection coll, BOTRelationCollection realtionColl, BOTRelationCollection realtionCollTmp, Map<String, BOTRelationInfo> existHeadSrcBills) throws EASBizException, BOSException {
        for (int index = 0; index < coll.size(); ++index) {
            VoucherInfo voucherTemp = (VoucherInfo)coll.get(index).clone();
            DynamicBillTemplate.add(voucherTemp.getId().toString());
            VoucherFactory.getLocalInstance((Context)this.ctx).delete(CommonUtil.convert2PK(voucherTemp.getId().toString()));
            if (MonitorManager.getCurrentMidBillToDest() != null) {
                int resultBillCount = MonitorManager.getCurrentMidBillToDest().getResultBillCount();
                MonitorManager.getCurrentMidBillToDest().setResultBillCount(resultBillCount - 1);
            }
            VoucherEntryCollection entrys = voucherTemp.getEntries();
            HashMap<String, String> entryIdMap = new HashMap<String, String>();
            for (int k = 0; k < entrys.size(); ++k) {
                VoucherEntryInfo entry = entrys.get(k);
                String srcId = entry.getId().toString();
                entry.setBill(voucher);
                entry.setSeq(voucher.getEntries().size() + 1);
                entry.setId(null);
                VoucherEntryFactory.getLocalInstance((Context)this.ctx).addnew((CoreBaseInfo)entry);
                voucher.getEntries().add(entry);
                entryIdMap.put(srcId, entry.getId().toString());
                VoucherAssistRecordCollection asstRecords = entry.getAssistRecords();
                CoreBaseCollection asstRecordsColl = new CoreBaseCollection();
                for (int arIndex = 0; arIndex < asstRecords.size(); ++arIndex) {
                    VoucherAssistRecordInfo aRecordInfo = asstRecords.get(arIndex);
                    aRecordInfo.setId(null);
                    aRecordInfo.setBill(voucher);
                    aRecordInfo.setEntry(entry);
                    asstRecordsColl.add((CoreBaseInfo)aRecordInfo);
                }
                VoucherAssistRecordFactory.getLocalInstance((Context)this.ctx).addnewBatchData(asstRecordsColl);
            }
            for (int i = 0; i < realtionCollTmp.size(); ++i) {
                BOTRelationInfo botpRelation = realtionCollTmp.get(i);
                for (int j = 0; j < botpRelation.getRelationEntries().size(); ++j) {
                    BOTRelationEntryInfo botpRelationEntry = botpRelation.getRelationEntries().get(j);
                    botpRelationEntry.setDestObjectID(voucher.getId().toString());
                    botpRelationEntry.setDestEntryID((String)entryIdMap.get(botpRelationEntry.getDestEntryID()));
                    botpRelationEntry.setId(null);
                }
                if (existHeadSrcBills.containsKey(botpRelation.getSrcObjectID())) {
                    BOTRelationInfo rootBotpRelation = existHeadSrcBills.get(botpRelation.getSrcObjectID().toString());
                    rootBotpRelation.getRelationEntries().addCollection(botpRelation.getRelationEntries());
                    continue;
                }
                existHeadSrcBills.put(botpRelation.getSrcObjectID(), botpRelation);
                realtionColl.add(botpRelation);
                botpRelation.setId(null);
                botpRelation.setDestObjectID(voucher.getId().toString());
            }
        }
        VoucherFactory.getLocalInstance((Context)this.ctx).save(CommonUtil.convert2PK(voucher.getId().toString()), (CoreBaseInfo)voucher);
        return voucher;
    }

    private String generateSqlWithCondtion(GroupInfo info, String groupBySql, Map<String, Boolean> typeMap, Map<String, String> tableEntryMap) {
        String sqlWhere = "";
        for (String columnName : info.getColumnValueMap().keySet()) {
            Object value = info.getColumnValueMap().get(columnName);
            sqlWhere = typeMap.get(columnName.toUpperCase()).booleanValue() ? (value == null ? sqlWhere + this.billMappingInfo.getMidBillTable() + "." + columnName + " is null" : sqlWhere + this.billMappingInfo.getMidBillTable() + "." + columnName + "=" + info.getColumnValueMap().get(columnName)) : (value == null ? sqlWhere + this.billMappingInfo.getMidBillEntryTable() + "." + columnName + " is null" : sqlWhere + this.billMappingInfo.getMidBillEntryTable() + "." + columnName + "=" + info.getColumnValueMap().get(columnName));
            sqlWhere = sqlWhere + " and ";
        }
        sqlWhere = sqlWhere + " 1=1 ";
        DIPMetadata dm = new DIPMetadata(this.billMappingInfo.getNumber());
        EntityObjectInfo entrysEntityInfo = UictUtils.loadEntity((IMetaDataPK)new MetaDataPK(dm.getEntryEntityPK()));
        String mappingField = entrysEntityInfo.getPropertyByName("entryStatus").getMappingField().getName();
        String result = "select count(1) ," + groupBySql + " from " + this.billMappingInfo.getMidBillTable() + " inner join " + this.billMappingInfo.getMidBillEntryTable() + " on " + this.billMappingInfo.getMidBillEntryTable() + ".fparentid =" + this.billMappingInfo.getMidBillTable() + ".fid where (" + this.billMappingInfo.getMidBillEntryTable() + "." + mappingField + " =0 or " + this.billMappingInfo.getMidBillEntryTable() + "." + mappingField + " is null ) and (" + sqlWhere + ")";
        if (this.headpkSet != null && !this.headpkSet.isEmpty()) {
            result = result + " and exists ( select 1 from T_EIP_AssigNumberBills where T_EIP_AssigNumberBills.FMidBillIds = " + this.billMappingInfo.getMidBillTable() + ".fid  and " + "T_EIP_AssigNumberBills" + ".FBillMappingId ='" + this.billMappingInfo.getId().toString() + "'  and " + "T_EIP_AssigNumberBills" + ".FAssignMentNumber ='" + this.assignNumber + "' )";
        }
        result = result + " group by " + groupBySql;
        result = result + " order by count(1) ";
        return result;
    }

    private CoreBillBaseCollection getSourceBill(IDynamicBillTemplateEntry template, Map<String, Boolean> typeMap, Map<String, String> tableEntryMap, List<GroupInfo> subGroupInfo, Set<String> headpkSet) throws BOSException {
        CoreBillBaseCollection billColl = new CoreBillBaseCollection();
        int pageSize = (subGroupInfo.size() - 1) / DestBillBatchUtil.maxGroupNumber + 1;
        for (int pageIndex = 0; pageIndex < pageSize; ++pageIndex) {
            List<GroupInfo> subList = null;
            subList = pageIndex < pageSize - 1 ? subGroupInfo.subList(pageIndex * DestBillBatchUtil.maxGroupNumber, (pageIndex + 1) * DestBillBatchUtil.maxGroupNumber) : subGroupInfo.subList(pageIndex * DestBillBatchUtil.maxGroupNumber, subGroupInfo.size());
            EntityViewInfo resultEntityView = this.getSubEntityViewInfo(typeMap, tableEntryMap, subList, headpkSet);
            DynamicBillTemplateEntryCollection entrys = template.getDynamicBillTemplateEntryCollection(resultEntityView);
            CoreBillBaseCollection bills = DestBillBatchUtil.convertBillEntryColl2BillColl(entrys);
            billColl.addCollection(bills);
        }
        return billColl;
    }

    @Override
    public EntityViewInfo getBaseEntityViewInfo(Set<String> headpkSet) {
        EntityViewInfo selectedView = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("entryStatus", (Object)Boolean.FALSE, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("entryStatus", null, CompareType.EQUALS));
        if (headpkSet != null && !headpkSet.isEmpty()) {
            String existSQL = "( select 1 from T_EIP_AssigNumberBills where T_EIP_AssigNumberBills.FMidBillIds =  \"T1\".fid  and T_EIP_AssigNumberBills.FBillMappingId ='" + this.billMappingInfo.getId().toString() + "'  and " + "T_EIP_AssigNumberBills" + ".FAssignMentNumber ='" + this.assignNumber + "' )";
            filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)existSQL, CompareType.EXISTS));
            filter.setMaskString("(#0 or #1) and #2");
        } else {
            filter.setMaskString("(#0 or #1)");
        }
        selectedView.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("parent.*"));
        sic.add(new SelectorItemInfo("*"));
        selectedView.setSelector(sic);
        return selectedView;
    }

    @Override
    public String initQueryString(String groupBySql, BillMappingInfo billMappingInfo, Set<String> headpkSet) {
        DIPMetadata dm = new DIPMetadata(billMappingInfo.getNumber());
        EntityObjectInfo entrysEntityInfo = UictUtils.loadEntity((IMetaDataPK)new MetaDataPK(dm.getEntryEntityPK()));
        String mappingField = entrysEntityInfo.getPropertyByName("entryStatus").getMappingField().getName();
        String result = "select count(1) ," + groupBySql + " from " + billMappingInfo.getMidBillTable() + " inner join " + billMappingInfo.getMidBillEntryTable() + " on " + billMappingInfo.getMidBillEntryTable() + ".fparentid =" + billMappingInfo.getMidBillTable() + ".fid where (" + billMappingInfo.getMidBillEntryTable() + "." + mappingField + " =0 or " + billMappingInfo.getMidBillEntryTable() + "." + mappingField + " is null )";
        if (headpkSet != null && !headpkSet.isEmpty()) {
            result = result + " and exists ( select 1 from T_EIP_AssigNumberBills where T_EIP_AssigNumberBills.FMidBillIds = " + billMappingInfo.getMidBillTable() + ".fid  and " + "T_EIP_AssigNumberBills" + ".FBillMappingId ='" + this.billMappingInfo.getId().toString() + "'  and " + "T_EIP_AssigNumberBills" + ".FAssignMentNumber ='" + this.assignNumber + "' )";
        }
        result = result + " group by " + groupBySql;
        result = result + " order by count(1) ";
        return result;
    }

    private void filterHeadAndEntryGroupField(Map<String, String> map) {
        Iterator<String> it = map.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next();
            String[] entity = key.split("\\.");
            if (entity[0].equalsIgnoreCase(this.billMappingInfo.getNumber() + "entry") && !key.endsWith("_BOTP")) continue;
            it.remove();
        }
    }

    private void filterHeadField(Map<String, String> map) {
        Iterator<String> it = map.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next();
            String[] entity = key.split("\\.");
            if (!entity[0].equalsIgnoreCase(this.billMappingInfo.getNumber()) || key.endsWith("_BOTP")) continue;
            it.remove();
        }
    }

    private void filterBotpTag(Map<String, String> map) {
        Iterator<String> it = map.keySet().iterator();
        String filterKey = null;
        String value = null;
        while (it.hasNext()) {
            String key = it.next();
            if (!key.endsWith("_BOTP")) continue;
            value = map.get(key);
            filterKey = key.substring(0, key.length() - "_BOTP".length());
            it.remove();
        }
        map.put(filterKey, value);
    }
}

