/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.schedule.app.service.destBillStrategy.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.IDynamicBillTemplate;
import com.kingdee.eas.csinterface.billmapping.BillMappingInfo;
import com.kingdee.eas.csinterface.schedule.app.service.DesBIllCreator;
import com.kingdee.eas.csinterface.schedule.app.service.destBillStrategy.AbstractDestBillTransferObject;
import com.kingdee.eas.csinterface.util.MidBillFactory;
import com.kingdee.eas.csinterface.util.ThrowableHelper;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.util.StringUtils;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class TransferOneTOneImpl
extends AbstractDestBillTransferObject {
    private static Logger logger = Logger.getLogger(TransferOneTOneImpl.class);

    public TransferOneTOneImpl(Context ctx, String scheduId, Set<String> headpkSet, BOTMappingInfo botMapping, BillMappingInfo billMappingInfo, Integer assignNumber) {
        super(ctx, scheduId, headpkSet, botMapping, billMappingInfo, assignNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transfer() throws BOSException, EASBizException {
        DesBIllCreator desBIllCreator = new DesBIllCreator(this.ctx, this.scheduId, this.billMappingInfo.getNumber(), this.botMapping, this.billMappingInfo.getCashFlowRelation(), this.billMappingInfo.isIntegrateCashFlow(), this.billMappingInfo.getEasCashFlowRelation(), this.billMappingInfo.isIntergrateEASCashFlow(), this.billMappingInfo.getAssistAccountRelation(), this.billMappingInfo.isIntegrateEasAssAcc());
        IDynamicBillTemplate template = MidBillFactory.getInstance(this.ctx, this.billMappingInfo.getNumber());
        int transferSize = this.billMappingInfo.getTransferSize();
        if (transferSize <= 0 || transferSize > this.headpkSet.size()) {
            transferSize = this.headpkSet.size();
        }
        HashSet<String> set = new HashSet<String>();
        for (String id : this.headpkSet) {
            set.add(id);
            if (set.size() % transferSize != 0) continue;
            try {
                this.doTransfer(desBIllCreator, template, set);
                this.recordIDErrorInfoMap(set, null, true);
            }
            catch (Exception e) {
                logger.error((Object)("\u3010\u751f\u6210\u76ee\u6807\u5355\u5931\u8d25\u3011" + ((Object)set).toString()), (Throwable)e);
                this.recordIDErrorInfoMap(set, StringUtils.arrayToString((Object[])ThrowableHelper.generatekernelMessage(e, 3), (String)";"), false);
            }
            finally {
                set.clear();
            }
        }
        if (!set.isEmpty()) {
            try {
                this.doTransfer(desBIllCreator, template, set);
                this.recordIDErrorInfoMap(set, null, true);
            }
            catch (Exception e) {
                this.recordIDErrorInfoMap(set, StringUtils.arrayToString((Object[])ThrowableHelper.generatekernelMessage(e, 3), (String)";"), false);
            }
            finally {
                set.clear();
            }
        }
    }

    private void doTransfer(DesBIllCreator desBIllCreator, IDynamicBillTemplate template, Set set) throws BOSException {
        EntityViewInfo selectedView = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        selectedView.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("fiVouchered", (Object)Boolean.FALSE, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("fiVouchered", null, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
        filter.setMaskString("(#0 or #1) and #2");
        String entrySeq = this.billMappingInfo.getEntrySeq();
        if (!StringUtils.isEmpty((String)entrySeq)) {
            SorterItemInfo sorter = new SorterItemInfo("entrys." + entrySeq);
            sorter.setSortType(SortType.ASCEND);
            selectedView.getSorter().add(sorter);
        }
        CoreBillBaseCollection sourceBills = null;
        sourceBills = template.getCoreBillBaseCollection(selectedView);
        if (!sourceBills.isEmpty()) {
            this.fillAssigNumber(sourceBills, this.assignNumber);
            this.recordSucNumber(this.assignNumber);
            try {
                desBIllCreator.botp2DesBill(sourceBills);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
    }
}

