/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.schedule.app.service.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.bp.BPJob;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobInstanceConfig;
import com.kingdee.bos.service.job.core.JobManager;
import com.kingdee.bos.service.job.ext.DynamicBackgroundServiceProvider;
import com.kingdee.eas.csinterface.schedule.app.service.ScheduleFacade;
import com.kingdee.eas.csinterface.schedule.app.service.util.EipBPJob;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class EIPBackgroundServiceProvider {
    private static Logger log = Logger.getLogger((String)DynamicBackgroundServiceProvider.class.getName());
    private static final EIPBackgroundJobHandler handler = new EIPBackgroundJobHandler();

    public static final EIPBackgroundServiceProvider getInstance() {
        return new EIPBackgroundServiceProvider();
    }

    public boolean submit(Context ctx, BPJob bpJob, String threadName) {
        JobInstanceConfig cfg = new JobInstanceConfig((IJobHandler)handler, false, true, 1000000, null, null, null, threadName, 1);
        Job job = new Job(ctx, "dynamic background job executing!", cfg, (Object)bpJob);
        String isolationBoundary = ScheduleFacade.getIsolation("EIP", ctx);
        if (!StringUtils.isEmpty((String)isolationBoundary)) {
            job.setIsolationBoundary(isolationBoundary);
        }
        try {
            JobManager.instance().add(job);
            return true;
        }
        catch (Exception e) {
            log.error((Object)("accept dynamic background job failed. " + bpJob.toString()), (Throwable)e);
            return false;
        }
    }

    private static class EIPBackgroundJobHandler
    implements IJobHandler {
        private static final long serialVersionUID = 983302828906069043L;

        private EIPBackgroundJobHandler() {
        }

        public Object execute(Job job) throws Exception {
            BPJob r = (BPJob)job.getParameters();
            if (r instanceof EipBPJob) {
                ((EipBPJob)r).setJob(job);
            }
            r.run();
            return null;
        }
    }
}

