/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.syncdatabase.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataMapingCollection;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataMapingFactory;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataMapingInfo;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataTypeInfo;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionFactory;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionInfo;
import com.kingdee.eas.csinterface.syncdatabase.IConnection;
import com.kingdee.eas.csinterface.syncdatabase.ISQLFacade;
import com.kingdee.eas.csinterface.syncdatabase.SQLFacadeFactory;
import com.kingdee.eas.csinterface.syncdatabase.util.BaseDataBean;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class BaseDataTypeRuleFilter {
    private static Logger logger = Logger.getLogger((String)BaseDataTypeRuleFilter.class.getName());
    public static final String ruleReg = "(\\*)*#(\\*)*\\$?";
    public static final String replaceReg = "[^?]*(\\?)[^?]*";
    public static final int pageSize = 1000;
    public static final String mixFlag = "$";

    public static void doFilter(String rule, List<String> srcList, Map<String, List<String>> record) throws Exception {
        if (StringUtils.isEmpty((String)rule)) {
            return;
        }
        if (!BaseDataTypeRuleFilter.matchRule(rule)) {
            return;
        }
        if (record == null) {
            return;
        }
        if (rule.endsWith(mixFlag)) {
            rule = rule.substring(0, rule.length() - 1);
        }
        String[] leftRight = rule.split("#");
        int leftLength = 0;
        int rightLength = 0;
        if (leftRight.length == 0) {
            return;
        }
        if (leftRight.length == 1) {
            leftLength = leftRight[0].trim().length();
        } else if (leftRight.length == 2) {
            leftLength = leftRight[0].trim().length();
            rightLength = leftRight[1].trim().length();
        }
        for (int i = 0; i < srcList.size(); ++i) {
            String str = srcList.get(i);
            if (leftLength + rightLength >= str.length()) {
                throw new Exception("\u89c4\u5219\u914d\u7f6e\u9519\u8bef");
            }
            String filterStr = str.substring(leftLength, str.length() - rightLength);
            srcList.set(i, filterStr);
            if (record.containsKey(filterStr)) {
                record.get(filterStr).add(str);
                continue;
            }
            ArrayList<String> list = new ArrayList<String>();
            list.add(str);
            record.put(filterStr, list);
        }
    }

    public static boolean verify(String rule) {
        if (!StringUtils.isEmpty((String)rule)) {
            return Pattern.matches(ruleReg, rule) || Pattern.matches(replaceReg, rule);
        }
        return true;
    }

    public static boolean matchRule(String rule) {
        if (!StringUtils.isEmpty((String)rule)) {
            return Pattern.matches(ruleReg, rule);
        }
        return false;
    }

    public static boolean matchReplace(String rule) {
        if (!StringUtils.isEmpty((String)rule)) {
            return Pattern.matches(replaceReg, rule);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getNumberNameMap(BaseDataTypeInfo baseDataTypeInfo, List<String> set, ConnectionInfo connectionInfo) throws BOSException {
        ConnectionInfo conn;
        IConnection connection;
        ArrayList<String> noMapSet;
        HashMap<String, String> numberNameMap;
        block10: {
            ObjectUuidPK pk;
            numberNameMap = new HashMap<String, String>();
            noMapSet = new ArrayList<String>(set);
            connection = ConnectionFactory.getRemoteInstance();
            conn = connectionInfo;
            if (conn == null || connection.exists((IObjectPK)(pk = new ObjectUuidPK(conn.getId().toString())))) break block10;
            MsgBox.showInfo((String)"\u8fde\u63a5\u5df2\u4e0d\u5b58\u5728!");
            HashMap<String, String> hashMap = numberNameMap;
            return hashMap;
        }
        try {
            conn = connection.getConnectionInfo((IObjectPK)new ObjectUuidPK(conn.getId().toString()));
            BaseDataMapingCollection coll = BaseDataMapingFactory.getRemoteInstance().getBaseDataMapingCollection("where baseDataType.id ='" + baseDataTypeInfo.getId().toString() + "'");
            if (StringUtils.isEmpty((String)baseDataTypeInfo.getRule()) || BaseDataTypeRuleFilter.matchReplace(baseDataTypeInfo.getRule()) || BaseDataTypeRuleFilter.verify(baseDataTypeInfo.getRule()) && baseDataTypeInfo.getRule().endsWith(mixFlag)) {
                List<BaseDataBean> resultList = BaseDataTypeRuleFilter.getRowSet(baseDataTypeInfo, coll, conn, noMapSet);
                for (BaseDataBean baseDataBean : resultList) {
                    numberNameMap.put(baseDataBean.getNumber(), baseDataBean.getName());
                }
            }
            if (!StringUtils.isEmpty((String)baseDataTypeInfo.getRule()) && BaseDataTypeRuleFilter.matchRule(baseDataTypeInfo.getRule())) {
                HashMap<String, List<String>> record = new HashMap<String, List<String>>();
                BaseDataTypeRuleFilter.doFilter(baseDataTypeInfo.getRule(), noMapSet, record);
                List<BaseDataBean> resultListSec = BaseDataTypeRuleFilter.getRowSet(baseDataTypeInfo, coll, conn, noMapSet);
                for (BaseDataBean baseDataBean : resultListSec) {
                    for (String srcNumber : (List)record.get(baseDataBean.getNumber())) {
                        numberNameMap.put(srcNumber, baseDataBean.getName());
                    }
                    numberNameMap.put(baseDataBean.getNumber(), baseDataBean.getName());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return numberNameMap;
    }

    private static String getSrcSql(BaseDataTypeInfo editData, List<String> noMapSet, String srcWhere) {
        StringBuffer sql = new StringBuffer();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < noMapSet.size(); ++i) {
            sb.append("'");
            sb.append(noMapSet.get(i));
            sb.append("'");
            if (i >= noMapSet.size() - 1) continue;
            sb.append(",");
        }
        sql.append("select ");
        sql.append(editData.getSrcID());
        if (editData.getSrcDisplay() != null) {
            sql.append(",");
            sql.append(editData.getSrcDisplay());
        }
        sql.append(" from  ");
        sql.append(editData.getSrcTable());
        if (StringUtils.isEmpty((String)srcWhere)) {
            sql.append(" where " + editData.getSrcID() + " in (");
            sql.append((CharSequence)sb);
            sql.append(")");
        } else {
            sql.append(" ").append(srcWhere);
            sql.append(" and  " + editData.getSrcID() + " in (");
            sql.append((CharSequence)sb);
            sql.append(")");
        }
        sql.append("  group by ");
        sql.append(editData.getSrcID());
        if (editData.getSrcDisplay() != null) {
            sql.append(",");
            sql.append(editData.getSrcDisplay());
        }
        logger.error((Object)("execute sql :" + sql.toString()));
        return sql.toString();
    }

    public static List<BaseDataBean> getRowSet(BaseDataTypeInfo baseDataTypeInfo, BaseDataMapingCollection coll, ConnectionInfo conn, List<String> noMapSet) throws EASBizException, BOSException, SQLException {
        ISQLFacade intance = SQLFacadeFactory.getRemoteInstance();
        IRowSet rowSet = null;
        ArrayList<BaseDataBean> result = new ArrayList<BaseDataBean>();
        if (noMapSet.isEmpty()) {
            return result;
        }
        if (coll == null || coll.size() == 0) {
            int count = (noMapSet.size() - 1) / 1000 + 1;
            for (int i = 0; i < count; ++i) {
                List<String> temp = null;
                temp = i == count - 1 ? noMapSet.subList(i * 1000, noMapSet.size()) : noMapSet.subList(i * 1000, (i + 1) * 1000);
                rowSet = intance.getTargetRowset(conn, BaseDataTypeRuleFilter.getSrcSql(baseDataTypeInfo, temp, null));
                ArrayList<String> tempList = new ArrayList<String>();
                while (rowSet.next()) {
                    tempList.add(rowSet.getString(1));
                    BaseDataBean baseDataBean = new BaseDataBean(rowSet.getString(1), rowSet.getString(2));
                    result.add(baseDataBean);
                }
                noMapSet.removeAll(tempList);
            }
        } else {
            for (int i = 0; i < coll.size() && !noMapSet.isEmpty(); ++i) {
                BaseDataMapingInfo baseDataMapingInfo = coll.get(i);
                String srcWhere = baseDataMapingInfo.getSrcWhere();
                if (!StringUtils.isEmpty((String)srcWhere)) {
                    int beginIndex = 0;
                    for (int index = 0; index < srcWhere.length(); ++index) {
                        if (" ".equals(String.valueOf(srcWhere.charAt(index)))) {
                            ++beginIndex;
                            continue;
                        }
                        srcWhere = srcWhere.substring(beginIndex);
                        break;
                    }
                    if (!StringUtils.startsWithIgnoreCase((String)srcWhere, (String)"where")) {
                        srcWhere = " where " + srcWhere;
                    }
                }
                if (!StringUtils.isEmpty((String)srcWhere)) {
                    srcWhere = srcWhere.trim();
                }
                ArrayList<String> tempList = new ArrayList<String>();
                int count = (noMapSet.size() - 1) / 1000 + 1;
                for (int j = 0; j < count; ++j) {
                    List<String> temp = null;
                    temp = j == count - 1 ? noMapSet.subList(j * 1000, noMapSet.size()) : noMapSet.subList(j * 1000, (j + 1) * 1000);
                    rowSet = intance.getTargetRowset(conn, BaseDataTypeRuleFilter.getSrcSql(baseDataTypeInfo, temp, srcWhere));
                    while (rowSet.next()) {
                        tempList.add(rowSet.getString(1));
                        BaseDataBean baseDataBean = new BaseDataBean(rowSet.getString(1), rowSet.getString(2));
                        result.add(baseDataBean);
                    }
                }
                noMapSet.removeAll(tempList);
            }
        }
        return result;
    }
}

