/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.util;

import com.kingdee.eas.csinterface.util.IOUtils;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class FileContentReader {
    public static String readFileContent(String filePath, String encoding) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(filePath);
            String string = IOUtils.readFully(fis, encoding);
            return string;
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static String readGBKFileContent(String filePath) {
        return FileContentReader.readFileContent(filePath, "GBK");
    }

    public static String readUTF8FileContent(String filePath) {
        return FileContentReader.readFileContent(filePath, "UTF-8");
    }
}

