/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.util;

import com.kingdee.eas.csinterface.util.IOUtils;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;

public class PropertiesUtils {
    private Properties prop = new Properties();

    public void loadProperties(String filename) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(filename);
            this.loadProperties(fileInputStream);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeInputStreamQuietly(fileInputStream);
                throw throwable;
            }
        }
        IOUtils.closeInputStreamQuietly(fileInputStream);
    }

    public void loadProperties(InputStream inStream) {
        try {
            this.prop.load(inStream);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Properties getProperties() {
        return this.prop;
    }

    public void setProperties(Properties properties) {
        this.prop = properties;
    }

    public String getValue(String key) {
        return this.prop.getProperty(key);
    }

    public String getValue(String key, String defaultValue) {
        return this.prop.getProperty(key, defaultValue);
    }

    public static String getSysProp(String key) {
        try {
            return System.getProperty(key);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getSysProp(String key, String defValue) {
        String value = defValue;
        try {
            value = System.getProperty(key, defValue);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public static boolean toBoolean(String value) {
        if (null == value) {
            return false;
        }
        return "true".equalsIgnoreCase(value);
    }

    public static int toInt(String value, int defValue) {
        if (null == value) {
            return defValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (Exception exception) {
            return defValue;
        }
    }

    public static boolean getSysProptToBoolean(String key) {
        return PropertiesUtils.toBoolean(PropertiesUtils.getSysProp(key));
    }

    public static int getSysProptToInt(String key, int defValue) {
        return PropertiesUtils.toInt(PropertiesUtils.getSysProp(key), defValue);
    }

    public String[] getAllKeys() {
        return this.prop.keySet().toArray(new String[0]);
    }

    public String[] getAllValues() {
        return this.prop.values().toArray(new String[0]);
    }
}

