/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.webservice.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.webservice.WSErrorParamLogInfo;
import com.kingdee.eas.csinterface.webservice.app.AbstractWSErrorParamLogControllerBean;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class WSErrorParamLogControllerBean
extends AbstractWSErrorParamLogControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.csinterface.webservice.app.WSErrorParamLogControllerBean");
    private static final int maxLen = 980;

    @Override
    protected void _log(Context ctx, WSErrorParamLogInfo errorParamLogInfo) throws BOSException, EASBizException {
        this.formatLogInfo(errorParamLogInfo);
        this._addnew(ctx, (IObjectPK)new ObjectUuidPK(errorParamLogInfo.getId()), (IObjectValue)errorParamLogInfo);
    }

    @Override
    protected void _updateLog(Context ctx, WSErrorParamLogInfo errorParamLogInfo) throws BOSException, EASBizException {
        this.formatLogInfo(errorParamLogInfo);
        this._update(ctx, (IObjectPK)new ObjectUuidPK(errorParamLogInfo.getId()), (IObjectValue)errorParamLogInfo);
    }

    private void formatLogInfo(WSErrorParamLogInfo errorParamLogInfo) {
        String errorMsg;
        String stackTrace;
        if (null == errorParamLogInfo) {
            return;
        }
        String incomingData = errorParamLogInfo.getIncomingData();
        if (StringUtils.isEmpty((String)incomingData)) {
            return;
        }
        if (incomingData.length() > 980) {
            incomingData = incomingData.substring(0, 980) + "\u2026";
            errorParamLogInfo.setIncomingData(incomingData);
        }
        if (StringUtils.isEmpty((String)(stackTrace = errorParamLogInfo.getStaceTrace()))) {
            return;
        }
        if (stackTrace.length() > 980) {
            stackTrace = stackTrace.substring(0, 980) + "\u2026";
            errorParamLogInfo.setStaceTrace(stackTrace);
        }
        if (StringUtils.isEmpty((String)(errorMsg = errorParamLogInfo.getErrorMsg()))) {
            return;
        }
        if (errorMsg.length() > 980) {
            errorMsg = errorMsg.substring(0, 980) + "\u2026";
            errorParamLogInfo.setErrorMsg(errorMsg);
        }
    }
}

