/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.webservice.app.handler.impl;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.bot.MappingUtil;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.csinterface.webservice.ImplType;
import com.kingdee.eas.csinterface.webservice.WSBillMappingInfo;
import com.kingdee.eas.csinterface.webservice.app.handler.IUserHandler;
import com.kingdee.eas.csinterface.webservice.app.handler.impl.AbstractHandler;
import com.kingdee.eas.csinterface.webservice.app.log.WSCallRecordManager;
import com.kingdee.eas.csinterface.webservice.app.model.WSDataModelUtil;
import com.kingdee.eas.csinterface.webservice.app.model.WSStructuredDataModel;
import com.kingdee.eas.csinterface.webservice.app.util.ResourceHolder;
import com.kingdee.eas.csinterface.webservice.app.webservice.engine.translate.Translater;
import com.kingdee.eas.csinterface.webservice.app.webservice.engine.translate.impl.JSONTranslater;
import com.kingdee.eas.csinterface.webservice.framework.exception.EIPBaseException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import java.lang.reflect.Method;
import javax.annotation.Resource;

public class SendHandler
extends AbstractHandler {
    @Resource
    protected Translater translater = new JSONTranslater();
    private Boolean flag;
    private IUserHandler userHandle;

    @Override
    protected SelectorItemCollection getSelectors() {
        return super.getSelectors();
    }

    @Override
    public Object innerHandler(WSBillMappingInfo wsbminfo, Object data) throws EIPBaseException, Exception {
        this.checkParameters(wsbminfo, data);
        this.userHandle = ResourceHolder.getUserHandler();
        this.flag = ImplType.userClass.equals((Object)wsbminfo.getImplType());
        Context ctx = ResourceHolder.getContext();
        if (this.flag.booleanValue()) {
            data = this.userHandle.handleOriginal(ctx, data);
            if (this.userHandle.isEndWithOriginal()) {
                return data;
            }
        }
        return this.defaultHandle(ctx, wsbminfo, data);
    }

    private Object defaultHandle(Context ctx, WSBillMappingInfo wsbminfo, Object data) throws EIPBaseException, Exception {
        WSStructuredDataModel model = WSDataModelUtil.convert(wsbminfo);
        Object result = this.translater.doTranslate(model, data);
        if (this.flag.booleanValue()) {
            result = this.userHandle.handleProcess(ctx, result);
            if (this.userHandle.isEndWithProcess()) {
                return result;
            }
        }
        BTPTransformResult botResult = null;
        try {
            String name = "com.kingdee.eas.csinterface.custom.webservice.app." + wsbminfo.getNumber();
            EntityViewInfo btpView = new EntityViewInfo();
            FilterInfo btpFilter = new FilterInfo();
            btpFilter.getFilterItems().add(new FilterItemInfo("srcEntityFullName", (Object)name, CompareType.EQUALS));
            btpFilter.getFilterItems().add(new FilterItemInfo("extRule.isEffected", (Object)"1", CompareType.EQUALS));
            btpView.setFilter(btpFilter);
            IBOTMapping botInstance = BOTMappingFactory.getLocalInstance((Context)ctx);
            BOTMappingCollection btps = botInstance.getBOTMappingCollection(btpView);
            if (btps.size() != 1) {
                throw new EIPBaseException(1230, "\u975e\u6cd5\u914d\u7f6e:the enable botp rule is not 1");
            }
            MappingUtil.initMappingEntity((BOTMappingInfo)btps.get(0), (IMetaDataLoader)MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ConfigMDUtil.getContext()));
            botResult = BTPManagerFactory.getLocalInstance((Context)ctx).transform((CoreBillBaseInfo)result, btps.get(0));
            if (this.flag.booleanValue()) {
                botResult = this.userHandle.handleBOTPResult(ctx, botResult);
                if (this.userHandle.isEndWithBOTPResult()) {
                    return botResult;
                }
            }
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            throw e;
        }
        Object bizResult = null;
        if (this.flag.booleanValue()) {
            bizResult = this.userHandle.handleDest(ctx, botResult);
            if (this.userHandle.isEndWithDest()) {
                return bizResult;
            }
        }
        if (ImplType.entity.equals((Object)wsbminfo.getImplType()) || ImplType.facade.equals((Object)wsbminfo.getImplType())) {
            String clzName = wsbminfo.getImplClass() + "Factory";
            Class<?> clz = Class.forName(clzName);
            Method method = clz.getMethod("getLocalInstance", Context.class);
            Object object = method.invoke(clz, ctx);
            Class<?> facade = object.getClass();
            Method method2 = facade.getMethod(wsbminfo.getImplMethod(), CoreBaseInfo.class);
            bizResult = method2.invoke(object, botResult.getBills().getObject(0));
            WSCallRecordManager.enterImplClassAndMethod(ctx, wsbminfo.getImplClass(), wsbminfo.getImplMethod());
        }
        return bizResult;
    }

    private void checkParameters(WSBillMappingInfo wsbminfo, Object data) throws EIPBaseException {
        if (ImplType.query.equals((Object)wsbminfo.getImplType())) {
            throw new EIPBaseException(1230, "\u975e\u6cd5\u914d\u7f6e:the model is query when the interface is enable to add");
        }
    }
}

