/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.webservice.app.handler.user;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.sql.util.StringUtil;
import com.kingdee.eas.csinterface.agent.service.work.basedata.model.ColumnModel;
import com.kingdee.eas.csinterface.monitor.app.BaseDataDownMonitorLogInfo;
import com.kingdee.eas.csinterface.monitor.app.MonitorManager;
import com.kingdee.eas.csinterface.webservice.WSServiceFactory;
import com.kingdee.eas.csinterface.webservice.WSServiceInfo;
import com.kingdee.eas.csinterface.webservice.app.handler.user.AbstractUserHandler;
import com.kingdee.eas.csinterface.webservice.app.handler.user.IERPUserHandler;
import com.kingdee.eas.csinterface.webservice.app.webapi.util.HttpServiceHelper;
import com.kingdee.eas.csinterface.webservice.app.webapi.util.LoopWebserviceEntryUtil;
import com.kingdee.eas.csinterface.webservice.framework.ServiceURLUtil;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonNode;

public class EASUserHandler
extends AbstractUserHandler {
    private static Logger logger = Logger.getLogger(IERPUserHandler.class);
    private static Map<String, String> tokenMap = new HashMap<String, String>();

    public static Map<String, String> login(Context ctx, WSServiceInfo serviceInfo) throws BOSException {
        String userName;
        Map bodyMap;
        WSServiceInfo loginService;
        String loginURL = "";
        try {
            loginService = LoopWebserviceEntryUtil.getLoginService(ctx, serviceInfo);
            loginURL = EASUserHandler.getServiceURL(loginService);
            Object[] obj = LoopWebserviceEntryUtil.getHeadAndBody(loginService);
            bodyMap = (Map)obj[0];
            userName = loginService.getServiceUser();
        }
        catch (Exception e) {
            logger.error((Object)("EIP:get head and body error![WSServiceid:'" + serviceInfo.getId().toString() + "']"));
            logger.error((Object)e);
            throw new BOSException("EIP:get head and body error![WSServiceid:'" + serviceInfo.getId().toString() + "']", (Throwable)e);
        }
        String bodyStr = "";
        try {
            bodyMap.put("user", userName);
            bodyMap.put("password", loginService.getPassword());
            bodyStr = JSONObject.toJSONString((Object)bodyMap);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        JsonNode resultObj = null;
        try {
            resultObj = (JsonNode)HttpServiceHelper.doPost(loginURL, null, bodyStr, JsonNode.class);
        }
        catch (BOSException e) {
            logger.error((Object)(loginURL + "login fail:"), (Throwable)e);
            throw new BOSException(loginURL + "login fail:", (Throwable)e);
        }
        if (resultObj == null || 0 != resultObj.get("code").getIntValue()) {
            logger.error((Object)resultObj.get("message"));
            throw new BOSException("url " + loginURL + " login fail " + resultObj.get("message"));
        }
        tokenMap.put(ServiceURLUtil.getHost(loginService), resultObj.findValue("token").getTextValue());
        return null;
    }

    private static WSServiceInfo getWSService(Context ctx) throws BOSException {
        WSServiceInfo wsserviceInfo = null;
        String wsserviceId = "";
        try {
            wsserviceId = ((BaseDataDownMonitorLogInfo)MonitorManager.getCurrent()).getExtendedProperty("wsserviceId");
            if (!StringUtil.isEmpty((String)wsserviceId)) {
                wsserviceInfo = WSServiceFactory.getLocalInstance(ctx).getWSServiceInfo("select serviceMethod,serviceUser,password,implClass,entrys.name,entrys.number,entrys.returnDataType,entrys.region,entrys.defaultValue,entrys.loginService,entrys.isLogin,login,tree.serviceURL,tree.port where id ='" + wsserviceId + "'");
            }
        }
        catch (Exception e) {
            logger.error((Object)("EIP:remoteService found error[id='" + wsserviceId + "']"));
            throw new BOSException("EIP:remoteService found error[id='" + wsserviceId + "']", (Throwable)e);
        }
        return wsserviceInfo;
    }

    private static String getToken(Context ctx, WSServiceInfo wsserviceInfo) throws BOSException {
        WSServiceInfo loginService = null;
        String token = "";
        String serverKey = ServiceURLUtil.getHost(wsserviceInfo);
        try {
            loginService = LoopWebserviceEntryUtil.getLoginService(ctx, wsserviceInfo);
        }
        catch (BOSException e) {
            logger.error((Object)("EIP:wsservice error[id:'" + wsserviceInfo.getId().toString() + "']"));
            throw new BOSException("EIP:wsservice error[id:'" + wsserviceInfo.getId().toString() + "']", (Throwable)e);
        }
        try {
            if (tokenMap != null && tokenMap.size() != 0 && !StringUtils.isEmpty((String)tokenMap.get(serverKey))) {
                token = tokenMap.get(serverKey);
            } else {
                EASUserHandler.login(ctx, wsserviceInfo);
                token = tokenMap.get(serverKey);
            }
        }
        catch (BOSException e) {
            logger.error((Object)("EIP:seek token fail[id:'" + wsserviceInfo.getId().toString() + "']"));
            throw new BOSException("EIP:seek token fail[id:'" + wsserviceInfo.getId().toString() + "']", (Throwable)e);
        }
        return token;
    }

    public static String sendDataToEasforAdd2Update(Context ctx, List<String[]> dataList, String tableName, String mainPK, ColumnModel[] colNameRaw, Map<String, String> colType, String method) throws BOSException {
        int i;
        WSServiceInfo sendService = null;
        String sendDataUrl = "";
        String returnValue = "";
        HashMap<String, String> headMap = new HashMap<String, String>();
        sendService = EASUserHandler.getWSService(ctx);
        String token = EASUserHandler.getToken(ctx, sendService);
        headMap.put("token", token);
        headMap.put("method", method);
        HashMap<String, String> bodyMap = new HashMap<String, String>();
        StringBuffer columnsBuff = new StringBuffer();
        ColumnModel model = null;
        if ("1".endsWith(method)) {
            for (i = 0; i < colNameRaw.length; ++i) {
                model = colNameRaw[i];
                if (mainPK.equalsIgnoreCase(model.name)) {
                    mainPK = model.destName;
                }
                columnsBuff.append(model.destName).append(",");
            }
        }
        if ("2".endsWith(method)) {
            for (i = 0; i < colNameRaw.length; ++i) {
                model = colNameRaw[i];
                if (mainPK.equalsIgnoreCase(model.name)) {
                    mainPK = model.destName;
                    continue;
                }
                columnsBuff.append(model.destName).append(",");
            }
            columnsBuff.append(mainPK).append(",");
        }
        columnsBuff.deleteCharAt(columnsBuff.length() - 1);
        bodyMap.put("tableName", tableName);
        bodyMap.put("columns", columnsBuff.toString());
        bodyMap.put("dataList", JSONObject.toJSONString(dataList));
        bodyMap.put("columnType", JSONObject.toJSONString(colType));
        bodyMap.put("mainpk", mainPK);
        sendDataUrl = EASUserHandler.getServiceURL(sendService);
        JsonNode resultObj = null;
        try {
            resultObj = (JsonNode)HttpServiceHelper.doPost(sendDataUrl, headMap, JSONObject.toJSONString(bodyMap), JsonNode.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (resultObj == null || 0 != resultObj.get("code").getIntValue()) {
            logger.error(resultObj);
            returnValue = resultObj.findValue("message").getTextValue();
            throw new BOSException(returnValue);
        }
        returnValue = resultObj.findValue("out").getTextValue();
        return returnValue;
    }

    public static String sendDataToEasQuery(Context ctx, List<String[]> checkList, String tableName, String mainPK, String oppValue, Map<String, String> colType, String method) throws BOSException {
        WSServiceInfo sendService = null;
        String sendDataUrl = "";
        String returnValue = "";
        JsonNode resultObj = null;
        HashMap<String, String> headMap = new HashMap<String, String>();
        sendService = EASUserHandler.getWSService(ctx);
        String token = EASUserHandler.getToken(ctx, sendService);
        if (StringUtils.isEmpty((String)token)) {
            throw new BOSException();
        }
        headMap.put("token", token);
        headMap.put("method", method);
        HashMap<String, String> bodyMap = new HashMap<String, String>();
        bodyMap.put("tableName", JSONObject.toJSONString((Object)tableName));
        bodyMap.put("dataList", JSONObject.toJSONString(checkList));
        bodyMap.put("columnType", JSONObject.toJSONString(colType));
        bodyMap.put("columns", oppValue);
        bodyMap.put("mainpk", mainPK);
        sendDataUrl = EASUserHandler.getServiceURL(sendService);
        try {
            resultObj = (JsonNode)HttpServiceHelper.doPost(sendDataUrl, headMap, JSONObject.toJSONString(bodyMap), JsonNode.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (resultObj == null || 0 != resultObj.get("code").getIntValue()) {
            returnValue = resultObj.findValue("message").getTextValue();
            logger.error((Object)returnValue);
            throw new BOSException(returnValue);
        }
        returnValue = resultObj.findValue("out").getTextValue();
        return returnValue;
    }

    public static String sendDataToEasForDel(Context ctx, String idstr, String tableName, String mainPK, String method) throws BOSException {
        WSServiceInfo sendService = null;
        String sendDataUrl = "";
        String returnValue = "";
        HashMap<String, String> headMap = new HashMap<String, String>();
        sendService = EASUserHandler.getWSService(ctx);
        String token = EASUserHandler.getToken(ctx, sendService);
        headMap.put("token", token);
        headMap.put("method", method);
        HashMap<String, String> bodyMap = new HashMap<String, String>();
        bodyMap.put("tableName", tableName);
        bodyMap.put("dataList", JSONObject.toJSONString((Object)idstr));
        bodyMap.put("mainpk", mainPK);
        sendDataUrl = EASUserHandler.getServiceURL(sendService);
        JsonNode resultObj = null;
        try {
            resultObj = (JsonNode)HttpServiceHelper.doPost(sendDataUrl, headMap, JSONObject.toJSONString(bodyMap), JsonNode.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (resultObj == null || 0 != resultObj.get("code").getIntValue()) {
            returnValue = resultObj.findValue("message").getTextValue();
            logger.error((Object)returnValue);
            throw new BOSException(returnValue);
        }
        returnValue = resultObj.findValue("out").getTextValue();
        return returnValue;
    }
}

