/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.webservice.app.handler.user;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.csinterface.agent.service.work.basedata.model.ColumnModel;
import com.kingdee.eas.csinterface.eipserviceplugin.execute.IERPExecute;
import com.kingdee.eas.csinterface.util.ColumnInfo;
import com.kingdee.eas.csinterface.util.ThrowableHelper;
import com.kingdee.eas.csinterface.webservice.WSBillMappingInfo;
import com.kingdee.eas.csinterface.webservice.WSServiceEntryCollection;
import com.kingdee.eas.csinterface.webservice.WSServiceEntryInfo;
import com.kingdee.eas.csinterface.webservice.WSServiceInfo;
import com.kingdee.eas.csinterface.webservice.app.handler.user.AbstractUserHandler;
import com.kingdee.eas.csinterface.webservice.app.handler.user.ierp.ISCAPIUtil;
import com.kingdee.eas.csinterface.webservice.app.handler.user.ierp.model.FieldDefineModel;
import com.kingdee.eas.csinterface.webservice.app.handler.user.ierp.model.ISCConnectModel;
import com.kingdee.eas.csinterface.webservice.app.log.WSCallRecordManager;
import com.kingdee.eas.csinterface.webservice.app.util.ResourceHolder;
import com.kingdee.eas.csinterface.webservice.app.webapi.util.HttpServiceHelper;
import com.kingdee.eas.csinterface.webservice.app.webapi.util.LoopWebserviceEntryUtil;
import com.kingdee.eas.csinterface.webservice.app.webservice.model.ReturnModel;
import com.kingdee.eas.csinterface.webservice.framework.ServiceURLUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonNode;

public class IERPUserHandler
extends AbstractUserHandler {
    private static Logger logger = Logger.getLogger(IERPUserHandler.class);
    private static Map<String, String> tokenMap = new HashMap<String, String>();

    public Map<String, String> login(Context ctx, WSServiceInfo serviceInfo) throws BOSException {
        WSServiceInfo loginService = null;
        try {
            loginService = LoopWebserviceEntryUtil.getLoginService(ctx, serviceInfo);
        }
        catch (BOSException e) {
            logger.info((Object)"looking for loginServcie fail", (Throwable)e);
        }
        String loginURL = IERPUserHandler.getServiceURL(loginService);
        logger.error((Object)(new Date() + " --- IERPHttpServiceImpl.login request:" + loginURL));
        Object[] obj = LoopWebserviceEntryUtil.getHeadAndBody(loginService);
        Map headerMap = (Map)obj[0];
        String bodyStr = (String)obj[1];
        logger.error((Object)(new Date() + " --- IERPHttpServiceImpl.login request body:" + bodyStr));
        JsonNode resultObj = null;
        try {
            resultObj = (JsonNode)HttpServiceHelper.doPost(loginURL, (Map<String, String>)headerMap, bodyStr, JsonNode.class);
        }
        catch (BOSException e) {
            logger.error((Object)(loginURL + "login fail:"), (Throwable)e);
            throw new BOSException(loginURL + "login fail:", (Throwable)e);
        }
        if (resultObj == null || !"success".equalsIgnoreCase(resultObj.get("state").getTextValue())) {
            logger.error((Object)resultObj.get("errorMsg"));
            throw new BOSException("url " + loginURL + " login fail " + resultObj.get("errorMsg"));
        }
        tokenMap.put(this.getCacheTokenKey(ctx, serviceInfo), resultObj.findValue("access_token").getTextValue());
        logger.info((Object)(new Date() + " --- IERPHttpServiceImpl.login response: accessToken=" + resultObj.findValue("access_token").getTextValue()));
        return tokenMap;
    }

    public boolean isNotLogin(Object returnData) {
        return ((Map)returnData).get("error_code") != null && "1".equals(((Map)returnData).get("error_code").toString());
    }

    @Override
    public Object handleOriginal(Context ctx, Object data) throws Exception {
        return data;
    }

    private String getCacheTokenKey(Context ctx, WSServiceInfo serviceInfo) {
        WSServiceInfo loginService = null;
        try {
            loginService = LoopWebserviceEntryUtil.getLoginService(ctx, serviceInfo);
        }
        catch (BOSException e) {
            logger.info((Object)"looking for loginServcie fail", (Throwable)e);
        }
        String url = ServiceURLUtil.getHost(loginService);
        WSServiceEntryCollection coll = loginService.getEntrys();
        Iterator its = coll.iterator();
        WSServiceEntryInfo entryInfo = null;
        String tenantid = null;
        while (its.hasNext()) {
            entryInfo = (WSServiceEntryInfo)its.next();
            if (!"tenantid".equalsIgnoreCase(entryInfo.getNumber())) continue;
            tenantid = entryInfo.getDefaultValue();
            break;
        }
        return url + tenantid;
    }

    @Override
    public Object handleSend(Context ctx, WSBillMappingInfo wsb, WSServiceInfo serviceInfo, Object[] sendData) throws BOSException {
        Map resultMap;
        block6: {
            String postUrl = IERPUserHandler.getServiceURL(serviceInfo);
            String token = null;
            if (tokenMap != null && tokenMap.size() != 0 && !StringUtils.isEmpty((String)tokenMap.get(ServiceURLUtil.getHost(serviceInfo)))) {
                token = tokenMap.get(this.getCacheTokenKey(ctx, serviceInfo));
            } else {
                this.login(ctx, serviceInfo);
                token = tokenMap.get(this.getCacheTokenKey(ctx, serviceInfo));
            }
            LoopWebserviceEntryUtil.resetToken(serviceInfo, sendData, null, token);
            Map headerMap = (Map)sendData[0];
            String bodyStr = sendData[1].toString();
            resultMap = null;
            try {
                resultMap = (Map)HttpServiceHelper.doPost(postUrl, (Map<String, String>)headerMap, bodyStr, Map.class);
                boolean isNotLogin = this.isNotLogin(resultMap);
                if (!isNotLogin) break block6;
                String oldToken = token;
                try {
                    Thread.sleep(500L);
                    this.login(ctx, serviceInfo);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                LoopWebserviceEntryUtil.resetToken(serviceInfo, sendData, oldToken, token);
                headerMap = (Map)sendData[0];
                bodyStr = sendData[1].toString();
                resultMap = (Map)HttpServiceHelper.doPost(postUrl, (Map<String, String>)headerMap, bodyStr, Map.class);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw e;
            }
        }
        return resultMap;
    }

    @Override
    public List<ReturnModel> handleResult(Context ctx, WSBillMappingInfo wsb, Object data, String pkField) throws BOSException {
        WSCallRecordManager.enterReturnData(ResourceHolder.getContext(), JSONObject.toJSONString((Object)data));
        return null;
    }

    public static String sendDataforAdd2Update(Context ctx, List<String[]> dataList, String tableName, String mainPK, ColumnModel[] colNameRaw, Map<String, String> colType, String method, WSServiceInfo serviceInfo) throws BOSException {
        int i;
        String sendDataUrl = "";
        String returnValue = "";
        HashMap<String, String> headMap = new HashMap<String, String>();
        headMap.put("method", method);
        HashMap<String, Object> bodyMap = new HashMap<String, Object>();
        StringBuffer columnsBuff = new StringBuffer();
        ColumnModel model = null;
        if ("1".endsWith(method)) {
            for (i = 0; i < colNameRaw.length; ++i) {
                model = colNameRaw[i];
                if (mainPK.equalsIgnoreCase(model.name)) {
                    mainPK = model.destName;
                }
                columnsBuff.append(model.destName).append(",");
            }
        }
        if ("2".endsWith(method)) {
            for (i = 0; i < colNameRaw.length; ++i) {
                model = colNameRaw[i];
                if (mainPK.equalsIgnoreCase(model.name)) {
                    mainPK = model.destName;
                    continue;
                }
                columnsBuff.append(model.destName).append(",");
            }
        }
        columnsBuff.deleteCharAt(columnsBuff.length() - 1);
        bodyMap.put("tableName", tableName);
        bodyMap.put("columns", columnsBuff.toString());
        bodyMap.put("dataList", dataList);
        bodyMap.put("columnType", colType);
        bodyMap.put("mainpk", mainPK);
        ISCConnectModel ierpModel = new ISCConnectModel();
        ierpModel.setSolution("default_db_solution");
        ierpModel.setAction("db");
        ierpModel.setAccess(serviceInfo.getIdentification());
        JSONObject bodyObj = new JSONObject();
        bodyObj.put("method", (Object)method);
        bodyObj.put("data", bodyMap);
        bodyObj.put("src_system", (Object)serviceInfo.getSrcSystem());
        ierpModel.setData(bodyObj);
        String bodyStr = JSONObject.toJSONString((Object)ierpModel);
        String url = serviceInfo.getServiceURL();
        Map resultMap = null;
        try {
            resultMap = ISCAPIUtil.doPost(ctx, url, serviceInfo, null, bodyStr, true, Map.class, null);
        }
        catch (Throwable e) {
            logger.error((Object)ThrowableHelper.toString(e));
            logger.error((Object)("EIP\u63a8\u9001\u6570\u636e\u81f3\u82cd\u7a79\u5f02\u5e38\uff0c" + JSONObject.toJSONString((Object)resultMap) + "\u540c\u6b65\u6570\u636e\uff1a" + bodyStr));
            throw new BOSException(e);
        }
        if ("1".endsWith(method) || "2".endsWith(method)) {
            try {
                String data = resultMap.get("data").toString();
                JSONObject objData = JSONObject.parseObject((String)data);
                return objData.getString("message");
            }
            catch (Throwable e) {
                logger.error((Object)ThrowableHelper.toString(e));
                logger.error((Object)("EIP\u63a8\u9001\u6570\u636e\u81f3\u82cd\u7a79\u5f02\u5e38\uff0c" + JSONObject.toJSONString((Object)resultMap) + "\u540c\u6b65\u6570\u636e\uff1a" + bodyStr));
                throw new BOSException(e);
            }
        }
        return null;
    }

    public static List<ColumnInfo> getTableFields(Context ctx, WSServiceInfo serviceInfo, String tableName) throws BOSException {
        ArrayList<ColumnInfo> list = new ArrayList<ColumnInfo>();
        FieldDefineModel fieldModel = null;
        serviceInfo = IERPExecute.getWSServiceInfo(ctx, serviceInfo.getId().toString(), "");
        String url = serviceInfo.getServiceURL();
        ISCConnectModel model = new ISCConnectModel();
        model.setSolution("default_db_solution");
        model.setAction("db");
        model.setAccess(serviceInfo.getIdentification());
        JSONObject bodyObj = new JSONObject();
        bodyObj.put("method", (Object)"5");
        bodyObj.put("src_system", (Object)serviceInfo.getSrcSystem());
        JSONObject dataObj = new JSONObject();
        dataObj.put("tableName", (Object)tableName);
        bodyObj.put("data", (Object)dataObj);
        model.setData(bodyObj);
        String bodyStr = JSONObject.toJSONString((Object)model);
        Map resultMap = ISCAPIUtil.doPost(ctx, url, serviceInfo, null, bodyStr, true, Map.class, null);
        Boolean isSuccess = Boolean.valueOf(resultMap.get("success").toString());
        if (isSuccess.booleanValue()) {
            fieldModel = new FieldDefineModel();
            String obj = resultMap.get("data").toString();
            String cols = JSONObject.parseObject((String)obj).getString("message");
            JSONArray columnsArray = JSONObject.parseArray((String)cols);
            for (Object object : columnsArray) {
                JSONObject jsonObject = (JSONObject)object;
                ColumnInfo columnInfo = (ColumnInfo)JSONObject.parseObject((String)jsonObject.toJSONString(), ColumnInfo.class);
                list.add(columnInfo);
            }
        }
        return list;
    }
}

