/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.webservice.app.handler.user.ierp;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.csinterface.webservice.WSServiceInfo;
import com.kingdee.eas.csinterface.webservice.app.handler.user.ierp.UserProperType;
import com.kingdee.eas.csinterface.webservice.app.handler.user.ierp.ValidationUtils;
import com.kingdee.eas.csinterface.webservice.app.webapi.util.HttpServiceHelper;
import com.kingdee.eas.csinterface.webservice.framework.ServiceURLUtil;
import com.kingdee.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonNode;

public class IERPLoginUtil {
    private static Logger logger = Logger.getLogger(IERPLoginUtil.class);
    private static Map<String, String> tokenMap = new HashMap<String, String>();

    public static Map<String, String> login(Context ctx, WSServiceInfo serviceInfo) throws BOSException {
        String appId = serviceInfo.getAppid();
        if (StringUtils.isEmpty((String)appId)) {
            return IERPLoginUtil.oldLogin(ctx, serviceInfo);
        }
        return IERPLoginUtil.newLogin(ctx, serviceInfo);
    }

    private static Map<String, String> newLogin(Context ctx, WSServiceInfo serviceInfo) throws BOSException {
        String bodyStr = null;
        try {
            HashMap<String, String> bodyMap = new HashMap<String, String>();
            bodyMap.put("appId", serviceInfo.getAppid());
            bodyMap.put("appSecuret", serviceInfo.getAppSecuret());
            bodyMap.put("accountId", serviceInfo.getDataCenter());
            bodyMap.put("tenantid", serviceInfo.getTenantId());
            bodyStr = JSONObject.toJSONString(bodyMap);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        JSONObject resultObj = null;
        String appTokenURL = serviceInfo.getServiceURL() + "/api/getAppToken.do";
        try {
            resultObj = (JSONObject)HttpServiceHelper.doPost(appTokenURL, null, bodyStr, JSONObject.class);
        }
        catch (BOSException e) {
            throw new BOSException(appTokenURL + "login fail:", (Throwable)e);
        }
        String appToken = null;
        if (resultObj == null || !"success".equalsIgnoreCase(resultObj.getString("state"))) {
            logger.error(resultObj.get((Object)"errorMsg"));
            throw new BOSException("url " + appTokenURL + " login fail " + resultObj.get((Object)"errorMsg"));
        }
        JSONObject data = resultObj.getJSONObject("data");
        appToken = data.getString("app_token");
        String loginURL = serviceInfo.getServiceURL() + serviceInfo.getServiceMethod();
        try {
            HashMap<String, String> bodyMap = new HashMap<String, String>();
            String user = serviceInfo.getServiceUser();
            bodyMap.put("user", user);
            String userType = UserProperType.UserName.toString();
            if (ValidationUtils.isEmail(user)) {
                userType = UserProperType.Email.toString();
            } else if (ValidationUtils.isPhone(user)) {
                userType = UserProperType.Mobile.toString();
            }
            bodyMap.put("usertype", userType);
            bodyMap.put("accountId", serviceInfo.getDataCenter());
            bodyMap.put("tenantid", serviceInfo.getTenantId());
            bodyMap.put("apptoken", appToken);
            bodyStr = JSONObject.toJSONString(bodyMap);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        String accessToken = null;
        try {
            resultObj = (JSONObject)HttpServiceHelper.doPost(loginURL, null, bodyStr, JSONObject.class);
            if (resultObj == null || !"success".equalsIgnoreCase(resultObj.getString("state"))) {
                logger.error(resultObj.get((Object)"errorMsg"));
                throw new BOSException("url " + loginURL + " login fail " + resultObj.get((Object)"errorMsg"));
            }
            JSONObject data2 = resultObj.getJSONObject("data");
            accessToken = data2.getString("access_token");
            tokenMap.put(IERPLoginUtil.getCacheTokenKey(ctx, serviceInfo), accessToken);
        }
        catch (BOSException e) {
            throw new BOSException(loginURL + "login fail:", (Throwable)e);
        }
        return tokenMap;
    }

    private static Map<String, String> oldLogin(Context ctx, WSServiceInfo serviceInfo) throws BOSException {
        HashMap<String, String> headerMap;
        Object[] dataObj = new Object[2];
        try {
            headerMap = new HashMap<String, String>();
            headerMap.put("api", "true");
            headerMap.put("tenantAlias", serviceInfo.getTenantId());
            dataObj[0] = headerMap;
            HashMap<String, String> bodyMap = new HashMap<String, String>();
            bodyMap.put("user", serviceInfo.getServiceUser());
            bodyMap.put("accountId", serviceInfo.getDataCenter());
            bodyMap.put("tenantid", serviceInfo.getTenantId());
            bodyMap.put("password", serviceInfo.getPassword());
            bodyMap.put("logintype", "2");
            dataObj[1] = JSONObject.toJSONString(bodyMap);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        headerMap = (Map)dataObj[0];
        String bodyStr = (String)dataObj[1];
        logger.error((Object)(new Date() + " --- IERPHttpServiceImpl.login request body:" + bodyStr));
        JsonNode resultObj = null;
        String loginURL = serviceInfo.getServiceURL() + serviceInfo.getServiceMethod();
        try {
            resultObj = (JsonNode)HttpServiceHelper.doPost(loginURL, headerMap, bodyStr, JsonNode.class);
        }
        catch (BOSException e) {
            throw new BOSException(loginURL + "login fail:", (Throwable)e);
        }
        String accessToken = null;
        if (resultObj == null || !"success".equalsIgnoreCase(resultObj.get("state").getTextValue())) {
            logger.error((Object)resultObj.get("errorMsg"));
            throw new BOSException("url " + loginURL + " login fail " + resultObj.get("errorMsg"));
        }
        accessToken = resultObj.findValue("access_token").getTextValue();
        tokenMap.put(IERPLoginUtil.getCacheTokenKey(ctx, serviceInfo), accessToken);
        logger.info((Object)(new Date() + " --- IERPLoginUtil.login response: accessToken=" + accessToken));
        return tokenMap;
    }

    public static String getToken(Context ctx, WSServiceInfo serviceInfo) throws BOSException {
        String token = tokenMap.get(IERPLoginUtil.getCacheTokenKey(ctx, serviceInfo));
        if (token == null) {
            IERPLoginUtil.login(ctx, serviceInfo);
            token = IERPLoginUtil.getToken(ctx, serviceInfo);
        }
        return token;
    }

    public static boolean needRelogin(Context ctx, WSServiceInfo serviceInfo, Map resultMap) throws BOSException {
        boolean isNotLogin = IERPLoginUtil.isNotLogin(resultMap);
        if (isNotLogin) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            IERPLoginUtil.login(ctx, serviceInfo);
            return true;
        }
        return false;
    }

    public static boolean isNotLogin(Object returnData) {
        if (returnData == null) {
            return false;
        }
        Object errorCode = ((Map)returnData).get("error_code");
        return errorCode != null && "1".equals(errorCode.toString());
    }

    public static String getCacheTokenKey(Context ctx, WSServiceInfo serviceInfo) {
        return ServiceURLUtil.getHost(serviceInfo) + serviceInfo.getTenantId() + serviceInfo.getDataCenter();
    }

    public static Object testHTTP(Context ctx, WSServiceInfo serviceInfo) throws BOSException {
        String result = null;
        Map<String, String> MAP = IERPLoginUtil.login(ctx, serviceInfo);
        String token = MAP.get(IERPLoginUtil.getCacheTokenKey(ctx, serviceInfo));
        if (!StringUtils.isEmpty((String)token)) {
            result = "\u767b\u5f55\u6210\u529f.";
        }
        return result;
    }
}

