/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.webservice.app.httpClient;

import com.kingdee.eas.csinterface.webservice.app.webapi.util.SSLClient;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.BackoffManager;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ConnectionBackoffStrategy;
import org.apache.http.client.RequestDirector;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.BasicHttpProcessor;
import org.apache.http.protocol.DefaultedHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.ImmutableHttpProcessor;

public class EIPHttpClient
extends DefaultHttpClient {
    private ImmutableHttpProcessor protocolProcessor;

    public final HttpResponse execute_eip(HttpUriRequest request) throws IOException, ClientProtocolException {
        return this.execute(request, null);
    }

    public static HttpResponse execute_eip_ssl(String surl, Map map) throws Exception {
        CloseableHttpResponse response = null;
        DefaultHttpClient httpClient = null;
        HttpPost httpPost = null;
        httpClient = EIPHttpClient.createSingleHttpClient();
        httpPost = new HttpPost(surl);
        httpPost.addHeader("Connection", "close");
        ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
        for (Map.Entry elem : map.entrySet()) {
            list.add(new BasicNameValuePair((String)elem.getKey(), (String)elem.getValue()));
        }
        if (list.size() > 0) {
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(list, "utf-8");
            httpPost.setEntity((HttpEntity)entity);
        }
        response = httpClient.execute((HttpUriRequest)httpPost);
        return response;
    }

    private static DefaultHttpClient createSingleHttpClient() throws Exception {
        SSLClient client = new SSLClient();
        HostConfiguration config = new HostConfiguration();
        client.getParams().setParameter("http.connection.timeout", (Object)5000);
        client.getParams().setParameter("http.socket.timeout", (Object)60000);
        return client;
    }

    public final HttpResponse execute1(HttpUriRequest request, HttpContext context) throws IOException, ClientProtocolException {
        if (request == null) {
            throw new IllegalArgumentException("Request must not be null.");
        }
        return this.execute3(EIPHttpClient.determineTarget2(request), (HttpRequest)request, context);
    }

    private static HttpHost determineTarget2(HttpUriRequest request) throws ClientProtocolException {
        HttpHost target = null;
        URI requestURI = request.getURI();
        if (requestURI.isAbsolute() && (target = URIUtils.extractHost((URI)requestURI)) == null) {
            throw new ClientProtocolException("URI does not specify a valid host name: " + requestURI);
        }
        return target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final HttpResponse execute3(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
        if (request == null) {
            throw new IllegalArgumentException("Request must not be null.");
        }
        Object execContext = null;
        RequestDirector director = null;
        HttpRoutePlanner routePlanner = null;
        ConnectionBackoffStrategy connectionBackoffStrategy = null;
        BackoffManager backoffManager = null;
        EIPHttpClient eIPHttpClient = this;
        synchronized (eIPHttpClient) {
            HttpContext defaultContext = this.createHttpContext();
            execContext = context == null ? defaultContext : new DefaultedHttpContext(context, defaultContext);
            director = this.createClientRequestDirector(this.getRequestExecutor(), this.getConnectionManager(), this.getConnectionReuseStrategy(), this.getConnectionKeepAliveStrategy(), this.getRoutePlanner(), this.getProtocolProcessor(), this.getHttpRequestRetryHandler(), this.getRedirectStrategy(), this.getTargetAuthenticationStrategy(), this.getProxyAuthenticationStrategy(), this.getUserTokenHandler(), this.determineParams(request));
            routePlanner = this.getRoutePlanner();
            connectionBackoffStrategy = this.getConnectionBackoffStrategy();
            backoffManager = this.getBackoffManager();
        }
        try {
            if (connectionBackoffStrategy != null && backoffManager != null) {
                HttpResponse out;
                HttpHost targetForRoute = target != null ? target : (HttpHost)this.determineParams(request).getParameter("http.default-host");
                HttpRoute route = routePlanner.determineRoute(targetForRoute, request, execContext);
                try {
                    out = director.execute(target, request, execContext);
                }
                catch (RuntimeException re) {
                    if (connectionBackoffStrategy.shouldBackoff((Throwable)re)) {
                        backoffManager.backOff(route);
                    }
                    throw re;
                }
                catch (Exception e) {
                    if (connectionBackoffStrategy.shouldBackoff((Throwable)e)) {
                        backoffManager.backOff(route);
                    }
                    if (e instanceof HttpException) {
                        throw (HttpException)((Object)e);
                    }
                    if (e instanceof IOException) {
                        throw (IOException)e;
                    }
                    throw new UndeclaredThrowableException(e);
                }
                if (connectionBackoffStrategy.shouldBackoff(out)) {
                    backoffManager.backOff(route);
                } else {
                    backoffManager.probe(route);
                }
                return out;
            }
            return director.execute(target, request, execContext);
        }
        catch (HttpException httpException) {
            throw new ClientProtocolException((Throwable)httpException);
        }
    }

    private final synchronized HttpProcessor getProtocolProcessor() {
        if (this.protocolProcessor == null) {
            BasicHttpProcessor proc = this.getHttpProcessor();
            int reqc = proc.getRequestInterceptorCount();
            HttpRequestInterceptor[] reqinterceptors = new HttpRequestInterceptor[reqc];
            for (int i = 0; i < reqc; ++i) {
                reqinterceptors[i] = proc.getRequestInterceptor(i);
            }
            int resc = proc.getResponseInterceptorCount();
            HttpResponseInterceptor[] resinterceptors = new HttpResponseInterceptor[resc];
            for (int i = 0; i < resc; ++i) {
                resinterceptors[i] = proc.getResponseInterceptor(i);
            }
            this.protocolProcessor = new ImmutableHttpProcessor(reqinterceptors, resinterceptors);
        }
        return this.protocolProcessor;
    }
}

