/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.webservice.app.log;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.orm.impl.server.ORMRPConfig;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.eas.csinterface.util.ThrowableHelper;
import com.kingdee.eas.csinterface.webservice.IWSErrorParamLog;
import com.kingdee.eas.csinterface.webservice.WSErrorParamLogFactory;
import com.kingdee.eas.csinterface.webservice.WSErrorParamLogInfo;
import com.kingdee.util.StringUtils;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public class PerformanceLogManager {
    private static Logger logger = Logger.getLogger(PerformanceLogManager.class);
    public static final String checkConfig = "";
    public static final String sdsd = "'";
    public static final String LOOPBACK_IP = "127.0.0.1";
    private static String localIp;

    public static WSErrorParamLogInfo error(Context ctx, Throwable throwable, WSErrorParamLogInfo errorParamLogInfo, String config, Object data) {
        if (errorParamLogInfo == null) {
            logger.error((Object)"[EIP] not exist wsTransferLogInfo!");
            return null;
        }
        BOSUuid id = BOSUuid.create((BOSObjectType)errorParamLogInfo.getBOSType());
        errorParamLogInfo.setId(id);
        errorParamLogInfo.setIncomingData("config:" + config + "\ndata:" + data.toString());
        errorParamLogInfo.setRpcPort(PerformanceLogManager.getRpcPort());
        errorParamLogInfo.setSeverIP(PerformanceLogManager.getLocalIP());
        errorParamLogInfo.setClientIP(ORMRPConfig.getRpcClientIP() == LOOPBACK_IP ? checkConfig : ORMRPConfig.getRpcClientIP().substring(1));
        String message = null;
        Throwable cause = throwable;
        while (StringUtils.isEmpty((String)(message = cause.getMessage())) && (cause = cause.getCause()) != null) {
        }
        errorParamLogInfo.setErrorMsg(message);
        errorParamLogInfo.setStaceTrace(ThrowableHelper.toString(throwable));
        return errorParamLogInfo;
    }

    public static WSErrorParamLogInfo error(Context ctx, String message, WSErrorParamLogInfo errorParamLogInfo) {
        if (errorParamLogInfo == null) {
            logger.error((Object)"[EIP] not exist errorParamLogInfo!");
            return null;
        }
        errorParamLogInfo.setErrorMsg(message);
        return errorParamLogInfo;
    }

    private static void saveErrorParamLog(Context ctx, WSErrorParamLogInfo errorParamLogInfo) throws Exception {
        IObjectPK pk;
        IWSErrorParamLog instance = WSErrorParamLogFactory.getLocalInstance(ctx);
        if (instance.exists(pk = CommonUtil.convert2PK(errorParamLogInfo.getId().toString()))) {
            instance.updateLog(errorParamLogInfo);
        } else {
            instance.log(errorParamLogInfo);
        }
    }

    public static void exit(Context ctx, WSErrorParamLogInfo errorParamLogInfo) {
        try {
            PerformanceLogManager.saveErrorParamLog(ctx, errorParamLogInfo);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    static final String getRpcPort() {
        return String.valueOf(ORMRPConfig.getTcpConnectionPort());
    }

    static final String getLocalIP() {
        if (localIp != null) {
            return localIp;
        }
        try {
            String ip = InetAddress.getLocalHost().getHostAddress();
            if (!LOOPBACK_IP.equals(ip)) {
                localIp = ip;
                return localIp;
            }
            ArrayList<String> localIPs = new ArrayList<String>();
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface n = e.nextElement();
                Enumeration<InetAddress> ee = n.getInetAddresses();
                while (ee.hasMoreElements()) {
                    InetAddress i = ee.nextElement();
                    if (LOOPBACK_IP.equals(i.getHostAddress())) continue;
                    localIPs.add(i.getHostAddress());
                }
            }
            if (localIPs.size() > 0) {
                Collections.sort(localIPs);
                localIp = (String)localIPs.get(0);
                return localIp;
            }
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
        localIp = LOOPBACK_IP;
        return localIp;
    }
}

