/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.webservice.app.log;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.orm.impl.server.ORMRPConfig;
import com.kingdee.bos.service.job.core.Configuration;
import com.kingdee.bos.sql.util.StringUtil;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.csinterface.app.DynamicBillBatchInsertHelper;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.eas.csinterface.util.ThrowableHelper;
import com.kingdee.eas.csinterface.webservice.IWSCallRecord;
import com.kingdee.eas.csinterface.webservice.IWSTransferLog;
import com.kingdee.eas.csinterface.webservice.Launch;
import com.kingdee.eas.csinterface.webservice.LogStatus;
import com.kingdee.eas.csinterface.webservice.ServiceStyle;
import com.kingdee.eas.csinterface.webservice.ServiceType;
import com.kingdee.eas.csinterface.webservice.SynchModel;
import com.kingdee.eas.csinterface.webservice.WSCallRecordFactory;
import com.kingdee.eas.csinterface.webservice.WSCallRecordInfo;
import com.kingdee.eas.csinterface.webservice.WSIdentificationCodeInfo;
import com.kingdee.eas.csinterface.webservice.WSInterfaceInfo;
import com.kingdee.eas.csinterface.webservice.WSTransferLogFactory;
import com.kingdee.eas.csinterface.webservice.WSTransferLogInfo;
import com.kingdee.eas.csinterface.webservice.app.util.ResourceHolder;
import com.kingdee.eas.csinterface.webservice.app.util.ReturnDataService;
import com.kingdee.eas.csinterface.webservice.framework.Return;
import com.kingdee.eas.csinterface.webservice.framework.exception.EIPBaseException;
import com.kingdee.eas.csinterface.webservice.framework.exception.ExceptionUtil;
import com.kingdee.util.StringUtils;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class WSCallRecordManager {
    private static Logger logger = Logger.getLogger(WSCallRecordManager.class);
    static final ThreadLocal<WSTransferLogInfo> threadTransferIds = new ThreadLocal();
    static final ThreadLocal<String> threadOperatorSources = new ThreadLocal();
    public static final String LOOPBACK_IP = "127.0.0.1";
    private static String localIp;

    public static void setOperatorSource(String operatorSource) {
        threadOperatorSources.set(operatorSource);
    }

    public static String getOperatorSource() {
        return threadOperatorSources.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enter(Context ctx, WSInterfaceInfo wsi, WSIdentificationCodeInfo identificationCode, Launch LaunchEum, Object incomingData, String config, String SyncType, String servicetype) {
        String identificationCodeNum = identificationCode.getNumber();
        String interfaceId = wsi.getId() == null ? "" : wsi.getId().toString();
        Boolean isExistWSCallLog = null;
        WSCallRecordInfo wsCallRecordInfo = null;
        WSTransferLogInfo wsTransferLogInfo = new WSTransferLogInfo();
        BOSUuid id = BOSUuid.create((BOSObjectType)wsTransferLogInfo.getBOSType());
        wsTransferLogInfo.setId(id);
        wsTransferLogInfo.setStatus(LogStatus.Runing);
        try {
            String string = interfaceId;
            synchronized (string) {
                isExistWSCallLog = WSCallRecordFactory.getLocalInstance(ctx).exists("where indenfiticationcode.number ='" + identificationCodeNum + "'and InterfaceID.id='" + interfaceId + "'");
                if (isExistWSCallLog.booleanValue()) {
                    wsCallRecordInfo = WSCallRecordFactory.getLocalInstance(ctx).getWSCallRecordInfo("where indenfiticationcode.number ='" + identificationCodeNum + "'and InterfaceID.id='" + interfaceId + "'");
                    int count = wsCallRecordInfo.getCount();
                    wsCallRecordInfo.setCount(++count);
                } else {
                    wsCallRecordInfo = new WSCallRecordInfo();
                    wsCallRecordInfo.setId(BOSUuid.create((BOSObjectType)wsCallRecordInfo.getBOSType()));
                    wsCallRecordInfo.setIndenfiticationCode(identificationCode);
                    wsCallRecordInfo.setLaunch(LaunchEum);
                    wsCallRecordInfo.setSyncType("1".equals(SyncType) ? SynchModel.synch : SynchModel.asynch);
                    wsCallRecordInfo.setInterfaceID(wsi);
                    wsCallRecordInfo.setWSBIllID(wsi.getWsbillMapping());
                    wsCallRecordInfo.setServiceID(wsi.getWebservice());
                    if (ServiceType.query.toString().equals(servicetype.toString())) {
                        wsCallRecordInfo.setServiceType(ServiceStyle.query);
                    } else {
                        wsCallRecordInfo.setServiceType(ServiceStyle.push);
                    }
                    wsCallRecordInfo.setCount(1);
                }
                WSCallRecordManager.saveCallRecord(ctx, wsCallRecordInfo);
            }
            wsTransferLogInfo.setCallRecordID(wsCallRecordInfo);
            JSONObject dataJSON = new JSONObject();
            dataJSON.put("class", (Object)incomingData.getClass().getCanonicalName());
            dataJSON.put("data", (Object)incomingData.toString());
            wsTransferLogInfo.setIncomingData(JSONObject.toJSONString((Object)dataJSON));
            wsTransferLogInfo.setRpcPort(WSCallRecordManager.getRpcPort());
            wsTransferLogInfo.setSeverIP(Configuration.instanceId());
            String clientIP = ORMRPConfig.getRpcClientIP();
            wsTransferLogInfo.setClientIP(clientIP == null ? LOOPBACK_IP : clientIP.substring(1));
            WSCallRecordManager.saveTransferLog(ctx, wsTransferLogInfo);
            WSCallRecordManager.setThreadTransferIds(wsTransferLogInfo);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    public static void setThreadTransferIds(WSTransferLogInfo wsTransferLogInfo) {
        threadTransferIds.set(wsTransferLogInfo);
    }

    public static void enterHeadAndEntryDataSize(int headSize, int entrySize) {
        WSTransferLogInfo wsTransferLogInfo = WSCallRecordManager.getCurrent();
        wsTransferLogInfo.setHeadDataSize(headSize);
        wsTransferLogInfo.setEntryDataSize(entrySize);
    }

    public static void enterImplClassAndMethod(Context ctx, String classFullName, String method) {
        WSTransferLogInfo wsTransferLogInfo = WSCallRecordManager.getCurrent();
        wsTransferLogInfo.setMethod(classFullName + "." + method);
    }

    public static void enterReturnData(Context ctx, String returnData) {
        WSTransferLogInfo wsTransferLogInfo = WSCallRecordManager.getCurrent();
        if (wsTransferLogInfo != null) {
            wsTransferLogInfo.setReturnData(returnData);
        }
    }

    public static void enterOutgoingData(Context ctx, String outgoingData) {
        WSTransferLogInfo wsTransferLogInfo = WSCallRecordManager.getCurrent();
        String oldValue = wsTransferLogInfo.getOutgoingData();
        if (!ResourceHolder.getIsBatch()) {
            wsTransferLogInfo.setOutgoingData(outgoingData);
        } else {
            oldValue = oldValue == null ? "" : oldValue;
            wsTransferLogInfo.setOutgoingData(oldValue + outgoingData);
        }
    }

    public static void enterFetchTime(long beginTime, long endTime) {
        WSTransferLogInfo wsTransferLogInfo = WSCallRecordManager.getCurrent();
        long duration = endTime - beginTime;
        String fetchTime = WSCallRecordManager.getDurationDesc(duration);
        wsTransferLogInfo.setFetchTime(fetchTime);
    }

    public static void enterProcessingTime(long beginTime, long endTime) {
        WSTransferLogInfo wsTransferLogInfo = WSCallRecordManager.getCurrent();
        long duration = endTime - beginTime;
        String processingTime = WSCallRecordManager.getDurationDesc(duration);
        wsTransferLogInfo.setProcessingTime(processingTime);
    }

    public static void enterFeedbackTime(long beginTime, long endTime) {
        WSTransferLogInfo wsTransferLogInfo = WSCallRecordManager.getCurrent();
        long duration = endTime - beginTime;
        String processingTime = WSCallRecordManager.getDurationDesc(duration);
        wsTransferLogInfo.setFeedbackTime(processingTime);
    }

    public static void enterCountTime(long beginTime, long endTime) {
        WSTransferLogInfo wsTransferLogInfo = WSCallRecordManager.getCurrent();
        long duration = endTime - beginTime;
        String processingTime = WSCallRecordManager.getDurationDesc(duration);
        wsTransferLogInfo.setCountTime(processingTime);
    }

    private static void saveTransferLog(Context ctx, WSTransferLogInfo wsTransferLogInfo) throws Exception {
        IObjectPK pk;
        IWSTransferLog instance = WSTransferLogFactory.getLocalInstance(ctx);
        if (instance.exists(pk = CommonUtil.convert2PK(wsTransferLogInfo.getId().toString()))) {
            instance.updateLog(wsTransferLogInfo);
        } else {
            instance.log(wsTransferLogInfo);
        }
    }

    private static void saveCallRecord(Context ctx, WSCallRecordInfo wsCallRecordInfo) throws Exception {
        IObjectPK pk;
        IWSCallRecord instance = WSCallRecordFactory.getLocalInstance(ctx);
        if (instance.exists(pk = CommonUtil.convert2PK(wsCallRecordInfo.getId().toString()))) {
            instance.updateLog(wsCallRecordInfo);
        } else {
            instance.log(wsCallRecordInfo);
        }
    }

    public static WSTransferLogInfo getCurrent() {
        return threadTransferIds.get();
    }

    public static void error(Context ctx, String message) {
        WSTransferLogInfo wsTransferLogInfo = threadTransferIds.get();
        if (wsTransferLogInfo == null) {
            logger.error((Object)"[EIP] not exist wsTransferLogInfo in current thread!");
            return;
        }
        wsTransferLogInfo.setStatus(LogStatus.fail);
        wsTransferLogInfo.setErrorMsg(message);
    }

    public static void error(Context ctx, Throwable throwable) {
        WSTransferLogInfo wsTransferLogInfo = threadTransferIds.get();
        if (wsTransferLogInfo == null) {
            logger.error((Object)"[EIP] not exist wsTransferLogInfo in current thread!");
            return;
        }
        String message = null;
        Throwable cause = throwable;
        while (StringUtils.isEmpty((String)(message = cause.getMessage())) && (cause = cause.getCause()) != null) {
        }
        wsTransferLogInfo.setStatus(LogStatus.fail);
        wsTransferLogInfo.setErrorMsg(message);
        wsTransferLogInfo.setStaceTrace(ThrowableHelper.toString(throwable));
    }

    public static String error(Context ctx, Exception e) {
        WSCallRecordManager.error(ctx, (Throwable)e);
        String resultData = null;
        if (e.getCause() instanceof EIPBaseException) {
            resultData = ReturnDataService.format(Return.valueOf(((EIPBaseException)e.getCause()).getCode(), ((EIPBaseException)e.getCause()).getMessage(), null));
            return resultData;
        }
        resultData = ReturnDataService.format(Return.valueOf(-1, ExceptionUtil.generatekernelMessage(e), null));
        return resultData;
    }

    public static void exit() {
        WSCallRecordManager.exit(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exit(String outgoingData) {
        Context ctx = ResourceHolder.getContext();
        WSTransferLogInfo wsTransferLogInfo = threadTransferIds.get();
        if (wsTransferLogInfo == null) {
            logger.error((Object)"[EIP] not exist wsTransferLogInfo in current thread!");
            return;
        }
        if (StringUtil.isEmpty((String)wsTransferLogInfo.getErrorMsg()) && StringUtil.isEmpty((String)wsTransferLogInfo.getStaceTrace())) {
            if (SynchModel.asynch.equals((Object)ResourceHolder.getSynchModel())) {
                wsTransferLogInfo.setStatus(LogStatus.waiting);
            } else {
                wsTransferLogInfo.setStatus(LogStatus.success);
            }
        }
        try {
            WSCallRecordManager.enterCountTime(wsTransferLogInfo.getCreateTime().getTime(), System.currentTimeMillis());
            if (!StringUtils.isEmpty((String)outgoingData)) {
                WSCallRecordManager.enterOutgoingData(ctx, outgoingData);
            }
            WSCallRecordManager.saveTransferLog(ctx, wsTransferLogInfo);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            threadTransferIds.remove();
            ResourceHolder.reset();
            DynamicBillBatchInsertHelper.close();
        }
    }

    public static void recordSendData(Map<String, String> headerMap, String bodyJson, String responseEntity) {
        try {
            WSCallRecordManager.enterReturnData(ResourceHolder.getContext(), responseEntity);
        }
        catch (Exception e) {
            logger.error((Object)"recording returnData error!", (Throwable)e);
        }
    }

    public static List<String> getReceiver() {
        ArrayList<String> receiverList = new ArrayList<String>();
        if (receiverList.size() == 0) {
            receiverList.add("256c221a-0106-1000-e000-10d7c0a813f413B7DE7F");
        }
        return receiverList;
    }

    static final String getRpcPort() {
        return String.valueOf(ORMRPConfig.getTcpConnectionPort());
    }

    static final String getLocalIP() {
        if (localIp != null) {
            return localIp;
        }
        try {
            String ip = InetAddress.getLocalHost().getHostAddress();
            if (!LOOPBACK_IP.equals(ip)) {
                localIp = ip;
                return localIp;
            }
            ArrayList<String> localIPs = new ArrayList<String>();
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface n = e.nextElement();
                Enumeration<InetAddress> ee = n.getInetAddresses();
                while (ee.hasMoreElements()) {
                    InetAddress i = ee.nextElement();
                    if (LOOPBACK_IP.equals(i.getHostAddress())) continue;
                    localIPs.add(i.getHostAddress());
                }
            }
            if (localIPs.size() > 0) {
                Collections.sort(localIPs);
                localIp = (String)localIPs.get(0);
                return localIp;
            }
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
        localIp = LOOPBACK_IP;
        return localIp;
    }

    public static String getDurationDesc(long t) {
        long hour = t / 3600000L;
        long left = t % 3600000L;
        long minus = left / 60000L;
        long second = (left %= 60000L) / 1000L;
        return hour + "\u65f6" + minus + "\u5206" + second + "\u79d2" + (left %= 1000L) + "\u6beb\u79d2";
    }
}

