/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.webservice.app.model;

import com.kingdee.eas.csinterface.common.DIPException;
import com.kingdee.eas.csinterface.webservice.ServiceType;
import com.kingdee.eas.csinterface.webservice.app.model.WSColumnModel;
import com.kingdee.eas.csinterface.webservice.app.model.WSTableModel;
import com.kingdee.eas.csinterface.webservice.app.util.ResourceHolder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class WSStructuredDataModel
implements Serializable {
    private static final long serialVersionUID = 2357973549216849724L;
    private boolean isCompleted;
    private WSTableModel[] tables;
    private WSTableModel hostTable;
    private WSTableModel[] priorityTables;
    private List priorityTablesRelation;
    public static final int DATASOURCE_DB = 1;
    public static final int DATASOURCE_FILE = 2;
    private int datasourceType;
    private String modelName;
    private String modelAlias;
    private Map modelProperties;
    private String pkField;

    public WSStructuredDataModel(String modelName, String modelAlias, Map modelProperties, String pkField) {
        this.pkField = pkField;
        this.modelName = modelName;
        this.modelAlias = modelAlias;
        this.modelProperties = modelProperties == null ? new HashMap() : modelProperties;
    }

    public WSStructuredDataModel(String modelName, String modelAlias, WSTableModel[] tables, String pkField) {
        this(modelName, modelAlias, new HashMap(), pkField);
        this.tables = tables;
    }

    public WSStructuredDataModel(String modelName, String modelAlias, Map modelProperties, WSTableModel[] tables, String pkField) {
        this(modelName, modelAlias, modelProperties, pkField);
        this.tables = tables;
    }

    public String getModelName() {
        return this.modelName;
    }

    public String getModelAlias() {
        return this.modelAlias;
    }

    public int getDatasourceType() {
        return this.datasourceType;
    }

    public Object getProperty(String name) {
        return this.modelProperties.get(name);
    }

    public void setProperty(String name, Object value) {
        this.modelProperties.put(name, value);
    }

    public String getPkField() {
        return this.pkField;
    }

    public void setPkField(String pkField) {
        this.pkField = pkField;
    }

    public synchronized void addTable(WSTableModel table) throws DIPException {
        this.checkReady();
        if (this.tables == null) {
            this.tables = new WSTableModel[1];
        } else {
            WSTableModel[] _tables = new WSTableModel[this.tables.length + 1];
            System.arraycopy(this.tables, 0, _tables, 0, this.tables.length);
            this.tables = _tables;
        }
        this.tables[this.tables.length - 1] = table;
    }

    public synchronized void addTableRelation(WSTableModel table1, WSTableModel table2, int relation) throws DIPException {
        this.checkReady();
        table1.addRelation(table2, relation);
        switch (relation) {
            case 2: {
                table2.addRelation(table1, 1);
                break;
            }
            case 1: {
                table2.addRelation(table1, 2);
                break;
            }
        }
    }

    private void checkReady() throws DIPException {
        if (this.isCompleted) {
            throw new DIPException("forbidden modify the completed DataModel");
        }
    }

    public synchronized boolean isCompleted() {
        return this.isCompleted;
    }

    public WSTableModel[] getPriorityTables() {
        return this.priorityTables;
    }

    public List getPriorityTablesRelation() {
        return this.priorityTablesRelation;
    }

    public synchronized void setCompleted() throws DIPException {
        if (this.tables == null || this.tables.length == 0) {
            throw new DIPException("\u6570\u636e\u6a21\u578b\u4e0d\u5b58\u5728\u8868\u6a21\u578b");
        }
        this.checkReady();
        HashSet<WSTableModel> existTables = new HashSet<WSTableModel>();
        for (int i = 0; i < this.tables.length; ++i) {
            if (existTables.contains(this.tables[i])) {
                throw new DIPException("\u6a21\u578b\u4e2d\u5b58\u5728\u76f8\u540c\u7684\u8868\u540d'" + this.tables[i].name + "'");
            }
            existTables.add(this.tables[i]);
            this.checkWSTableModel(this.tables[i]);
            Map relations = this.tables[i].getTableRelations();
            if (relations == null || relations.size() == 0) {
                this.hostTable = this.tables[i];
                continue;
            }
            if (this.hostTable != null) continue;
            Set keySet = relations.keySet();
            boolean hasManyToOne = false;
            for (WSTableModel WSTableModel2 : keySet) {
                int relation = (Integer)relations.get(WSTableModel2);
                if (2 != relation) continue;
                hasManyToOne = true;
                break;
            }
            if (hasManyToOne) continue;
            this.hostTable = this.tables[i];
        }
        if (this.hostTable == null) {
            throw new DIPException("\u6570\u636e\u6e90\u6620\u5c04\u5173\u7cfb\u4e0d\u6b63\u786e!");
        }
        ArrayList traversalPath = new ArrayList(this.tables.length);
        ArrayList priorityPath = new ArrayList(this.tables.length);
        this.processTableRelation(this.hostTable, traversalPath, priorityPath);
        if (priorityPath.size() != this.tables.length) {
            throw new DIPException("\u6570\u636e\u6e90\u6570\u636e\u8868\u5173\u8054\u5173\u7cfb\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u6e90\u6620\u5c04\u5173\u7cfb!");
        }
        this.priorityTables = priorityPath.toArray(new WSTableModel[0]);
        this.priorityTablesRelation = this.prepareTableRelation(this.priorityTables);
        this.isCompleted = true;
    }

    private List prepareTableRelation(WSTableModel[] WSTableModels) {
        ArrayList<int[]> priorityTablesRelation = new ArrayList<int[]>();
        for (int i = 0; i < WSTableModels.length; ++i) {
            Map relations = WSTableModels[i].getTableRelations();
            if (relations == null) {
                return priorityTablesRelation;
            }
            Set entrySet = relations.entrySet();
            block1: for (Map.Entry entry : entrySet) {
                WSTableModel WSTableModel2 = (WSTableModel)entry.getKey();
                int relation = (Integer)entry.getValue();
                if (relation != 1) continue;
                for (int j = 0; j < WSTableModels.length; ++j) {
                    if (!WSTableModels[j].name.equals(WSTableModel2.name)) continue;
                    int[] tablesRelation = new int[]{i, j, relation};
                    priorityTablesRelation.add(tablesRelation);
                    continue block1;
                }
            }
        }
        return priorityTablesRelation;
    }

    private void checkWSTableModel(WSTableModel WSTableModel2) throws DIPException {
        ServiceType serviceType = ResourceHolder.getWSInterfaceInfo().getServiceType();
        if (!ServiceType.addNew.equals((Object)serviceType)) {
            return;
        }
        WSColumnModel[] columns = WSTableModel2.columns;
        for (int i = 0; i < columns.length; ++i) {
            if (!columns[i].isPk) continue;
            return;
        }
        throw new DIPException("\u8868\u6a21\u578b" + WSTableModel2.name + "\u7f3a\u5c11\u4e3b\u952e");
    }

    private void processTableRelation(WSTableModel WSTableModel2, List traversalPath, List priorityPath) {
        Map tRelations;
        if (traversalPath.size() == 0) {
            traversalPath.add(WSTableModel2);
            priorityPath.add(WSTableModel2);
        }
        if ((tRelations = WSTableModel2.getTableRelations()) == null || tRelations.size() == 0) {
            return;
        }
        Set tEntrySet = tRelations.entrySet();
        for (Map.Entry tEntry : tEntrySet) {
            WSTableModel tWSTableModel = (WSTableModel)tEntry.getKey();
            if (traversalPath.contains(tWSTableModel)) continue;
            Map relations = tWSTableModel.getTableRelations();
            Set pEntrySet = relations.entrySet();
            for (Map.Entry entry : pEntrySet) {
                WSTableModel pWSTableModel = (WSTableModel)entry.getKey();
                int pRelation = (Integer)entry.getValue();
                if (pRelation != 2) continue;
                int index = priorityPath.indexOf(tWSTableModel);
                if (index != -1) {
                    if (priorityPath.contains(pWSTableModel)) continue;
                    priorityPath.add(index, pWSTableModel);
                    continue;
                }
                if (priorityPath.contains(pWSTableModel)) continue;
                priorityPath.add(pWSTableModel);
            }
            if (!priorityPath.contains(tWSTableModel)) {
                priorityPath.add(tWSTableModel);
            }
            traversalPath.add(tWSTableModel);
            if (tWSTableModel.getTableRelations() == null) continue;
            this.processTableRelation(tWSTableModel, traversalPath, priorityPath);
        }
    }

    public String toString() {
        return this.modelName + "(" + this.modelAlias + ")";
    }

    public int hashCode() {
        return this.modelName.hashCode();
    }
}

