/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.webservice.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.csinterface.bizbill.metadata.info.DIPMetadata;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.DBUtils;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.UictUtils;
import com.kingdee.eas.csinterface.webservice.model.WSDynamicBillTemplateExInfo;
import com.kingdee.eas.csinterface.webservice.model.WSDynamicBillTemplateInfo;
import com.kingdee.eas.framework.AbstractCoreBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class WSDynamicBillBatchInsertHelper {
    private static ThreadLocal<WSDynamicBillBatchInsertHelper> threadInsertHelpers = new ThreadLocal();
    private List<String> headColumns;
    private List<String> entryColumns;
    private String insertHeaderSql;
    private String insertEntrySql;
    private BOSObjectType headerBOSType;
    private BOSObjectType entryBOSType;
    private String userInfoId;
    private Timestamp currentTime;
    private String controlUnitID;
    private static final String headReservedFields = "FID, FControlUnitID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime";
    private static final int headReservedFieldsLen = 6;
    private static final String entryReservedFields = "FID, FSeq";
    private static final int entryReservedFieldsLen = 2;
    private String transmitSerialNumber;
    private int transmitChunkedNumber;
    private static final String insertChunkedTransmit = "insert into T_EIP_ChunkedTransmit(FTransmitSerialNumber, FTransmitChunkedNumber, FUserID, FCreateTime, FLastUpdateTime) values(?,?,?,?,?)";
    private static final String undateChunkedTransmit = "update T_EIP_ChunkedTransmit set FTransmitChunkedNumber=?, FLastUpdateTime=? where FTransmitSerialNumber=?";

    private WSDynamicBillBatchInsertHelper() {
    }

    public String getInsertEntrySql() {
        return this.insertEntrySql;
    }

    public String getInsertHeaderSql() {
        return this.insertHeaderSql;
    }

    public BOSObjectType getHeaderBOSType() {
        return this.headerBOSType;
    }

    public BOSObjectType getEntryBOSType() {
        return this.entryBOSType;
    }

    private void prepareHeadCommonParam(PreparedStatement preparedStratement, IObjectValue model) throws BOSException, SQLException {
        BOSUuid headerId = BOSUuid.create((BOSObjectType)this.getHeaderBOSType());
        ((WSDynamicBillTemplateInfo)model).setId(headerId);
        preparedStratement.setString(1, headerId.toString());
        preparedStratement.setString(2, this.controlUnitID);
        preparedStratement.setString(3, this.userInfoId);
        preparedStratement.setTimestamp(4, this.currentTime);
        preparedStratement.setString(5, this.userInfoId);
        preparedStratement.setTimestamp(6, this.currentTime);
    }

    public void setHeaderParameters(PreparedStatement preparedStratement, WSDynamicBillTemplateInfo templateInfo) throws SQLException, BOSException {
        this.prepareHeadCommonParam(preparedStratement, (IObjectValue)templateInfo);
        int i = 0;
        int j = 7;
        while (i < this.headColumns.size()) {
            Object obj = templateInfo.get(this.headColumns.get(i));
            if (obj instanceof AbstractCoreBaseInfo) {
                preparedStratement.setObject(j, ((AbstractCoreBaseInfo)obj).getId().toString());
            } else {
                preparedStratement.setObject(j, obj);
            }
            ++i;
            ++j;
        }
    }

    public void setEntryParameters(PreparedStatement preparedStratement, WSDynamicBillTemplateExInfo templateInfo, int index) throws SQLException {
        preparedStratement.setString(1, BOSUuid.create((BOSObjectType)this.getEntryBOSType()).toString());
        preparedStratement.setInt(2, index);
        int i = 0;
        int j = 3;
        while (i < this.entryColumns.size()) {
            String columnName = this.entryColumns.get(i);
            if ("parent".equals(columnName)) {
                WSDynamicBillTemplateInfo parent = (WSDynamicBillTemplateInfo)templateInfo.get(this.entryColumns.get(i));
                preparedStratement.setObject(j, parent.getId().toString());
            } else {
                Object obj = templateInfo.get(this.entryColumns.get(i));
                if (obj instanceof AbstractCoreBaseInfo) {
                    preparedStratement.setObject(j, ((AbstractCoreBaseInfo)obj).getId().toString());
                } else {
                    preparedStratement.setObject(j, obj);
                }
            }
            ++i;
            ++j;
        }
    }

    public static final WSDynamicBillBatchInsertHelper getInstance() {
        return threadInsertHelpers.get();
    }

    private static UserInfo getUserInfo(Context ctx) throws BOSException {
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        return userInfo;
    }

    private static Timestamp getTime() {
        java.util.Date date = new java.util.Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }

    public static void setCurrentTransmitChunkedNumber(int transmitChunkedNumber) {
        WSDynamicBillBatchInsertHelper.threadInsertHelpers.get().transmitChunkedNumber = transmitChunkedNumber;
    }

    private static CtrlUnitInfo getCU(Context ctx, ObjectBaseInfo model) {
        CtrlUnitInfo cu = null;
        if (model != null && model.getCU() != null) {
            return model.getCU();
        }
        cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        return cu;
    }

    public void updateTransmitChunked(Connection con) throws SQLException {
        if (!StringUtils.isEmpty((String)this.transmitSerialNumber)) {
            PreparedStatement undateChunkedTransmitStatement = con.prepareStatement(undateChunkedTransmit);
            try {
                undateChunkedTransmitStatement.setInt(1, this.transmitChunkedNumber);
                undateChunkedTransmitStatement.setDate(2, new Date(System.currentTimeMillis()));
                undateChunkedTransmitStatement.setString(3, this.transmitSerialNumber);
                undateChunkedTransmitStatement.executeUpdate();
            }
            finally {
                SQLUtils.cleanup((Statement)undateChunkedTransmitStatement);
            }
        }
    }

    public static final void prepare(Context ctx, String number, String transmitSerialNumber) throws BOSException {
        if (!StringUtils.isEmpty((String)transmitSerialNumber)) {
            Connection con = DBUtils.getConnection(ctx);
            try {
                Date now = new Date(System.currentTimeMillis());
                PreparedStatement insertStatement = con.prepareStatement(insertChunkedTransmit);
                insertStatement.setString(1, transmitSerialNumber);
                insertStatement.setInt(2, 0);
                insertStatement.setString(3, ctx.get((Object)"agentId").toString());
                insertStatement.setDate(4, now);
                insertStatement.setDate(5, now);
                insertStatement.executeUpdate();
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                SQLUtils.cleanup((Connection)con);
            }
        }
        WSDynamicBillBatchInsertHelper insertHelper = new WSDynamicBillBatchInsertHelper();
        DIPMetadata dm = new DIPMetadata(number);
        EntityObjectInfo entityInfo = UictUtils.loadEntity((IMetaDataPK)new MetaDataPK(dm.getHeaderEntityPK()));
        EntityObjectInfo entrysEntityInfo = UictUtils.loadEntity((IMetaDataPK)new MetaDataPK(dm.getEntryEntityPK()));
        if (entityInfo.getProperties() == null) {
            MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).clearAll();
            entityInfo = UictUtils.loadEntity((IMetaDataPK)new MetaDataPK(dm.getHeaderEntityPK()));
            entrysEntityInfo = UictUtils.loadEntity((IMetaDataPK)new MetaDataPK(dm.getEntryEntityPK()));
        }
        insertHelper.currentTime = WSDynamicBillBatchInsertHelper.getTime();
        insertHelper.userInfoId = ctx.get((Object)"agentId").toString();
        insertHelper.controlUnitID = WSDynamicBillBatchInsertHelper.getCU(ctx, null).getId().toString();
        insertHelper.headerBOSType = entityInfo.getType();
        insertHelper.entryBOSType = entrysEntityInfo.getType();
        insertHelper.headColumns = new ArrayList<String>(entityInfo.getProperties().size());
        insertHelper.entryColumns = new ArrayList<String>(entrysEntityInfo.getProperties().size());
        insertHelper.insertHeaderSql = WSDynamicBillBatchInsertHelper.generateInsertSql(insertHelper.headColumns, entityInfo, true);
        insertHelper.insertEntrySql = WSDynamicBillBatchInsertHelper.generateInsertSql(insertHelper.entryColumns, entrysEntityInfo, false);
        insertHelper.transmitSerialNumber = transmitSerialNumber;
        threadInsertHelpers.set(insertHelper);
    }

    private static String generateInsertSql(List<String> columns, EntityObjectInfo objectInfo, boolean isHeader) {
        int i;
        PropertyCollection propertiesColl = objectInfo.getProperties();
        StringBuilder sqlBuffer = new StringBuilder();
        StringBuilder paramBuffer = new StringBuilder();
        sqlBuffer.append("insert into ").append(objectInfo.getTable().getName()).append("(").append(isHeader ? headReservedFields : entryReservedFields);
        int preParamCount = isHeader ? 6 : 2;
        for (i = 0; i < preParamCount; ++i) {
            if (i > 0) {
                paramBuffer.append(",");
            }
            paramBuffer.append("?");
        }
        for (i = 0; i < propertiesColl.size(); ++i) {
            PropertyInfo propertyInfo = propertiesColl.get(i);
            if (propertyInfo.getMappingField() == null) continue;
            columns.add(propertyInfo.getName());
            sqlBuffer.append(",");
            paramBuffer.append(",");
            sqlBuffer.append(propertyInfo.getMappingField().getName());
            paramBuffer.append("?");
        }
        sqlBuffer.append(")");
        sqlBuffer.append(" values(").append((CharSequence)paramBuffer).append(")");
        return sqlBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Map<String, Map<String, Object>> queryTransmitChunked(Context ctx, String[] transmitSerialNumbers) throws Exception {
        StringBuilder transNumberBuf = new StringBuilder();
        HashMap<String, Map<String, Object>> chunkedMap = new HashMap<String, Map<String, Object>>();
        for (int i = 0; i < transmitSerialNumbers.length; ++i) {
            if (i > 0) {
                transNumberBuf.append(",");
            }
            transNumberBuf.append("'").append(transmitSerialNumbers[i].replaceAll("'", "''")).append("'");
        }
        Connection con = DBUtils.getConnection(ctx);
        ResultSet rs = null;
        try {
            rs = con.createStatement().executeQuery("select FTransmitSerialNumber, FTransmitChunkedNumber, FIgnoreHeadpk from T_EIP_ChunkedTransmit where FTransmitSerialNumber in (" + transNumberBuf.toString() + ")");
            HashMap<String, Object> valueMap = new HashMap<String, Object>();
            while (rs.next()) {
                valueMap.put("FTransmitChunkedNumber", rs.getInt(2));
                String headpkStr = rs.getString(3);
                if (StringUtils.isEmpty((String)headpkStr)) {
                    headpkStr = "";
                }
                valueMap.put("FIgnoreHeadpk", headpkStr);
                chunkedMap.put(rs.getString(1), valueMap);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs);
            SQLUtils.cleanup((Connection)con);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((Connection)con);
        return chunkedMap;
    }

    public static final void close() {
        threadInsertHelpers.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void addIgnoreHeadPK(Context ctx, String transmitSerialNumber, Set<String> headPKs) throws Exception {
        String newHeadPk;
        ResultSet rs;
        Connection con;
        block7: {
            if (null == headPKs || headPKs.size() == 0) {
                return;
            }
            StringBuilder headPKbuilder = new StringBuilder();
            Iterator<String> it = headPKs.iterator();
            while (it.hasNext()) {
                headPKbuilder.append(it.next()).append(",");
            }
            headPKbuilder.deleteCharAt(headPKbuilder.toString().length() - 1);
            con = DBUtils.getConnection(ctx);
            rs = null;
            try {
                rs = con.createStatement().executeQuery("select FIgnoreHeadpk from T_EIP_ChunkedTransmit where FTransmitSerialNumber='" + transmitSerialNumber + "'");
                String beforeHeadpk = null;
                if (rs.next()) {
                    beforeHeadpk = rs.getString(1);
                }
                newHeadPk = headPKbuilder.toString();
                if (null != beforeHeadpk && beforeHeadpk.trim().length() > 0) {
                    newHeadPk = beforeHeadpk.endsWith(",") ? beforeHeadpk + newHeadPk : beforeHeadpk + "," + newHeadPk;
                }
                if (null != newHeadPk && newHeadPk.trim().length() != 0) break block7;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
            SQLUtils.cleanup((ResultSet)rs);
            SQLUtils.cleanup((Connection)con);
            return;
        }
        PreparedStatement updateStatement = con.prepareStatement("update T_EIP_ChunkedTransmit set FIgnoreHeadpk=? where FTransmitSerialNumber=?");
        updateStatement.setString(1, newHeadPk);
        updateStatement.setString(2, transmitSerialNumber);
        updateStatement.executeUpdate();
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String selectIgnoreHeadPK(Context ctx, String transmitSerialNumber) throws Exception {
        ResultSet rs;
        Connection con;
        String ignoreHeadpk;
        block5: {
            String string;
            ignoreHeadpk = "";
            if (StringUtils.isEmpty((String)transmitSerialNumber)) {
                return ignoreHeadpk;
            }
            con = DBUtils.getConnection(ctx);
            rs = null;
            try {
                rs = con.createStatement().executeQuery("select FIgnoreHeadpk from T_EIP_ChunkedTransmit where FTransmitSerialNumber='" + transmitSerialNumber + "'");
                if (rs.next()) {
                    ignoreHeadpk = rs.getString(1);
                }
                if (!StringUtils.isEmpty((String)ignoreHeadpk)) break block5;
                string = "";
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
            SQLUtils.cleanup((ResultSet)rs);
            SQLUtils.cleanup((Connection)con);
            return string;
        }
        String string = ignoreHeadpk;
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((Connection)con);
        return string;
    }
}

