/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.webservice.app.webapi.util;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.csinterface.util.AES;
import com.kingdee.eas.csinterface.webservice.app.httpClient.EIPHttpClient;
import com.kingdee.eas.csinterface.webservice.app.log.WSCallRecordManager;
import com.kingdee.eas.csinterface.webservice.app.webapi.util.SSLClient;
import com.kingdee.eas.csinterface.webservice.app.webapi.util.WebAPIUtil;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class HttpServiceHelper {
    private static Logger logger = Logger.getLogger(HttpServiceHelper.class);
    private static final int DEFAULT_OVERTIME = 5000;

    public static Map<String, Object> doPost(String url, List<NameValuePair> reqParams) {
        return HttpServiceHelper.doPost(url, reqParams, 5000);
    }

    private static Map<String, Object> doPost(String url, List<NameValuePair> reqParams, int overTime) {
        Map resultMap = new HashMap();
        try {
            EIPHttpClient e = new EIPHttpClient();
            HttpParams httpParams = e.getParams();
            httpParams.setParameter("http.connection.timeout", (Object)overTime);
            httpParams.setParameter("http.socket.timeout", (Object)overTime);
            UrlEncodedFormEntity reqFromEntity = new UrlEncodedFormEntity(reqParams);
            HttpPost httpPost = new HttpPost(url);
            httpPost.setEntity((HttpEntity)reqFromEntity);
            HttpResponse response = e.execute_eip((HttpUriRequest)httpPost);
            HttpEntity responseEntity = response.getEntity();
            if (responseEntity != null) {
                String resultStr = EntityUtils.toString((HttpEntity)responseEntity);
                resultMap = (Map)WebAPIUtil.cast(resultStr, Map.class);
            }
        }
        catch (IOException arg10) {
            logger.error((Object)arg10);
        }
        return resultMap;
    }

    private static Map<String, Object> doPost(String url, String params) {
        Map resultMap = new HashMap();
        try {
            EIPHttpClient e = new EIPHttpClient();
            HttpParams httpParams = e.getParams();
            Integer overTime = 5000;
            httpParams.setParameter("http.connection.timeout", (Object)overTime);
            httpParams.setParameter("http.socket.timeout", (Object)overTime);
            StringEntity reqFromEntity = new StringEntity(params, ContentType.APPLICATION_JSON);
            HttpPost httpPost = new HttpPost(url);
            httpPost.setEntity((HttpEntity)reqFromEntity);
            HttpResponse response = e.execute_eip((HttpUriRequest)httpPost);
            HttpEntity responseEntity = response.getEntity();
            if (responseEntity != null) {
                String resultStr = EntityUtils.toString((HttpEntity)responseEntity);
                if (response.getStatusLine().getStatusCode() != 200) {
                    // empty if block
                }
                resultMap = (Map)WebAPIUtil.cast(resultStr, Map.class);
                logger.info((Object)resultStr);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return resultMap;
    }

    public static Object doGet(String url, Map paramMap, Class cls) {
        return HttpServiceHelper.doGet(url, paramMap, cls, 5000);
    }

    public static Object doGet(String url, Map paramMap, Class cls, int overTime) {
        Object resultObj = null;
        String resultStr = HttpServiceHelper.doGet(url, paramMap, overTime);
        try {
            resultObj = WebAPIUtil.cast(resultStr, cls);
        }
        catch (IOException arg6) {
            logger.error((Object)arg6);
        }
        return resultObj;
    }

    public static String doGet(String url, Map paramMap) {
        return HttpServiceHelper.doGet(url, paramMap, 5000);
    }

    public static String doGet(String url, Map paramMap, int overTime) {
        String resultStr = null;
        EIPHttpClient httpClient = new EIPHttpClient();
        HttpParams httpParams = httpClient.getParams();
        httpParams.setParameter("http.connection.timeout", (Object)overTime);
        httpParams.setParameter("http.socket.timeout", (Object)overTime);
        try {
            HttpGet httpGet1;
            HttpResponse response1;
            HttpEntity responseEntity1;
            URIBuilder e = new URIBuilder(url);
            if (paramMap != null) {
                Set httpGet = paramMap.keySet();
                for (String responseEntity : httpGet) {
                    e.setParameter(responseEntity, (String)paramMap.get(responseEntity));
                }
            }
            if ((responseEntity1 = (response1 = httpClient.execute_eip((HttpUriRequest)(httpGet1 = new HttpGet(e.build())))).getEntity()) != null) {
                resultStr = EntityUtils.toString((HttpEntity)responseEntity1);
            }
        }
        catch (IOException iOException) {
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return resultStr;
    }

    public static Object doPost(String url, Map<String, String> headerMap, Map<String, Object> bodyMap, Class cls) {
        Object resultObj = null;
        EIPHttpClient httpClient = new EIPHttpClient();
        HttpPost httpPost = new HttpPost(url);
        try {
            if (headerMap != null && headerMap.size() != 0) {
                for (String responseEntity : headerMap.keySet()) {
                    httpPost.setHeader(responseEntity, headerMap.get(responseEntity));
                }
            }
            if (bodyMap != null && bodyMap.size() != 0) {
                ArrayList<BasicNameValuePair> e1 = new ArrayList<BasicNameValuePair>();
                for (String resultStr : bodyMap.keySet()) {
                    String objectMapper = bodyMap.get(resultStr).toString();
                    e1.add(new BasicNameValuePair(resultStr, objectMapper));
                }
                UrlEncodedFormEntity responseEntity2 = new UrlEncodedFormEntity(e1, "UTF-8");
                httpPost.setEntity((HttpEntity)responseEntity2);
            }
            httpPost.setHeader("referer", url);
            HttpResponse e2 = httpClient.execute_eip((HttpUriRequest)httpPost);
            HttpEntity responseEntity3 = e2.getEntity();
            if (responseEntity3 != null) {
                String resultStr;
                resultStr = EntityUtils.toString((HttpEntity)responseEntity3);
                resultObj = WebAPIUtil.cast(resultStr, cls);
            }
        }
        catch (IOException arg10) {
            arg10.printStackTrace();
        }
        return resultObj;
    }

    public static Object doPost(String url, Map<String, String> headerMap, String bodyJson) throws BOSException {
        return HttpServiceHelper.doPost(url, headerMap, bodyJson, null);
    }

    public static Object doPost(String url, Map<String, String> headerMap, String bodyJson, Class cls) throws BOSException {
        Object resultObj = null;
        DefaultHttpClient httpClient = new EIPHttpClient();
        if (url.indexOf("https:") > -1) {
            try {
                httpClient = new SSLClient();
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        } else {
            httpClient = new EIPHttpClient();
        }
        HostConfiguration config = new HostConfiguration();
        httpClient.getParams().setParameter("http.connection.timeout", (Object)30000);
        httpClient.getParams().setParameter("http.socket.timeout", (Object)60000);
        HttpPost httpPost = new HttpPost(url);
        HttpEntity responseEntity = null;
        String responseEntityValue = "";
        try {
            if (headerMap != null && headerMap.size() != 0) {
                for (String response : headerMap.keySet()) {
                    httpPost.setHeader(response, headerMap.get(response));
                }
            }
            StringEntity e1 = new StringEntity(bodyJson, "UTF-8");
            e1.setContentType("application/json");
            httpPost.setEntity((HttpEntity)e1);
            httpPost.setHeader("referer", url);
            Object response1 = null;
            response1 = httpClient instanceof EIPHttpClient ? ((EIPHttpClient)httpClient).execute_eip((HttpUriRequest)httpPost) : httpClient.execute((HttpUriRequest)httpPost);
            responseEntity = response1.getEntity();
            if (responseEntity != null) {
                responseEntityValue = EntityUtils.toString((HttpEntity)responseEntity);
                resultObj = WebAPIUtil.cast(responseEntityValue.toString(), cls);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            WSCallRecordManager.recordSendData(headerMap, bodyJson, responseEntityValue);
        }
        return resultObj;
    }

    public static Object doPostEncrypt(String url, Map<String, String> headerMap, String bodyJson, Class cls, String entryptKey) throws BOSException {
        Object resultObj = null;
        EIPHttpClient httpClient = new EIPHttpClient();
        HttpPost httpPost = new HttpPost(url);
        HttpEntity responseEntity = null;
        String responseEntityValue = "";
        try {
            if (headerMap != null && headerMap.size() != 0) {
                for (String response : headerMap.keySet()) {
                    httpPost.setHeader(response, headerMap.get(response));
                }
            }
            String sendBody = AES.encryptToString(bodyJson, entryptKey);
            StringEntity e1 = new StringEntity(sendBody, "UTF-8");
            e1.setContentType("text/json");
            httpPost.setHeader("referer", url);
            httpPost.setEntity((HttpEntity)e1);
            HttpResponse response1 = httpClient.execute_eip((HttpUriRequest)httpPost);
            responseEntity = response1.getEntity();
            if (responseEntity != null) {
                responseEntityValue = EntityUtils.toString((HttpEntity)responseEntity);
                responseEntityValue = AES.decryptToString(responseEntityValue, entryptKey);
                resultObj = WebAPIUtil.cast(responseEntityValue, cls);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            WSCallRecordManager.recordSendData(headerMap, bodyJson, responseEntityValue);
        }
        return resultObj;
    }

    public static Object doPost(String url, Class cls) throws BOSException {
        Object resultObj = null;
        EIPHttpClient httpClient = new EIPHttpClient();
        HttpPost httpPost = new HttpPost(url);
        HttpEntity responseEntity = null;
        String responseEntityValue = "";
        try {
            httpPost.setHeader("referer", url);
            HttpResponse response1 = httpClient.execute_eip((HttpUriRequest)httpPost);
            responseEntity = response1.getEntity();
            if (responseEntity != null) {
                responseEntityValue = EntityUtils.toString((HttpEntity)responseEntity);
                resultObj = WebAPIUtil.cast(responseEntityValue.toString(), cls);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return resultObj;
    }

    public static Object doPostGuanyi(String url, Map<String, String> headerMap, String bodyJson, Class cls) throws BOSException {
        Object resultObj = null;
        EIPHttpClient httpClient = new EIPHttpClient();
        HttpEntity responseEntity = null;
        String responseEntityValue = "";
        try {
            HttpPost httpPost;
            HttpResponse response1;
            StringBuffer header = new StringBuffer(2000);
            if (headerMap != null && headerMap.size() != 0) {
                header.append("?");
                boolean isFirst = false;
                for (String response : headerMap.keySet()) {
                    if (isFirst) {
                        header.append("&");
                    }
                    header.append(response).append("=").append(headerMap.get(response));
                    if (isFirst) continue;
                    isFirst = true;
                }
            }
            if ((responseEntity = (response1 = httpClient.execute_eip((HttpUriRequest)(httpPost = new HttpPost(url = url + header.toString())))).getEntity()) != null) {
                responseEntityValue = EntityUtils.toString((HttpEntity)responseEntity);
                resultObj = WebAPIUtil.cast(responseEntityValue, cls);
            }
        }
        catch (IOException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            WSCallRecordManager.recordSendData(headerMap, bodyJson, responseEntityValue);
        }
        return resultObj;
    }

    private void setRequestBody(PostMethod method, Map<String, Object> params) throws IOException {
        method.setRequestBody((InputStream)new ByteArrayInputStream(HttpServiceHelper.buildQuery(params)));
    }

    public static byte[] buildQuery(Map<String, Object> params) throws IOException {
        if (params == null || params.isEmpty()) {
            return null;
        }
        StringBuilder query = new StringBuilder();
        Set<Map.Entry<String, Object>> entries = params.entrySet();
        boolean hasParam = false;
        for (Map.Entry<String, Object> entry : entries) {
            String name = entry.getKey();
            String value = entry.getValue().toString();
            if (StringUtils.isEmpty((String)name)) continue;
            if (hasParam) {
                query.append("&");
            } else {
                hasParam = true;
            }
            if (value == null) {
                value = "";
            }
            query.append(name).append("=").append(value);
        }
        return query.toString().getBytes("UTF-8");
    }
}

