/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.webservice.converter;

import com.kingdee.eas.csinterface.converter.core.MarshallingContext;
import com.kingdee.eas.csinterface.converter.core.UnmarshallingContext;
import com.kingdee.eas.csinterface.planmanager.converter.AbstractDataBaseInfoConverter;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataTypeInfo;
import com.kingdee.eas.csinterface.util.JDomB9Utils;
import com.kingdee.eas.csinterface.webservice.ImplType;
import com.kingdee.eas.csinterface.webservice.WSBillMappingEntryCollection;
import com.kingdee.eas.csinterface.webservice.WSBillMappingEntryInfo;
import com.kingdee.eas.csinterface.webservice.WSBillMappingInfo;
import java.util.Iterator;
import java.util.List;
import org.jdom2.Element;

public class WSBillMappingConverter
extends AbstractDataBaseInfoConverter {
    private String[] header_string = new String[]{"number", "name", "implClass", "implMethod", "billEntity", "description"};
    private String[] header_boolean = new String[]{"needSrcTable", "needMidData", "preset"};
    private String[] header_enum = new String[]{"implType"};
    private String[] entry_string = new String[]{"srcField", "srcAlias", "destField", "destAlias", "defaultValue", "defaultType", "baseDataField", "formater", "fieldType"};
    private String[] entry_integer = new String[]{"fieldLength", "fieldPrecision", "fieldScale"};
    private String[] entry_boolean = new String[]{"unique", "required", "dropped", "preset"};

    @Override
    public boolean canConvert(Class type) {
        return WSBillMappingInfo.class == type;
    }

    @Override
    public Object marshal(Object source, MarshallingContext context) {
        WSBillMappingInfo info = (WSBillMappingInfo)source;
        Element root = new Element(info.getClass().getName());
        this.marshalHeader(root, info);
        this.marshalEntrys(root, info, context);
        return root;
    }

    @Override
    public Object unmarshal(Object source, UnmarshallingContext context) {
        Element data = (Element)source;
        WSBillMappingInfo info = new WSBillMappingInfo();
        List children = data.getChildren();
        this.unmarshalHeader(info, children);
        this.unmarshalEntrys(info, children, context);
        return info;
    }

    private void marshalHeader(Element root, WSBillMappingInfo info) {
        int i;
        for (i = 0; i < this.header_string.length; ++i) {
            this.addChild(root, this.header_string[i], info.getString(this.header_string[i]));
        }
        for (i = 0; i < this.header_boolean.length; ++i) {
            this.addChild(root, this.header_boolean[i], info.getBoolean(this.header_boolean[i]));
        }
        for (i = 0; i < this.header_enum.length; ++i) {
            this.addChild(root, this.header_enum[i], info.getString(this.header_enum[i]));
        }
    }

    private void marshalEntrys(Element root, WSBillMappingInfo info, MarshallingContext context) {
        Element entryRoot = JDomB9Utils.addChild(root, "entrys");
        WSBillMappingEntryCollection collInfo = new WSBillMappingEntryCollection();
        Iterator iterator = info.getEntrys().iterator();
        List entryList = entryRoot.getChildren("entry");
        while (iterator.hasNext()) {
            int i;
            WSBillMappingEntryInfo entryInfo = (WSBillMappingEntryInfo)iterator.next();
            Element entry = JDomB9Utils.addChild(entryRoot, "entry");
            for (i = 0; i < this.entry_string.length; ++i) {
                this.addChild(entry, this.entry_string[i], entryInfo.getString(this.entry_string[i]));
            }
            for (i = 0; i < this.entry_boolean.length; ++i) {
                this.addChild(entry, this.entry_boolean[i], entryInfo.getBoolean(this.entry_boolean[i]));
            }
            for (i = 0; i < this.entry_integer.length; ++i) {
                this.addChild(entry, this.entry_integer[i], entryInfo.getInt(this.entry_integer[i]));
            }
            this.marshalBaseDataType(entry, entryInfo.getBaseDataType(), context);
            collInfo.add(entryInfo);
        }
        info.getEntrys().addCollection(collInfo);
    }

    private void marshalBaseDataType(Element root, BaseDataTypeInfo baseDataTypeInfo, MarshallingContext context) {
        if (null == baseDataTypeInfo) {
            return;
        }
        Object object = context.marshall(baseDataTypeInfo);
        this.addChild(root, baseDataTypeInfo.getClass().getSimpleName(), (Element)object);
    }

    public void unmarshalHeader(WSBillMappingInfo info, List<Element> children) {
        for (int i = 0; i < this.header_string.length; ++i) {
            info.setString(this.header_string[i], this.getElementTextByName(children, this.header_string[i]));
        }
        for (int k = 0; k < this.header_boolean.length; ++k) {
            info.setBoolean(this.header_boolean[k], WSBillMappingConverter.changeStringToBoolean(this.getElementTextByName(children, this.header_boolean[k])));
        }
        for (int j = 0; j < this.header_enum.length; ++j) {
            info.setImplType(ImplType.getEnum(this.getElementTextByName(children, this.header_enum[j])));
        }
    }

    private void unmarshalEntrys(WSBillMappingInfo info, List<Element> children, UnmarshallingContext context) {
        Element entrys = this.getElementByName(children, "entrys");
        if (null == entrys) {
            return;
        }
        WSBillMappingEntryCollection entryCollection = new WSBillMappingEntryCollection();
        List entryList = entrys.getChildren("com.kingdee.eas.csinterface.webservice.WSBillMappingEntryInfo");
        for (Element entry : entryList) {
            String value;
            WSBillMappingEntryInfo entryInfo = new WSBillMappingEntryInfo();
            for (int i = 0; i < this.entry_string.length; ++i) {
                value = this.getElementTextByName(entry, this.entry_string[i]);
                entryInfo.setString(this.entry_string[i], value);
            }
            for (int j = 0; j < this.entry_integer.length; ++j) {
                value = this.getElementTextByName(entry, this.entry_integer[j]);
                entryInfo.setInt(this.entry_integer[j], Integer.parseInt(value));
            }
            for (int k = 0; k < this.entry_boolean.length; ++k) {
                entryInfo.setBoolean(this.entry_integer[k], WSBillMappingConverter.changeStringToBoolean(this.getElementTextByName(entry, this.entry_integer[k])));
            }
            this.unmarshalBaseDataType(entry, entryInfo, context);
            entryCollection.add(entryInfo);
        }
        info.getEntrys().addCollection(entryCollection);
    }

    private void unmarshalBaseDataType(Element entry, WSBillMappingEntryInfo entryInfo, UnmarshallingContext context) {
        if (entry == null || entryInfo.getBaseDataType() == null) {
            return;
        }
        BaseDataTypeInfo item = (BaseDataTypeInfo)context.unmarshall(entryInfo.getBaseDataType());
        entryInfo.setBaseDataType(item);
    }
}

