/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.webservice.model.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.DBUtils;
import com.kingdee.eas.csinterface.webservice.WSBillMappingEntryCollection;
import com.kingdee.eas.csinterface.webservice.WSBillMappingEntryInfo;
import com.kingdee.eas.csinterface.webservice.WSBillMappingInfo;
import com.kingdee.eas.csinterface.webservice.model.util.FieldInfo;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class SourceTableUtil {
    private static Logger logger = Logger.getLogger(SourceTableUtil.class);

    private static String calcTableName(String billMappingId) {
        String billId = billMappingId.length() > 19 ? billMappingId.substring(0, 19) : billMappingId;
        billId = billId.replaceAll("\\+", "").toUpperCase();
        return "\"T_EIP_SRC_" + billId + "\"".toUpperCase();
    }

    private static String calcPKName(String billMappingId) {
        String billId = billMappingId.length() > 19 ? billMappingId.substring(0, 19) : billMappingId;
        billId = billId.replaceAll("\\+", "").toUpperCase();
        return "PK_" + billId;
    }

    public static void addDbSourceColumns(Context ctx, WSBillMappingInfo info) throws BOSException {
        ArrayList<FieldInfo> fields = new ArrayList<FieldInfo>();
        WSBillMappingEntryCollection coll = info.getEntrys();
        Iterator its = coll.iterator();
        while (its.hasNext()) {
            WSBillMappingEntryInfo entryInfo = (WSBillMappingEntryInfo)its.next();
            if (entryInfo.isDropped() || entryInfo.isPublished()) continue;
            fields.add(SourceTableUtil.convertSourceField(entryInfo));
        }
        Connection cn = null;
        try {
            cn = SourceTableUtil.open(ctx, info);
            String tableName = SourceTableUtil.calcTableName(info.getId().toString());
            info.setSrcTableName(tableName);
            if (!info.isPublished()) {
                info.setSrcTableName(tableName);
                SourceTableUtil.createTable(cn, info, tableName, fields);
            } else {
                SourceTableUtil.addSourceDBColumns(cn, fields, tableName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    private static void createTable(Connection conn, WSBillMappingInfo info, String tableName, List<FieldInfo> fields) throws BOSException {
        StringBuffer ksqlBuffer = new StringBuffer();
        StringBuffer primarySQL = new StringBuffer();
        ksqlBuffer.append("If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='").append(tableName).append("') ");
        ksqlBuffer.append("Create Table ").append(tableName).append("(");
        FieldInfo field = null;
        int j = fields.size();
        for (int i = 0; i < j; ++i) {
            if (i > 0) {
                ksqlBuffer.append(",");
            }
            field = fields.get(i);
            ksqlBuffer.append(SourceTableUtil.getColSQL(field));
            if (!field.isUnique()) continue;
            String pkname = "PK_" + SourceTableUtil.calcPKName(info.getId().toString());
            primarySQL.append(", CONSTRAINT " + pkname + " PRIMARY KEY (" + field.getName() + ")");
        }
        if (primarySQL != null) {
            ksqlBuffer.append(primarySQL);
        }
        ksqlBuffer.append(" );");
        DBUtils.excuteSql(conn, ksqlBuffer.toString());
    }

    private static FieldInfo convertSourceField(WSBillMappingEntryInfo entryInfo) throws BOSException {
        String name = entryInfo.getSrcField();
        String alias = entryInfo.getSrcAlias();
        int precision = entryInfo.getFieldPrecision();
        int length = entryInfo.getFieldLength();
        int scale = entryInfo.getFieldScale();
        boolean isUnique = entryInfo.isUnique();
        boolean isNullable = entryInfo.isRequired();
        String sqlTypeName = entryInfo.getFieldType().getName();
        SQLType sqlType = SQLType.getEnum((String)sqlTypeName);
        FieldInfo field = new FieldInfo(name, alias, sqlType, length, precision, scale, isNullable, isUnique);
        return field;
    }

    private static void addSourceDBColumns(Connection cn, List<FieldInfo> fields, String tableName) throws BOSException {
        for (int i = 0; i < fields.size(); ++i) {
            FieldInfo fieldInfo = fields.get(i);
            DBUtils.excuteSql(cn, SourceTableUtil.buildColumnSql(tableName, fieldInfo));
        }
    }

    public static String buildColumnSql(String tableName, FieldInfo field) {
        StringBuffer sql = new StringBuffer();
        if (field != null) {
            sql.append("IF Not Exists(Select * From KSQL_USERCOLUMNS Where KSQL_COL_TABNAME='" + tableName + "' AND KSQL_COL_NAME='" + field.getName() + "') \n");
            sql.append(" ALTER Table " + tableName);
            sql.append(" ADD " + SourceTableUtil.getColSQL(field));
        }
        return sql.toString();
    }

    public static String getColSQL(FieldInfo field) {
        String sql = "";
        String sqlpost = SourceTableUtil.getDataType(field);
        sqlpost = sqlpost + (field.isNullable() ? " NULL" : " NOT NULL");
        sql = field.getName() + " " + sqlpost;
        return sql;
    }

    public static String getDataType(FieldInfo field) {
        SQLType name = field.getSqlType();
        if (SQLType.CHAR.equals((Object)name) || SQLType.VARCHAR.equals((Object)name) || SQLType.NCHAR.equals((Object)name) || SQLType.NVARCHAR.equals((Object)name) || SQLType.CLOB.equals((Object)name) || SQLType.BLOB.equals((Object)name) || SQLType.NCLOB.equals((Object)name) || SQLType.BINARY.equals((Object)name) || SQLType.VARBINARY.equals((Object)name)) {
            return name.getName() + "(" + field.getLength() + ")";
        }
        if (SQLType.NUMERIC.equals((Object)name)) {
            int precision = field.getPrecision();
            if (precision == 0) {
                precision = field.getLength() - 1;
            }
            return "DECIMAL(" + precision + "," + field.getScale() + ")";
        }
        if (SQLType.INT.equals((Object)name) || SQLType.DATETIME.equals((Object)name)) {
            return name.getName();
        }
        logger.error((Object)("invalid col DataType " + name.getName()), (Throwable)new Exception("invalid col DataType"));
        return name.getName();
    }

    private static Connection open(Context ctx, WSBillMappingInfo info) throws Exception {
        Connection cn = null;
        try {
            cn = DBUtils.getConnection(ctx);
        }
        catch (Exception e) {
            SQLUtils.cleanup((Connection)cn);
            throw new BOSException((Throwable)e);
        }
        return cn;
    }

    private static void close() throws Exception {
    }
}

