/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.webservice.model.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.xml.impl.MetaDataPK2;
import com.kingdee.bos.db.DBUpdateInfo;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bizunit.proxy.ConvertUtils;
import com.kingdee.bos.metadata.configure.IServerMetadataStore;
import com.kingdee.bos.metadata.configure.MetadataStoreFactory;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.eas.csinterface.agent.service.base.util.SQLUtil;
import com.kingdee.eas.csinterface.bizbill.metadata.editor.EntityTableEditor;
import com.kingdee.eas.csinterface.bizbill.metadata.editor.FieldEditorUtil;
import com.kingdee.eas.csinterface.bizbill.metadata.editor.ListUIEditor;
import com.kingdee.eas.csinterface.bizbill.metadata.editor.QueryEditor;
import com.kingdee.eas.csinterface.bizbill.metadata.info.FieldInfo;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.DBUtils;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.MetadataUtils;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.UictUtils;
import com.kingdee.eas.csinterface.common.DIPException;
import com.kingdee.eas.csinterface.webservice.model.metadata.WsMetadata;
import com.kingdee.util.StringUtils;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;

public class WSModelUtil {
    public static void addFields(Context ctx, String name, List<FieldInfo> fieldInfos) throws Exception {
        if (fieldInfos == null || fieldInfos.size() == 0) {
            return;
        }
        if (!MetadataUtils.checkBillName(name)) {
            throw new DIPException("\u975e\u6cd5\u7684\u5355\u636e\u540d\u79f0'" + name + "'");
        }
        WsMetadata dm = new WsMetadata(name);
        EntityObjectInfo entityInfo = UictUtils.loadEntity((IMetaDataPK)new MetaDataPK(dm.getEntityPK()));
        entityInfo.setTrueClone(true);
        DataTableInfo tableInfo = entityInfo.getTable();
        QueryInfo queryInfo = UictUtils.loadQuery((IMetaDataPK)new MetaDataPK(dm.getQueryPK()));
        UIObjectInfo listUIInfo = UictUtils.loadUI((IMetaDataPK)new MetaDataPK(dm.getListUIPK()));
        EntityTableEditor entityTableEditor = new EntityTableEditor(entityInfo, tableInfo);
        QueryEditor queryEditor = new QueryEditor(queryInfo, entityInfo, null);
        ListUIEditor listUIEditor = new ListUIEditor(listUIInfo, queryInfo);
        ArrayList<FieldInfo> headFields = new ArrayList<FieldInfo>();
        for (int i = 0; i < fieldInfos.size(); ++i) {
            boolean isBaseDataType;
            FieldInfo fieldInfo = fieldInfos.get(i);
            headFields.add(fieldInfo);
            entityTableEditor.add(fieldInfo);
            String displayName = fieldInfo.getBaseDataDisplayName();
            boolean bl = isBaseDataType = !StringUtils.isEmpty((String)fieldInfo.getBaseDataType());
            if (isBaseDataType) {
                fieldInfo.setBaseDataDisplayName("number");
                queryEditor.add(fieldInfo);
                listUIEditor.addNumber(fieldInfo);
            }
            fieldInfo.setBaseDataDisplayName(displayName);
            queryEditor.add(fieldInfo);
            listUIEditor.add(fieldInfo);
        }
        listUIInfo = listUIEditor.getListUIObject();
        ArrayList<RelationshipInfo> relationInfos = new ArrayList<RelationshipInfo>();
        if (entityTableEditor.getRelationInfos() != null && entityTableEditor.getRelationInfos().size() > 0) {
            relationInfos.addAll(entityTableEditor.getRelationInfos());
        }
        AbstractMetaDataValue[] mds = new AbstractMetaDataValue[4 + (relationInfos.size() > 0 ? relationInfos.size() : 0)];
        mds[0] = tableInfo;
        mds[1] = entityInfo;
        mds[2] = queryInfo;
        mds[3] = listUIInfo;
        queryInfo.setTrueClone(true);
        if (relationInfos.size() > 0) {
            int i = 4;
            for (int j = 0; j < relationInfos.size(); ++j) {
                if (relationInfos.get(j) != null) {
                    mds[i] = (AbstractMetaDataValue)relationInfos.get(j);
                }
                ++i;
            }
        }
        MetadataStoreFactory.getServerMetadataStore((Context)ctx).saveMetadata(mds, MetadataUtils.PROJECT.getId(), null);
        Connection cn = null;
        try {
            cn = DBUtils.getConnection(ctx);
            WSModelUtil.addDBColumns(cn, entityInfo, headFields);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtil.cleanup(cn);
            MetadataUtils.clearServerMetadataCache();
        }
    }

    private static void addDBColumns(Connection cn, EntityObjectInfo entityInfo, List fieldInfos) throws BOSException {
        PropertyCollection col = entityInfo.getProperties();
        ArrayList list = new ArrayList();
        for (int i = 0; i < fieldInfos.size(); ++i) {
            List sqlObjs;
            FieldInfo fieldInfo = (FieldInfo)fieldInfos.get(i);
            PropertyInfo pInfo = entityInfo.getPropertyByName(fieldInfo.getRealName());
            if (pInfo == null || !pInfo.isConfigured() || (sqlObjs = FieldEditorUtil.addSQL4DynCol(entityInfo.getTable(), pInfo.getMappingField())) == null || sqlObjs.size() <= 0) continue;
            for (int j = 0; j < sqlObjs.size(); ++j) {
                DBUtils.excuteSql(cn, ((DBUpdateInfo)sqlObjs.get(j)).getSql().getValue());
            }
        }
    }

    public static void addFieldsEx(Context ctx, String name, List<FieldInfo> fieldInfos) throws Exception {
        if (fieldInfos == null || fieldInfos.size() == 0) {
            return;
        }
        if (!MetadataUtils.checkBillName(name)) {
            throw new DIPException("\u975e\u6cd5\u7684\u5355\u636e\u540d\u79f0'" + name + "'");
        }
        WsMetadata dm = new WsMetadata(name);
        EntityObjectInfo entityInfo = UictUtils.loadEntity((IMetaDataPK)new MetaDataPK(dm.getEntityPK()));
        UIObjectInfo listUIInfo = UictUtils.loadUI((IMetaDataPK)new MetaDataPK(dm.getListUIPK()));
        entityInfo.setTrueClone(true);
        DataTableInfo tableInfo = entityInfo.getTable();
        EntityTableEditor entityTableEditor = new EntityTableEditor(entityInfo, tableInfo);
        ArrayList<FieldInfo> headFields = new ArrayList<FieldInfo>();
        for (int i = 0; i < fieldInfos.size(); ++i) {
            boolean isBaseDataType;
            FieldInfo fieldInfo = fieldInfos.get(i);
            headFields.add(fieldInfo);
            entityTableEditor.add(fieldInfo);
            String displayName = fieldInfo.getBaseDataDisplayName();
            boolean bl = isBaseDataType = !StringUtils.isEmpty((String)fieldInfo.getBaseDataType());
            if (isBaseDataType) {
                fieldInfo.setBaseDataDisplayName("number");
            }
            fieldInfo.setBaseDataDisplayName(displayName);
        }
        ArrayList<RelationshipInfo> relationInfos = new ArrayList<RelationshipInfo>();
        if (entityTableEditor.getRelationInfos() != null && entityTableEditor.getRelationInfos().size() > 0) {
            relationInfos.addAll(entityTableEditor.getRelationInfos());
        }
        AbstractMetaDataValue[] mds = new AbstractMetaDataValue[2 + (relationInfos.size() > 0 ? relationInfos.size() : 0)];
        mds[0] = tableInfo;
        mds[1] = entityInfo;
        if (relationInfos.size() > 0) {
            int i = 2;
            for (int j = 0; j < relationInfos.size(); ++j) {
                if (relationInfos.get(j) != null) {
                    mds[i] = (AbstractMetaDataValue)relationInfos.get(j);
                }
                ++i;
            }
        }
        MetadataStoreFactory.getServerMetadataStore((Context)ctx).saveMetadata(mds, MetadataUtils.PROJECT.getId(), null);
        Connection cn = null;
        try {
            cn = DBUtils.getConnection(ctx);
            WSModelUtil.addDBColumns(cn, entityInfo, headFields);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtil.cleanup(cn);
            MetadataUtils.clearServerMetadataCache();
        }
    }

    public static void bindRelation(Context ctx, String clientpk, String entryName, String supplierpk) throws Exception {
        WsMetadata dm1 = new WsMetadata(clientpk);
        EntityObjectInfo client = UictUtils.loadEntity((IMetaDataPK)new MetaDataPK(dm1.getEntityPK()));
        WsMetadata dm2 = new WsMetadata(supplierpk);
        EntityObjectInfo supplier = UictUtils.loadEntity((IMetaDataPK)new MetaDataPK(dm2.getEntityPK()));
        RelationshipInfo relation = new RelationshipInfo();
        relation.setPackage("com.kingdee.eas.csinterface.custom.webservice");
        String relationName = "R_" + client.getName() + "_" + supplier.getName() + "_entrys";
        relation.setAlias("\u591a\u5206\u5f55\u57fa\u7840\u6a21\u677f\u5173\u7cfb");
        relation.setName(relationName);
        relation.setType(RelationshipType.COMPOSITION);
        relation.setClientCardinality(CardinalityType.ONE);
        relation.setSupplierCardinality(CardinalityType.ZERO_TO_UNBOUNDED);
        relation.setClientObject(client);
        relation.setSupplierObject(supplier);
        relation.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        LinkPropertyInfo linkprop_entrys = new LinkPropertyInfo();
        linkprop_entrys.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        linkprop_entrys.setRelationship(relation);
        linkprop_entrys.setConfigured(true);
        linkprop_entrys.setName(entryName);
        linkprop_entrys.setAlias("\u5206\u5f55");
        client.getProperties().add((PropertyInfo)linkprop_entrys);
        ColumnInfo column = new ColumnInfo();
        column.setName("FParentID");
        column.setTypeName(SQLType.VARCHAR);
        column.setLength(44);
        LinkPropertyInfo linkprop_parent = new LinkPropertyInfo();
        linkprop_parent.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        linkprop_parent.setRelationship(relation);
        linkprop_parent.setConfigured(true);
        linkprop_parent.setName("parent");
        linkprop_parent.setMappingField(column);
        supplier.getProperties().add((PropertyInfo)linkprop_parent);
        supplier.getTable().getColumns().add(column);
        AbstractMetaDataValue[] mds = new AbstractMetaDataValue[]{client, supplier.getTable(), supplier, relation};
        MetadataStoreFactory.getServerMetadataStore((Context)ctx).saveMetadata(mds, MetadataUtils.PROJECT.getId(), null);
        Connection cn = null;
        try {
            cn = DBUtils.getConnection(ctx);
            FieldInfo field = new FieldInfo("parent", "\u5355\u636e\u5934", SQLType.VARCHAR, 44, 0, 0);
            ArrayList<FieldInfo> list = new ArrayList<FieldInfo>();
            list.add(field);
            WSModelUtil.addDBColumns(cn, supplier, list);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtil.cleanup(cn);
            MetadataUtils.clearServerMetadataCache();
        }
    }

    public static void deleteFields(Context ctx, String name, List fieldInfos) throws Exception {
        if (fieldInfos == null || fieldInfos.size() == 0) {
            return;
        }
        if (!name.matches("[A-Z][A-Za-z0-9_]*")) {
            throw new DIPException("\u975e\u6cd5\u7684\u5355\u636e\u540d\u79f0'" + name + "'");
        }
        WsMetadata dm = new WsMetadata(name);
        EntityObjectInfo entityInfo = UictUtils.loadEntity((IMetaDataPK)new MetaDataPK(dm.getEntityPK()));
        entityInfo.setTrueClone(true);
        DataTableInfo tableInfo = entityInfo.getTable();
        QueryInfo queryInfo = UictUtils.loadQuery((IMetaDataPK)new MetaDataPK(dm.getQueryPK()));
        UIObjectInfo listUIInfo = UictUtils.loadUI((IMetaDataPK)new MetaDataPK(dm.getListUIPK()));
        EntityTableEditor entityTableEditor = new EntityTableEditor(entityInfo, tableInfo);
        QueryEditor queryEditor = new QueryEditor(queryInfo, entityInfo, null);
        ListUIEditor listUIEditor = new ListUIEditor(listUIInfo, queryInfo);
        for (int i = 0; i < fieldInfos.size(); ++i) {
            FieldInfo fieldInfo = (FieldInfo)fieldInfos.get(i);
            listUIEditor.delete(fieldInfo);
            queryEditor.delete(fieldInfo);
            entityTableEditor.delete(fieldInfo);
        }
        listUIInfo = listUIEditor.getListUIObject();
        AbstractMetaDataValue[] mds = new AbstractMetaDataValue[]{tableInfo, entityInfo, queryInfo, listUIInfo};
        queryInfo.setTrueClone(true);
        List<String> toDelHeaderList = entityTableEditor.getToDelRelationList();
        IServerMetadataStore metadataStore = MetadataStoreFactory.getServerMetadataStore((Context)ctx);
        metadataStore.saveMetadata(mds, MetadataUtils.PROJECT.getId(), null);
        if (toDelHeaderList != null && toDelHeaderList.size() > 0) {
            MetaDataPK2[] toDelHeaderPKs = new MetaDataPK2[toDelHeaderList.size()];
            for (int i = 0; i < toDelHeaderList.size(); ++i) {
                toDelHeaderPKs[i] = new MetaDataPK2(toDelHeaderList.get(i) + "!" + MetaDataTypeList.RELATIONSHIP);
            }
            metadataStore.deleteMetadata(toDelHeaderPKs, MetadataUtils.PROJECT.getId());
        }
    }

    public static void deleteFieldsEx(Context ctx, String name, List fieldInfos) throws Exception {
        if (fieldInfos == null || fieldInfos.size() == 0) {
            return;
        }
        if (!name.matches("[A-Z][A-Za-z0-9_]*")) {
            throw new DIPException("\u975e\u6cd5\u7684\u5355\u636e\u540d\u79f0'" + name + "'");
        }
        WsMetadata dm = new WsMetadata(name);
        EntityObjectInfo entityInfo = UictUtils.loadEntity((IMetaDataPK)new MetaDataPK(dm.getEntityPK()));
        entityInfo.setTrueClone(true);
        DataTableInfo tableInfo = entityInfo.getTable();
        EntityTableEditor entityTableEditor = new EntityTableEditor(entityInfo, tableInfo);
        for (int i = 0; i < fieldInfos.size(); ++i) {
            FieldInfo fieldInfo = (FieldInfo)fieldInfos.get(i);
            entityTableEditor.delete(fieldInfo);
        }
        AbstractMetaDataValue[] mds = new AbstractMetaDataValue[]{tableInfo, entityInfo};
        List<String> toDelHeaderList = entityTableEditor.getToDelRelationList();
        IServerMetadataStore metadataStore = MetadataStoreFactory.getServerMetadataStore((Context)ctx);
        metadataStore.saveMetadata(mds, MetadataUtils.PROJECT.getId(), null);
        if (toDelHeaderList != null && toDelHeaderList.size() > 0) {
            MetaDataPK2[] toDelHeaderPKs = new MetaDataPK2[toDelHeaderList.size()];
            for (int i = 0; i < toDelHeaderList.size(); ++i) {
                toDelHeaderPKs[i] = new MetaDataPK2(toDelHeaderList.get(i) + "!" + MetaDataTypeList.RELATIONSHIP);
            }
            metadataStore.deleteMetadata(toDelHeaderPKs, MetadataUtils.PROJECT.getId());
        }
    }
}

