/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectReferedException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.BaseTreeModel;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.HRTreeBaseCollection;
import com.kingdee.eas.framework.HRTreeBaseInfo;
import com.kingdee.eas.framework.TreeBaseException;
import com.kingdee.eas.framework.app.AbstractHRTreeBaseControllerBean;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.framework.util.StringUtility;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.util.Iterator;
import java.util.Locale;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.log4j.Logger;

public abstract class HRTreeBaseControllerBean
extends AbstractHRTreeBaseControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.framework.app.HRTreeBaseControllerBean");
    private final int startlevel = 1;
    public static final Locale locale_L1 = LocaleUtils.locale_L1;
    public static final Locale locale_L2 = LocaleUtils.locale_L2;
    public static final Locale locale_L3 = LocaleUtils.locale_L3;
    private BaseTreeModel treeModel;

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        boolean notExistLongNumber = false;
        SelectorItemInfo info = null;
        for (int i = 0; i < selector.size(); ++i) {
            info = selector.get(i);
            if (!info.getPropertyName().equals("longNumber")) continue;
            notExistLongNumber = true;
        }
        if (notExistLongNumber) {
            info = new SelectorItemInfo("longNumber");
            selector.add(info);
        }
        return super._getValue(ctx, pk, selector);
    }

    @Override
    protected void _checkParentDataExist(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException, TreeBaseException {
        HRTreeBaseInfo treeBaseInfo = (HRTreeBaseInfo)model;
        treeBaseInfo = this.lazyLoad(ctx, (IObjectValue)treeBaseInfo);
        boolean deleted = false;
        String longNumber = treeBaseInfo.getLongNumber();
        if (longNumber.indexOf("!") < 0) {
            return;
        }
        HRTreeBaseInfo parent = this.getFullParent(ctx, (IObjectValue)treeBaseInfo);
        if (parent == null) {
            throw new TreeBaseException(TreeBaseException.CHECKPARENTNOTNULL);
        }
        if (this._isExistPropertyName(ctx, parent, "deletedStatus") && treeBaseInfo.getBoolean("deletedStatus")) {
            deleted = true;
        }
        if (deleted) {
            throw new TreeBaseException(TreeBaseException.CHECKPARENTDELETED, new Object[0]);
        }
    }

    @Override
    protected void _checkParentValid(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException, TreeBaseException {
        HRTreeBaseInfo treeBaseInfo = (HRTreeBaseInfo)model;
        treeBaseInfo = this.lazyLoad(ctx, (IObjectValue)treeBaseInfo);
        this._checkParentDataExist(ctx, pk, (IObjectValue)treeBaseInfo);
        HRTreeBaseInfo parent = this.getFullParent(ctx, (IObjectValue)treeBaseInfo);
        if (this._isExistPropertyName(ctx, parent, "effectedStatus") && !parent.getBoolean("effectedStatus")) {
            throw new TreeBaseException(TreeBaseException.CHECKPARENTINVALIDED, new Object[0]);
        }
    }

    @Override
    protected void _checkParentBeUsed(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException, TreeBaseException {
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            this._isReferenced(ctx, pk, cn);
        }
        catch (ObjectReferedException ore) {
            throw new TreeBaseException(TreeBaseException.CHECKPARENTBEUSED, new Object[0]);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    @Override
    protected IObjectValue _getRoot(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        HRTreeBaseInfo treeBaseInfo = (HRTreeBaseInfo)model;
        treeBaseInfo = this.lazyLoad(ctx, (IObjectValue)treeBaseInfo);
        String longNumber = treeBaseInfo.getLongNumber();
        String[] numbers = longNumber.split("!");
        String root = numbers[0];
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("longNumber", (Object)treeBaseInfo.getLongNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(filter);
        HRTreeBaseCollection results = this.getHRTreeBaseCollection(ctx, ev);
        if (results != null && results.size() > 0) {
            return results.get(0);
        }
        return null;
    }

    @Override
    protected void _deleteWithChildren(Context ctx, IObjectValue model) throws BOSException, EASBizException, TreeBaseException {
        HRTreeBaseInfo treeBaseInfo = (HRTreeBaseInfo)model;
        if (treeBaseInfo == null) {
            throw new TreeBaseException(TreeBaseException.CHECKISNULL);
        }
        treeBaseInfo = this.lazyLoad(ctx, (IObjectValue)treeBaseInfo);
        HRTreeBaseCollection childrenCol = this.getAllChildren(ctx, treeBaseInfo);
        for (int i = 0; i < childrenCol.size(); ++i) {
            super._delete(ctx, (IObjectPK)new ObjectUuidPK(childrenCol.get(i).getId()));
        }
        super._delete(ctx, (IObjectPK)new ObjectUuidPK(treeBaseInfo.getId()));
        HRTreeBaseInfo parent = this.getFullParent(ctx, (IObjectValue)treeBaseInfo);
        if (parent != null) {
            this.resetLeafAndUpdateByChildRemoved(ctx, (IObjectValue)parent);
        }
    }

    @Override
    protected IObjectCollection _getChildren(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        HRTreeBaseInfo treeBaseInfo = (HRTreeBaseInfo)model;
        if (treeBaseInfo == null) {
            throw new TreeBaseException(TreeBaseException.CHECKISNULL);
        }
        FilterInfo filter = new FilterInfo();
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("parent", (Object)treeBaseInfo.getId().toString(), CompareType.EQUALS));
        HRTreeBaseCollection col = this.getHRTreeBaseCollection(ctx, ev);
        for (int i = 0; i < col.size(); ++i) {
            col.get(i).innerSetParent(treeBaseInfo);
        }
        return col;
    }

    @Override
    protected BaseTreeModel _getTreeModel(Context ctx, IObjectValue node) throws BOSException, EASBizException {
        HRTreeBaseInfo rootObject = (HRTreeBaseInfo)node;
        if (rootObject == null) {
            throw new TreeBaseException(TreeBaseException.CHECKNODEISNULL);
        }
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
        this.treeModel = new BaseTreeModel(rootNode);
        rootNode.setUserObject(rootObject);
        this.buildChildrenTreeModel(ctx, rootObject, rootNode);
        return this.treeModel;
    }

    private void buildChildrenTreeModel(Context ctx, HRTreeBaseInfo parentObject, DefaultMutableTreeNode parentNode) throws BOSException, EASBizException {
        HRTreeBaseCollection childrenObject = this.getChildren(ctx, parentObject);
        for (int i = 0; i < childrenObject.size(); ++i) {
            HRTreeBaseInfo childInfo = childrenObject.get(i);
            DefaultMutableTreeNode childNode = new DefaultMutableTreeNode();
            childNode.setUserObject(childInfo);
            this.treeModel.insertNodeInto(childNode, parentNode, i);
            this.buildChildrenTreeModel(ctx, childInfo, childNode);
        }
    }

    @Override
    protected IObjectValue _getValueWithParent(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk == null) {
            throw new TreeBaseException(TreeBaseException.CHECKISNULL);
        }
        HRTreeBaseInfo info = (HRTreeBaseInfo)super.getValue(ctx, pk);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("parent"));
        HRTreeBaseInfo infoWithParent = (HRTreeBaseInfo)super.getValue(ctx, pk);
        info.innerSetParent(infoWithParent.innerGetParent());
        return info;
    }

    @Override
    protected IObjectCollection _getAllChildren(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        HRTreeBaseInfo treeBaseInfo = (HRTreeBaseInfo)model;
        if (treeBaseInfo == null) {
            EntityViewInfo ev = new EntityViewInfo();
            ev.setFilter(new FilterInfo());
            ev.getFilter().getFilterItems().add(new FilterItemInfo("longNumber", (Object)"%", CompareType.LIKE));
            FilterInfo filterCU = this.getFilterForDefaultCU(ctx, (IObjectValue)treeBaseInfo);
            if (FilterUtility.hasFilterItem(filterCU)) {
                ev.getFilter().mergeFilter(filterCU, "AND");
            }
            HRTreeBaseCollection col = this.getHRTreeBaseCollection(ctx, ev);
            return col;
        }
        treeBaseInfo = this.lazyLoad(ctx, (IObjectValue)treeBaseInfo);
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(new FilterInfo());
        ev.getFilter().getFilterItems().add(new FilterItemInfo("longNumber", (Object)(treeBaseInfo.getLongNumber() + "!" + "%"), CompareType.LIKE));
        FilterInfo filterCU = this.getFilterForDefaultCU(ctx, (IObjectValue)treeBaseInfo);
        if (FilterUtility.hasFilterItem(filterCU)) {
            ev.getFilter().mergeFilter(filterCU, "AND");
        }
        HRTreeBaseCollection col = this.getHRTreeBaseCollection(ctx, ev);
        return col;
    }

    @Override
    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        HRTreeBaseInfo treeModel = (HRTreeBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = null;
        if (treeModel.innerGetParent() == null) {
            filterItem = new FilterItemInfo("number", (Object)treeModel.getNumber(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
            filter.getFilterItems().add(new FilterItemInfo("parent", null, CompareType.EQUALS));
            filter.setMaskString("#0 and #1");
            if (treeModel.getId() != null) {
                filterItem = new FilterItemInfo("id", (Object)treeModel.getId().toString(), CompareType.NOTEQUALS);
                filter.getFilterItems().add(filterItem);
                filter.setMaskString("#0 and #1 and #2");
            }
        } else {
            filterItem = new FilterItemInfo("number", (Object)treeModel.getNumber(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
            if (treeModel.innerGetParent().getId() != null) {
                filterItem = new FilterItemInfo("parent", (Object)treeModel.innerGetParent().getId().toString(), CompareType.EQUALS);
                filter.getFilterItems().add(filterItem);
                filter.setMaskString("#0 and #1");
            }
            if (treeModel.getId() != null) {
                filterItem = new FilterItemInfo("id", (Object)treeModel.getId().toString(), CompareType.NOTEQUALS);
                filter.getFilterItems().add(filterItem);
                if (treeModel.innerGetParent().getId() != null) {
                    filter.setMaskString("#0 and #1 and #2");
                } else {
                    filter.setMaskString("#0 and #1");
                }
            }
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterCU = this.getFilterForDefaultCU(ctx, (IObjectValue)treeModel);
        if (FilterUtility.hasFilterItem(filterCU)) {
            if (FilterUtility.hasFilterItem(filter)) {
                filter.mergeFilter(filterCU, "AND");
            } else {
                filter = filterCU;
            }
        }
        view.setFilter(filter);
        HRTreeBaseCollection results = this.getHRTreeBaseCollection(ctx, view);
        if (results != null && results.size() > 0) {
            throw new TreeBaseException(TreeBaseException.CHECKNUMBERDUPLICATED, new Object[]{treeModel.getNumber()});
        }
    }

    protected int getLongNumberLen(Context ctx, HRTreeBaseInfo info) throws EASBizException, BOSException {
        int maxLen = 0;
        String longNumberParam = null;
        longNumberParam = ParamManager.getParamValue((Context)ctx, null, (String)"TreeLongNumberlen");
        if (longNumberParam != null) {
            maxLen = Integer.parseInt(longNumberParam);
        }
        return maxLen;
    }

    private void checkLongNumberLen(Context ctx, HRTreeBaseInfo info) throws EASBizException, BOSException {
        String propertyAlias = null;
        int maxLen = 0;
        propertyAlias = this.getPropertyAlias(ctx, info, "longNumber", ctx.getLocale());
        int len = null == info.getLongNumber() ? -1 : info.getLongNumber().length();
        if (len > (maxLen = this.getLongNumberLen(ctx, info))) {
            throw new TreeBaseException(TreeBaseException.CHECKLONGNUMBERLEN, new Object[]{propertyAlias, String.valueOf(maxLen)});
        }
    }

    private PropertyInfo getProperty(Context ctx, CoreBaseInfo info, String propertyName) {
        EntityObjectInfo entity = this.getBOSEntity(ctx, info);
        PropertyInfo property = null;
        property = entity.getPropertyByNameRuntime(propertyName);
        return property;
    }

    private String getPropertyAlias(Context ctx, CoreBaseInfo info, String propertyName, Locale locale) {
        String alias = null;
        PropertyInfo property = this.getProperty(ctx, info, propertyName);
        if (property != null) {
            alias = property.getAlias(locale);
        }
        return alias;
    }

    private void LinkDisplayName(HRTreeBaseInfo parent, HRTreeBaseInfo info, Locale locale) {
        String disPlayName = null;
        String parentDisplayName = parent.getDisplayName(locale);
        disPlayName = parentDisplayName != null ? parentDisplayName + "_" + info.getName(locale) : info.getName(locale);
        info.setDisplayName(disPlayName, locale);
    }

    @Override
    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        HRTreeBaseInfo treeBaseInfo = (HRTreeBaseInfo)model;
        if (treeBaseInfo == null) {
            throw new TreeBaseException(TreeBaseException.CHECKISNULL);
        }
        this._checkNumberDup(ctx, (IObjectValue)treeBaseInfo);
        treeBaseInfo.setIsLeaf(true);
        HRTreeBaseInfo parent = this.getFullParent(ctx, (IObjectValue)treeBaseInfo);
        if (parent == null || parent.getId().equals((Object)treeBaseInfo.getId())) {
            treeBaseInfo.setLevel(1);
            treeBaseInfo.setLongNumber(treeBaseInfo.getNumber());
            this.checkLongNumberLen(ctx, treeBaseInfo);
            treeBaseInfo.setDisplayName(treeBaseInfo.getName());
            treeBaseInfo.setDisplayName(treeBaseInfo.getName(locale_L1), locale_L1);
            this.limitDisplayNameLength(treeBaseInfo, locale_L1);
            treeBaseInfo.setDisplayName(treeBaseInfo.getName(locale_L2), locale_L2);
            this.limitDisplayNameLength(treeBaseInfo, locale_L2);
            treeBaseInfo.setDisplayName(treeBaseInfo.getName(locale_L3), locale_L3);
            this.limitDisplayNameLength(treeBaseInfo, locale_L3);
        } else {
            treeBaseInfo.setLevel(parent.getLevel() + 1);
            treeBaseInfo.setLongNumber(parent.getLongNumber() + "!" + treeBaseInfo.getNumber());
            this.checkLongNumberLen(ctx, treeBaseInfo);
            treeBaseInfo.setDisplayName(parent.getDisplayName() + "_" + treeBaseInfo.getName());
            this.LinkDisplayName(parent, treeBaseInfo, locale_L1);
            this.limitDisplayNameLength(treeBaseInfo, locale_L1);
            this.LinkDisplayName(parent, treeBaseInfo, locale_L2);
            this.limitDisplayNameLength(treeBaseInfo, locale_L2);
            this.LinkDisplayName(parent, treeBaseInfo, locale_L3);
            this.limitDisplayNameLength(treeBaseInfo, locale_L3);
            if (parent.isIsLeaf()) {
                parent.setIsLeaf(false);
                super._update(ctx, (IObjectPK)new ObjectUuidPK(parent.getId()), (IObjectValue)parent);
            }
        }
        super._addnew(ctx, pk, (IObjectValue)treeBaseInfo);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        HRTreeBaseInfo treeBaseInfo = (HRTreeBaseInfo)model;
        if (treeBaseInfo == null) {
            throw new TreeBaseException(TreeBaseException.CHECKISNULL);
        }
        this._checkNumberDup(ctx, (IObjectValue)treeBaseInfo);
        HRTreeBaseInfo parent = this.getFullParent(ctx, (IObjectValue)treeBaseInfo);
        treeBaseInfo.setIsLeaf(true);
        if (parent == null || parent.getId().equals((Object)treeBaseInfo.getId())) {
            treeBaseInfo.setLevel(1);
            treeBaseInfo.setLongNumber(treeBaseInfo.getNumber());
            this.checkLongNumberLen(ctx, treeBaseInfo);
            treeBaseInfo.setDisplayName(treeBaseInfo.getName());
            treeBaseInfo.setDisplayName(treeBaseInfo.getName(locale_L1), locale_L1);
            this.limitDisplayNameLength(treeBaseInfo, locale_L1);
            treeBaseInfo.setDisplayName(treeBaseInfo.getName(locale_L2), locale_L2);
            this.limitDisplayNameLength(treeBaseInfo, locale_L2);
            treeBaseInfo.setDisplayName(treeBaseInfo.getName(locale_L3), locale_L3);
            this.limitDisplayNameLength(treeBaseInfo, locale_L3);
        } else {
            treeBaseInfo.setLevel(parent.getLevel() + 1);
            treeBaseInfo.setLongNumber(parent.getLongNumber() + "!" + treeBaseInfo.getNumber());
            this.checkLongNumberLen(ctx, treeBaseInfo);
            this.LinkDisplayName(parent, treeBaseInfo, null);
            this.limitDisplayNameLength(treeBaseInfo);
            this.LinkDisplayName(parent, treeBaseInfo, locale_L1);
            this.limitDisplayNameLength(treeBaseInfo, locale_L1);
            this.LinkDisplayName(parent, treeBaseInfo, locale_L2);
            this.limitDisplayNameLength(treeBaseInfo, locale_L2);
            this.LinkDisplayName(parent, treeBaseInfo, locale_L3);
            this.limitDisplayNameLength(treeBaseInfo, locale_L3);
            if (parent.isIsLeaf()) {
                parent.setIsLeaf(false);
                super._update(ctx, (IObjectPK)new ObjectUuidPK(parent.getId()), (IObjectValue)parent);
            }
        }
        IObjectPK pk = super._addnew(ctx, (IObjectValue)treeBaseInfo);
        return pk;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        HRTreeBaseInfo info = null;
        info = this.getValueWithParent(ctx, pk);
        if (info == null) {
            throw new TreeBaseException(TreeBaseException.CHECKISNULL);
        }
        if (!info.isIsLeaf()) {
            throw new TreeBaseException(TreeBaseException.CHECKHAVECHILDREN, new Object[]{info.getName()});
        }
        super._delete(ctx, pk);
        HRTreeBaseInfo parent = this.getFullParent(ctx, (IObjectValue)info);
        if (parent != null) {
            this.resetLeafAndUpdateByChildRemoved(ctx, (IObjectValue)parent);
        }
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        HRTreeBaseInfo treeBaseInfo = (HRTreeBaseInfo)model;
        if (treeBaseInfo == null) {
            throw new TreeBaseException(TreeBaseException.CHECKISNULL);
        }
        HRTreeBaseInfo oldInfo = (HRTreeBaseInfo)this._getValue(ctx, pk);
        String oldDisplayName = oldInfo.getDisplayName();
        String oldDisplayName_L1 = oldInfo.getDisplayName(locale_L1);
        String oldDisplayName_L2 = oldInfo.getDisplayName(locale_L2);
        String oldDisplayName_L3 = oldInfo.getDisplayName(locale_L3);
        String oldLongNumber = oldInfo.getLongNumber();
        if (treeBaseInfo.getDisplayName() == null) {
            treeBaseInfo.setDisplayName(oldDisplayName);
            treeBaseInfo.setDisplayName(oldDisplayName_L1, locale_L1);
            treeBaseInfo.setDisplayName(oldDisplayName_L2, locale_L2);
            treeBaseInfo.setDisplayName(oldDisplayName_L3, locale_L3);
        }
        if (treeBaseInfo.getLongNumber() == null) {
            treeBaseInfo.setLongNumber(oldLongNumber);
            this.checkLongNumberLen(ctx, treeBaseInfo);
        }
        if (oldLongNumber == null) {
            throw new TreeBaseException(TreeBaseException.CHECKISNULL);
        }
        if (treeBaseInfo.containsKey("number") && oldLongNumber != null) {
            String longNumber = "";
            String number = "";
            longNumber = oldLongNumber;
            number = treeBaseInfo.getNumber();
            HRTreeBaseInfo parent = this.getFullParent(ctx, (IObjectValue)treeBaseInfo);
            if (parent == null || parent.getId().equals((Object)treeBaseInfo.getId())) {
                treeBaseInfo.setLongNumber(treeBaseInfo.getNumber());
                this.checkLongNumberLen(ctx, treeBaseInfo);
                treeBaseInfo.setDisplayName(treeBaseInfo.getName());
                treeBaseInfo.setDisplayName(treeBaseInfo.getName(locale_L1), locale_L1);
                treeBaseInfo.setDisplayName(treeBaseInfo.getName(locale_L2), locale_L2);
                treeBaseInfo.setDisplayName(treeBaseInfo.getName(locale_L3), locale_L3);
            } else {
                treeBaseInfo.setLongNumber(parent.getLongNumber() + "!" + treeBaseInfo.getNumber());
                this.checkLongNumberLen(ctx, treeBaseInfo);
                this.LinkDisplayName(parent, treeBaseInfo, null);
                this.LinkDisplayName(parent, treeBaseInfo, locale_L1);
                this.LinkDisplayName(parent, treeBaseInfo, locale_L2);
                this.LinkDisplayName(parent, treeBaseInfo, locale_L3);
            }
            this.checkLNForTree(ctx, treeBaseInfo);
            int level = treeBaseInfo.getLongNumber().split("!").length;
            treeBaseInfo.setLevel(level);
            if (longNumber != null && !longNumber.equals(treeBaseInfo.getLongNumber())) {
                this.updateChildrenByNumberUpdated(ctx, (IObjectValue)treeBaseInfo, longNumber);
                this.updateChildrenByNameUpdated(ctx, (IObjectValue)treeBaseInfo, oldDisplayName, longNumber);
                this.updateChildrenByNameUpdated(ctx, (IObjectValue)treeBaseInfo, oldDisplayName_L1, longNumber, locale_L1);
                this.updateChildrenByNameUpdated(ctx, (IObjectValue)treeBaseInfo, oldDisplayName_L2, longNumber, locale_L2);
                this.updateChildrenByNameUpdated(ctx, (IObjectValue)treeBaseInfo, oldDisplayName_L3, longNumber, locale_L3);
            }
            if (!(longNumber = treeBaseInfo.getLongNumber()).substring(longNumber.lastIndexOf("!") + 1).equals(number)) {
                this._checkNumberDup(ctx, (IObjectValue)treeBaseInfo);
                treeBaseInfo.setLongNumber(longNumber.substring(0, longNumber.lastIndexOf("!") + 1) + treeBaseInfo.getNumber());
                this.checkLongNumberLen(ctx, treeBaseInfo);
                this.updateChildrenByNumberUpdated(ctx, (IObjectValue)treeBaseInfo, longNumber);
                this.updateChildrenByNameUpdated(ctx, (IObjectValue)treeBaseInfo, oldDisplayName, longNumber);
                this.updateChildrenByNameUpdated(ctx, (IObjectValue)treeBaseInfo, oldDisplayName_L1, longNumber, locale_L1);
                this.updateChildrenByNameUpdated(ctx, (IObjectValue)treeBaseInfo, oldDisplayName_L2, longNumber, locale_L2);
                this.updateChildrenByNameUpdated(ctx, (IObjectValue)treeBaseInfo, oldDisplayName_L3, longNumber, locale_L3);
            }
            if (oldDisplayName != null && !oldDisplayName.equals(treeBaseInfo.getDisplayName())) {
                this.updateChildrenByNameUpdated(ctx, (IObjectValue)treeBaseInfo, oldDisplayName, longNumber);
                this.updateChildrenByNameUpdated(ctx, (IObjectValue)treeBaseInfo, oldDisplayName_L1, longNumber, locale_L1);
                this.updateChildrenByNameUpdated(ctx, (IObjectValue)treeBaseInfo, oldDisplayName_L2, longNumber, locale_L2);
                this.updateChildrenByNameUpdated(ctx, (IObjectValue)treeBaseInfo, oldDisplayName_L3, longNumber, locale_L3);
            }
        }
        this.limitDisplayNameLength(treeBaseInfo);
        this.limitDisplayNameLength(treeBaseInfo, locale_L1);
        this.limitDisplayNameLength(treeBaseInfo, locale_L2);
        this.limitDisplayNameLength(treeBaseInfo, locale_L3);
        super._update(ctx, pk, (IObjectValue)treeBaseInfo);
    }

    protected void checkLNForTree(Context ctx, HRTreeBaseInfo treeBaseInfo) throws BOSException, EASBizException, TreeBaseException {
        FilterInfo lNfilter = new FilterInfo();
        lNfilter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)treeBaseInfo.getLongNumber()));
        lNfilter.getFilterItems().add(new FilterItemInfo("id", (Object)treeBaseInfo.getId().toString(), CompareType.NOTEQUALS));
        lNfilter.setMaskString("#0 AND #1");
        FilterInfo filterCU = this.getFilterForDefaultCU(ctx, (IObjectValue)treeBaseInfo);
        if (FilterUtility.hasFilterItem(filterCU)) {
            lNfilter.mergeFilter(filterCU, "AND");
        }
        if (this.exists(ctx, lNfilter)) {
            throw new TreeBaseException(TreeBaseException.CHECKNUMBERDUPLICATED, new Object[]{treeBaseInfo.getNumber()});
        }
    }

    private void resetLeafAndUpdateByChildRemoved(Context ctx, IObjectValue model) throws BOSException, EASBizException, TreeBaseException {
        HRTreeBaseInfo treeBaseInfo = (HRTreeBaseInfo)model;
        if (treeBaseInfo == null) {
            throw new TreeBaseException(TreeBaseException.CHECKISNULL);
        }
        int childCount = this._getChildren(ctx, (IObjectValue)treeBaseInfo).size();
        if (childCount == 0) {
            treeBaseInfo.setIsLeaf(true);
            super._update(ctx, (IObjectPK)new ObjectUuidPK(treeBaseInfo.getId()), (IObjectValue)treeBaseInfo);
        }
    }

    private void updateChildrenByNumberUpdated(Context ctx, IObjectValue model, String oldLongNumber) throws BOSException, EASBizException {
        HRTreeBaseInfo treeBaseInfo = (HRTreeBaseInfo)model;
        String longNumber = treeBaseInfo.getLongNumber();
        FilterItemInfo item = new FilterItemInfo("longNumber", (Object)(oldLongNumber + "!" + "%"), CompareType.LIKE);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(item);
        FilterInfo filterCU = this.getFilterForDefaultCU(ctx, (IObjectValue)treeBaseInfo);
        if (FilterUtility.hasFilterItem(filterCU)) {
            filter.mergeFilter(filterCU, "AND");
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        HRTreeBaseCollection collection = this.getHRTreeBaseCollection(ctx, view);
        HRTreeBaseInfo temp = null;
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            temp = (HRTreeBaseInfo)iter.next();
            String temps = StringUtility.castRegular(oldLongNumber);
            temp.setLongNumber(temp.getLongNumber().replaceFirst(temps, longNumber));
            this.checkLongNumberLen(ctx, temp);
            int level = temp.getLongNumber().split("!").length;
            temp.setLevel(level);
            super._update(ctx, (IObjectPK)new ObjectUuidPK(temp.getId()), (IObjectValue)temp);
        }
    }

    private HRTreeBaseInfo getFullParent(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        HRTreeBaseInfo treeBaseInfo = (HRTreeBaseInfo)model;
        HRTreeBaseInfo parent = treeBaseInfo.innerGetParent();
        if (parent == null || parent.getId().equals((Object)treeBaseInfo.getId())) {
            return null;
        }
        parent = this.lazyLoad(ctx, (IObjectValue)parent);
        treeBaseInfo.innerSetParent(parent);
        return parent;
    }

    private HRTreeBaseInfo lazyLoad(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        HRTreeBaseInfo treeBaseInfo = (HRTreeBaseInfo)model;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("CU.id"));
        selector.add(new SelectorItemInfo("longNumber"));
        selector.add(new SelectorItemInfo("parent"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("level"));
        selector.add(new SelectorItemInfo("isLeaf"));
        selector.add(new SelectorItemInfo("displayName"));
        selector.add(new SelectorItemInfo("deletedStatus"));
        HRTreeBaseInfo result = (HRTreeBaseInfo)this.getValue(ctx, (IObjectPK)new ObjectUuidPK(treeBaseInfo.getId()), selector);
        return result;
    }

    @Override
    protected void _moveTreeNode(Context ctx, IObjectValue sourceNode, IObjectValue targetNode) throws EASBizException, BOSException {
        HRTreeBaseInfo sourceTree = (HRTreeBaseInfo)sourceNode;
        HRTreeBaseInfo targetTree = (HRTreeBaseInfo)targetNode;
        ObjectUuidPK sourceTreePK = new ObjectUuidPK(((HRTreeBaseInfo)sourceNode).getId());
        ObjectUuidPK targetTreePK = null;
        sourceTree = (HRTreeBaseInfo)super._getValue(ctx, (IObjectPK)sourceTreePK);
        if (targetNode == null) {
            targetTree = null;
        } else {
            targetTreePK = new ObjectUuidPK(((HRTreeBaseInfo)targetNode).getId());
            targetTree = (HRTreeBaseInfo)super._getValue(ctx, (IObjectPK)targetTreePK);
        }
        this.canMove(sourceTree);
        this.canReceive(targetTree);
        if (sourceTree.getLevel() > 1) {
            ObjectUuidPK parentPK = new ObjectUuidPK(((HRTreeBaseInfo)sourceNode.get("parent")).getId());
            HRTreeBaseInfo parent = (HRTreeBaseInfo)super._getValue(ctx, (IObjectPK)parentPK);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("parent", (Object)parent.getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)sourceTree.getId().toString(), CompareType.NOTEQUALS));
            if (!this._exists(ctx, filter)) {
                parent.setIsLeaf(true);
                this._update(ctx, (IObjectPK)parentPK, (IObjectValue)parent);
            }
        }
        if (targetTree != null && targetTree.isIsLeaf()) {
            targetTree.setIsLeaf(false);
            this._update(ctx, (IObjectPK)targetTreePK, (IObjectValue)targetTree);
        }
        sourceTree.innerSetParent(targetTree);
        this._update(ctx, (IObjectPK)sourceTreePK, (IObjectValue)sourceTree);
    }

    protected void canMove(HRTreeBaseInfo tree) throws EASBizException, BOSException {
    }

    protected void canReceive(HRTreeBaseInfo tree) throws EASBizException, BOSException {
    }

    @Override
    protected IObjectCollection _getAllChildren(Context ctx, IObjectValue model, EntityViewInfo view) throws BOSException, EASBizException {
        FilterInfo filterCU;
        HRTreeBaseInfo treeBaseInfo = (HRTreeBaseInfo)model;
        if (treeBaseInfo == null) {
            EntityViewInfo ev = view;
            if (view.getFilter() == null || view.getFilter().size() == 0) {
                ev.setFilter(new FilterInfo());
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)"%", CompareType.LIKE));
            if (FilterUtility.hasFilterItem(ev.getFilter())) {
                ev.getFilter().mergeFilter(filter, "AND");
            } else {
                ev.setFilter(filter);
            }
            FilterInfo filterCU2 = this.getFilterForDefaultCU(ctx, (IObjectValue)treeBaseInfo);
            if (FilterUtility.hasFilterItem(filterCU2)) {
                ev.getFilter().mergeFilter(filterCU2, "AND");
            }
            HRTreeBaseCollection col = this.getHRTreeBaseCollection(ctx, ev);
            return col;
        }
        treeBaseInfo = this.lazyLoad(ctx, (IObjectValue)treeBaseInfo);
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(new FilterInfo());
        ev.getFilter().getFilterItems().add(new FilterItemInfo("longNumber", (Object)(treeBaseInfo.getLongNumber() + "!" + "%"), CompareType.LIKE));
        if (FilterUtility.hasFilterItem(view.getFilter())) {
            ev.getFilter().mergeFilter(view.getFilter(), "AND");
        }
        if (view != null && view.getSelector() != null) {
            ev.getSelector().addObjectCollection((IObjectCollection)view.getSelector());
        }
        if (FilterUtility.hasFilterItem(filterCU = this.getFilterForDefaultCU(ctx, (IObjectValue)treeBaseInfo))) {
            ev.getFilter().mergeFilter(filterCU, "AND");
        }
        HRTreeBaseCollection col = this.getHRTreeBaseCollection(ctx, ev);
        return col;
    }

    private void updateChildrenByNameUpdated(Context ctx, IObjectValue model, String oldDisplayName, String oldLongNumber) throws BOSException, EASBizException {
        HRTreeBaseInfo treeBaseInfo = (HRTreeBaseInfo)model;
        String displayName = treeBaseInfo.getDisplayName();
        FilterItemInfo item = new FilterItemInfo("longNumber", (Object)(treeBaseInfo.getLongNumber() + "!" + "%"), CompareType.LIKE);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(item);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        FilterInfo filterCU = this.getFilterForDefaultCU(ctx, (IObjectValue)treeBaseInfo);
        if (FilterUtility.hasFilterItem(filterCU)) {
            view.getFilter().mergeFilter(filterCU, "AND");
        }
        HRTreeBaseCollection collection = this.getHRTreeBaseCollection(ctx, view);
        HRTreeBaseInfo temp = null;
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            temp = (HRTreeBaseInfo)iter.next();
            if (oldDisplayName != null) {
                if (temp.getDisplayName() != null) {
                    if (temp.getDisplayName().indexOf(oldDisplayName) > 1) {
                        return;
                    }
                    String temps = StringUtility.castRegular(oldDisplayName);
                    temp.setDisplayName(temp.getDisplayName().replaceFirst(temps + "_", displayName + "_"));
                } else {
                    temp.setDisplayName(displayName);
                }
            } else {
                temp.setDisplayName(displayName);
            }
            this.limitDisplayNameLength(temp);
            super._update(ctx, (IObjectPK)new ObjectUuidPK(temp.getId()), (IObjectValue)temp);
        }
    }

    private void updateChildrenByNameUpdated(Context ctx, IObjectValue model, String oldDisplayName, String oldLongNumber, Locale locale) throws BOSException, EASBizException {
        HRTreeBaseInfo treeBaseInfo = (HRTreeBaseInfo)model;
        String displayName = treeBaseInfo.getDisplayName(locale);
        if (displayName == null) {
            return;
        }
        FilterItemInfo item = new FilterItemInfo("longNumber", (Object)(treeBaseInfo.getLongNumber() + "!" + "%"), CompareType.LIKE);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(item);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        FilterInfo filterCU = this.getFilterForDefaultCU(ctx, (IObjectValue)treeBaseInfo);
        if (FilterUtility.hasFilterItem(filterCU)) {
            view.getFilter().mergeFilter(filterCU, "AND");
        }
        HRTreeBaseCollection collection = this.getHRTreeBaseCollection(ctx, view);
        HRTreeBaseInfo temp = null;
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            temp = (HRTreeBaseInfo)iter.next();
            if (oldDisplayName != null) {
                if (temp.getDisplayName(locale) != null) {
                    if (temp.getDisplayName(locale).indexOf(oldDisplayName) > 1) {
                        return;
                    }
                    String temps = StringUtility.castRegular(oldDisplayName);
                    if (!displayName.startsWith(temps)) {
                        temp.setDisplayName(temp.getDisplayName(locale).replaceFirst(temps + "_", displayName + "_"), locale);
                    }
                } else {
                    temp.setDisplayName(displayName, locale);
                }
            } else {
                temp.setDisplayName(displayName, locale);
            }
            this.limitDisplayNameLength(temp);
            super._update(ctx, (IObjectPK)new ObjectUuidPK(temp.getId()), (IObjectValue)temp);
        }
    }

    protected int getDisplayNameLength() {
        return 80;
    }

    private void limitDisplayNameLength(HRTreeBaseInfo tree) {
        String displayName = tree.getDisplayName();
        String[] displayNameVar = StringUtils.split((String)displayName, (String)"_");
        if (displayNameVar == null) {
            return;
        }
        if (displayNameVar.length > 1 && displayName.length() > this.getDisplayNameLength()) {
            int len = displayName.indexOf("_");
            displayName = displayName.substring(len + 1);
            tree.setDisplayName(displayName);
            this.limitDisplayNameLength(tree);
        }
    }

    private void limitDisplayNameLength(HRTreeBaseInfo tree, Locale locale) {
        String displayName = tree.getDisplayName(locale);
        String[] displayNameVar = StringUtils.split((String)displayName, (String)"_");
        if (displayNameVar == null) {
            return;
        }
        if (displayNameVar.length > 1 && displayName.length() > this.getDisplayNameLength()) {
            int len = displayName.indexOf("_");
            displayName = displayName.substring(len + 1);
            tree.setDisplayName(displayName, locale);
            this.limitDisplayNameLength(tree, locale);
        }
    }

    @Override
    protected String _getFullDisplayName(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String fullDisplayName = "";
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("displayName"));
        HRTreeBaseInfo tree = (HRTreeBaseInfo)this._getValue(ctx, pk, selector);
        fullDisplayName = tree.getDisplayName();
        return fullDisplayName;
    }
}

