/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.portal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.portal.IPage;
import com.kingdee.eas.portal.IPageFacade;
import com.kingdee.eas.portal.PageFacadeFactory;
import com.kingdee.eas.portal.PageFactory;
import com.kingdee.eas.portal.PageInfo;
import com.kingdee.eas.portal.PagesInfo;
import com.kingdee.eas.portal.PortalContentInfo;
import com.kingdee.eas.portal.ThemeInfo;
import com.kingdee.eas.portal.app.AbstractPortalFacadeControllerBean;
import com.kingdee.eas.portal.app.PortalSynchronizationBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.UuidException;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class PortalFacadeControllerBean
extends AbstractPortalFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.portal.app.PortalFacadeControllerBean");

    @Override
    protected CoreBaseCollection _getUserPagesInfo(Context ctx, String userName) throws BOSException, EASBizException {
        IPageFacade iPageFacade = PageFacadeFactory.getLocalInstance(ctx);
        PagesInfo pages = iPageFacade.getUserPagesInfo();
        try {
            if (pages.getIsNeedUpdate() == 1) {
                this._synchPortalData(ctx);
                iPageFacade.updateNeedState(ctx.getCaller().toString(), ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), 0);
            }
        }
        catch (Throwable e) {
            logger.info((Object)"portal data synchronizate err.");
        }
        IPage iPage = PageFactory.getLocalInstance(ctx);
        return iPage.getCollection(this.getUserEnityViewInfo(ctx, pages.getId().toString()));
    }

    private EntityViewInfo getUserEnityViewInfo(Context ctx, String pagesInfoId) throws EASBizException, BOSException, UuidException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("parent"));
        selector.add(new SelectorItemInfo("isDefaultOpen"));
        selector.add(new SelectorItemInfo("isDirectory"));
        selector.add(new SelectorItemInfo("displayStyle"));
        selector.add(new SelectorItemInfo("description"));
        selector.add(new SelectorItemInfo("pageNumber"));
        selector.add(new SelectorItemInfo("isLeaf"));
        selector.add(new SelectorItemInfo("level"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("pageDescription"));
        selector.add(new SelectorItemInfo("pageDescription.changeable"));
        selector.add(new SelectorItemInfo("pageDescription.pageState"));
        selector.add(new SelectorItemInfo("tab"));
        selector.add(new SelectorItemInfo("tab.moveable"));
        selector.add(new SelectorItemInfo("tab.closeable"));
        selector.add(new SelectorItemInfo("tab.maxminable"));
        selector.add(new SelectorItemInfo("tab.singlePortlet"));
        selector.add(new SelectorItemInfo("tab.borderVisible"));
        selector.add(new SelectorItemInfo("tab.autofreshable"));
        selector.add(new SelectorItemInfo("tab.id"));
        selector.add(new SelectorItemInfo("tab.layout"));
        selector.add(new SelectorItemInfo("tab.layout.colNum"));
        selector.add(new SelectorItemInfo("tab.layout.id"));
        selector.add(new SelectorItemInfo("tab.layout.template.id"));
        selector.add(new SelectorItemInfo("tab.layout.template.name"));
        selector.add(new SelectorItemInfo("tab.layout.cols"));
        selector.add(new SelectorItemInfo("tab.layout.cols.adaptive"));
        selector.add(new SelectorItemInfo("tab.layout.cols.areaFloat"));
        selector.add(new SelectorItemInfo("tab.layout.cols.marginLeft"));
        selector.add(new SelectorItemInfo("tab.layout.cols.marginRight"));
        selector.add(new SelectorItemInfo("tab.layout.cols.areaWidth"));
        selector.add(new SelectorItemInfo("tab.layout.cols.id"));
        selector.add(new SelectorItemInfo("tab.layout.cols.portlets"));
        selector.add(new SelectorItemInfo("tab.layout.cols.portlets.portletID"));
        selector.add(new SelectorItemInfo("tab.layout.cols.portlets.action"));
        selector.add(new SelectorItemInfo("tab.layout.cols.portlets.id"));
        selector.add(new SelectorItemInfo("tab.layout.cols.portlets.params"));
        selector.add(new SelectorItemInfo("tab.layout.cols.portlets.params.paramName"));
        selector.add(new SelectorItemInfo("tab.layout.cols.portlets.params.paramValue"));
        selector.add(new SelectorItemInfo("tab.layout.cols.portlets.params.id"));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().addObjectCollection((IObjectCollection)selector);
        viewInfo.getSorter().add(new SorterItemInfo("orderNum"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("pages", (Object)pagesInfoId, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        return viewInfo;
    }

    @Override
    protected PortalContentInfo _getPortalContentInfo(Context ctx, String userName) throws EASBizException, BOSException {
        PortalContentInfo portalContentInfo = new PortalContentInfo();
        portalContentInfo.setPageCollection(this.getUserPagesInfo(ctx, userName));
        portalContentInfo.setThemeInfo(this.getUserThemeInfo(ctx, userName));
        return portalContentInfo;
    }

    @Override
    protected ThemeInfo _getUserThemeInfo(Context ctx, String _realname) throws EASBizException, BOSException {
        ThemeInfo themeInfo = new ThemeInfo();
        return themeInfo;
    }

    @Override
    protected void _synchPortalData(Context ctx) throws BOSException, EASBizException {
        PortalSynchronizationBean synBean = new PortalSynchronizationBean();
        synBean.synchronizate(ctx);
    }

    @Override
    protected int _getUserPageNum(Context ctx) throws BOSException, EASBizException {
        int num = 0;
        String strSql = "select max(A.FORDERNUM) num from T_PORTAL_PAGES B,T_PORTAL_PAGE A where B.FISDEFAULT=0 and B.FUSERID=? and B.FCONTROLUNITID=? and A.FPAGESID=B.FID";
        Object[] param = new String[]{ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString()};
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)strSql.toString(), (Object[])param);
        try {
            if (rowSet != null && rowSet.next()) {
                num = rowSet.getInt("num");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            num = 0;
        }
        return num;
    }

    @Override
    protected int _getDefaultPageNum(Context ctx) throws BOSException, EASBizException {
        int num = 0;
        String strSql = "select max(A.FORDERNUM) num from T_PORTAL_PAGES B,T_PORTAL_PAGE A where B.FISDEFAULT=1 and A.FPAGESID=B.FID ";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)strSql.toString());
        try {
            if (rowSet != null && rowSet.next()) {
                num = rowSet.getInt("num");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            num = 0;
        }
        return num;
    }

    @Override
    protected void _updatePageState(Context ctx, String pageId, int nState) throws BOSException, EASBizException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("update T_PORTAL_PAGEDESCRIPTION set FPAGESTATE =? ");
        buffer.append(" where FID in( select A.FPAGEDESCRIPTIONID from T_PORTAL_PAGE A where A.FFROMPAGEID=? )");
        if (30 == nState) {
            buffer.append(" and FPAGESTATE = ").append(20);
        } else if (20 == nState) {
            buffer.append(" and FPAGESTATE = ").append(30);
        } else if (40 == nState) {
            buffer.append(" and FPAGESTATE != ").append(40);
        }
        Object[] param = new String[]{"" + nState, pageId};
        DbUtil.execute((Context)ctx, (String)buffer.toString(), (Object[])param);
    }

    @Override
    protected void _isDefaultOpen(Context ctx, String pageID, String sysType) throws BOSException, EASBizException {
        if ("1".equals(sysType)) {
            this.setDefaultOpen(ctx, pageID);
            return;
        }
        IPageFacade iPageFacade = PageFacadeFactory.getLocalInstance(ctx);
        PagesInfo pagesInfo = null;
        pagesInfo = "2".equals(sysType) ? iPageFacade.getUserPagesInfo() : iPageFacade.getDefaultPagesInfo();
        StringBuffer buffer = new StringBuffer();
        buffer.append("update T_PORTAL_PAGE set FISDEFAULTOPEN =0 ");
        buffer.append(" where FPAGESID = ? ");
        Object[] param = new String[]{pagesInfo.getId().toString()};
        DbUtil.execute((Context)ctx, (String)buffer.toString(), (Object[])param);
        buffer = new StringBuffer();
        buffer.append("update T_PORTAL_PAGE set FISDEFAULTOPEN =1 ");
        buffer.append(" where FID = ? ");
        param = new String[]{pageID};
        DbUtil.execute((Context)ctx, (String)buffer.toString(), (Object[])param);
    }

    private void setDefaultOpen(Context ctx, String pageID) throws BOSException, EASBizException {
        IPage iPage = PageFactory.getLocalInstance(ctx);
        PageInfo info = (PageInfo)iPage.getValue((IObjectPK)new ObjectUuidPK(pageID));
        IPageFacade iPageFacade = PageFacadeFactory.getLocalInstance(ctx);
        PagesInfo pagesInfo = null;
        pagesInfo = iPageFacade.getDefaultPagesInfo();
        StringBuffer buffer = new StringBuffer();
        buffer.append("update T_PORTAL_PAGE set FOrderNum =FOrderNum+1 ");
        buffer.append(" where FPAGESID = ? and FOrderNum<?");
        Object[] param = new String[]{pagesInfo.getId().toString(), "" + info.getOrderNum()};
        DbUtil.execute((Context)ctx, (String)buffer.toString(), (Object[])param);
        buffer = new StringBuffer();
        buffer.append("update T_PORTAL_PAGE set FOrderNum =0 ");
        buffer.append(" where FID=?");
        param = new String[]{pageID};
        DbUtil.execute((Context)ctx, (String)buffer.toString(), (Object[])param);
        buffer = new StringBuffer();
        buffer.append("update T_PORTAL_PAGE set FISDEFAULTOPEN =0 ");
        DbUtil.execute((Context)ctx, (String)buffer.toString());
        buffer = new StringBuffer();
        buffer.append("update T_PORTAL_PAGE set FISDEFAULTOPEN =1 ");
        buffer.append(" where fFromPageId =? or FID = ?");
        param = new String[]{pageID, pageID};
        DbUtil.execute((Context)ctx, (String)buffer.toString(), (Object[])param);
    }

    @Override
    protected boolean _existsUserPage(Context ctx) throws BOSException, EASBizException {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("select FID from T_PORTAL_PAGES  where FUSERID=? and FCONTROLUNITID=? and FISDEFAULT=0");
        Object[] param = new String[]{ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString()};
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString(), (Object[])param);
        try {
            if (rowSet != null && rowSet.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    protected void _updatePageStateOfDelete(Context ctx, String pageId) throws BOSException, EASBizException {
        this._updatePageState(ctx, pageId, 40);
    }

    @Override
    protected void _updatePageStateOfRun(Context ctx, String pageId) throws BOSException, EASBizException {
        this._updatePageState(ctx, pageId, 20);
    }

    @Override
    protected void _updatePageStateOfStop(Context ctx, String pageId) throws BOSException, EASBizException {
        this._updatePageState(ctx, pageId, 30);
    }
}

