/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.portal.web.cache.resource;

import com.enterprisedt.util.safe.SafeCheckUtils;
import com.kingdee.eas.portal.web.cache.resource.CacheEntry;
import com.kingdee.eas.portal.web.cache.resource.ProxyDirContext;
import com.kingdee.eas.portal.web.cache.resource.ResourceAttributes;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HttpResourceLoader {
    protected int output = 2048;
    protected int input = 2048;
    protected static final String mimeSeparation = "CATALINA_MIME_BOUNDARY";
    protected ProxyDirContext resources = null;

    public HttpResourceLoader() {
        this(null);
    }

    public HttpResourceLoader(ProxyDirContext resources) {
        this.resources = resources;
    }

    protected String getRelativePath(HttpServletRequest request) {
        String result = request.getPathInfo();
        if (result == null || result.equals("")) {
            result = request.getServletPath();
        }
        if (result == null || result.equals("")) {
            result = "/";
        }
        return SafeCheckUtils.cleanPathString((String)result);
    }

    private boolean checkIfMatch(HttpServletRequest request, HttpServletResponse response, ResourceAttributes resourceAttributes) throws IOException {
        String eTag = this.getETag(resourceAttributes);
        String headerValue = request.getHeader("If-Match");
        if (headerValue != null && headerValue.indexOf(42) == -1) {
            StringTokenizer commaTokenizer = new StringTokenizer(headerValue, ",");
            boolean conditionSatisfied = false;
            while (!conditionSatisfied && commaTokenizer.hasMoreTokens()) {
                String currentToken = commaTokenizer.nextToken();
                if (!currentToken.trim().equals(eTag)) continue;
                conditionSatisfied = true;
            }
            if (!conditionSatisfied) {
                response.sendError(412);
                return false;
            }
        }
        return true;
    }

    private boolean checkIfModifiedSince(HttpServletRequest request, HttpServletResponse response, ResourceAttributes resourceAttributes) throws IOException {
        try {
            long headerValue = request.getDateHeader("If-Modified-Since");
            long lastModified = resourceAttributes.getLastModified();
            if (headerValue != -1L && lastModified <= headerValue + 1000L) {
                response.setStatus(304);
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgument) {
            return true;
        }
        return true;
    }

    private boolean checkIfNoneMatch(HttpServletRequest request, HttpServletResponse response, ResourceAttributes resourceAttributes) throws IOException {
        String eTag = this.getETag(resourceAttributes);
        String headerValue = request.getHeader("If-None-Match");
        if (headerValue != null) {
            boolean conditionSatisfied = false;
            if (!headerValue.equals("*")) {
                StringTokenizer commaTokenizer = new StringTokenizer(headerValue, ",");
                while (!conditionSatisfied && commaTokenizer.hasMoreTokens()) {
                    String currentToken = commaTokenizer.nextToken();
                    if (!currentToken.trim().equals(eTag)) continue;
                    conditionSatisfied = true;
                }
            } else {
                conditionSatisfied = true;
            }
            if (conditionSatisfied) {
                if ("GET".equals(request.getMethod()) || "HEAD".equals(request.getMethod())) {
                    response.setStatus(304);
                    return false;
                }
                response.sendError(412);
                return false;
            }
        }
        return true;
    }

    private boolean checkIfUnmodifiedSince(HttpServletRequest request, HttpServletResponse response, ResourceAttributes resourceAttributes) throws IOException {
        try {
            long lastModified = resourceAttributes.getLastModified();
            long headerValue = request.getDateHeader("If-Unmodified-Since");
            if (headerValue != -1L && lastModified > headerValue + 1000L) {
                response.sendError(412);
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgument) {
            return true;
        }
        return true;
    }

    protected boolean checkIfHeaders(HttpServletRequest request, HttpServletResponse response, ResourceAttributes resourceAttributes) throws IOException {
        return this.checkIfMatch(request, response, resourceAttributes) && this.checkIfModifiedSince(request, response, resourceAttributes) && this.checkIfNoneMatch(request, response, resourceAttributes) && this.checkIfUnmodifiedSince(request, response, resourceAttributes);
    }

    protected void defineCaching(HttpServletRequest request, HttpServletResponse response, ResourceAttributes resourceAttributes) {
    }

    protected void defineContentHeaders(HttpServletRequest request, HttpServletResponse response, ResourceAttributes resourceAttributes, String contentEncoding) {
    }

    protected String mapMimeType(String mime) {
        if (mime.endsWith(".gz")) {
            mime = mime.substring(0, mime.length() - 3);
        }
        return mime;
    }

    public void serveResource(ServletContext context, HttpServletRequest request, HttpServletResponse response, boolean content) throws IOException, ServletException {
    }

    private void copy(CacheEntry cacheEntry, InputStream is, ServletOutputStream ostream) throws IOException {
        IOException exception = null;
        InputStream resourceInputStream = null;
        if (cacheEntry.resource != null) {
            byte[] buffer = cacheEntry.resource.getContent();
            if (buffer != null) {
                ostream.write(buffer, 0, buffer.length);
                return;
            }
            resourceInputStream = cacheEntry.resource.streamContent();
        } else {
            resourceInputStream = is;
        }
        BufferedInputStream istream = new BufferedInputStream(resourceInputStream, this.input);
        exception = this.copyRange(istream, ostream);
        try {
            ((InputStream)istream).close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (exception != null) {
            throw exception;
        }
    }

    private void copy(CacheEntry cacheEntry, InputStream is, PrintWriter writer) throws IOException {
        IOException exception = null;
        InputStream resourceInputStream = null;
        resourceInputStream = cacheEntry.resource != null ? cacheEntry.resource.streamContent() : is;
        InputStreamReader reader = new InputStreamReader(resourceInputStream);
        exception = this.copyRange(reader, writer);
        try {
            ((Reader)reader).close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (exception != null) {
            throw exception;
        }
    }

    private IOException copyRange(InputStream istream, ServletOutputStream ostream) {
        IOException exception = null;
        byte[] buffer = new byte[this.input];
        int len = buffer.length;
        try {
            while ((len = istream.read(buffer)) != -1) {
                ostream.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            exception = e;
            len = -1;
        }
        return exception;
    }

    private IOException copyRange(Reader reader, PrintWriter writer) {
        IOException exception = null;
        char[] buffer = new char[this.input];
        int len = buffer.length;
        try {
            while ((len = reader.read(buffer)) != -1) {
                writer.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            exception = e;
            len = -1;
        }
        return exception;
    }

    private void copy(CacheEntry cacheEntry, ServletOutputStream ostream, Range range) throws IOException {
        IOException exception = null;
        InputStream resourceInputStream = cacheEntry.resource.streamContent();
        BufferedInputStream istream = new BufferedInputStream(resourceInputStream, this.input);
        exception = this.copyRange(istream, ostream, range.start, range.end);
        try {
            ((InputStream)istream).close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (exception != null) {
            throw exception;
        }
    }

    private void copy(CacheEntry cacheEntry, PrintWriter writer, Range range) throws IOException {
        IOException exception = null;
        InputStream resourceInputStream = cacheEntry.resource.streamContent();
        InputStreamReader reader = new InputStreamReader(resourceInputStream);
        exception = this.copyRange(reader, writer, range.start, range.end);
        try {
            ((Reader)reader).close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (exception != null) {
            throw exception;
        }
    }

    private IOException copyRange(InputStream istream, ServletOutputStream ostream, long start, long end) {
        try {
            istream.skip(start);
        }
        catch (IOException e) {
            return e;
        }
        IOException exception = null;
        long bytesToRead = end - start + 1L;
        byte[] buffer = new byte[this.input];
        int len = buffer.length;
        while (bytesToRead > 0L && len >= buffer.length) {
            try {
                len = istream.read(buffer);
                if (bytesToRead >= (long)len) {
                    ostream.write(buffer, 0, len);
                    bytesToRead -= (long)len;
                } else {
                    ostream.write(buffer, 0, (int)bytesToRead);
                    bytesToRead = 0L;
                }
            }
            catch (IOException e) {
                exception = e;
                len = -1;
            }
            if (len >= buffer.length) continue;
            break;
        }
        return exception;
    }

    private IOException copyRange(Reader reader, PrintWriter writer, long start, long end) {
        try {
            reader.skip(start);
        }
        catch (IOException e) {
            return e;
        }
        IOException exception = null;
        long bytesToRead = end - start + 1L;
        char[] buffer = new char[this.input];
        int len = buffer.length;
        while (bytesToRead > 0L && len >= buffer.length) {
            try {
                len = reader.read(buffer);
                if (bytesToRead >= (long)len) {
                    writer.write(buffer, 0, len);
                    bytesToRead -= (long)len;
                } else {
                    writer.write(buffer, 0, (int)bytesToRead);
                    bytesToRead = 0L;
                }
            }
            catch (IOException e) {
                exception = e;
                len = -1;
            }
            if (len >= buffer.length) continue;
            break;
        }
        return exception;
    }

    private void copy(CacheEntry cacheEntry, ServletOutputStream ostream, Enumeration ranges, String contentType) throws IOException {
        IOException exception = null;
        while (exception == null && ranges.hasMoreElements()) {
            InputStream resourceInputStream = cacheEntry.resource.streamContent();
            BufferedInputStream istream = new BufferedInputStream(resourceInputStream, this.input);
            Range currentRange = (Range)ranges.nextElement();
            ostream.println();
            ostream.println("--CATALINA_MIME_BOUNDARY");
            if (contentType != null) {
                ostream.println("Content-Type: " + contentType);
            }
            ostream.println("Content-Range: bytes " + currentRange.start + "-" + currentRange.end + "/" + currentRange.length);
            ostream.println();
            exception = this.copyRange(istream, ostream, currentRange.start, currentRange.end);
            try {
                ((InputStream)istream).close();
            }
            catch (Throwable throwable) {}
        }
        ostream.println();
        ostream.print("--CATALINA_MIME_BOUNDARY--");
        if (exception != null) {
            throw exception;
        }
    }

    private void copy(CacheEntry cacheEntry, PrintWriter writer, Enumeration ranges, String contentType) throws IOException {
        IOException exception = null;
        while (exception == null && ranges.hasMoreElements()) {
            InputStream resourceInputStream = cacheEntry.resource.streamContent();
            InputStreamReader reader = new InputStreamReader(resourceInputStream);
            Range currentRange = (Range)ranges.nextElement();
            writer.println();
            writer.println("--CATALINA_MIME_BOUNDARY");
            if (contentType != null) {
                writer.println("Content-Type: " + contentType);
            }
            writer.println("Content-Range: bytes " + currentRange.start + "-" + currentRange.end + "/" + currentRange.length);
            writer.println();
            exception = this.copyRange(reader, writer, currentRange.start, currentRange.end);
            try {
                ((Reader)reader).close();
            }
            catch (Throwable throwable) {}
        }
        writer.println();
        writer.print("--CATALINA_MIME_BOUNDARY--");
        if (exception != null) {
            throw exception;
        }
    }

    protected Vector parseRange(HttpServletRequest request, HttpServletResponse response, ResourceAttributes resourceAttributes) throws IOException {
        long fileLength;
        String headerValue = request.getHeader("If-Range");
        if (headerValue != null) {
            long headerValueTime = -1L;
            try {
                headerValueTime = request.getDateHeader("If-Range");
            }
            catch (Exception exception) {
                // empty catch block
            }
            String eTag = this.getETag(resourceAttributes);
            long lastModified = resourceAttributes.getLastModified();
            if (headerValueTime == -1L ? !eTag.equals(headerValue.trim()) : lastModified > headerValueTime + 1000L) {
                return null;
            }
        }
        if ((fileLength = resourceAttributes.getContentLength()) == 0L) {
            return null;
        }
        String rangeHeader = request.getHeader("Range");
        if (rangeHeader == null) {
            return null;
        }
        if (!rangeHeader.startsWith("bytes")) {
            response.addHeader("Content-Range", "bytes */" + fileLength);
            response.sendError(416);
            return null;
        }
        rangeHeader = rangeHeader.substring(6);
        Vector<Range> result = new Vector<Range>();
        StringTokenizer commaTokenizer = new StringTokenizer(rangeHeader, ",");
        while (commaTokenizer.hasMoreTokens()) {
            String rangeDefinition = commaTokenizer.nextToken().trim();
            Range currentRange = new Range();
            currentRange.length = fileLength;
            int dashPos = rangeDefinition.indexOf(45);
            if (dashPos == -1) {
                response.addHeader("Content-Range", "bytes */" + fileLength);
                response.sendError(416);
                return null;
            }
            if (dashPos == 0) {
                try {
                    long offset = Long.parseLong(rangeDefinition);
                    currentRange.start = fileLength + offset;
                    currentRange.end = fileLength - 1L;
                }
                catch (NumberFormatException e) {
                    response.addHeader("Content-Range", "bytes */" + fileLength);
                    response.sendError(416);
                    return null;
                }
            }
            try {
                currentRange.start = Long.parseLong(rangeDefinition.substring(0, dashPos));
                currentRange.end = dashPos < rangeDefinition.length() - 1 ? Long.parseLong(rangeDefinition.substring(dashPos + 1, rangeDefinition.length())) : fileLength - 1L;
            }
            catch (NumberFormatException e) {
                response.addHeader("Content-Range", "bytes */" + fileLength);
                response.sendError(416);
                return null;
            }
            if (!currentRange.validate()) {
                response.addHeader("Content-Range", "bytes */" + fileLength);
                response.sendError(416);
                return null;
            }
            result.addElement(currentRange);
        }
        return result;
    }

    protected String getETag(ResourceAttributes resourceAttributes) {
        String result = null;
        result = resourceAttributes.getETag(true);
        if (result != null) {
            return result;
        }
        result = resourceAttributes.getETag();
        if (result != null) {
            return result;
        }
        return "ETAG-" + resourceAttributes.getContentLength() + "-" + resourceAttributes.getLastModified();
    }

    private class Range {
        public long start;
        public long end;
        public long length;

        private Range() {
        }

        public boolean validate() {
            if (this.end >= this.length) {
                this.end = this.length - 1L;
            }
            return this.start >= 0L && this.end >= 0L && this.start <= this.end && this.length > 0L;
        }

        public void recycle() {
            this.start = 0L;
            this.end = 0L;
            this.length = 0L;
        }
    }
}

