/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.portal.web.configuration;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ClusterConfig {
    private static Logger logger = Logger.getLogger(ClusterConfig.class);
    private static final String CONFIG_FILEPATH = File.separator + "server" + File.separator + "cluster" + File.separator + "ormrpc_loadbalance.properties";
    private static Properties prop;
    private static final int DEFAULT_CONTROL_PORT = 11034;

    public static int getClusterCtrlPort() {
        try {
            if (prop == null) {
                ClusterConfig.loadConfigs();
            }
            return Integer.parseInt(ClusterConfig.blankWhenNull(prop.get("tcpConnectionPort")));
        }
        catch (Exception e) {
            logger.error((Object)"exception occured , return the default port '11034'");
            return 11034;
        }
    }

    private static void loadConfigs() {
        prop = new Properties();
        FileInputStream is = null;
        String absolutePath = System.getProperty("EAS_HOME") + CONFIG_FILEPATH;
        try {
            is = new FileInputStream(absolutePath);
            prop.load(is);
        }
        catch (IOException e) {
            logger.error((Object)("config file '" + absolutePath + "' was not found,details message :" + e.getMessage()));
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static String blankWhenNull(Object str) {
        return str == null ? "" : str.toString();
    }
}

