/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.portal.web.configuration;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.portal.IPortlet;
import com.kingdee.eas.portal.PortletFactory;
import com.kingdee.eas.portal.PortletInfo;
import com.kingdee.eas.portal.app.cache.PortletForClusterCacheFactory;
import com.kingdee.eas.portal.web.configuration.AbstractPortletDefinitionsFactory;
import com.kingdee.eas.portal.web.configuration.PortletConfiguration;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class XmlPortletDefinitionsFactory
extends AbstractPortletDefinitionsFactory {
    private Logger logger = Logger.getLogger(XmlPortletDefinitionsFactory.class);
    private final String PORTLETS_CONFIG_FILE_REGEX = "(^portlets).*(.xml$)";

    @Override
    public void init() throws IOException, SAXException, BOSException {
        this.logger.debug((Object)"XmlPortletDefinitionsFactory.init().start.......");
        PortletConfiguration t = new PortletConfiguration();
        File[] files = this.getFiles(this.getConfigDir(), "(^portlets).*(.xml$)");
        Map temp = new HashMap();
        for (int i = 0; i < files.length; ++i) {
            t.initConfiguration(files[i]);
            temp = (Map)t.getPortletsManager().getPortlets().clone();
            this.portletDefines.putAll(temp);
        }
        if (!PortletForClusterCacheFactory.isLocal()) {
            try {
                PortletForClusterCacheFactory.getPortletForClusterCache(this.context).refreshMSPortletCache(this.context);
            }
            catch (EASBizException e) {
                this.logger.debug((Object)("XmlPortletDefinitionsFactory.init()...error......." + (Object)((Object)e)));
            }
        } else {
            HashMap<String, PortletInfo> portlet = new HashMap<String, PortletInfo>();
            IPortlet iportlet = PortletFactory.getLocalInstance(this.context);
            StringBuffer condSb = new StringBuffer("select *, params.*, ");
            condSb.append("portletExt.id, portletExt.showTitleArea, portletExt.title, portletExt.titleFontColor, portletExt.titleBoxLeftSuffix, ").append("portletExt.titleBoxBgSuffix, portletExt.titleBoxRightSuffix, portletExt.titleAreaBgSuffix, portletExt.titleIconSuffix, ").append("portletExt.showTitleAreaBorder, portletExt.titleAreaBorderColor, portletExt.showContentAreaBorder, portletExt.contentAreaBorderColor, ").append("portletExt.contentAreaBgColor, portletExt.height, portletExt.bizDefUrl, portletExt.bizInsUrl, portletExt.attrConfigurable, portletExt.lastUpdateTime ").append("where enable = ").append(1);
            CoreBaseCollection collection = iportlet.getCollection(condSb.toString());
            Iterator iterator = collection.iterator();
            portlet.clear();
            while (iterator.hasNext()) {
                PortletInfo info = (PortletInfo)iterator.next();
                portlet.put(info.getId().toString(), info);
            }
            this.portlets.put(this.context.getAIS(), portlet);
            this.logger.debug((Object)"XmlPortletDefinitionsFactory.init().end.......");
        }
    }

    public String getConfigDir() {
        String configDir = System.getProperty("EAS_HOME");
        if (configDir == null) {
            throw new RuntimeException("cann't find the portalConfig file!");
        }
        File configFile = new File(configDir);
        if (!configFile.exists()) {
            throw new RuntimeException("cann't find the config file!");
        }
        configDir = configFile.getAbsolutePath() + "/server/deploy/eas.ear/cp_web.war/WEB-INF/";
        return configDir;
    }

    private File[] getFiles(String dirStr, String regex) throws IOException {
        File dir = new File(dirStr);
        if (!dir.isDirectory()) {
            return null;
        }
        FileListFilter select = new FileListFilter(regex);
        File[] files = dir.listFiles(select);
        return files;
    }

    class FileListFilter
    implements FilenameFilter {
        private String fileFullNameRegex;

        public FileListFilter(String fileFullNameRegex) {
            this.fileFullNameRegex = fileFullNameRegex;
        }

        @Override
        public boolean accept(File directory, String filename) {
            if (this.fileFullNameRegex != null) {
                String regEx = this.fileFullNameRegex;
                Pattern p = Pattern.compile(regEx);
                Matcher m = p.matcher(filename);
                return m.find();
            }
            return false;
        }
    }
}

