/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.portal.web.control;

import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.portal.ColCollection;
import com.kingdee.eas.portal.ColInfo;
import com.kingdee.eas.portal.LayoutInfo;
import com.kingdee.eas.portal.PageDescriptionInfo;
import com.kingdee.eas.portal.PageInfo;
import com.kingdee.eas.portal.PageStateEnum;
import com.kingdee.eas.portal.PortletPreferencesInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class PortalContextBean {
    private CoreBaseCollection pageCollection = new CoreBaseCollection();
    private boolean configPageVisible = false;
    private int nCurrentPages = 0;
    private int defaultPageIndex = -1;
    private String defaultPageId = null;
    private HashMap pageMaps = new HashMap();
    private HashMap portletMaps = new HashMap();
    private HashMap colCollectionMaps = new HashMap();

    public PortalContextBean(CoreBaseCollection argPageCollection) {
        int i;
        PageInfo pageInfo = null;
        PortletPreferencesInfo portletInfo = null;
        Iterator colIterator = null;
        Iterator portletIterator = null;
        PageDescriptionInfo descInfo = null;
        PageStateEnum state = null;
        ArrayList<PageInfo> subPageList = new ArrayList<PageInfo>();
        int nNum = argPageCollection.size();
        int n = 0;
        for (i = 0; i < nNum; ++i) {
            pageInfo = (PageInfo)argPageCollection.get(i);
            if (pageInfo == null || (descInfo = pageInfo.getPageDescription()) == null || (state = descInfo.getPageState()) == null || state.getValue() != 20 || pageInfo.getParent() == null) continue;
            subPageList.add(pageInfo);
        }
        for (i = 0; i < nNum; ++i) {
            pageInfo = (PageInfo)argPageCollection.get(i);
            if (pageInfo == null || (descInfo = pageInfo.getPageDescription()) == null || (state = descInfo.getPageState()) == null || state.getValue() != 20 || pageInfo.getIsDirectory() == 1 && this.isPageDirectoryIneffect(pageInfo, subPageList)) continue;
            if (n == 0 || pageInfo.getIsDefaultOpen() == 1) {
                this.defaultPageIndex = n;
                this.defaultPageId = pageInfo.getId().toString();
            }
            this.pageCollection.add((CoreBaseInfo)pageInfo);
            this.pageMaps.put(pageInfo.getId().toString(), "" + n);
            ++n;
            ColCollection cc = pageInfo.getTab().getLayout().getCols();
            this.colCollectionMaps.put(pageInfo.getId().toString(), cc);
            colIterator = cc.iterator();
            while (colIterator.hasNext()) {
                portletIterator = ((ColInfo)colIterator.next()).getPortlets().iterator();
                while (portletIterator.hasNext()) {
                    portletInfo = (PortletPreferencesInfo)portletIterator.next();
                    this.portletMaps.put(portletInfo.getId(), portletInfo);
                }
            }
        }
        this.setNCurrentPages(n);
    }

    private boolean isPageDirectoryIneffect(PageInfo pageInfo, ArrayList subPageInfoList) {
        boolean flag = true;
        if (pageInfo == null) {
            return true;
        }
        PageStateEnum pageState = null;
        int isDirectory = pageInfo.getIsDirectory();
        if (isDirectory == 1) {
            for (int i = 0; i < subPageInfoList.size(); ++i) {
                PageInfo subPageInfo = (PageInfo)subPageInfoList.get(i);
                PageInfo parentPage = subPageInfo.getParent();
                if (pageInfo == null || !pageInfo.getId().equals((Object)parentPage.getId()) || (pageState = subPageInfo.getPageDescription().getPageState()) == null || pageState.getValue() != 20) continue;
                if (subPageInfo.getIsDirectory() == 1) {
                    if (this.isPageDirectoryIneffect(subPageInfo, subPageInfoList)) continue;
                    flag = false;
                } else {
                    flag = false;
                }
                break;
            }
        } else {
            flag = false;
        }
        return flag;
    }

    public void addPortletPreferencesInfo(PortletPreferencesInfo portletPreferencesInfo) {
        this.portletMaps.put(portletPreferencesInfo.getId(), portletPreferencesInfo);
    }

    public void removePortletPreferencesInfo(PortletPreferencesInfo portletPreferencesInfo) {
        this.portletMaps.remove(portletPreferencesInfo.getId());
    }

    public ColInfo getColInfo(int pageIndex, int colNum) {
        ColCollection cols = this.getPageInfo(pageIndex).getTab().getLayout().getCols();
        int n = cols.size();
        if (colNum >= n) {
            colNum = n - 1;
        } else if (colNum < 0) {
            colNum = 0;
        }
        return cols.get(colNum);
    }

    public ColCollection getColCollection(String pageID) {
        if (pageID == null) {
            return ((PageInfo)this.pageCollection.get(0)).getTab().getLayout().getCols();
        }
        return (ColCollection)((Object)this.colCollectionMaps.get(pageID));
    }

    public LayoutInfo getLayoutInfo(String pageID) {
        LayoutInfo layoutInfo = this.getPageInfo(pageID).getTab().getLayout();
        return layoutInfo;
    }

    public PageInfo getPageInfo(int tabKey) {
        if (tabKey < 0) {
            tabKey = 0;
        }
        if (tabKey >= this.pageCollection.size()) {
            tabKey = this.pageCollection.size() - 1;
        }
        return (PageInfo)this.pageCollection.get(tabKey);
    }

    public String getTabIndex(String pageID) {
        if (pageID == null || pageID.equals("0")) {
            return "0";
        }
        return this.pageMaps.get(pageID).toString();
    }

    public String[] getTabIndexAndIdByNumber(String pageNumber) {
        String[] returns = new String[2];
        if (pageNumber == null || pageNumber.equals("")) {
            returns[0] = this.defaultPageId;
            returns[1] = "" + this.defaultPageIndex;
            return returns;
        }
        int size = this.pageCollection.size();
        PageInfo pageInfo = null;
        for (int i = 0; i < size; ++i) {
            pageInfo = (PageInfo)this.pageCollection.get(i);
            if (pageInfo == null || !pageNumber.equals(pageInfo.getPageNumber())) continue;
            returns[0] = pageInfo.getId().toString();
            returns[1] = this.pageMaps.get(returns[0]).toString();
            return returns;
        }
        returns[0] = this.defaultPageId;
        returns[1] = "" + this.defaultPageIndex;
        return returns;
    }

    public PageInfo getPageInfo(String pageID) {
        if (pageID == null) {
            return (PageInfo)this.pageCollection.get(0);
        }
        if (pageID.equals("0")) {
            return (PageInfo)this.pageCollection.get(0);
        }
        int n = new Integer(this.pageMaps.get(pageID).toString());
        return (PageInfo)this.pageCollection.get(n);
    }

    public PortletPreferencesInfo getPortletPreferencesInfo(BOSUuid id) {
        return (PortletPreferencesInfo)this.portletMaps.get(id);
    }

    public CoreBaseCollection getPages() {
        return this.pageCollection;
    }

    public boolean isConfigPageVisible() {
        return this.configPageVisible;
    }

    public void setConfigPageVisible(boolean configPageVisible) {
        this.configPageVisible = configPageVisible;
    }

    public int getNCurrentPages() {
        return this.nCurrentPages;
    }

    public void setNCurrentPages(int currentPages) {
        this.nCurrentPages = currentPages;
    }

    public String getDefaultPageId() {
        return this.defaultPageId;
    }

    public void setDefaultPageId(String defaultPageId) {
        this.defaultPageId = defaultPageId;
    }

    public int getDefaultPageIndex() {
        return this.defaultPageIndex;
    }

    public void setDefaultPageIndex(int defaultPageIndex) {
        this.defaultPageIndex = defaultPageIndex;
    }
}

