/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.portal.web.control;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.portal.web.util.PortalUtil;
import com.kingdee.eas.util.app.ContextUtil;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.tiles.TilesRequestProcessor;
import org.xml.sax.SAXException;

public class PortalRequestProcessor
extends TilesRequestProcessor {
    private static final Logger logger = CoreUIObject.getLogger(PortalRequestProcessor.class);
    private static final String STRUTS_ACTION_NAME = "struts_action_name";
    private static final String PORTLETS_ACTION_FORWARDS = "com.kingdee.eas.portal.web.control.PORTLETS_ACTION_FORWARDS";
    private static HashMap HashMapSystemUrl = new HashMap();

    protected boolean processPreprocess(HttpServletRequest request, HttpServletResponse response) {
        if (this.isRenderRequest(request)) {
            try {
                this.render(request, response);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return true;
        }
        return super.processPreprocess(request, response);
    }

    private boolean isActionRequest(HttpServletRequest request) {
        return "1".equals(request.getParameter("p_p_action")) && request.getAttribute("haveDoAction") == null;
    }

    private void render(HttpServletRequest request, HttpServletResponse response) throws EASBizException, BOSException, InstantiationException, IllegalAccessException, ClassNotFoundException, IOException, SAXException {
        Context _userCtx = WebContextUtil.getEasContext((HttpServletRequest)request);
        String _realname = "";
        Object portalBean = request.getSession().getAttribute("com.kingdee.portal.web.control.PORTAL_CONTEXT_BEAN");
        if (portalBean != null) {
            return;
        }
        try {
            _realname = ContextUtil.getCurrentUserInfo((Context)_userCtx).getId().toString();
        }
        catch (Exception e) {
            logger.warn((Object)e.toString());
        }
        PortalUtil.setPortalContext(request, _userCtx, _realname);
    }

    private boolean isRenderRequest(HttpServletRequest request) {
        return "1".equals(request.getParameter("p_p_action")) && request.getAttribute("haveDoAction") == null;
    }

    protected String processPath(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.isActionRequest(request)) {
            String actionName = request.getParameter(STRUTS_ACTION_NAME);
            if (StringUtils.isNotBlank((String)actionName)) {
                return actionName;
            }
            String path = super.processPath(request, response);
            return path;
        }
        String path = super.processPath(request, response);
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ActionForward processActionPerform(HttpServletRequest request, HttpServletResponse response, Action action, ActionForm form, ActionMapping mapping) throws IOException, ServletException {
        try {
            boolean isActionRequest = this.isActionRequest(request);
            if (isActionRequest && StringUtils.isNotBlank((String)request.getParameter(STRUTS_ACTION_NAME)) && request.getAttribute("haveDoAction") == null) {
                ActionForward actionForward = super.processActionPerform(request, response, action, form, mapping);
                HttpSession session = request.getSession();
                HashMap<String, ActionForward> hashMap = null;
                HttpSession httpSession = session;
                synchronized (httpSession) {
                    hashMap = (HashMap<String, ActionForward>)session.getAttribute(PORTLETS_ACTION_FORWARDS);
                    if (hashMap == null) {
                        hashMap = new HashMap<String, ActionForward>();
                    }
                    if (!HashMapSystemUrl.containsKey(request.getParameter(STRUTS_ACTION_NAME))) {
                        hashMap.put(request.getParameter("portal_portlet_instance_id"), actionForward);
                        session.setAttribute(PORTLETS_ACTION_FORWARDS, hashMap);
                    }
                }
                StringBuffer url = new StringBuffer("/layout.do");
                request.setAttribute("haveDoAction", (Object)"1");
                ActionForward forward = new ActionForward(url.toString(), false);
                return forward;
            }
            return super.processActionPerform(request, response, action, form, mapping);
        }
        catch (Exception e) {
            return this.processException(request, response, e, form, mapping);
        }
    }

    static {
        HashMapSystemUrl.put("/closeportlet", "/closeportlet");
        HashMapSystemUrl.put("/openportlet", "/openportlet");
        HashMapSystemUrl.put("/moveportlet", "/moveportlet");
    }
}

