/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.portal.web.util;

import com.kingdee.eas.base.license.ILicenseSrvAgent;
import com.kingdee.eas.base.license.LicenseBaseInfo;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.portal.web.util.ProductInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.util.Base64Encoder;
import com.kingdee.util.DateTimeUtils;
import java.security.MessageDigest;
import java.util.Date;
import net.buffalo.server.BuffaloService;
import org.apache.log4j.Logger;

public class ProductService
extends BuffaloService {
    private static Logger logger = Logger.getLogger(ProductService.class);
    public static final String IP_link = "http://service.kingdee.com/csso/customer/getClientIP.action";
    public static final String SERVICE_LOGIN_URL = "http://service.kingdee.com/csso/customer/productLogin.action";
    public static final String SERVICE_SITE = "http://service.kingdee.com/";
    public static final String SERVICE_HELP = "http://csrc.kingdee.com";

    public static String getProductService(String ip) throws Exception {
        String onlineServiceURL = null;
        ProductInfo productInfo = new ProductInfo();
        ILicenseSrvAgent agent = LicenseSrvAgentFactory.getRemoteInstance();
        LicenseBaseInfo baseInfo = agent.getLicenseBaseInfo();
        productInfo.isRegister = baseInfo.isRegistedVersion();
        productInfo.serviceDate = baseInfo.getServiceDate();
        productInfo.serialNum = baseInfo.getSerialNum();
        productInfo.licenseTo = baseInfo.getLicenseTo();
        String no = agent.getProductNo();
        System.err.println("no==" + no);
        logger.info((Object)(productInfo.isRegister + "," + productInfo.serviceDate + "," + no));
        if (no != null) {
            no = Base64Encoder.byteArrayToBase64((byte[])no.getBytes());
        }
        logger.info((Object)("base64 ProductNo=" + no));
        productInfo.productNo = no;
        if (productInfo.isRegister) {
            String hash;
            Date curDate;
            productInfo.serverDate = curDate = SysUtil.getAppServerTime(null);
            String dt = DateTimeUtils.format((Date)curDate, (String)"yyyy-MM-dd");
            String tempHash = no + dt + ip;
            logger.info((Object)("hash for not MD5 =" + tempHash));
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(tempHash.getBytes());
            productInfo.hash = hash = ProductService.bytesToHexString(md.digest());
        }
        onlineServiceURL = "http://service.kingdee.com/csso/customer/productLogin.action?productno=" + productInfo.productNo + "&hash=" + productInfo.hash + "&loginType=";
        return onlineServiceURL;
    }

    private static String bytesToHexString(byte[] bt) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < bt.length; ++i) {
            String s = Integer.toHexString(bt[i] & 0xFF);
            if (s.length() == 1) {
                buffer.append("0");
            }
            buffer.append(s);
        }
        return buffer.toString();
    }
}

