/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.lightapp.message;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.lightapp.pa.MessageModelEnum;
import com.kingdee.lightapp.pa.MessageTypeEnum;
import com.kingdee.lightapp.pa.api.IMessageAdapter;
import com.kingdee.lightapp.xt.XTServiceConfig;
import com.kingdee.util.StringUtils;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.apache.log4j.Logger;

public class WFProcessinstAdapter
implements IMessageAdapter {
    private static Logger logger = Logger.getLogger(WFProcessinstAdapter.class);
    private Message message = null;
    private Context ctx = null;
    private MessageModelEnum messageModel = null;
    Map<String, Object> contents = null;

    @Override
    public boolean isNeedSendXT() {
        return true;
    }

    public WFProcessinstAdapter(Message message) {
        logger.debug((Object)"WFProcessinstAdapter init");
        this.message = message;
        this.ctx = WFProcessinstAdapter.createContext(message.getStringHeader("solution"), message.getStringHeader("databaseCenter"));
        this.initMessageModel();
    }

    @Override
    public MessageTypeEnum getType() {
        return MessageTypeEnum.LINK;
    }

    @Override
    public MessageModelEnum getModel() {
        return this.messageModel;
    }

    @Override
    public Map<String, Object> getContent() {
        String mbosUrl;
        if (this.contents != null) {
            return this.contents;
        }
        HashMap<String, Object> contents = new HashMap<String, Object>();
        Map<String, Object> content = this.parseContent();
        contents.put("wxtitle", "\u6d88\u606f\u901a\u77e5");
        contents.putAll(content);
        String assignid = this.message.getStringHeader("assignid");
        String dbCode = this.ctx.getAIS();
        String fproinstid = this.message.getStringHeader("ProcessInstId");
        String initiatorId = URLEncoder.encode(this.message.getStringHeader("initiatorId"));
        String eid = XTServiceConfig.getInstance().getEidByDbCode(dbCode);
        String host = XTServiceConfig.getInstance().getPubAcctProperty(eid, "WFMessage", "host", "");
        String appId = XTServiceConfig.getInstance().getPubAcctProperty(eid, "WFMessage", "appId", "");
        String newEid = XTServiceConfig.getInstance().getPubAcctProperty(eid, "WFMessage", "eid", "");
        String procid = this.message.getStringHeader("ProcessDefId");
        String actDefId = this.message.getStringHeader("activityDefId");
        String url = host;
        if (!(StringUtils.isEmpty((String)procid) || StringUtils.isEmpty((String)actDefId) || StringUtils.isEmpty((String)(mbosUrl = this.getMbosUrl(procid, actDefId, fproinstid))))) {
            url = mbosUrl.replace("page/loadPage", "mbosw/getWorkflowUrl");
        }
        if (url.indexOf("?") > -1) {
            if (url.indexOf("name") == -1) {
                url = url + "&storeEid=21231&name=approveui.navui";
            }
            url = url + "&viewtype=message&eid=" + newEid + "&type=message&fpersonuserid=" + initiatorId + "&appid=" + appId + "&fprocinstid=" + fproinstid + "&actDefId=" + actDefId;
        } else {
            url = url + "/otherDetails.html?viewtype=message&eid=" + newEid + "&type=message&fpersonuserid=" + initiatorId + "&appid=" + appId + "&fprocinstid=" + fproinstid;
        }
        contents.put("url", url);
        contents.put("appid", appId);
        contents.put("procinstid", fproinstid);
        contents.put("sendId", this.message.getStringHeader("initiatorId"));
        contents.put("receiver", this.message.getStringHeader("receiver"));
        contents.put("todo", "0");
        if (MessageModelEnum.FLOWCENTERNOTICE.equals((Object)this.messageModel)) {
            contents.put("itemtitle", this.message.getLocaleStringHeader("title", new Locale("L2")));
            contents.put("text", this.message.getLocaleStringHeader("body", new Locale("L2")));
            contents.put("tagId", "notify");
            contents.put("assignId", UUID.randomUUID() + "LCZSITEM");
        }
        return contents;
    }

    private String getMbosUrl(String procid, String actDefId, String procinstId) {
        String url = "";
        try {
            IRowSet rowSet;
            StringBuffer sql = new StringBuffer("SELECT url FROM T_WFR_MBOS_WORKFLOW  ");
            if (!StringUtils.isEmpty((String)actDefId)) {
                sql.append(" WHERE actDefId in ('" + actDefId + "')");
            }
            if (!StringUtils.isEmpty((String)procid)) {
                sql.append(" and procdefid in ('" + procid + "')");
            }
            if ((rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString())).next()) {
                url = rowSet.getString("url");
            }
            if (!StringUtils.isEmpty((String)url)) {
                IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)this.ctx);
                String billid = service.getBizObjIdByProcessInstanceId(procinstId);
                url = url + "&billID=" + URLEncoder.encode(billid);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return url;
    }

    private Map<String, Object> parseContent() {
        HashMap<String, Object> contents = new HashMap<String, Object>();
        String msgContent = null;
        if (msgContent == null || msgContent.equals("")) {
            msgContent = this.message.getLocaleStringHeader("title", new Locale("L2"));
            msgContent = msgContent + "\n\u6d88\u606f\u5185\u5bb9\uff1a" + this.message.getLocaleStringHeader("body", new Locale("L2"));
        }
        contents.put("text", msgContent);
        logger.info((Object)("XT Message parseContext() body=" + this.message.getLocaleStringHeader("body", new Locale("L2")) + ",title=" + this.message.getLocaleStringHeader("title", new Locale("L2"))));
        return contents;
    }

    @Override
    public List<String> getUsers() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            IUser user = UserFactory.getLocalInstance((Context)this.ctx);
            String msgReceiver = this.message.getStringHeader("receiver");
            logger.info((Object)("XT Message getUsers() msgReceiver: " + msgReceiver));
            if (msgReceiver != null) {
                list.add(msgReceiver);
                logger.info((Object)("XT Message getUsers() userID:" + msgReceiver));
            }
        }
        catch (Exception e) {
            logger.error((Object)"XT Message getUsers() error!", (Throwable)e);
        }
        return list;
    }

    @Override
    public Date getUpdateTime() {
        return new Date();
    }

    @Override
    public void clearTemporary() {
    }

    private static Context createContext(String solution, String ais) {
        Context context = new Context((IObjectPK)new ObjectUuidPK(), solution, ais, new Locale("l2"));
        return context;
    }

    private void initMessageModel() {
        boolean ifInit = false;
        String apiVersion = XTServiceConfig.getInstance().getXTInfoProperties().get("apiVersion");
        try {
            String initiatorId;
            String quarySql;
            IRowSet rowSet;
            String procinstid = this.message.getStringHeader("ProcessInstId");
            if ("flowcenter".equalsIgnoreCase(apiVersion) && !StringUtils.isEmpty((String)procinstid) && (rowSet = DbUtil.executeQuery((Context)this.ctx, (String)(quarySql = "SELECT 1 FROM T_PM_EASXTUSERMAP WHERE FUSERID = ? OR FPERSONID = ? "), (Object[])new Object[]{initiatorId = this.message.getStringHeader("initiatorId"), initiatorId})).next()) {
                ifInit = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)"XT Message ifInitFlowCenterMoudle error!", (Throwable)e);
        }
        if (ifInit) {
            this.messageModel = MessageModelEnum.FLOWCENTERNOTICE;
        }
    }
}

