/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.lightapp.welink;

import com.alibaba.fastjson.JSON;
import com.kingdee.lightapp.exception.WorkflowException;
import com.kingdee.lightapp.exception.enums.WorkflowErrorEnums;
import com.kingdee.lightapp.pa.api.HttpClientUtil;
import com.kingdee.lightapp.welink.WeLinkUrlContants;
import com.kingdee.lightapp.xt.XTServiceConfig;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class WeLinkAPIInvokeUtil {
    private static final Logger logger = Logger.getLogger(WeLinkAPIInvokeUtil.class);
    private static ConcurrentHashMap<String, AccessTokenInfo> accessTokenMap = new ConcurrentHashMap();

    public static String pushTodoMessage(String msg, String welinkClientId) throws Exception {
        String accessToken = WeLinkAPIInvokeUtil.getAccessToken(welinkClientId);
        String url = WeLinkUrlContants.PUSH_TODO_URL;
        HashMap<String, String> headMap = new HashMap<String, String>();
        headMap.put("x-wlk-Authorization", accessToken);
        XTServiceConfig instance = XTServiceConfig.getInstance();
        String x_hw_id = instance.getWeLinkConfig("X-HW-ID");
        String x_hw_appkey = instance.getWeLinkConfig("X-HW-APPKEY");
        headMap.put("X-HW-ID", x_hw_id);
        headMap.put("X-HW-APPKEY", x_hw_appkey);
        return HttpClientUtil.doPost(url, msg, headMap, "UTF-8");
    }

    public static String pushNoticeMessage(String msg, String welinkClientId) throws Exception {
        String accessToken = WeLinkAPIInvokeUtil.getAccessToken(welinkClientId);
        String url = WeLinkUrlContants.PUSH_NOTICE_URL;
        HashMap<String, String> headMap = new HashMap<String, String>();
        headMap.put("x-wlk-Authorization", accessToken);
        XTServiceConfig instance = XTServiceConfig.getInstance();
        String x_hw_id = instance.getWeLinkConfig("X-HW-ID");
        String x_hw_appkey = instance.getWeLinkConfig("X-HW-APPKEY");
        headMap.put("X-HW-ID", x_hw_id);
        headMap.put("X-HW-APPKEY", x_hw_appkey);
        return HttpClientUtil.doPost(url, msg, headMap, "UTF-8");
    }

    public static String updateTodoMessage(Map<String, String> dealMap, String welinkClientId) throws Exception {
        String accessToken = WeLinkAPIInvokeUtil.getAccessToken(welinkClientId);
        String url = WeLinkUrlContants.UPDATE_TODO_URL;
        String param = "";
        if (dealMap != null && dealMap.size() > 0) {
            Set<String> keySet = dealMap.keySet();
            StringBuilder paramBuilder = new StringBuilder();
            for (String key : keySet) {
                paramBuilder.append("&");
                paramBuilder.append(key);
                paramBuilder.append("=");
                paramBuilder.append(dealMap.get(key));
            }
            param = paramBuilder.replace(0, 1, "?").toString();
        }
        url = url + param;
        HashMap<String, String> headMap = new HashMap<String, String>();
        headMap.put("x-wlk-Authorization", accessToken);
        XTServiceConfig instance = XTServiceConfig.getInstance();
        String x_hw_id = instance.getWeLinkConfig("X-HW-ID");
        String x_hw_appkey = instance.getWeLinkConfig("X-HW-APPKEY");
        headMap.put("X-HW-ID", x_hw_id);
        headMap.put("X-HW-APPKEY", x_hw_appkey);
        return HttpClientUtil.doPut(url, JSON.toJSONString(dealMap), headMap, "UTF-8");
    }

    public static String deleteTodoMessage(Map<String, String> dealMap, String welinkClientId) throws Exception {
        String accessToken = WeLinkAPIInvokeUtil.getAccessToken(welinkClientId);
        String url = WeLinkUrlContants.DELETE_TODO_URL;
        String param = "";
        if (dealMap != null && dealMap.size() > 0) {
            Set<String> keySet = dealMap.keySet();
            StringBuilder paramBuilder = new StringBuilder();
            for (String key : keySet) {
                paramBuilder.append("&");
                paramBuilder.append(key);
                paramBuilder.append("=");
                paramBuilder.append(dealMap.get(key));
            }
            param = paramBuilder.replace(0, 1, "?").toString();
        }
        url = url + param;
        HashMap<String, String> headMap = new HashMap<String, String>();
        headMap.put("x-wlk-Authorization", accessToken);
        XTServiceConfig instance = XTServiceConfig.getInstance();
        String x_hw_id = instance.getWeLinkConfig("X-HW-ID");
        String x_hw_appkey = instance.getWeLinkConfig("X-HW-APPKEY");
        headMap.put("X-HW-ID", x_hw_id);
        headMap.put("X-HW-APPKEY", x_hw_appkey);
        return HttpClientUtil.doDelete(url, headMap, "UTF-8");
    }

    public static String getAccessToken(String welinkClientId) {
        AccessTokenInfo accessTokenInfo;
        block9: {
            long curTime;
            long passTime;
            accessTokenInfo = null;
            if (StringUtils.isEmpty((String)welinkClientId)) {
                throw new WorkflowException(WorkflowErrorEnums.CONFIG_ERROR_NOAPPSECRET, null, welinkClientId);
            }
            if (accessTokenMap.get(welinkClientId) != null && !StringUtils.isEmpty((String)(accessTokenInfo = accessTokenMap.get(welinkClientId)).accessToken) && (passTime = (curTime = System.currentTimeMillis()) - accessTokenInfo.accessTokenTime) / 1000L < accessTokenInfo.expireTime) {
                return accessTokenInfo.accessToken;
            }
            XTServiceConfig instance = XTServiceConfig.getInstance();
            String clientSecret = instance.getAppSecret(welinkClientId);
            if (StringUtils.isEmpty((String)clientSecret)) {
                logger.error((Object)"===  WeLinkLogin getAccessToken no AppSecret ===");
                throw new WorkflowException(WorkflowErrorEnums.CONFIG_ERROR_NOAPPSECRET, null, clientSecret);
            }
            String url = WeLinkUrlContants.GET_ACCESSTOKEN_URL;
            try {
                if (accessTokenInfo == null) {
                    accessTokenInfo = new AccessTokenInfo();
                }
                accessTokenInfo.accessTokenTime = System.currentTimeMillis();
                HashMap<String, String> param = new HashMap<String, String>();
                param.put("client_id", welinkClientId);
                param.put("client_secret", clientSecret);
                HashMap<String, String> headMap = new HashMap<String, String>();
                String x_hw_id = instance.getWeLinkConfig("X-HW-ID");
                String x_hw_appkey = instance.getWeLinkConfig("X-HW-APPKEY");
                headMap.put("X-HW-ID", x_hw_id);
                headMap.put("X-HW-APPKEY", x_hw_appkey);
                String weLinkResult = HttpClientUtil.doPost(url, JSON.toJSONString(param), headMap, "UTF-8");
                if (StringUtils.isEmpty((String)weLinkResult)) break block9;
                JSONObject jsonObj = new JSONObject(weLinkResult);
                if ("0".equals(jsonObj.get("code")) && "ok".equalsIgnoreCase(jsonObj.getString("message"))) {
                    accessTokenInfo.accessToken = jsonObj.getString("access_token");
                    accessTokenInfo.expireTime = Long.parseLong(jsonObj.getString("expires_in"));
                    accessTokenMap.put(welinkClientId, accessTokenInfo);
                    break block9;
                }
                logger.error((Object)("WeLinkLogin getAccessToken error: " + weLinkResult));
                throw new WorkflowException(WorkflowErrorEnums.CONNET_WELINKTOKENURL_EXCEPTION, null, jsonObj.getString("message"));
            }
            catch (WorkflowException e) {
                logger.error((Object)("WeLinkLogin getAccessToken url:" + url));
                logger.error((Object)"WeLinkLogin getAccessToken Exception", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                logger.error((Object)("WeLinkLogin getAccessToken url:" + url));
                logger.error((Object)"WeLinkLogin getAccessToken Exception", (Throwable)e);
                throw new WorkflowException(WorkflowErrorEnums.CONNET_WELINKTOKENURL_EXCEPTION, null, e.getMessage());
            }
        }
        if (StringUtils.isEmpty((String)accessTokenInfo.accessToken)) {
            logger.error((Object)"WeLinkLogin getAccessToken isEmpty: ");
            throw new WorkflowException(WorkflowErrorEnums.CONNET_WELINKTOKENURL_EXCEPTION, null, welinkClientId);
        }
        return accessTokenInfo.accessToken;
    }

    public static HashMap<String, Object> getUseridInfo(String userid, String welinkClientId) {
        String accessToken = WeLinkAPIInvokeUtil.getAccessToken(welinkClientId);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String url = WeLinkUrlContants.GET_USERDETAILINFO_URL;
        try {
            JSONObject jsonObj;
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("corpUserId", userid);
            HashMap<String, String> headMap = new HashMap<String, String>();
            headMap.put("x-wlk-Authorization", accessToken);
            headMap.put("Content-Type", "application/json");
            XTServiceConfig instance = XTServiceConfig.getInstance();
            String x_hw_id = instance.getWeLinkConfig("X-HW-ID");
            String x_hw_appkey = instance.getWeLinkConfig("X-HW-APPKEY");
            headMap.put("X-HW-ID", x_hw_id);
            headMap.put("X-HW-APPKEY", x_hw_appkey);
            String weLinkResult = HttpClientUtil.doPost(url, JSON.toJSONString(param), headMap, "UTF-8");
            if (!StringUtils.isEmpty((String)weLinkResult) && "0".equals((jsonObj = new JSONObject(weLinkResult)).get("code")) && "ok".equalsIgnoreCase(jsonObj.getString("message"))) {
                Iterator keys = jsonObj.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    resultMap.put(key, jsonObj.getString(key));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("WeLinkAPIInvokeUtil getUseridInfo url:" + url));
            logger.error((Object)"WeLinkAPIInvokeUtil getUseridInfo Exception", (Throwable)e);
            throw new WorkflowException(WorkflowErrorEnums.CONNET_WELINKTOKENURL_EXCEPTION, null, userid);
        }
        return resultMap;
    }

    private static class AccessTokenInfo {
        private String accessToken = null;
        private long accessTokenTime = 0L;
        private long expireTime = 7000L;

        private AccessTokenInfo() {
        }
    }
}

