/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.lightapp.xt;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.MD5Util;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.lightapp.pa.api.HttpClientUtil;
import com.kingdee.lightapp.pa.api.YZJInvokeUtil;
import com.kingdee.lightapp.xt.XTServiceConfig;
import com.kingdee.lightapp.xt.YZJUrlContants;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class YZJFlowCenterMouldHandler {
    private static YZJFlowCenterMouldHandler instance = null;
    private static HashMap<String, String> MOULDMAP = null;
    private static HashMap<String, String> MOULDFIELDMD5MAP = null;
    private static String MOULDSORTNAME = "EAS\u6d41\u7a0b\u52a9\u624b";
    private static String MOULDTYPENAME = "EAS\u5355\u636e";
    private static Logger logger = Logger.getLogger(YZJFlowCenterMouldHandler.class);

    public static synchronized YZJFlowCenterMouldHandler getInstance() {
        if (instance == null) {
            instance = new YZJFlowCenterMouldHandler();
            MOULDMAP = new HashMap();
            MOULDFIELDMD5MAP = new HashMap();
        }
        return instance;
    }

    public String getMouldTypeId(Context ctx, String bosType) throws Exception {
        if (StringUtils.isEmpty((String)MOULDMAP.get(bosType))) {
            this.initMouldByBosType(ctx, bosType);
        }
        return MOULDMAP.get(bosType);
    }

    public String getMouldTypeId(Context ctx, String bosType, String fieldMD5String) throws Exception {
        if (StringUtils.isEmpty((String)MOULDMAP.get(bosType)) || StringUtils.isEmpty((String)MOULDFIELDMD5MAP.get(bosType))) {
            this.initMouldByBosType(ctx, bosType);
        }
        if (StringUtils.isEmpty((String)fieldMD5String) || !fieldMD5String.equals(MOULDFIELDMD5MAP.get(bosType))) {
            return null;
        }
        return MOULDMAP.get(bosType);
    }

    private void initMouldByBosType(Context ctx, String bosType) throws Exception {
        String sql = "SELECT FTYPEID,FMOULDFIELDMD5 FROM T_WFR_YZJFLOWCENTERMOULD WHERE FBOSTYPE = ? ";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{bosType});
        if (rowSet.next()) {
            String typeId = rowSet.getString(1);
            String mouldMD5 = rowSet.getString(2);
            MOULDMAP.put(bosType, typeId);
            MOULDFIELDMD5MAP.put(bosType, mouldMD5);
        }
    }

    public String initMould(Context ctx, String billId, String creatorOpenid, ArrayList<HashMap<String, Object>> fieldList) throws Exception {
        JSONObject initObject;
        boolean updateFlag = false;
        XTServiceConfig instance = XTServiceConfig.getInstance();
        String realeid = instance.getXTInfoProperties().get("realEid");
        String dbEid = instance.getEidByDbCode(ctx.getAIS());
        realeid = StringUtils.isEmpty((String)realeid) ? dbEid : realeid;
        String appid = instance.getPubAcctProperty(dbEid, "WFMessage", "appId", "");
        String teamAccessToken = YZJInvokeUtil.getInstance().getTeamAccessToken(realeid, appid, "");
        String mouldSortName = instance.getPubAcctProperty(dbEid, "WFMessage", "mouldSortName", "");
        mouldSortName = StringUtils.isEmpty((String)mouldSortName) ? MOULDSORTNAME : mouldSortName;
        BOSObjectType bosObjectType = BOSUuid.getBOSObjectType((String)billId, (boolean)true);
        String bosType = bosObjectType.toString();
        HashMap<String, Object> param = new HashMap<String, Object>();
        String typeId = "type-" + appid + "-" + bosType;
        String bosTypeName = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(bosObjectType).getAlias();
        bosTypeName = StringUtils.isEmpty((String)bosTypeName) ? MOULDTYPENAME : bosTypeName;
        String appidFlag = appid.substring(appid.length() - 4, appid.length());
        String typeName = bosTypeName + "-" + appidFlag;
        if (typeName.length() > 40) {
            bosTypeName = bosTypeName.substring(bosTypeName.length() - 40, bosTypeName.length());
        }
        String des = "EAS\u6d41\u7a0b\u52a9\u624b\u63a8\u9001" + bosTypeName + "\u6d88\u606f\u6a21\u677f\uff0c\u5e94\u7528ID\uff1a" + appid;
        String qrySql = "SELECT FTYPEID,FTYPENAME,FDESCRIPTION,FCREATOROPENID FROM T_WFR_YZJFLOWCENTERMOULD WHERE FBOSTYPE = ? ";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)qrySql, (Object[])new Object[]{bosType});
        if (rowSet.next()) {
            updateFlag = true;
            param.put("typeId", rowSet.getString("FTYPEID"));
            param.put("typeName", rowSet.getString("FTYPENAME"));
            param.put("creator", rowSet.getString("FCREATOROPENID"));
            param.put("description", rowSet.getString("FDESCRIPTION"));
        } else {
            param.put("typeName", typeName);
            param.put("creator", creatorOpenid);
            param.put("description", des);
        }
        param.put("typeId", typeId);
        param.put("appId", appid);
        param.put("appName", mouldSortName);
        String allFieldsKeysStr = "";
        ArrayList field4MouldList = new ArrayList();
        if (fieldList != null && fieldList.size() > 0) {
            for (HashMap<String, Object> fieldMap : fieldList) {
                HashMap<String, String> field = new HashMap<String, String>();
                String name = (String)fieldMap.get("name");
                field.put("title", (String)fieldMap.get("name"));
                field4MouldList.add(field);
                allFieldsKeysStr = allFieldsKeysStr + "|" + name;
            }
        }
        param.put("field", field4MouldList);
        String fieldMD5String = MD5Util.getMD5String((String)allFieldsKeysStr);
        String mouldParamStr = JSON.toJSONString(param);
        String url = YZJUrlContants.FLOWCENTER_INIT_URL + "?accessToken=" + teamAccessToken;
        logger.error((Object)("post mouldParamStr:" + mouldParamStr));
        String initResult = HttpClientUtil.doPost(url, mouldParamStr, "UTF-8");
        logger.error((Object)("mould initResult:" + initResult));
        boolean initSuccess = false;
        if (!StringUtils.isEmpty((String)initResult) && (initSuccess = (initObject = JSON.parseObject((String)initResult)).getBoolean("success").booleanValue())) {
            MOULDMAP.put(bosType, typeId);
            MOULDFIELDMD5MAP.put(bosType, fieldMD5String);
            if (updateFlag) {
                String updateSql = "UPDATE T_WFR_YZJFLOWCENTERMOULD SET FUPDATETIME = getdate(), FMOULDFIELDMD5 = ?  WHERE  FBOSTYPE = ? ";
                DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{fieldMD5String, bosType});
            } else {
                String insertsql = "INSERT INTO T_WFR_YZJFLOWCENTERMOULD(FTYPEID,FBOSTYPE,FAPPNAME,FTYPENAME, FDESCRIPTION,FCREATOROPENID,FMOULDFIELDMD5,FCREATETIME,FUPDATETIME) VALUES(?,?,?,?,?,?,?,getdate(),getdate())";
                DbUtil.execute((Context)ctx, (String)insertsql, (Object[])new Object[]{typeId, bosType, mouldSortName, typeName, des, creatorOpenid, fieldMD5String});
            }
        }
        if (!initSuccess) {
            logger.error((Object)("yzj flowcenter initMould failed:" + initResult));
            throw new Exception("\u667a\u80fd\u5ba1\u6279\u6a21\u677f\u672a\u6210\u529f\u521d\u59cb\u5316");
        }
        return typeId;
    }

    public void makeReinitMouldFlag(Context ctx, String billId) throws Exception {
        BOSObjectType bosObjectType = BOSUuid.getBOSObjectType((String)billId, (boolean)true);
        String bosType = bosObjectType.toString();
        MOULDFIELDMD5MAP.put(bosType, "need_reinit_mould_flag");
    }

    public void clearMouldMap() {
        MOULDMAP.clear();
        MOULDFIELDMD5MAP.clear();
    }
}

