/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.Context;
import com.kingdee.bos.orm.ORMCoreException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.mobile.IServerEngine;
import com.kingdee.eas.mobile.framework.ConnectionState;
import com.kingdee.eas.mobile.framework.ServerCenter;
import com.kingdee.eas.mobile.msg.BizModuleConfig;
import com.kingdee.eas.mobile.msg.CommunicateException;
import org.apache.log4j.Logger;

public class ServerEngine
extends AbstractBOSObject
implements IServerEngine {
    private Logger logger = Logger.getLogger(ServerEngine.class);

    public ServerEngine() {
        super.registerInterface(IServerEngine.class, (Object)this);
        this.logger.info((Object)"ServerEngine has newed!");
    }

    public ServerEngine(Context context) {
        super(context);
        super.registerInterface(IServerEngine.class, (Object)this);
        this.logger.info((Object)"ServerEngine has newed by context");
    }

    @Override
    public boolean saveConfig(BizModuleConfig config) throws ORMCoreException {
        this.logger.debug((Object)"saveConfig() start");
        ServerCenter instance = this.getServer();
        boolean ok = false;
        if (instance != null) {
            try {
                ok = instance.saveConfig(config);
            }
            catch (Exception e) {
                throw new ORMCoreException((Throwable)e);
            }
        }
        return ok;
    }

    @Override
    public BizModuleConfig loadConfig() throws ORMCoreException {
        this.logger.debug((Object)"loadConfig() start");
        ServerCenter instance = this.getServer();
        return instance.loadConfig();
    }

    @Override
    public boolean start() throws ORMCoreException, CommunicateException {
        boolean success = false;
        ServerCenter instance = this.getServer();
        if (instance != null) {
            success = instance.start();
        }
        return success;
    }

    @Override
    public boolean stop() throws ORMCoreException {
        ServerCenter instance = this.getServer();
        if (instance != null) {
            instance.stop();
        }
        return true;
    }

    @Override
    public boolean connect() throws ORMCoreException, CommunicateException {
        this.logger.debug((Object)"connect");
        ServerCenter instance = this.getServer();
        if (instance != null) {
            boolean isConnected = instance.connect();
            return isConnected;
        }
        throw new CommunicateException("\u521b\u5efaServerCenter\u5b9e\u4f8b\u5931\u8d25");
    }

    @Override
    public boolean disConnect() throws ORMCoreException {
        this.logger.debug((Object)"disConnect");
        ServerCenter instance = this.getServer();
        if (instance != null) {
            instance.disConnect();
            return true;
        }
        return false;
    }

    @Override
    public ConnectionState getEngineState() throws ORMCoreException {
        this.logger.debug((Object)"start");
        ServerCenter instance = this.getServer();
        if (instance != null) {
            return instance.getCurState();
        }
        return null;
    }

    public BOSObjectType getType() {
        return IServerEngine.BOSTYPE;
    }

    private ServerCenter getServer() {
        this.logger.debug((Object)"getServer");
        Context ctx = this.getContext();
        ServerCenter instance = ServerCenter.getInstance(ctx);
        return instance;
    }
}

