/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mobile.ChargeCompanyCollection;
import com.kingdee.eas.mobile.ChargeCompanyInfo;
import com.kingdee.eas.mobile.MobileException;
import com.kingdee.eas.mobile.app.AbstractChargeCompanyControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class ChargeCompanyControllerBean
extends AbstractChargeCompanyControllerBean {
    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ChargeCompanyInfo info = (ChargeCompanyInfo)model;
        String cuId = info.getCu().getId().toString();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("cu.id", (Object)cuId));
        if (this._exists(ctx, filterInfo)) {
            throw new MobileException(MobileException.CU_EXISTS);
        }
        return super._addnew(ctx, model);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ChargeCompanyInfo info = (ChargeCompanyInfo)model;
        String cuId = info.getCu().getId().toString();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("cu.id", (Object)cuId));
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)pk.toString(), CompareType.NOTEQUALS));
        if (this._exists(ctx, filterInfo)) {
            throw new MobileException(MobileException.CU_EXISTS);
        }
        super._update(ctx, pk, model);
    }

    @Override
    protected IObjectValue _getChargeCompanyInfoByCU(Context ctx, IObjectPK cuPK) throws BOSException, EASBizException {
        if (this._exists(ctx, "where cu.id = '" + cuPK.toString() + "'")) {
            return this._getValue(ctx, "select *, company.number, company.name where cu.id = '" + cuPK.toString() + "'");
        }
        return null;
    }

    @Override
    protected HashMap _getChargeCompanyColByCUs(Context ctx, ArrayList cuList) throws BOSException, EASBizException {
        HashMap<String, ChargeCompanyInfo> result = new HashMap<String, ChargeCompanyInfo>();
        if (cuList == null || cuList.size() == 0) {
            return result;
        }
        HashSet idSet = new HashSet(cuList);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        viewInfo.getSelector().add(new SelectorItemInfo("company.*"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("cu.id", idSet, CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        ChargeCompanyCollection chargeCompanyCol = this.getChargeCompanyCollection(ctx, viewInfo);
        for (int i = 0; i < chargeCompanyCol.size(); ++i) {
            ChargeCompanyInfo chargeCompanyInfo = chargeCompanyCol.get(i);
            result.put(chargeCompanyInfo.getCu().getId().toString(), chargeCompanyInfo);
        }
        return result;
    }

    @Override
    protected void _saveChargeMapping(Context ctx, HashMap chargeMap) throws BOSException, EASBizException {
        if (chargeMap == null || chargeMap.size() == 0) {
            return;
        }
        for (String cuId : chargeMap.keySet()) {
            String companyId = (String)chargeMap.get(cuId);
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("cu.id", (Object)cuId, CompareType.EQUALS));
            this._delete(ctx, filterInfo);
            if (companyId == null) continue;
            String id = BOSUuid.create((String)"63A977F5").toString();
            String insertSql = "INSERT INTO T_MO_ChargeCompany VALUES (?, ?, ?)";
            Object[] params = new Object[]{id, cuId, companyId};
            DbUtil.execute((Context)ctx, (String)insertSql, (Object[])params);
        }
    }

    @Override
    protected IObjectValue _getChargeCompanyInfoByCU(Context ctx, String id) throws BOSException, EASBizException {
        return this.getChargeCompanyInfoByCU(ctx, (IObjectPK)new ObjectUuidPK(id));
    }
}

