/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mobile.IMsgFacade;
import com.kingdee.eas.mobile.MobileMessageAssignCollection;
import com.kingdee.eas.mobile.MobileMessageAssignInfo;
import com.kingdee.eas.mobile.MsgFacadeFactory;
import com.kingdee.eas.mobile.app.AbstractMobileMessageAssignControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.log4j.Logger;

public class MobileMessageAssignControllerBean
extends AbstractMobileMessageAssignControllerBean {
    private static Logger logger = Logger.getLogger((String)MobileMessageAssignControllerBean.class.getName());

    protected boolean _assignSet(Context ctx, IObjectValue assignValue, String[] userIDS) throws BOSException {
        boolean flag = false;
        if (assignValue == null || userIDS == null || userIDS.length == 0) {
            return flag;
        }
        MobileMessageAssignInfo info = (MobileMessageAssignInfo)assignValue;
        StringBuffer sqlBf = new StringBuffer();
        if (info.getAppendCount() == 0) {
            sqlBf.append("delete  from T_MO_MobileMessageAssign where FUserID in(");
            for (int i = 0; i < userIDS.length; ++i) {
                if (i == 0) {
                    sqlBf.append("'");
                    sqlBf.append(userIDS[i]);
                    sqlBf.append("'");
                    continue;
                }
                sqlBf.append(",'");
                sqlBf.append(userIDS[i]);
                sqlBf.append("'");
            }
            sqlBf.append(")");
            UserInfo uInfo = null;
            try {
                DbUtil.execute((Context)ctx, (String)sqlBf.toString());
                for (int i = 0; i < userIDS.length; ++i) {
                    uInfo = new UserInfo();
                    uInfo.setId(BOSUuid.read((String)userIDS[i]));
                    info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
                    info.setUser(uInfo);
                    this.addnew(ctx, (CoreBaseInfo)info);
                }
                flag = true;
            }
            catch (Exception e) {
                logger.error((Object)"\u8bbe\u7f6e\u4eba\u5458\u7684\u77ed\u4fe1\u53d1\u9001\u6570\u91cf\u51fa\u9519", (Throwable)e);
            }
        } else {
            sqlBf.append("update T_MO_MobileMessageAssign set FCanSendCount=FCanSendCount+" + info.getAppendCount() + " where FUserID in(");
            for (int i = 0; i < userIDS.length; ++i) {
                if (i == 0) {
                    sqlBf.append("'");
                    sqlBf.append(userIDS[i]);
                    sqlBf.append("'");
                    continue;
                }
                sqlBf.append(",'");
                sqlBf.append(userIDS[i]);
                sqlBf.append("'");
            }
            sqlBf.append(")");
            try {
                DbUtil.execute((Context)ctx, (String)sqlBf.toString());
                flag = true;
            }
            catch (Exception e) {
                logger.error((Object)"\u8ffd\u52a0\u65b9\u5f0f\u8bbe\u7f6e\u4eba\u5458\u7684\u77ed\u4fe1\u53d1\u9001\u6570\u91cf\u51fa\u9519", (Throwable)e);
            }
        }
        return flag;
    }

    @Override
    protected int _getSendedCountByUserId(Context ctx, String userId, String orgId) throws BOSException {
        MobileMessageAssignCollection col = this.getMobileMessageAssignCollection(ctx, "where user = '" + userId + "' and org = '" + orgId + "'");
        if (col == null || col.size() == 0) {
            return 0;
        }
        MobileMessageAssignInfo info = col.get(0);
        IMsgFacade iMsgFacade = MsgFacadeFactory.getLocalInstance(ctx);
        return iMsgFacade.getAlreadySendCount(info);
    }

    @Override
    protected boolean _deleteAssign(Context ctx, String[] userIds, String orgId, String logInfo) throws BOSException {
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"deleteAssign", (BOSObjectType)new MobileMessageAssignInfo().getBOSType(), null, (String)logInfo.toString(), (String)"mobile_MessageAssign_delete");
        if (userIds == null || userIds.length == 0 || orgId == null) {
            return false;
        }
        StringBuffer sqlDelete = new StringBuffer();
        sqlDelete.append("DELETE FROM T_MO_MobileMessageAssign WHERE FUserID IN (");
        for (int i = 0; i < userIds.length; ++i) {
            if (i == 0) {
                sqlDelete.append("'");
                sqlDelete.append(userIds[i]);
                sqlDelete.append("'");
                continue;
            }
            sqlDelete.append(", '");
            sqlDelete.append(userIds[i]);
            sqlDelete.append("'");
        }
        sqlDelete.append(") and FOrgId = '");
        sqlDelete.append(orgId);
        sqlDelete.append("'");
        try {
            DbUtil.execute((Context)ctx, (String)sqlDelete.toString());
        }
        catch (Exception e) {
            logger.error((Object)"\u5220\u9664\u7528\u6237\u7684\u77ed\u4fe1\u914d\u7f6e\u4fe1\u606f\u51fa\u9519", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        return true;
    }

    @Override
    protected int _canSendCount(Context ctx, String userId, String orgId) throws BOSException {
        MobileMessageAssignCollection col = this.getMobileMessageAssignCollection(ctx, "where user = '" + userId + "' and org = '" + orgId + "'");
        if (col == null || col.size() == 0) {
            return 0;
        }
        MobileMessageAssignInfo info = col.get(0);
        if (info.getCountType() == 1) {
            Timestamp ctTime = new Timestamp(new Date().getTime());
            if (ctTime.after(info.getBeginTime()) && ctTime.before(info.getEndTime())) {
                return info.getCanSendCount();
            }
            return 0;
        }
        if (info.getCountType() == 0) {
            return info.getCanSendCount();
        }
        return 0;
    }

    @Override
    protected int _getCanSendCount(Context ctx, String userId, String orgId) throws BOSException {
        MobileMessageAssignCollection col = this.getMobileMessageAssignCollection(ctx, "where user = '" + userId + "' and org = '" + orgId + "'");
        if (col == null || col.size() == 0) {
            return 0;
        }
        MobileMessageAssignInfo info = col.get(0);
        return info.getCanSendCount();
    }

    @Override
    protected IObjectValue _getMobileMessageAssignInfo(Context ctx, String userId, String orgId) throws BOSException {
        MobileMessageAssignCollection col = this.getMobileMessageAssignCollection(ctx, "where user = '" + userId + "' and org = '" + orgId + "'");
        if (col == null || col.size() == 0) {
            return null;
        }
        return col.get(0);
    }

    @Override
    protected boolean _assignSet(Context ctx, IObjectValue assignValue, String[] setedUserIds, String[] unSetUserIds, boolean isAppend, String orgId, String logInfo) throws BOSException {
        int i;
        if (assignValue == null || StringUtils.isEmpty((String)orgId) || (setedUserIds == null || setedUserIds.length == 0) && (unSetUserIds == null || unSetUserIds.length == 0)) {
            return false;
        }
        MobileMessageAssignInfo assignInfo = (MobileMessageAssignInfo)assignValue;
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"deleteAssign", (BOSObjectType)assignInfo.getBOSType(), null, (String)logInfo.toString(), (String)"mobile_MessageAssign_set");
        if (unSetUserIds != null && unSetUserIds.length > 0) {
            if (isAppend) {
                assignInfo.setCountType(0);
                assignInfo.setCanSendCount(assignInfo.getAppendCount());
            }
            UserInfo userInfo = null;
            FullOrgUnitInfo unitInfo = new FullOrgUnitInfo();
            unitInfo.setId(BOSUuid.read((String)orgId));
            try {
                for (i = 0; i < unSetUserIds.length; ++i) {
                    assignInfo.setId(BOSUuid.create((BOSObjectType)assignInfo.getBOSType()));
                    userInfo = new UserInfo();
                    userInfo.setId(BOSUuid.read((String)unSetUserIds[i]));
                    assignInfo.setUser(userInfo);
                    assignInfo.setOrg(unitInfo);
                    this.addnew(ctx, (CoreBaseInfo)assignInfo);
                }
            }
            catch (Exception e) {
                logger.error((Object)"\u589e\u52a0\u7528\u6237\u7684\u77ed\u4fe1\u53d1\u9001\u6570\u91cf\u51fa\u9519", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        if (setedUserIds != null && setedUserIds.length > 0) {
            StringBuffer sql = new StringBuffer();
            if (!isAppend) {
                sql.append("DELETE FROM T_MO_MobileMessageAssign WHERE FUserID IN (");
                for (int i2 = 0; i2 < setedUserIds.length; ++i2) {
                    if (i2 == 0) {
                        sql.append("'");
                        sql.append(setedUserIds[i2]);
                        sql.append("'");
                        continue;
                    }
                    sql.append(", '");
                    sql.append(setedUserIds[i2]);
                    sql.append("'");
                }
                sql.append(") and FOrgId = '");
                sql.append(orgId);
                sql.append("'");
                try {
                    DbUtil.execute((Context)ctx, (String)sql.toString());
                    UserInfo userInfo = null;
                    FullOrgUnitInfo unitInfo = new FullOrgUnitInfo();
                    unitInfo.setId(BOSUuid.read((String)orgId));
                    for (int i3 = 0; i3 < setedUserIds.length; ++i3) {
                        assignInfo.setId(BOSUuid.create((BOSObjectType)assignInfo.getBOSType()));
                        userInfo = new UserInfo();
                        userInfo.setId(BOSUuid.read((String)setedUserIds[i3]));
                        assignInfo.setUser(userInfo);
                        assignInfo.setOrg(unitInfo);
                        this.addnew(ctx, (CoreBaseInfo)assignInfo);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"\u4fee\u6539\u7528\u6237\u7684\u77ed\u4fe1\u53d1\u9001\u6570\u91cf\u51fa\u9519", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
            }
            sql.append("UPDATE T_MO_MobileMessageAssign SET FCanSendCount = FCanSendCount + " + assignInfo.getAppendCount() + " WHERE FUserID in (");
            int cansendCount = 0;
            for (i = 0; i < setedUserIds.length; ++i) {
                cansendCount = this._getCanSendCount(ctx, setedUserIds[i], orgId);
                if ((cansendCount += assignInfo.getAppendCount()) < 0) {
                    logger.error((Object)"\u8ffd\u52a0\u65b9\u5f0f\u8bbe\u7f6e\u4eba\u5458\u7684\u77ed\u4fe1\u53d1\u9001\u6570\u91cf\u51fa\u9519");
                    throw new BOSException();
                }
                if (i == 0) {
                    sql.append("'");
                    sql.append(setedUserIds[i]);
                    sql.append("'");
                    continue;
                }
                sql.append(", '");
                sql.append(setedUserIds[i]);
                sql.append("'");
            }
            sql.append(") and FOrgId = '");
            sql.append(orgId);
            sql.append("'");
            try {
                DbUtil.execute((Context)ctx, (String)sql.toString());
            }
            catch (Exception e) {
                logger.error((Object)"\u8ffd\u52a0\u65b9\u5f0f\u8bbe\u7f6e\u4eba\u5458\u7684\u77ed\u4fe1\u53d1\u9001\u6570\u91cf\u51fa\u9519", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        return true;
    }

    @Override
    protected boolean _initCUAssignInfo(Context ctx, String cuid) throws BOSException {
        this.initAssignInfoBy(ctx, cuid);
        return true;
    }

    private boolean initAssignInfoBy(Context ctx, String cuid) throws BOSException {
        String bosType = this.getBOSType().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("insert into T_MO_MobileMessageAssign (FID,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID,").append("FUserID,FCanSendCount,FBeginTime,FEndTime,FCountType,FOrgID) ").append(" select * from (select newbosid('").append(bosType).append("') as \"F1\",").append("'00000000-0000-0000-0000-00000000000013B7DE7F' as \"F2\",getdate() as \"F3\",").append("'00000000-0000-0000-0000-00000000000013B7DE7F' as \"F4\",getdate() as \"F5\",").append("'").append(cuid).append("' as \"F6\",").append("user1.fid as \"F7\",0 as \"F8\",CONVERT(DATETIME,null) as \"F9\",CONVERT(DATETIME,null) as \"F10\" ,0 as \"F11\",").append("'").append(cuid).append("' as \"F12\" from T_PM_User as user1 ").append("inner join T_PM_OrgRange range on user1.fid=range.fuserid ").append("where range.forgid='").append(cuid).append("' and range.FType = 10 AND user1.FIsDelete = 0 and not exists (select 1 from T_MO_MobileMessageAssign as assign").append(" where assign.FUserID=user1.fid ").append(" and assign.FOrgID = '").append(cuid).append("')) as A ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        return true;
    }
}

