/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mobile.MobileException;
import com.kingdee.eas.mobile.MobileMessageFormatCollection;
import com.kingdee.eas.mobile.MobileMessageFormatInfo;
import com.kingdee.eas.mobile.app.AbstractMobileMessageFormatControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.STConverter;
import com.kingdee.util.StringUtils;
import java.util.Locale;

public class MobileMessageFormatControllerBean
extends AbstractMobileMessageFormatControllerBean {
    @Override
    protected void _updateFormat(Context ctx, IObjectCollection formatCol) throws BOSException, EASBizException {
        MobileMessageFormatCollection col = (MobileMessageFormatCollection)formatCol;
        if (col.size() == 0) {
            return;
        }
        UserInfo currentUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String userId = currentUserInfo.getId().toString();
        String bosType = col.get(0).getBosType();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("user.id", (Object)userId));
        filterInfo.getFilterItems().add(new FilterItemInfo("bosType", (Object)bosType));
        this._delete(ctx, filterInfo);
        for (int i = 0; i < col.size(); ++i) {
            String format;
            MobileMessageFormatInfo info = col.get(i);
            info.setUser(currentUserInfo);
            String fieldName = info.getFieldName();
            String fieldAlias = info.getFieldAlias();
            if (!StringUtils.isEmpty((String)fieldName) && fieldName.length() > 255 || !StringUtils.isEmpty((String)fieldAlias) && fieldAlias.length() > 255) {
                throw new MobileException(MobileException.FIELD_TOO_LONG);
            }
            if (!StringUtils.isEmpty((String)fieldAlias)) {
                if (new Locale("L2").equals(ctx.getLocale())) {
                    info.setFieldAlias(STConverter.sc2tc((String)fieldAlias), new Locale("L3"));
                } else if (new Locale("L3").equals(ctx.getLocale())) {
                    info.setFieldAlias(STConverter.tc2sc((String)fieldAlias), new Locale("L2"));
                }
            }
            if (StringUtils.isEmpty((String)(format = info.getFormat()))) continue;
            if (format.length() > 500) {
                throw new MobileException(MobileException.FORMAT_TOO_LONG);
            }
            if (new Locale("L2").equals(ctx.getLocale())) {
                info.setFormat(STConverter.sc2tc((String)format), new Locale("L3"));
                continue;
            }
            if (!new Locale("L3").equals(ctx.getLocale())) continue;
            info.setFormat(STConverter.tc2sc((String)format), new Locale("L2"));
        }
        this.addnew(ctx, col);
    }
}

