/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.message.IMAGroupResolvent;
import com.kingdee.eas.base.message.MAGroupResolventCollection;
import com.kingdee.eas.base.message.MAGroupResolventFactory;
import com.kingdee.eas.base.message.MAGroupResolventInfo;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mobile.CustomCMDShortCutCollection;
import com.kingdee.eas.mobile.IMobileConfig;
import com.kingdee.eas.mobile.MobileConfigFactory;
import com.kingdee.eas.mobile.MobileConfigInfo;
import com.kingdee.eas.mobile.MobileException;
import com.kingdee.eas.mobile.MobileMessageAssignInfo;
import com.kingdee.eas.mobile.PersonNameToPhoneNumber;
import com.kingdee.eas.mobile.SendMessageParamInfo;
import com.kingdee.eas.mobile.UserMessageConfigInfo;
import com.kingdee.eas.mobile.app.AbstractMsgFacadeControllerBean;
import com.kingdee.eas.mobile.dao.DefaultMsgDAO;
import com.kingdee.eas.mobile.dao.DefaultReceiveMoMsgDAO;
import com.kingdee.eas.mobile.dao.DefaultSendMoMsgDao;
import com.kingdee.eas.mobile.msg.util.MsgUtil;
import com.kingdee.eas.mobile.util.MailServerConfigPropUtil;
import com.kingdee.eas.mobile.util.MobileUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.configuration.ConfigurationException;

public class MsgFacadeControllerBean
extends AbstractMsgFacadeControllerBean {
    @Override
    protected boolean _saveUserConfig(Context ctx, String userId, IObjectValue person, IObjectValue userMsgConfig, IObjectCollection shortCuts) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)userId) || person == null || userMsgConfig == null || shortCuts == null) {
            return false;
        }
        PersonInfo personInfo = (PersonInfo)person;
        UserMessageConfigInfo userMsgConfigInfo = (UserMessageConfigInfo)userMsgConfig;
        CustomCMDShortCutCollection cCMDShortCutInfos = (CustomCMDShortCutCollection)shortCuts;
        if (!DefaultMsgDAO.updatePersonConfig(ctx, personInfo)) {
            return false;
        }
        if (!DefaultMsgDAO.saveUserMessageConfigInfo(ctx, userMsgConfigInfo)) {
            return false;
        }
        return DefaultMsgDAO.saveUserShortCut1(ctx, cCMDShortCutInfos, userId);
    }

    @Override
    protected void _test1ForMobile(Context ctx, Object params11) throws BOSException, EASBizException {
        MsgUtil.newMsgMobileDerect(ctx, true, "1test", "13333333333");
    }

    @Override
    protected boolean _saveBizConfig(Context ctx, IObjectValue mobileConfig, HashMap bizCommandHM) throws BOSException, EASBizException, MobileException {
        MobileConfigInfo mobileConfigInfo = (MobileConfigInfo)mobileConfig;
        IMobileConfig iMobileConfig = MobileConfigFactory.getLocalInstance(ctx);
        if (mobileConfigInfo.getId() == null) {
            IObjectPK pk = iMobileConfig.addnew(mobileConfigInfo);
            if (pk == null) {
                return false;
            }
        } else {
            ObjectUuidPK pk = new ObjectUuidPK(mobileConfigInfo.getId());
            iMobileConfig.update((IObjectPK)pk, mobileConfigInfo);
        }
        return DefaultMsgDAO.saveBizCommand(ctx, bizCommandHM);
    }

    @Override
    protected boolean _deleteSendMoMsg(Context ctx, String sendMoMsgId) throws BOSException, EASBizException {
        return DefaultSendMoMsgDao.delete(ctx, sendMoMsgId);
    }

    @Override
    protected boolean _deleteReceiveMoMsg(Context ctx, String receiveMoMsgId) throws BOSException, EASBizException {
        return DefaultReceiveMoMsgDAO.delete(ctx, receiveMoMsgId);
    }

    @Override
    protected int _getAlreadySendCount(Context ctx, IObjectValue assignSetInfo) throws BOSException {
        MobileMessageAssignInfo assignInfo = (MobileMessageAssignInfo)assignSetInfo;
        int countType = assignInfo.getCountType();
        String userId = assignInfo.getUser().getId().toString();
        String orgId = null;
        if (assignInfo.getOrg() != null) {
            orgId = assignInfo.getOrg().getId().toString();
        }
        if (countType == 0) {
            Timestamp currentTime = new Timestamp(new Date().getTime());
            currentTime.setHours(0);
            currentTime.setMinutes(0);
            currentTime.setSeconds(0);
            currentTime.setNanos(0);
            return DefaultSendMoMsgDao.getSentMessageCountForMonth(ctx, userId, currentTime, orgId);
        }
        Timestamp beginTime = assignInfo.getBeginTime();
        Timestamp endTime = assignInfo.getEndTime();
        return DefaultSendMoMsgDao.getSentMessageCount(ctx, userId, beginTime, endTime, orgId);
    }

    @Override
    protected String _getPhoneNumberByName(Context ctx, String name) throws BOSException, EASBizException {
        if (name == null || name.equals("")) {
            return "";
        }
        String[] tempNames = name.split(",");
        if (tempNames.length == 0) {
            return "";
        }
        StringBuffer cellNumber = new StringBuffer();
        StringBuffer noneCellNumberPerson = new StringBuffer();
        String sql = "SELECT FCell FROM T_BD_Person ";
        String appendSql = "";
        String local = ctx.getLocale().toString();
        if (local.equalsIgnoreCase("l1")) {
            appendSql = " WHERE FName_L1 = ? ";
        } else if (local.equalsIgnoreCase("l2")) {
            appendSql = " WHERE FName_L2 = ? ";
        } else if (local.equalsIgnoreCase("l3")) {
            appendSql = " WHERE FName_L3 = ? ";
        }
        sql = sql + appendSql;
        try {
            int num = tempNames.length;
            for (int i = 0; i < num; ++i) {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{tempNames[i]});
                if (rs.next()) {
                    String tempCellNumber = rs.getString("FCell");
                    if (tempCellNumber != null && !tempCellNumber.equals("")) {
                        cellNumber.append(tempCellNumber);
                        cellNumber.append(",");
                        continue;
                    }
                    noneCellNumberPerson.append(tempNames[i]);
                    noneCellNumberPerson.append(",");
                    continue;
                }
                noneCellNumberPerson.append(tempNames[i]);
                noneCellNumberPerson.append(",");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        String result = cellNumber.toString() + "&" + noneCellNumberPerson.toString();
        return result;
    }

    @Override
    protected String _getPhoneNumberByName2(Context ctx, String name) throws BOSException, EASBizException {
        if (name == null || name.equals("")) {
            return "";
        }
        name = this.getPersonIdFromOrgName(ctx, name);
        name = this.getPersonIdFromMAGroupName(ctx, name);
        String[] tempNames = (name = MobileUtil.filterStringBufferDup(new StringBuffer(name)).toString()).split(",");
        if (tempNames.length == 0) {
            return "";
        }
        String sql = "SELECT FCell FROM T_BD_Person ";
        String appendSql = "";
        String local = ctx.getLocale().toString();
        if (local.equalsIgnoreCase("l1")) {
            appendSql = " WHERE FName_L1 = ? ";
        } else if (local.equalsIgnoreCase("l2")) {
            appendSql = " WHERE FName_L2 = ? ";
        } else if (local.equalsIgnoreCase("l3")) {
            appendSql = " WHERE FName_L3 = ? ";
        }
        sql = sql + appendSql;
        StringBuffer cellNumber = new StringBuffer();
        StringBuffer noneCellNumberPerson = new StringBuffer();
        try {
            for (String tempName : tempNames) {
                String tempCellNumber;
                IRowSet rs;
                if (tempName.startsWith("{") && tempName.endsWith("}") && tempName.length() > 2) {
                    tempName = tempName.substring(1, tempName.length() - 1);
                }
                if ((rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{tempName})).next()) {
                    tempCellNumber = rs.getString("FCell");
                    if (tempCellNumber != null && !tempCellNumber.equals("")) {
                        if (cellNumber.length() != 0) {
                            cellNumber.append(",");
                        }
                        cellNumber.append(tempCellNumber);
                    } else {
                        if (noneCellNumberPerson.length() != 0) {
                            noneCellNumberPerson.append(",");
                        }
                        noneCellNumberPerson.append(tempName);
                    }
                } else {
                    if (noneCellNumberPerson.length() != 0) {
                        noneCellNumberPerson.append(",");
                    }
                    noneCellNumberPerson.append(tempName);
                }
                while (rs.next()) {
                    tempCellNumber = rs.getString("FCell");
                    if (tempCellNumber != null && !tempCellNumber.equals("")) {
                        if (cellNumber.length() != 0) {
                            cellNumber.append(",");
                        }
                        cellNumber.append(tempCellNumber);
                        continue;
                    }
                    if (noneCellNumberPerson.length() != 0) {
                        noneCellNumberPerson.append(",");
                    }
                    noneCellNumberPerson.append(tempName);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        String result = cellNumber.toString() + "&" + noneCellNumberPerson.toString();
        return result;
    }

    private String getPersonIdFromOrgName(Context ctx, String name) throws BOSException {
        String userNames;
        String[] tempNames = name.split(",");
        HashMap<String, String> orgNameToPersonNameMap = new HashMap<String, String>();
        String localedName = null;
        String local = ctx.getLocale().toString();
        if (local.equalsIgnoreCase("l1")) {
            localedName = "FName_L1";
        } else if (local.equalsIgnoreCase("l2")) {
            localedName = "FName_L2";
        } else if (local.equalsIgnoreCase("l3")) {
            localedName = "FName_L3";
        }
        for (int i = 0; i < tempNames.length; ++i) {
            StringBuffer sql = new StringBuffer("SELECT user1.FPersonId").append(" FROM T_PM_User user1 JOIN T_ORG_BaseUnit unit ON user1.FDefOrgUnitID = unit.FID").append(" WHERE unit.").append(localedName).append(" = '").append(tempNames[i]).append("'");
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                userNames = "";
                while (rs.next()) {
                    String userName = rs.getString(1);
                    if (userName == null || userName.equals("")) continue;
                    if (userNames.length() == 0) {
                        userNames = userName;
                        continue;
                    }
                    userNames = userNames + "," + userName;
                }
                if (StringUtils.isEmpty((String)userNames)) continue;
                orgNameToPersonNameMap.put(tempNames[i], userNames);
                continue;
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
        }
        String result = new String(name);
        if (!orgNameToPersonNameMap.isEmpty()) {
            for (String orgName : orgNameToPersonNameMap.keySet()) {
                userNames = (String)orgNameToPersonNameMap.get(orgName);
                int index = result.indexOf(orgName);
                if (index > 0) {
                    result = result.substring(0, index) + userNames + result.substring(index + orgName.length());
                    continue;
                }
                if (index != 0) continue;
                result = userNames + result.substring(index + orgName.length());
            }
        }
        return result;
    }

    private String getPersonIdFromMAGroupName(Context ctx, String name) throws BOSException {
        String[] tempNames = name.split(",");
        HashMap<String, String> maNameToPersonNameMap = new HashMap<String, String>();
        IMAGroupResolvent iGroup = MAGroupResolventFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < tempNames.length; ++i) {
            MAGroupResolventCollection groupCol = iGroup.getMAGroupResolventCollection("select id where name = '" + tempNames[i] + "'");
            if (groupCol.size() <= 0) continue;
            MAGroupResolventInfo groupInfo = groupCol.get(0);
            String groupId = groupInfo.getId().toString();
            UserCollection userCol = this.getMAGroupResolventToUser(ctx, groupId);
            String userNames = "";
            for (int j = 0; j < userCol.size(); ++j) {
                String userName;
                UserInfo userInfo = userCol.get(j);
                if (userInfo == null || userInfo.getPerson() == null || (userName = userInfo.getPerson().getId().toString()) == null || userName.equals("")) continue;
                userNames = userNames.length() == 0 ? userName : userNames + "," + userName;
            }
            if (StringUtils.isEmpty((String)userNames)) continue;
            maNameToPersonNameMap.put(tempNames[i], userNames);
        }
        String result = new String(name);
        if (!maNameToPersonNameMap.isEmpty()) {
            for (String groupName : maNameToPersonNameMap.keySet()) {
                String userNames = (String)maNameToPersonNameMap.get(groupName);
                int index = result.indexOf(groupName);
                if (index > 0) {
                    result = result.substring(0, index) + userNames + result.substring(index + groupName.length());
                    continue;
                }
                if (index != 0) continue;
                result = userNames + result.substring(index + groupName.length());
            }
        }
        return result;
    }

    private String replaceOrgNameByPersonName(Context ctx, String name) throws BOSException {
        String userNames;
        String[] tempNames = name.split(",");
        HashMap<String, String> orgNameToPersonNameMap = new HashMap<String, String>();
        String localedName = null;
        String local = ctx.getLocale().toString();
        if (local.equalsIgnoreCase("l1")) {
            localedName = "FName_L1";
        } else if (local.equalsIgnoreCase("l2")) {
            localedName = "FName_L2";
        } else if (local.equalsIgnoreCase("l3")) {
            localedName = "FName_L3";
        }
        for (int i = 0; i < tempNames.length; ++i) {
            StringBuffer sql = new StringBuffer("SELECT user1.").append(localedName).append(" FROM T_PM_User user1 JOIN T_ORG_BaseUnit unit ON user1.FDefOrgUnitID = unit.FID").append(" WHERE unit.").append(localedName).append(" = '").append(tempNames[i]).append("'");
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                userNames = "";
                while (rs.next()) {
                    String userName = rs.getString(1);
                    if (userName == null || userName.equals("")) continue;
                    if (userNames.length() == 0) {
                        userNames = userName;
                        continue;
                    }
                    userNames = userNames + "," + userName;
                }
                if (StringUtils.isEmpty((String)userNames)) continue;
                orgNameToPersonNameMap.put(tempNames[i], userNames);
                continue;
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
        }
        String result = new String(name);
        if (!orgNameToPersonNameMap.isEmpty()) {
            for (String orgName : orgNameToPersonNameMap.keySet()) {
                userNames = (String)orgNameToPersonNameMap.get(orgName);
                int index = result.indexOf(orgName);
                if (index > 0) {
                    result = result.substring(0, index) + userNames + result.substring(index + orgName.length());
                    continue;
                }
                if (index != 0) continue;
                result = userNames + result.substring(index + orgName.length());
            }
        }
        return result;
    }

    private String replaceMAGroupNameByPersonName(Context ctx, String name) throws BOSException {
        String[] tempNames = name.split(",");
        HashMap<String, String> maNameToPersonNameMap = new HashMap<String, String>();
        IMAGroupResolvent iGroup = MAGroupResolventFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < tempNames.length; ++i) {
            MAGroupResolventCollection groupCol = iGroup.getMAGroupResolventCollection("select id where name = '" + tempNames[i] + "'");
            if (groupCol.size() <= 0) continue;
            MAGroupResolventInfo groupInfo = groupCol.get(0);
            String groupId = groupInfo.getId().toString();
            UserCollection userCol = this.getMAGroupResolventToUser(ctx, groupId);
            String userNames = "";
            for (int j = 0; j < userCol.size(); ++j) {
                UserInfo userInfo = userCol.get(j);
                String userName = userInfo.getName();
                if (userName == null || userName.equals("")) continue;
                userNames = userNames.length() == 0 ? userName : userNames + "," + userName;
            }
            if (StringUtils.isEmpty((String)userNames)) continue;
            maNameToPersonNameMap.put(tempNames[i], userNames);
        }
        String result = new String(name);
        if (!maNameToPersonNameMap.isEmpty()) {
            for (String groupName : maNameToPersonNameMap.keySet()) {
                String userNames = (String)maNameToPersonNameMap.get(groupName);
                int index = result.indexOf(groupName);
                if (index > 0) {
                    result = result.substring(0, index) + userNames + result.substring(index + groupName.length());
                    continue;
                }
                if (index != 0) continue;
                result = userNames + result.substring(index + groupName.length());
            }
        }
        return result;
    }

    private UserCollection getMAGroupResolventToUser(Context ctx, String mAGroupResolventID) throws BOSException {
        UserCollection userCol = new UserCollection();
        String selectSql = "select Person.fid from T_BAS_MAGroupResolvent Resolvent inner join T_BAS_MAGroupResolventEntry ResolventEntry on Resolvent.fid = ResolventEntry.fparent inner join T_BAS_MAGroup MAGroup  on ResolventEntry.fgroup = MAGroup.fid  inner join T_BAS_MAGroupEntry GroupEntry  on MAGroup.fid = GroupEntry.fparent inner join t_bd_person Person on GroupEntry.fpersonnel = Person.fid where Resolvent.fid = ?";
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)selectSql, (Object[])new Object[]{mAGroupResolventID});
        try {
            while (rowset.next()) {
                String personId = rowset.getString(1);
                userCol.addCollection(UserFactory.getLocalInstance((Context)ctx).getUserCollection("select * where Person = '" + personId + "'"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return userCol;
    }

    @Override
    protected PersonNameToPhoneNumber _getPhoneNumberByPersonName(Context ctx, String name) throws BOSException, EASBizException {
        if (name == null || name.equals("")) {
            return null;
        }
        String sql = "SELECT FCell FROM T_BD_Person ";
        String appendSql = "";
        String local = ctx.getLocale().toString();
        if (local.equalsIgnoreCase("l1")) {
            appendSql = " WHERE FName_L1 = ? ";
        } else if (local.equalsIgnoreCase("l2")) {
            appendSql = " WHERE FName_L2 = ? ";
        } else if (local.equalsIgnoreCase("l3")) {
            appendSql = " WHERE FName_L3 = ? ";
        }
        sql = sql + appendSql;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{name});
            PersonNameToPhoneNumber nameNumber = null;
            while (rs.next()) {
                String phoneNumber = rs.getString("FCell");
                if (StringUtils.isEmpty((String)phoneNumber)) continue;
                if (nameNumber == null) {
                    ArrayList<String> numberList = new ArrayList<String>();
                    numberList.add(phoneNumber);
                    nameNumber = new PersonNameToPhoneNumber(name, numberList);
                    continue;
                }
                nameNumber.phoneNumberList.add(phoneNumber);
            }
            return nameNumber;
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected PersonNameToPhoneNumber _getPhoneNumberByPersonNumber(Context ctx, String number) throws BOSException, EASBizException {
        if (number == null || number.equals("")) {
            return null;
        }
        String localedName = null;
        String local = ctx.getLocale().toString();
        if (local.equalsIgnoreCase("l1")) {
            localedName = "FName_L1";
        } else if (local.equalsIgnoreCase("l2")) {
            localedName = "FName_L2";
        } else if (local.equalsIgnoreCase("l3")) {
            localedName = "FName_L3";
        }
        String sql = "SELECT " + localedName + ", FCell FROM T_BD_Person WHERE FNumber = ?";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{number});
            if (rs.next()) {
                String personName = rs.getString(1);
                String phoneNumber = rs.getString(2);
                if (!StringUtils.isEmpty((String)phoneNumber)) {
                    ArrayList<String> numberList = new ArrayList<String>();
                    numberList.add(phoneNumber);
                    return new PersonNameToPhoneNumber(personName, numberList);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    @Override
    protected PersonNameToPhoneNumber _getPhoneNumberByUserNumber(Context ctx, String number) throws BOSException, EASBizException {
        if (number == null || number.equals("")) {
            return null;
        }
        String localedName = null;
        String local = ctx.getLocale().toString();
        if (local.equalsIgnoreCase("l1")) {
            localedName = "FName_L1";
        } else if (local.equalsIgnoreCase("l2")) {
            localedName = "FName_L2";
        } else if (local.equalsIgnoreCase("l3")) {
            localedName = "FName_L3";
        }
        String sql = "SELECT p." + localedName + ", p.FCell FROM T_BD_Person p JOIN T_PM_User u ON p.FID = u.FPersonId WHERE u.FNumber = ?";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{number});
            if (rs.next()) {
                String personName = rs.getString(1);
                String phoneNumber = rs.getString(2);
                if (!StringUtils.isEmpty((String)phoneNumber)) {
                    ArrayList<String> numberList = new ArrayList<String>();
                    numberList.add(phoneNumber);
                    return new PersonNameToPhoneNumber(personName, numberList);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    @Override
    protected PersonNameToPhoneNumber _getPersonNameAndPhoneNumber(Context ctx, String key) throws BOSException, EASBizException {
        if (key == null || key.equals("")) {
            return null;
        }
        ArrayList<PersonNameToPhoneNumber> resultList = new ArrayList<PersonNameToPhoneNumber>();
        PersonNameToPhoneNumber result1 = this._getPhoneNumberByPersonName(ctx, key);
        if (result1 != null) {
            resultList.add(result1);
        }
        return result1;
    }

    @Override
    protected ArrayList _getPersonNameAndPhoneNumbers(Context ctx, String key) throws BOSException, EASBizException {
        PersonNameToPhoneNumber result3;
        PersonNameToPhoneNumber result2;
        if (key == null || key.equals("")) {
            return null;
        }
        ArrayList<PersonNameToPhoneNumber> resultList = new ArrayList<PersonNameToPhoneNumber>();
        PersonNameToPhoneNumber result1 = this._getPhoneNumberByPersonName(ctx, key);
        if (result1 != null) {
            resultList.add(result1);
        }
        if ((result2 = this._getPhoneNumberByPersonNumber(ctx, key)) != null) {
            resultList.add(result2);
        }
        if ((result3 = this._getPhoneNumberByUserNumber(ctx, key)) != null) {
            resultList.add(result3);
        }
        block0: for (int i = resultList.size() - 1; i >= 1; --i) {
            PersonNameToPhoneNumber tempResult = (PersonNameToPhoneNumber)resultList.get(i);
            for (int j = i - 1; j >= 0; --j) {
                PersonNameToPhoneNumber compResult = (PersonNameToPhoneNumber)resultList.get(j);
                if (!tempResult.personName.equals(compResult.personName)) continue;
                for (String number : tempResult.phoneNumberList) {
                    if (compResult.phoneNumberList.contains(number)) continue;
                    compResult.phoneNumberList.add(number);
                }
                resultList.remove(i);
                continue block0;
            }
        }
        return resultList;
    }

    @Override
    protected String _getNameByPhoneNumber(Context ctx, String phoneNumber) throws BOSException, EASBizException {
        if (phoneNumber == null || phoneNumber.equals("")) {
            return null;
        }
        StringBuffer sql = new StringBuffer("SELECT");
        String local = ctx.getLocale().toString();
        if (local.equalsIgnoreCase("l1")) {
            sql.append(" FName_L1 ");
        } else if (local.equalsIgnoreCase("l2")) {
            sql.append(" FName_L2 ");
        } else if (local.equalsIgnoreCase("l3")) {
            sql.append(" FName_L3 ");
        }
        sql.append("FROM T_BD_Person WHERE FCell = ?");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{phoneNumber});
            if (rs.next()) {
                return rs.getString(1);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    @Override
    protected ArrayList _getNameByPhoneNumber2(Context ctx, String phoneNumber) throws BOSException, EASBizException {
        if (phoneNumber == null || phoneNumber.equals("")) {
            return null;
        }
        StringBuffer sql = new StringBuffer("SELECT");
        String local = ctx.getLocale().toString();
        if (local.equalsIgnoreCase("l1")) {
            sql.append(" FName_L1 ");
        } else if (local.equalsIgnoreCase("l2")) {
            sql.append(" FName_L2 ");
        } else if (local.equalsIgnoreCase("l3")) {
            sql.append(" FName_L3 ");
        }
        sql.append("FROM T_BD_Person WHERE FCell = ?");
        ArrayList<String> nameList = new ArrayList<String>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{phoneNumber});
            while (rs.next()) {
                String name = rs.getString(1);
                if (StringUtils.isEmpty((String)name)) continue;
                nameList.add(name);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return nameList;
    }

    @Override
    protected boolean _sendMsg(Context ctx, String content, String receivers) throws BOSException, EASBizException {
        return MsgUtil.msgMobileDerect(ctx, content, receivers);
    }

    @Override
    protected boolean _sendMsg(Context ctx, boolean canBack, String content, String receivers) throws BOSException, EASBizException {
        return MsgUtil.newMsgMobileDerect(ctx, canBack, content, receivers);
    }

    @Override
    protected boolean _sendMsg(Context ctx, boolean canBack, boolean isAppendRevert, boolean isAppendUserName, boolean isAppendCompanyName, String content, String receivers) throws BOSException, EASBizException {
        return MsgUtil.newMsgMobileDerect(ctx, canBack, isAppendRevert, isAppendUserName, isAppendCompanyName, content, receivers);
    }

    @Override
    protected boolean _sendMsg(Context ctx, SendMessageParamInfo msgInfo) throws BOSException, EASBizException {
        return MsgUtil.newMsgMobileDerect(ctx, msgInfo);
    }

    @Override
    protected Properties _getMailServerConfig(Context ctx) throws BOSException, EASBizException {
        try {
            return MailServerConfigPropUtil.getProperties();
        }
        catch (IOException e) {
            throw new BOSException((Throwable)e);
        }
        catch (ConfigurationException ce) {
            throw new BOSException((Throwable)ce);
        }
    }

    @Override
    protected void _saveMailServerConfig(Context ctx, Properties properties) throws BOSException, EASBizException {
        try {
            MailServerConfigPropUtil.saveProperties(properties);
        }
        catch (IOException e) {
            throw new BOSException((Throwable)e);
        }
        catch (ConfigurationException ce) {
            throw new BOSException((Throwable)ce);
        }
    }
}

