/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.biz;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.mobile.AbstractMobileMessageQuerySchemaInfo;
import com.kingdee.eas.mobile.CoreReceiveMessageInfo;
import com.kingdee.eas.mobile.CoreSendMessageInfo;
import com.kingdee.eas.mobile.EmailReceiveMessageInfo;
import com.kingdee.eas.mobile.EmailSendMessageInfo;
import com.kingdee.eas.mobile.IMobileMessageQuerySchema;
import com.kingdee.eas.mobile.MobileMessageQuerySchemaCollection;
import com.kingdee.eas.mobile.MobileMessageQuerySchemaFactory;
import com.kingdee.eas.mobile.ReceiveMobileMessageInfo;
import com.kingdee.eas.mobile.SendMobileMessageInfo;
import com.kingdee.eas.mobile.biz.BizFuncParamObj;
import com.kingdee.eas.mobile.biz.BizReturnObj;
import com.kingdee.eas.mobile.biz.IMessageHandler;
import com.kingdee.eas.mobile.biz.ISendMsgFunction;
import com.kingdee.eas.mobile.dao.DefaultMsgDAO;
import com.kingdee.eas.mobile.util.AppMsgUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.log4j.Logger;

public class SendMsgHandler
implements IMessageHandler {
    private static final Logger logger = Logger.getLogger(SendMsgHandler.class);

    @Override
    public CoreSendMessageInfo executeBizAction(Context ctx, UserInfo userInfo, CoreReceiveMessageInfo receiveMsgInfo) {
        logger.info((Object)("in executeBizAction \uff1a" + receiveMsgInfo.getContent()));
        String content = receiveMsgInfo.getContent();
        if (StringUtils.isEmpty((String)content)) {
            return null;
        }
        String[] contents = AppMsgUtil.getCommandParams(content.trim());
        if (contents == null || contents.length < 1) {
            return null;
        }
        String command = contents[0];
        String[] params = new String[contents.length - 1];
        for (int i = 0; i < params.length; ++i) {
            params[i] = contents[i + 1];
        }
        SendMobileMessageInfo sendMoMsgInfo = null;
        String[] commands = null;
        try {
            char numKey = command.charAt(0);
            logger.debug((Object)("numKey: " + numKey));
            switch (numKey) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    commands = DefaultMsgDAO.getBizFunctionByUserShortCut(ctx, userInfo.getId().toString(), numKey);
                    if (commands != null && !StringUtils.isEmpty((String)commands[0]) && !StringUtils.isEmpty((String)commands[1])) break;
                    sendMoMsgInfo = new SendMobileMessageInfo();
                    sendMoMsgInfo.setContent(ResourceBase.getString((String)"com.kingdee.eas.mobile.msg.MobileResource", (String)"youHaveNotDefineKJJ", (Locale)ctx.getLocale()) + numKey);
                    return sendMoMsgInfo;
                }
                case '?': {
                    logger.debug((Object)"\u663e\u793a\u547d\u4ee4\u4fe1\u606f");
                    return null;
                }
                default: {
                    commands = DefaultMsgDAO.getBizFunctionByCommand(ctx, command);
                    if (commands != null && !StringUtils.isEmpty((String)commands[0]) && !StringUtils.isEmpty((String)commands[1])) break;
                    sendMoMsgInfo = new SendMobileMessageInfo();
                    sendMoMsgInfo.setTitle("Reply message for Error");
                    sendMoMsgInfo.setContent(ResourceBase.getString((String)"com.kingdee.eas.mobile.msg.MobileResource", (String)"byCommand", (Locale)ctx.getLocale()) + command + ResourceBase.getString((String)"com.kingdee.eas.mobile.msg.MobileResource", (String)"notFindBiz", (Locale)ctx.getLocale()));
                    return sendMoMsgInfo;
                }
            }
            if (params.length == 0) {
                String condition;
                String bizFunctionID = commands[2];
                String userID = userInfo.getId().toString();
                IMobileMessageQuerySchema iSchema = MobileMessageQuerySchemaFactory.getLocalInstance(ctx);
                MobileMessageQuerySchemaCollection schemaCol = iSchema.getSchemaByUserAndFunction(userID, bizFunctionID);
                AbstractMobileMessageQuerySchemaInfo schemaInfo = null;
                for (int i = 0; i < schemaCol.size(); ++i) {
                    if (!schemaCol.get(i).isIsDefault()) continue;
                    schemaInfo = schemaCol.get(i);
                    break;
                }
                ArrayList<String> paramList = new ArrayList<String>();
                if (schemaInfo != null && !StringUtils.isEmpty((String)(condition = schemaInfo.getQueryCondition()))) {
                    String[] entries = condition.split(",");
                    for (int i = 0; i < entries.length; ++i) {
                        String[] elements = entries[i].split(":");
                        paramList.add(elements[1]);
                    }
                }
                if (paramList.size() > 0) {
                    params = paramList.toArray(new String[0]);
                }
            }
            logger.info((Object)("do executeBizAction \uff1a" + receiveMsgInfo.getContent()));
            return this.executeBizAction(ctx, userInfo.getId().toString(), commands[0], commands[1], params, receiveMsgInfo);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)("\u5904\u7406\u4e3b\u53d1\u77ed\u4fe1\u6267\u884c\u4e1a\u52a1\u529f\u80fd\u65f6\u53d1\u751f\u9519\u8bef\uff0c\u88c5\u8f7d\u4e1a\u52a1\u529f\u80fd\u5904\u7406\u5b9e\u4f8b\u5931\u8d25\uff1a" + e.getMessage()));
        }
        catch (Exception e) {
            logger.error((Object)("\u5904\u7406\u4e3b\u53d1\u77ed\u4fe1\u6267\u884c\u4e1a\u52a1\u529f\u80fd\u65f6\u53d1\u751f\u9519\u8bef\uff1a" + e.getMessage()));
        }
        return sendMoMsgInfo;
    }

    private CoreSendMessageInfo executeBizAction(Context ctx, String userID, String implClassName, String command, String[] params, CoreReceiveMessageInfo receiveMsgInfo) throws Exception {
        CoreSendMessageInfo coreSendMessageInfo = null;
        Class<?> bizClass = Class.forName(implClassName.trim());
        Object instance = bizClass.newInstance();
        if (instance instanceof ISendMsgFunction) {
            BizReturnObj returnObj;
            ISendMsgFunction bizInstance = (ISendMsgFunction)instance;
            BizFuncParamObj paramObj = new BizFuncParamObj(ctx, userID, command, params, null, receiveMsgInfo);
            if (bizInstance.beforeExecSendAction(paramObj) && bizInstance.afterExecSendAction(paramObj, returnObj = bizInstance.executeSendAction(paramObj)) && returnObj != null && returnObj.isMustReply()) {
                if (receiveMsgInfo instanceof ReceiveMobileMessageInfo) {
                    coreSendMessageInfo = new SendMobileMessageInfo();
                } else if (receiveMsgInfo instanceof EmailReceiveMessageInfo) {
                    coreSendMessageInfo = new EmailSendMessageInfo();
                }
                if (returnObj.isSucceed()) {
                    coreSendMessageInfo.setContent(returnObj.getReturnText());
                    if (StringUtils.isEmpty((String)returnObj.getTitle())) {
                        coreSendMessageInfo.setTitle("Reply message");
                    } else {
                        coreSendMessageInfo.setTitle(returnObj.getTitle());
                    }
                    if (!StringUtils.isEmpty((String)returnObj.getMsgId())) {
                        coreSendMessageInfo.setMsgID(returnObj.getMsgId());
                    }
                    if (!StringUtils.isEmpty((String)returnObj.getAssignmentID())) {
                        coreSendMessageInfo.setAssignID(returnObj.getAssignmentID());
                    }
                    if (!StringUtils.isEmpty((String)returnObj.getCustomStr())) {
                        coreSendMessageInfo.setCustomStr(returnObj.getCustomStr());
                    }
                } else {
                    coreSendMessageInfo.setContent(returnObj.getErrorText());
                    if (StringUtils.isEmpty((String)returnObj.getTitle())) {
                        coreSendMessageInfo.setTitle("Reply message for Error");
                    } else {
                        coreSendMessageInfo.setTitle(returnObj.getTitle());
                    }
                }
                coreSendMessageInfo.setSendBizFunction(implClassName);
            }
        } else {
            logger.error((Object)"\u5904\u7406\u4e3b\u53d1\u77ed\u4fe1\u6267\u884c\u4e1a\u52a1\u529f\u80fd\u65f6\u53d1\u751f\u9519\u8bef\uff1a\u88c5\u8f7d\u4e1a\u52a1\u529f\u80fd\u5904\u7406\u5b9e\u4f8b\u5931\u8d25\uff0c\u5b9e\u73b0\u7c7b\u6ca1\u5b9e\u73b0\u6267\u884c\u7684\u63a5\u53e3\uff01");
        }
        return coreSendMessageInfo;
    }
}

