/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.convert.util;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.mobile.convert.RptParamsXMLConvert;
import com.kingdee.eas.mobile.convert.util.EmptyUtil;
import org.apache.log4j.Logger;

public class TransferParamsUtil {
    private static final Logger logger = CoreUIObject.getLogger(TransferParamsUtil.class);

    public static CustomerParams setToCustomerParams(CustomerParams cp, Object value) {
        TransferParamsUtil.processRptParams(value, cp);
        return cp;
    }

    public static Object getFromCustomerParams(CustomerParams cp) throws EASBizException {
        RptParams param;
        RptParams rptParams = param = new RptParams();
        try {
            for (String key : cp.getKeys()) {
                if ("RPTPARAMS_KEY_AT_CUSTOMERPARAMS".equals(key)) {
                    return rptParams;
                }
                String value = cp.getCustomerParam(key);
                RptParamsXMLConvert convert = new RptParamsXMLConvert();
                rptParams.setObject(key, convert.decode(value));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return rptParams;
    }

    public static CustomerParams processRptParams(Object bizParam, CustomerParams customerParams) {
        RptParams rptParams = (RptParams)bizParam;
        for (String key : rptParams.keySet()) {
            if ("RPTPARAMS_KEY_AT_CUSTOMERPARAMS".equals(key)) {
                return customerParams;
            }
            Object value = rptParams.getObject(key);
            if (EmptyUtil.isEmpty(value)) continue;
            try {
                customerParams.addCustomerParam(key, new RptParamsXMLConvert().encode(value));
            }
            catch (Exception e) {
                logger.error((Object)String.format("[%s]\u7c7b\u7684[%s]\u5b57\u6bb5\u7f16\u7801\u5931\u8d25\u3002\u5177\u4f53\u539f\u56e0\u4e3a\uff1a", bizParam.getClass().getName(), key), (Throwable)e);
            }
        }
        return customerParams;
    }
}

