/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mobile.EmailReceiveMessageCollection;
import com.kingdee.eas.mobile.EmailReceiveMessageFactory;
import com.kingdee.eas.mobile.EmailReceiveMessageInfo;
import com.kingdee.eas.mobile.EmailSendMessageCollection;
import com.kingdee.eas.mobile.EmailSendMessageFactory;
import com.kingdee.eas.mobile.EmailSendMessageInfo;
import com.kingdee.eas.mobile.IEmailReceiveMessage;
import com.kingdee.eas.mobile.IEmailSendMessage;
import com.kingdee.eas.mobile.util.CheckLicense;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.Configuration;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import javax.security.auth.login.LoginException;
import org.apache.log4j.Logger;

public class DefaultEmailMessageDAO {
    private static final Logger logger = Logger.getLogger(DefaultEmailMessageDAO.class);

    private DefaultEmailMessageDAO() {
    }

    public static IObjectPK addNew(Context ctx, EmailSendMessageInfo emailSendMsgInfo) throws BOSException, EASBizException {
        IEmailSendMessage iEmailMessage = EmailSendMessageFactory.getLocalInstance(ctx);
        try {
            if (CheckLicense.checkMobileLicence(ctx, "com.kingdee.eas.mobile.client.BizConfigUI") != 1) {
                logger.error((Object)"No Match License.");
                return null;
            }
        }
        catch (LicenseException e) {
            e.printStackTrace();
        }
        catch (LoginException e) {
            e.printStackTrace();
        }
        IObjectPK pk = null;
        if (StringUtils.isEmpty((String)emailSendMsgInfo.getRootMsgID())) {
            emailSendMsgInfo.setRootMsgID(emailSendMsgInfo.getMsgID());
        }
        pk = iEmailMessage.addnew(emailSendMsgInfo);
        return pk;
    }

    public static boolean addNew(Context ctx, EmailSendMessageCollection emailSendMsgInfos) throws BOSException, EASBizException {
        IObjectPK pk = null;
        try {
            if (CheckLicense.checkMobileLicence(ctx, "com.kingdee.eas.mobile.client.BizConfigUI") != 1) {
                logger.error((Object)"No Match License.");
                return false;
            }
        }
        catch (LicenseException e) {
            e.printStackTrace();
        }
        catch (LoginException e) {
            e.printStackTrace();
        }
        boolean succeed = true;
        if (emailSendMsgInfos.size() > 0) {
            IEmailSendMessage iEmailMessage = EmailSendMessageFactory.getLocalInstance(ctx);
            for (int i = 0; i < emailSendMsgInfos.size(); ++i) {
                if (StringUtils.isEmpty((String)emailSendMsgInfos.get(i).getRootMsgID())) {
                    emailSendMsgInfos.get(i).setRootMsgID(emailSendMsgInfos.get(i).getMsgID());
                }
                logger.info((Object)("---mobile--addnewEmail=---" + emailSendMsgInfos.get(i)));
                pk = iEmailMessage.addnew(emailSendMsgInfos.get(i));
                if (pk != null) continue;
                succeed = false;
                break;
            }
        }
        return succeed;
    }

    public static IObjectPK addNew(Context ctx, EmailReceiveMessageInfo emailReceiveMsgInfo) throws BOSException, EASBizException {
        IEmailReceiveMessage iEmailReceiveMessage = EmailReceiveMessageFactory.getLocalInstance(ctx);
        try {
            if (CheckLicense.checkMobileLicence(ctx, "com.kingdee.eas.mobile.client.BizConfigUI") != 1) {
                logger.error((Object)"No Match License.");
                return null;
            }
        }
        catch (LicenseException e) {
            e.printStackTrace();
        }
        catch (LoginException e) {
            e.printStackTrace();
        }
        IObjectPK pk = null;
        if (StringUtils.isEmpty((String)emailReceiveMsgInfo.getRootMsgID())) {
            emailReceiveMsgInfo.setRootMsgID(emailReceiveMsgInfo.getMsgID());
        }
        pk = iEmailReceiveMessage.addnew(emailReceiveMsgInfo);
        return pk;
    }

    public static EmailSendMessageCollection getUnSendEmails(Context ctx) throws BOSException, EASBizException {
        String sendDaysCount;
        IEmailSendMessage iEmailSendMessage = EmailSendMessageFactory.getLocalInstance(ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add("*");
        viewInfo.getSelector().add("address.*");
        int days = 3;
        Configuration bosConfig = Configuration.getInstance();
        ConfigurationItem sln = bosConfig.getConfigItem("PortalInfo");
        if (sln != null && (sendDaysCount = sln.getProperty("sendDaysCount")) != null) {
            try {
                days = Integer.parseInt(sendDaysCount.trim());
            }
            catch (Exception e) {
                logger.error((Object)"sendDaysCount is not correct! please reset it.");
            }
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(5, calendar.get(5) - days);
        Date filterDate = calendar.getTime();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sendSucceed", (Object)new Boolean(false)));
        filter.getFilterItems().add(new FilterItemInfo("sendFail", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("deleted", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("sentFailNumber", (Object)new Integer(5), CompareType.LESS));
        filter.getFilterItems().add(new FilterItemInfo("createTime", (Object)filterDate, CompareType.GREATER_EQUALS));
        viewInfo.setFilter(filter);
        SorterItemInfo sorterItemInfo = new SorterItemInfo("sentFailNumber");
        sorterItemInfo.setSortType(SortType.DESCEND);
        viewInfo.getSorter().add(sorterItemInfo);
        viewInfo.getSorter().add(new SorterItemInfo("priority"));
        viewInfo.getSorter().add(new SorterItemInfo("createTime"));
        viewInfo.setTopCount(100);
        EmailSendMessageCollection emailMessageeCollection = iEmailSendMessage.getEmailSendMessageCollection(viewInfo);
        return emailMessageeCollection;
    }

    public static EmailSendMessageInfo getEmailSendMsgInfoByMsgId(Context ctx, String msgID) {
        EmailSendMessageInfo emailSendMessageInfo = null;
        try {
            IEmailSendMessage iEmailSendMessage = EmailSendMessageFactory.getLocalInstance(ctx);
            EntityViewInfo evi = new EntityViewInfo();
            evi.getSelector().add("*");
            evi.getSelector().add("address.*");
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("msgID", (Object)msgID));
            evi.setFilter(filter);
            EmailSendMessageCollection emailSendMessageInfos = iEmailSendMessage.getEmailSendMessageCollection(evi);
            if (emailSendMessageInfos != null && emailSendMessageInfos.size() > 0) {
                emailSendMessageInfo = emailSendMessageInfos.get(0);
            }
        }
        catch (Exception err) {
            logger.error((Object)("There has some error while getEmailSendMsgInfoByMsgId :" + err.getMessage()));
        }
        return emailSendMessageInfo;
    }

    public static EmailReceiveMessageInfo getEmailReceiveMsgInfoByMsgId(Context ctx, String msgID) {
        EmailReceiveMessageInfo emailReceiveMessageInfo = null;
        try {
            IEmailReceiveMessage iEmailReceiveMessage = EmailReceiveMessageFactory.getLocalInstance(ctx);
            EntityViewInfo evi = new EntityViewInfo();
            evi.getSelector().add("*");
            evi.getSelector().add("address.*");
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("msgID", (Object)msgID));
            evi.setFilter(filter);
            EmailReceiveMessageCollection emailReceiveMessageInfos = iEmailReceiveMessage.getEmailReceiveMessageCollection(evi);
            if (emailReceiveMessageInfos != null && emailReceiveMessageInfos.size() > 0) {
                emailReceiveMessageInfo = emailReceiveMessageInfos.get(0);
            }
            emailReceiveMessageInfo = iEmailReceiveMessage.getEmailReceiveMessageInfo("select *,address.* where msgID='" + msgID + "' ");
        }
        catch (Exception err) {
            logger.error((Object)("There has some error while getEmailReceiveMsgInfoByMsgId :" + err.getMessage()));
        }
        return emailReceiveMessageInfo;
    }

    public static void updateSendEmailMsgInfo(Context ctx, String id, String msgId) throws BOSException {
        if (StringUtils.isEmpty((String)id) || StringUtils.isEmpty((String)msgId)) {
            return;
        }
        String updateCommandSQL = "update T_MO_EmailSendMsg set FMsgID=? where FID=? ";
        Object[] params = new Object[]{msgId, id};
        DbUtil.execute((Context)ctx, (String)updateCommandSQL, (Object[])params);
    }

    public static void updateReceiveEmailMsgInfo(Context ctx, String id, String msgId) throws BOSException {
        if (StringUtils.isEmpty((String)id) || StringUtils.isEmpty((String)msgId)) {
            return;
        }
        String updateCommandSQL = "update T_MO_EmailSendMsg set FMsgID=? where FID=? ";
        Object[] params = new Object[]{msgId, id};
        DbUtil.execute((Context)ctx, (String)updateCommandSQL, (Object[])params);
    }

    public static void updateSendEmailMsgInfo(Context ctx, String id, boolean isSendSucceed, Timestamp sentTime, boolean isSendFail) throws BOSException {
        if (StringUtils.isEmpty((String)id)) {
            return;
        }
        String updateCommandSQL = null;
        Object[] params = null;
        if (isSendSucceed) {
            String sentTimeStr = sentTime == null ? "" : ",FSentTime=? ";
            updateCommandSQL = "update T_MO_EmailSendMsg set FSent=1,FSendSucceed=1" + sentTimeStr + ",FSendFail=0 where FID=? ";
            params = new Object[]{sentTime, id};
        } else {
            updateCommandSQL = isSendFail ? "update T_MO_EmailSendMsg set FSent=1,FSendSucceed=0,FSendFail=1,FSentFailNumber=FSentFailNumber+1 where FID=? " : "update T_MO_EmailSendMsg set FSent=1,FSendSucceed=0,FSendFail=0,FSentFailNumber=FSentFailNumber+1 where FID=? ";
            params = new Object[]{id};
        }
        DbUtil.execute((Context)ctx, (String)updateCommandSQL, (Object[])params);
    }

    public static void updateSendEmailMsgInfoForResponsed(Context ctx, String id, boolean isResponsed) throws BOSException {
        if (StringUtils.isEmpty((String)id)) {
            return;
        }
        String updateCommandSQL = "update T_MO_EmailSendMsg set FResponsed=? where FID=? ";
        Object[] params = null;
        params = isResponsed ? new Object[]{new Integer(1), id} : new Object[]{new Integer(0), id};
        DbUtil.execute((Context)ctx, (String)updateCommandSQL, (Object[])params);
    }
}

