/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.framework;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.orm.ORMCoreException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mobile.EmailSendMessageInfo;
import com.kingdee.eas.mobile.IMobileConfig;
import com.kingdee.eas.mobile.MobileConfigCollection;
import com.kingdee.eas.mobile.MobileConfigFactory;
import com.kingdee.eas.mobile.SendMobileMessageInfo;
import com.kingdee.eas.mobile.framework.ServerCenter;
import com.kingdee.eas.mobile.msg.CommunicateException;
import com.kingdee.eas.mobile.util.MessageConstant;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.log4j.Logger;

public class BizServer {
    private static final Logger logger = Logger.getLogger(BizServer.class);
    private static Hashtable bizServerPool = new Hashtable();
    private String host = "";
    private int port = 0;
    private String loginName = "";
    private String code = "";
    private ServerCenter serverCenter = null;
    private Context ctx;
    private boolean isOldKingdeeGatewayProvider = false;

    private BizServer(Context ctx) {
        this.ctx = ctx;
        this.serverCenter = ServerCenter.getInstance(ctx);
        IMobileConfig iMobileConfig = null;
        MobileConfigCollection mobileConfigs = null;
        try {
            iMobileConfig = MobileConfigFactory.getLocalInstance(ctx);
            mobileConfigs = iMobileConfig.getMobileConfigCollection();
        }
        catch (BOSException err) {
            logger.error((Object)("Get mobile's config has some error: " + err.getMessage()));
        }
        if (mobileConfigs.size() > 0) {
            this.host = mobileConfigs.get(0).getHost();
            String portStr = mobileConfigs.get(0).getPort();
            if (portStr != null && portStr.trim().length() > 0) {
                Integer portObj = new Integer(portStr);
                this.port = portObj;
            }
            this.isOldKingdeeGatewayProvider = mobileConfigs.get(0).isKingdeeGatewayProvider();
            if (this.isOldKingdeeGatewayProvider) {
                this.loginName = ctx.getAIS();
                this.code = MessageConstant.BIZINTERFACE_P;
            } else {
                this.loginName = mobileConfigs.get(0).getLoginName();
                this.code = mobileConfigs.get(0).getPassword();
            }
        } else {
            logger.error((Object)"Get mobile's config has some error: have none mobile config!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized BizServer getInstance(Context ctx) {
        Hashtable hashtable = bizServerPool;
        synchronized (hashtable) {
            Object obj = bizServerPool.get(ctx.getAIS());
            if (obj != null) {
                return (BizServer)obj;
            }
            BizServer bizServer = new BizServer(ctx);
            bizServerPool.put(ctx.getAIS(), bizServer);
            return bizServer;
        }
    }

    public boolean sendMessage(SendMobileMessageInfo sendMoMsgInfo) throws EASBizException, BOSException {
        return this.serverCenter.sendMessage(sendMoMsgInfo);
    }

    public boolean sendMail(EmailSendMessageInfo emailSendMessageInfo) throws EASBizException, BOSException {
        return this.serverCenter.sendMail(emailSendMessageInfo);
    }

    public void open() throws ORMCoreException, CommunicateException {
        if (!this.serverCenter.isConnect()) {
            if (StringUtils.isEmpty((String)this.getHost())) {
                throw new CommunicateException(ResourceBase.getString((String)"com.kingdee.eas.mobile.msg.MobileResource", (String)"connectError", (Locale)this.ctx.getLocale()));
            }
            long curTime = System.currentTimeMillis();
            boolean success = this.serverCenter.getiMobileGatewayProvider().connect(this.getHost(), this.getPort(), this.getLoginName(), this.getPassword());
            long invokeTime = System.currentTimeMillis();
            logger.error((Object)(">>>>>>>>>connet Communicate error: \u767b\u5f55\u901a\u8baf\u5e73\u53f0\u6240\u82b1\u5f97\u65f6\u95f4\u4e3a\uff1a" + (invokeTime - curTime) + "\u6beb\u79d2"));
            logger.debug((Object)("Connect to BOS Comunication Platform " + success));
            if (!success) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                logger.error((Object)"\u767b\u5f55\u901a\u8baf\u5e73\u53f0\u9519.");
                throw new CommunicateException(ResourceBase.getString((String)"com.kingdee.eas.mobile.msg.MobileResource", (String)"connectError", (Locale)this.ctx.getLocale()));
            }
        }
    }

    public void close() {
        ServerCenter serverCenter = ServerCenter.getInstance(this.ctx);
        serverCenter.stop();
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getLoginName() {
        return this.loginName;
    }

    public String getPassword() {
        return this.code;
    }

    public boolean isOldKingdeeGatewayProvider() {
        return this.isOldKingdeeGatewayProvider;
    }
}

